/*
 * Decompiled with CFR 0.152.
 */
package woolpack.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConvertUtils {
    public static final Fn<Object, BigDecimal, RuntimeException> TO_BIG_DECIMAL = new Fn<Object, BigDecimal, RuntimeException>(){

        @Override
        public BigDecimal exec(Object c) {
            if (c instanceof BigDecimal) {
                return (BigDecimal)c;
            }
            if (c instanceof BigInteger) {
                return new BigDecimal((BigInteger)c);
            }
            return new BigDecimal(((Number)c).doubleValue());
        }
    };
    public static final Fn<Object, BigInteger, RuntimeException> TO_BIG_INTEGER = new Fn<Object, BigInteger, RuntimeException>(){

        @Override
        public BigInteger exec(Object c) {
            if (c instanceof BigInteger) {
                return (BigInteger)c;
            }
            if (c instanceof BigDecimal) {
                return ((BigDecimal)c).toBigIntegerExact();
            }
            return new BigDecimal(((Number)c).doubleValue()).toBigIntegerExact();
        }
    };
    public static final Fn<Object, Byte, RuntimeException> TO_BYTE = new Fn<Object, Byte, RuntimeException>(){

        @Override
        public Byte exec(Object c) {
            if (c instanceof Byte) {
                return (Byte)c;
            }
            Number n = (Number)c;
            byte b = n.byteValue();
            if ((double)b != n.doubleValue()) {
                throw new IllegalArgumentException("out of range : " + c);
            }
            return b;
        }
    };
    public static final Fn<Object, Double, RuntimeException> TO_DOUBLE = new Fn<Object, Double, RuntimeException>(){

        @Override
        public Double exec(Object c) {
            if (c instanceof Double) {
                return (Double)c;
            }
            return ((Number)c).doubleValue();
        }
    };
    public static final Fn<Object, Float, RuntimeException> TO_FLOAT = new Fn<Object, Float, RuntimeException>(){

        @Override
        public Float exec(Object c) {
            if (c instanceof Float) {
                return (Float)c;
            }
            return Float.valueOf(((Number)c).floatValue());
        }
    };
    public static final Fn<Object, Integer, RuntimeException> TO_INTEGER = new Fn<Object, Integer, RuntimeException>(){

        @Override
        public Integer exec(Object c) {
            if (c instanceof Integer) {
                return (Integer)c;
            }
            Number n = (Number)c;
            int i = n.intValue();
            if ((double)i != n.doubleValue()) {
                throw new IllegalArgumentException("out of range : " + c);
            }
            return i;
        }
    };
    public static final Fn<Object, Long, RuntimeException> TO_LONG = new Fn<Object, Long, RuntimeException>(){

        @Override
        public Long exec(Object c) {
            if (c instanceof Long) {
                return (Long)c;
            }
            Number n = (Number)c;
            long l = n.longValue();
            if ((double)l != n.doubleValue()) {
                throw new IllegalArgumentException("out of range : " + c);
            }
            return l;
        }
    };
    public static final Fn<Object, Short, RuntimeException> TO_SHORT = new Fn<Object, Short, RuntimeException>(){

        @Override
        public Short exec(Object c) {
            if (c instanceof Short) {
                return (Short)c;
            }
            Number n = (Number)c;
            short s = n.shortValue();
            if ((double)s != n.doubleValue()) {
                throw new IllegalArgumentException("out of range : " + c);
            }
            return s;
        }
    };
    public static final Fn<Object, Date, RuntimeException> TO_SQL_DATE = new Fn<Object, Date, RuntimeException>(){

        @Override
        public Date exec(Object c) {
            if (c instanceof Date) {
                return (Date)c;
            }
            return new Date(((java.util.Date)c).getTime());
        }
    };
    public static final Fn<Object, Time, RuntimeException> TO_TIME = new Fn<Object, Time, RuntimeException>(){

        @Override
        public Time exec(Object c) {
            if (c instanceof Time) {
                return (Time)c;
            }
            return new Time(((java.util.Date)c).getTime());
        }
    };
    public static final Fn<Object, Timestamp, RuntimeException> TO_TIMESTAMP = new Fn<Object, Timestamp, RuntimeException>(){

        @Override
        public Timestamp exec(Object c) {
            if (c instanceof Timestamp) {
                return (Timestamp)c;
            }
            return new Timestamp(((java.util.Date)c).getTime());
        }
    };
    public static final Fn<Object, Calendar, RuntimeException> TO_CALENDAR = new Fn<Object, Calendar, RuntimeException>(){

        @Override
        public Calendar exec(Object c) {
            if (c instanceof Calendar) {
                return (Calendar)c;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((java.util.Date)c);
            return calendar;
        }
    };
    public static final Fn<Object, String, RuntimeException> TO_STRING = new Fn<Object, String, RuntimeException>(){

        @Override
        public String exec(Object c) {
            return c == null ? null : c.toString();
        }
    };

    private ConvertUtils() {
    }

    public static <K> Fn<Map<K, ?>, Set<K>, RuntimeException> keySet() {
        return new Fn<Map<K, ?>, Set<K>, RuntimeException>(){

            @Override
            public Set<K> exec(Map<K, ?> c) {
                return c.keySet();
            }
        };
    }

    public static Fn<Object, Format, RuntimeException> formatFactory(final Format format) {
        return new Fn<Object, Format, RuntimeException>(){

            @Override
            public Format exec(Object c) {
                return (Format)format.clone();
            }
        };
    }

    public static <E extends Exception> Fn<Object, String, E> format(final Fn<?, ? extends Format, ? extends E> formatFactory) {
        return new Fn<Object, String, E>(){

            @Override
            public String exec(Object c) throws Exception {
                return ((Format)formatFactory.exec(null)).format(c);
            }
        };
    }

    public static Fn<String, String, RuntimeException> netMask(String netMask) {
        return new Fn<String, String, RuntimeException>(netMask){
            private final int IP_COUNT = 4;
            private final Pattern PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)");
            private int[] maskArray;
            {
                this.maskArray = this.toArray(string);
            }

            private int[] toArray(String s) {
                if (s == null) {
                    return null;
                }
                Matcher m = this.PATTERN.matcher(s);
                if (!m.matches()) {
                    return null;
                }
                int[] a = new int[4];
                int i = 0;
                while (i < a.length) {
                    a[i] = Integer.parseInt(m.group(i + 1));
                    ++i;
                }
                return a;
            }

            @Override
            public String exec(String c) {
                int[] a = this.toArray(c);
                if (a == null) {
                    return null;
                }
                int i = 0;
                while (i < a.length) {
                    a[i] = a[i] & this.maskArray[i];
                    ++i;
                }
                StringBuilder sb = new StringBuilder();
                int i2 = 0;
                while (i2 < a.length) {
                    if (i2 != 0) {
                        sb.append('.');
                    }
                    sb.append(a[i2]);
                    ++i2;
                }
                return sb.toString();
            }
        };
    }

    public static Fn<String, Object, Exception> parse(final Fn<?, ? extends Format, ? extends Exception> formatFactory) {
        return new Fn<String, Object, Exception>(){

            @Override
            public Object exec(String c) throws Exception {
                ParsePosition pp = new ParsePosition(0);
                Format format = (Format)formatFactory.exec(null);
                Object o = format.parseObject(c, pp);
                if (o != null && pp.getIndex() == c.length()) {
                    return o;
                }
                throw new ParseException("cannot parse " + c + " at " + format, 0);
            }
        };
    }

    public static Fn<String, String, RuntimeException> convertRegExp(final Pattern pattern, final String replacement) {
        return new Fn<String, String, RuntimeException>(){

            @Override
            public String exec(String c) {
                return pattern.matcher(c).replaceAll(replacement);
            }
        };
    }

    public static <C, R, E extends Exception> Fn<C, R, E> trys(final Iterable<? extends Fn<? super C, ? extends R, ? extends Exception>> iterable, final Fn<? super Exception, ?, ? extends E> errorFn, final Fn<? super Exception, ? extends R, ? extends E> finalFn) {
        return new Fn<C, R, E>(){

            @Override
            public R exec(C c) throws Exception {
                Exception t = null;
                for (Fn fn : iterable) {
                    try {
                        return fn.exec(c);
                    }
                    catch (Exception e) {
                        t = e;
                        errorFn.exec(t);
                    }
                }
                return finalFn.exec(t);
            }
        };
    }

    public static <C, R> Fn<C, R, IllegalStateException> trys(Iterable<? extends Fn<? super C, ? extends R, ? extends Exception>> iterable) {
        return ConvertUtils.trys(iterable, FnUtils.fixThrows(null), new Fn<Exception, R, IllegalStateException>(){

            @Override
            public R exec(Exception c) throws IllegalStateException {
                throw new IllegalStateException(c);
            }
        });
    }

    public static Fn<Map<?, ?>, Boolean, RuntimeException> retainKeys(final Collection<?> collection) {
        return new Fn<Map<?, ?>, Boolean, RuntimeException>(){

            @Override
            public Boolean exec(Map<?, ?> c) {
                c.keySet().retainAll(collection);
                return true;
            }
        };
    }
}

