/*
 * Decompiled with CFR 0.152.
 */
package woolpack.fn;

import java.util.Collection;
import java.util.Map;
import woolpack.fn.Delegator;
import woolpack.fn.Fn;
import woolpack.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FnUtils {
    public static final Fn<Class, Class, RuntimeException> TO_WRAPPER = FnUtils.switching((Map)Utils.map(Boolean.TYPE, Boolean.class).map(Character.TYPE, Character.class).map(Byte.TYPE, Byte.class).map(Short.TYPE, Short.class).map(Integer.TYPE, Integer.class).map(Long.TYPE, Long.class).map(Float.TYPE, Float.class).map(Double.TYPE, Double.class), FnUtils.echo());

    private FnUtils() {
    }

    public static <R> Fn<Object, R, RuntimeException> castTo(final Class<R> clazz) {
        return new Fn<Object, R, RuntimeException>(){

            @Override
            public R exec(Object c) {
                return clazz.cast(c);
            }
        };
    }

    public static <C, R, E extends Exception> Fn<C, R, E> exec(final Fn<? super C, ? extends Fn<? super C, ? extends R, ? extends E>, ? extends E> fn) {
        return new Fn<C, R, E>(){

            @Override
            public R exec(C c) throws Exception {
                return ((Fn)fn.exec(c)).exec(c);
            }
        };
    }

    public static <C> Fn<C, C, RuntimeException> echo() {
        return new Fn<C, C, RuntimeException>(){

            @Override
            public C exec(C c) {
                return c;
            }
        };
    }

    public static <C, R, E extends Exception> Fn<C, R, E> fixThrows(final R value) {
        return new Fn<C, R, E>(){

            @Override
            public R exec(C c) {
                return value;
            }
        };
    }

    public static <C, R> Fn<C, R, RuntimeException> fix(R value) {
        return FnUtils.fixThrows(value);
    }

    public static <C, R, E extends Exception> Fn<C, R, E> ifTrue(final Fn<? super C, ?, ? extends E> ifFn, final Fn<? super C, ? extends R, ? extends E> trueFn, final Fn<? super C, ? extends R, ? extends E> falseFn) {
        return new Fn<C, R, E>(){

            @Override
            public R exec(C c) throws Exception {
                Object o = ifFn.exec(c);
                if (Boolean.TRUE.equals(o)) {
                    return trueFn.exec(c);
                }
                return falseFn.exec(c);
            }
        };
    }

    public static <A, B, C, E extends Exception> Fn<A, C, E> join(final Fn<? super A, ? extends B, ? extends E> fn0, final Fn<? super B, ? extends C, ? extends E> fn1) {
        return new Fn<A, C, E>(){

            @Override
            public C exec(A a) throws Exception {
                return fn1.exec(fn0.exec(a));
            }
        };
    }

    public static <A, B, C, D, E extends Exception> Fn<A, D, E> join(Fn<? super A, ? extends B, ? extends E> fn0, Fn<? super B, ? extends C, ? extends E> fn1, Fn<? super C, ? extends D, ? extends E> fn2) {
        return FnUtils.join(FnUtils.join(fn0, fn1), fn2);
    }

    public static <A, B, C, D, E, T extends Exception> Fn<A, E, T> join(Fn<? super A, ? extends B, ? extends T> fn0, Fn<? super B, ? extends C, ? extends T> fn1, Fn<? super C, ? extends D, ? extends T> fn2, Fn<? super D, ? extends E, ? extends T> fn3) {
        return FnUtils.join(FnUtils.join(fn0, fn1), FnUtils.join(fn2, fn3));
    }

    public static <A, B, C, D, E, F, T extends Exception> Fn<A, F, T> join(Fn<? super A, ? extends B, ? extends T> fn0, Fn<? super B, ? extends C, ? extends T> fn1, Fn<? super C, ? extends D, ? extends T> fn2, Fn<? super D, ? extends E, ? extends T> fn3, Fn<? super E, ? extends F, ? extends T> fn4) {
        return FnUtils.join(FnUtils.join(fn0, fn1, fn2), FnUtils.join(fn3, fn4));
    }

    public static <C, R, E extends Exception> Fn<C, R, E> recode(final Fn<? super C, ? extends R, ? extends E> fn, final String name, final Collection<String> nameList, final Collection<? super C> contextList, final Collection<? super R> returnList) {
        return new Fn<C, R, E>(){

            @Override
            public R exec(C c) throws Exception {
                if (nameList != null) {
                    nameList.add(name);
                }
                if (contextList != null) {
                    contextList.add(c);
                }
                Object r = null;
                if (fn != null) {
                    r = fn.exec(c);
                }
                if (returnList != null) {
                    returnList.add(r);
                }
                return r;
            }
        };
    }

    public static <C, R, E extends Exception> Fn<C, R, E> recode(Fn<? super C, ? extends R, ? extends E> fn, String name, Collection<String> nameList) {
        return FnUtils.recode(fn, name, nameList, null, null);
    }

    public static <C, R, E extends Exception> Fn<C, R, E> recode(Fn<? super C, ? extends R, ? extends E> fn, Collection<? super C> contextList, Collection<? super R> returnList) {
        return FnUtils.recode(fn, null, null, contextList, returnList);
    }

    public static <C, R, E extends Exception> Fn<C, R, E> seq(final Iterable<? extends Fn<? super C, ? extends R, ? extends E>> iterable) {
        return new Fn<C, R, E>(){

            @Override
            public R exec(C c) throws Exception {
                Object r = null;
                for (Fn e : iterable) {
                    r = e.exec(c);
                }
                return r;
            }
        };
    }

    public static <C, R, E extends Exception> Fn<C, R, E> switching(final Map<? super C, ? extends R> map, final Fn<? super C, ? extends R, ? extends E> defaultFn) {
        return new Fn<C, R, E>(){

            @Override
            public R exec(C c) throws Exception {
                Object r = map.get(c);
                if (r == null) {
                    return defaultFn.exec(c);
                }
                return r;
            }
        };
    }

    public static <C, R> Fn<C, R, RuntimeException> switching(Map<? super C, ? extends R> map, R defaultValue) {
        return FnUtils.switching(map, FnUtils.fix(defaultValue));
    }

    public static <C, R> Fn<C, R, RuntimeException> switching(Map<? super C, ? extends R> map) {
        return FnUtils.switching(map, FnUtils.fix(null));
    }

    public static <C, R, E extends Exception> Fn<C, R, E> throwing(final E exception) {
        return new Fn<C, R, E>(){

            @Override
            public R exec(C c) throws Exception {
                throw exception;
            }
        };
    }

    public static <C, R, E extends Exception> Fn<C, R, E> trying(final Fn<? super C, ? extends R, ? extends Exception> fn, final Fn<? super Exception, ? extends R, ? extends E> reportFn, final Fn<? super C, ?, ? extends E> finallyFn) {
        return new Fn<C, R, E>(){

            @Override
            public R exec(C c) throws Exception {
                try {
                    Object r = fn.exec(c);
                    return r;
                }
                catch (Exception e) {
                    Object r = reportFn.exec(e);
                    return r;
                }
                finally {
                    finallyFn.exec(c);
                }
            }
        };
    }

    public static <C, R, E extends Exception> Delegator<C, R, E> delegate(Fn<? super C, ? extends R, ? extends E> fn) {
        return new Delegator<C, R, E>(fn);
    }

    public static <C, R, E extends Exception> Delegator<C, R, E> delegate() {
        return FnUtils.delegate(null);
    }

    public static <C, R, E extends Exception> Fn<C, R, E> maybe(final Fn<? super C, ? extends R, ? extends E> fn) {
        return new Fn<C, R, E>(){

            @Override
            public R exec(C c) throws Exception {
                if (c == null) {
                    return null;
                }
                return fn.exec(c);
            }
        };
    }

    public static <C, R, E extends Exception> Fn<C, R, E> ifElse(final Map<? extends Fn<? super C, ?, ? extends E>, R> map, final Fn<? super C, ? extends R, ? extends E> defaultFn) {
        return new Fn<C, R, E>(){

            @Override
            public R exec(C c) throws Exception {
                for (Map.Entry entry : map.entrySet()) {
                    if (!Boolean.TRUE.equals(((Fn)entry.getKey()).exec(c))) continue;
                    return entry.getValue();
                }
                return defaultFn.exec(c);
            }
        };
    }

    public static <C, R, E extends Exception> Fn<C, R, E> ifElse(Map<? extends Fn<? super C, ?, ? extends E>, R> map, R defaultValue) {
        return FnUtils.ifElse(map, FnUtils.fixThrows(defaultValue));
    }
}

