/*
 * Decompiled with CFR 0.152.
 */
package woolpack.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import woolpack.el.AbstractEL;
import woolpack.el.AbstractGettingEL;
import woolpack.el.EL;
import woolpack.el.GettingEL;
import woolpack.fn.Fn;
import woolpack.utils.Utils;
import woolpack.web.WebContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebUtils {
    public static final int TOKEN_LENGTH = 32;
    private static final int DEGIT_COUNT = 10;
    private static final int TOKEN_CHAR_COUNT = 36;
    public static final EL INPUT_EL = new AbstractEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getInput();
        }

        public boolean setValue(Object root, Object value) {
            ((WebContext)root).setInput((Map)value);
            return true;
        }
    };
    public static final GettingEL REQUEST_EL = new AbstractGettingEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getRequest();
        }
    };
    public static final GettingEL SESSION_EL = new AbstractGettingEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getSession();
        }
    };
    public static final GettingEL APPLICATION_EL = new AbstractGettingEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getApplication();
        }
    };
    public static final EL CONTAINER_EL = new AbstractEL(){

        public Object getValue(Object root, Class clazz) {
            return ((WebContext)root).getContainer();
        }

        public boolean setValue(Object root, Object value) {
            ((WebContext)root).setContainer(value);
            return true;
        }
    };
    public static final Fn<WebContext, Void, RuntimeException> CLEAR_SESSION = new Fn<WebContext, Void, RuntimeException>(){

        @Override
        public Void exec(WebContext context) {
            context.getSession().clear();
            return null;
        }
    };

    private WebUtils() {
    }

    public static Map<String, List<Object>> convert(Map map) {
        HashMap<String, List<Object>> map1 = new HashMap<String, List<Object>>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = iterator.next();
            Iterable<?> c = Utils.toIterable(entry.getValue());
            ArrayList list = new ArrayList();
            for (Object o : c) {
                list.add(o);
            }
            map1.put((String)entry.getKey(), list);
        }
        return map1;
    }

    public static <E extends Exception> Fn<WebContext, Map<String, List<Object>>, E> inputFn() {
        return new Fn<WebContext, Map<String, List<Object>>, E>(){

            @Override
            public Map<String, List<Object>> exec(WebContext c) {
                return c.getInput();
            }
        };
    }

    public static <E extends Exception> Fn<WebContext, Map<String, Object>, E> requestFn() {
        return new Fn<WebContext, Map<String, Object>, E>(){

            @Override
            public Map<String, Object> exec(WebContext c) {
                return c.getRequest();
            }
        };
    }

    public static <E extends Exception> Fn<WebContext, ConcurrentMap<String, Object>, E> sessionFn() {
        return new Fn<WebContext, ConcurrentMap<String, Object>, E>(){

            @Override
            public ConcurrentMap<String, Object> exec(WebContext c) {
                return c.getSession();
            }
        };
    }

    public static <E extends Exception> Fn<WebContext, ConcurrentMap<String, Object>, E> applicationFn() {
        return new Fn<WebContext, ConcurrentMap<String, Object>, E>(){

            @Override
            public ConcurrentMap<String, Object> exec(WebContext c) {
                return c.getApplication();
            }
        };
    }

    public static <E extends Exception> Fn<WebContext, Object, E> containerFn() {
        return new Fn<WebContext, Object, E>(){

            @Override
            public Object exec(WebContext c) {
                return c.getContainer();
            }
        };
    }

    public static <C extends WebContext, R, E extends Exception> Fn<C, R, E> checkTransactionToken(final String key, final Fn<? super C, Boolean, ? extends E> targetCheckFn, final Fn<? super C, R, ? extends E> trueFn, final Fn<? super C, R, ? extends E> falseFn, final int size) {
        return new Fn<C, R, E>(){
            private final Random r = new Random();

            @Override
            public R exec(C c) throws Exception {
                if (((Boolean)targetCheckFn.exec(c)).booleanValue()) {
                    Object oldToken = c.getSession().get(key);
                    List<?> requestedTokens = Utils.toList(c.getInput().get(key));
                    String newToken = this.generateToken();
                    if (oldToken != null && oldToken.equals(requestedTokens.get(0)) && c.getSession().replace(key, oldToken, newToken)) {
                        trueFn.exec(c);
                    } else {
                        falseFn.exec(c);
                    }
                } else {
                    String newToken;
                    Object oldToken;
                    do {
                        oldToken = c.getSession().get(key);
                        newToken = this.generateToken();
                    } while (!(oldToken == null ? c.getSession().putIfAbsent(key, newToken) == null : c.getSession().replace(key, oldToken, newToken)));
                    trueFn.exec(c);
                }
                return null;
            }

            String generateToken() {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < size) {
                    int j = this.r.nextInt(36);
                    sb.append(j < 10 ? (char)(48 + j) : (char)(65 + j - 10));
                    ++i;
                }
                return sb.toString();
            }
        };
    }

    public static <C extends WebContext, R, E extends Exception> Fn<C, R, E> checkTransactionToken(String key, Fn<? super C, Boolean, ? extends E> targetCheckFn, Fn<? super C, R, ? extends E> trueFn, Fn<? super C, R, ? extends E> falseFn) {
        return WebUtils.checkTransactionToken(key, targetCheckFn, trueFn, falseFn, 32);
    }
}

