/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

/**
 * 初期設定により
 * {@link PropertyNotFoundException}が発生した際の挙動を切り替える
 * プロパティ式言語ファクトリです。
 * <br/>適用しているデザインパターン：エラー発生時の挙動を加工するDecorator。
 * @author nakamura
 *
 */
public class MaybePropertyELFactory implements PropertyELFactory {
	private PropertyELFactory factory;
	private boolean notFoundIgnoreFlag;
	
	/**
	 * 
	 * @param notFoundIgnoreFlag メンバが存在しない場合に何もしない場合はtrue。
	 * @param factory 委譲先。
	 */
	public MaybePropertyELFactory(
			final boolean notFoundIgnoreFlag,
			final PropertyELFactory factory) {
		this.notFoundIgnoreFlag = notFoundIgnoreFlag;
		this.factory = factory;
	}

	public GettingEL newGetter(final Class clazz, final String propertyName) {
		try {
			return factory.newGetter(clazz, propertyName);
		} catch (final PropertyNotFoundException e) {
			if (notFoundIgnoreFlag) {
				return ELUtils.NULL;
			} else {
				throw e;
			}
		}
	}

	public EL newSetter(final Class clazz, final String propertyName) {
		try {
			return factory.newSetter(clazz, propertyName);
		} catch (final PropertyNotFoundException e) {
			if (notFoundIgnoreFlag) {
				return ELUtils.NULL;
			} else {
				throw e;
			}
		}
	}

	public PropertyELFactory getFactory() {
		return factory;
	}
	public void setFactory(final PropertyELFactory factory) {
		this.factory = factory;
	}
	public boolean isNotFoundIgnoreFlag() {
		return notFoundIgnoreFlag;
	}
	public void setNotFoundIgnoreFlag(final boolean notFoundIgnoreFlag) {
		this.notFoundIgnoreFlag = notFoundIgnoreFlag;
	}
}
