/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.adapter;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

/**
 * 委譲するだけの{@link DataSource}です。
 * <br/>適用しているデザインパターン：Delegation。
 * @author nakamura
 *
 */
public class DataSourceAdapter implements DataSource {
	private DataSource parent;
	
	public DataSourceAdapter(final DataSource parent) {
		this.parent = parent;
	}
	public DataSource getParent() {
		return parent;
	}
	public void setParent(final DataSource parent) {
		this.parent = parent;
	}

	public Connection getConnection() throws SQLException {
		return parent.getConnection();
	}
	public Connection getConnection(final String username, final String password) throws SQLException {
		return parent.getConnection(username, password);
	}
	public int getLoginTimeout() throws SQLException {
		return parent.getLoginTimeout();
	}
	public PrintWriter getLogWriter() throws SQLException {
		return parent.getLogWriter();
	}
	public void setLoginTimeout(final int seconds) throws SQLException {
		parent.setLoginTimeout(seconds);
	}
	public void setLogWriter(final PrintWriter out) throws SQLException {
		parent.setLogWriter(out);
	}
}
