/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.adapter;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import junit.framework.TestCase;
import woolpack.test.TestUtils;

public class PreparedStatementAdapterTest extends TestCase {
	public void testNormal() throws SQLException {
		final PreparedStatementAdapter o = new PreparedStatementAdapter(TestUtils.newProxyInstance(
				PreparedStatement.class,
				TestUtils.getMockHandler()
		));
		
		String sql = null;
		String[] autoGeneratedKeys = null;
		int[] columnIndexes = null;
		String[] columnNames = null;
		String name = null;
		boolean enable = false;
		int direction = 0;
		int rows = 0;
		int max = 0;
		int seconds = 0;
		int current = 0;

		int i = 0;
		int parameterIndex = 0;
		int length = 0;
		int sqlType = 0;
		String typeName = null;
		int targetSqlType = 0;
		int scale = 0;
		
		o.addBatch();
		o.addBatch(sql);
		o.cancel();
		o.clearBatch();
		o.clearParameters();
		o.clearWarnings();
		o.close();
		o.setArray(i, null);
		o.setAsciiStream(parameterIndex, null, length);
		o.setBigDecimal(parameterIndex, null);
		o.setBinaryStream(parameterIndex, null, length);
		o.setBlob(i, null);
		o.setBoolean(parameterIndex, false);
		o.setByte(parameterIndex, (byte)0);
		o.setBytes(parameterIndex, null);
		o.setCharacterStream(parameterIndex, null, length);
		o.setClob(i, null);
		o.setCursorName(name);
		o.setDate(parameterIndex, null, null);
		o.setDate(parameterIndex, null);
		o.setDouble(parameterIndex, 0);
		o.setEscapeProcessing(enable);
		o.setFetchDirection(direction);
		o.setFetchSize(rows);
		o.setFloat(parameterIndex, 0f);
		o.setInt(parameterIndex, 0);
		o.setLong(parameterIndex, 0);
		o.setMaxFieldSize(max);
		o.setMaxRows(max);
		o.setNull(parameterIndex, sqlType);
		o.setNull(0, sqlType, typeName);
		o.setObject(parameterIndex, null, targetSqlType, scale);
		o.setObject(parameterIndex, null, targetSqlType);
		o.setObject(parameterIndex, null);
		o.setQueryTimeout(seconds);
		o.setRef(i, null);
		o.setShort(parameterIndex, (short)0);
		o.setString(parameterIndex, null);
		o.setTime(parameterIndex, null, null);
		o.setTime(parameterIndex, null);
		o.setTimestamp(parameterIndex, null, null);
		o.setTimestamp(parameterIndex, null);
		o.setUnicodeStream(parameterIndex, null, length);
		o.setURL(parameterIndex, null);
		o.execute();
		o.execute(sql, autoGeneratedKeys);
		o.execute(sql, columnIndexes);
		o.execute(sql, columnNames);
		o.execute(sql);
		o.executeBatch();
		o.executeQuery();
		o.executeQuery(sql);
		o.executeUpdate();
		o.executeUpdate(sql, autoGeneratedKeys);
		o.executeUpdate(sql, columnIndexes);
		o.executeUpdate(sql, columnNames);
		o.executeUpdate(sql);
		o.getConnection();
		o.getFetchDirection();
		o.getFetchSize();
		o.getGeneratedKeys();
		o.getMaxFieldSize();
		o.getMaxRows();
		o.getMetaData();
		o.getMoreResults();
		o.getMoreResults(current);
		o.getParameterMetaData();
		o.getQueryTimeout();
		o.getResultSet();
		o.getResultSetConcurrency();
		o.getResultSetHoldability();
		o.getResultSetType();
		o.getUpdateCount();
		o.getWarnings();

		o.getParent();
		o.setParent(null);
	}
}
