/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.adapter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;

import junit.framework.TestCase;
import woolpack.test.TestUtils;

public class ResultSetAdapterTest extends TestCase {
	public void testNormal() throws SQLException {
		final ResultSetAdapter o = new ResultSetAdapter(TestUtils.newProxyInstance(
				ResultSet.class,
				TestUtils.getMockHandler()
		));
		
		int direction = 0;
		int rows = 0;
		int i = 0;
		int length = 0;
		int scale = 0;
		int columnIndex = 0;
		String columnName = null;
		Calendar cal = null;
		String colName = null;

		o.afterLast();
		o.beforeFirst();
		o.cancelRowUpdates();
		o.clearWarnings();
		o.close();
		o.deleteRow();
		o.insertRow();
		o.moveToCurrentRow();
		o.moveToInsertRow();
		o.refreshRow();
		o.setFetchDirection(direction);
		o.setFetchSize(rows);
		o.updateArray(columnIndex,null);
		o.updateArray(columnName,null);
		o.updateAsciiStream(columnIndex,null, length);
		o.updateAsciiStream(columnName,null, length);
		o.updateBigDecimal(columnIndex,null);
		o.updateBigDecimal(columnName,null);
		o.updateBinaryStream(columnIndex,null, length);
		o.updateBinaryStream(columnName,null, length);
		o.updateBlob(columnIndex,null);
		o.updateBlob(columnName,null);
		o.updateBoolean(columnIndex,false);
		o.updateBoolean(columnName,false);
		o.updateByte(columnIndex,(byte)0);
		o.updateByte(columnName,(byte)0);
		o.updateBytes(columnIndex,null);
		o.updateBytes(columnName,null);
		o.updateCharacterStream(columnIndex,null, length);
		o.updateCharacterStream(columnName, null, length);
		o.updateClob(columnIndex,null);
		o.updateClob(columnName,null);
		o.updateDate(columnIndex,null);
		o.updateDate(columnName,null);
		o.updateDouble(columnIndex,0);
		o.updateDouble(columnName,0);
		o.updateFloat(columnIndex,0f);
		o.updateFloat(columnName,0f);
		o.updateInt(columnIndex,0);
		o.updateInt(columnName,0);
		o.updateLong(columnIndex,0);
		o.updateLong(columnName,0);
		o.updateNull(columnIndex);
		o.updateNull(columnName);
		o.updateObject(columnIndex,null, scale);
		o.updateObject(columnIndex,null);
		o.updateObject(columnName,null, scale);
		o.updateObject(columnName,null);
		o.updateRef(columnIndex,null);
		o.updateRef(columnName,null);
		o.updateRow();
		o.updateShort(columnIndex,(short)0);
		o.updateShort(columnName,(short)0);
		o.updateString(columnIndex,null);
		o.updateString(columnName,null);
		o.updateTime(columnIndex,null);
		o.updateTime(columnName,null);
		o.updateTimestamp(columnIndex,null);
		o.updateTimestamp(columnName,null);
		o.absolute(0);
		o.findColumn(columnName);
		o.first();
		o.getArray(colName);
		o.getArray(i);
		o.getAsciiStream(columnIndex);
		o.getAsciiStream(columnName);
		o.getBigDecimal(columnIndex, scale);
		o.getBigDecimal(columnIndex);
		o.getBigDecimal(columnName, scale);
		o.getBigDecimal(columnName);
		o.getBinaryStream(columnIndex);
		o.getBinaryStream(columnName);
		o.getBlob(colName);
		o.getBlob(i);
		o.getBoolean(columnIndex);
		o.getBoolean(columnName);
		o.getByte(columnIndex);
		o.getByte(columnName);
		o.getBytes(columnIndex);
		o.getBytes(columnName);
		o.getCharacterStream(columnIndex);
		o.getCharacterStream(columnName);
		o.getClob(colName);
		o.getClob(i);
		o.getConcurrency();
		o.getCursorName();
		o.getDate(columnIndex, cal);
		o.getDate(columnIndex);
		o.getDate(columnName, cal);
		o.getDate(columnName);
		o.getDouble(columnIndex);
		o.getDouble(columnName);
		o.getFetchDirection();
		o.getFetchSize();
		o.getFloat(columnIndex);
		o.getFloat(columnName);
		o.getInt(columnIndex);
		o.getInt(columnName);
		o.getLong(columnIndex);
		o.getLong(columnName);
		o.getMetaData();
		o.getObject(colName, null);
		o.getObject(columnIndex);
		o.getObject(columnName);
		o.getObject(i, null);
		o.getRef(colName);
		o.getRef(i);
		o.getRow();
		o.getShort(columnIndex);
		o.getShort(columnName);
		o.getStatement();
		o.getString(columnIndex);
		o.getString(columnName);
		o.getTime(columnIndex, cal);
		o.getTime(columnIndex);
		o.getTime(columnName, cal);
		o.getTime(columnName);
		o.getTimestamp(columnIndex, cal);
		o.getTimestamp(columnIndex);
		o.getTimestamp(columnName, cal);
		o.getTimestamp(columnName);
		o.getType();
		o.getUnicodeStream(columnIndex);
		o.getUnicodeStream(columnName);
		o.getURL(columnIndex);
		o.getURL(columnName);
		o.getWarnings();
		o.isAfterLast();
		o.isBeforeFirst();
		o.isFirst();
		o.isLast();
		o.last();
		o.next();
		o.previous();
		o.relative(rows);
		o.rowDeleted();
		o.rowInserted();
		o.rowUpdated();
		o.wasNull();


		o.getParent();
		o.setParent(null);
	}
}
