/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;

public class MapIterableMapTest extends TestCase {

	private Map<String, String> mapA;

	private Map<String, String> mapB;

	private Map<String, String> priorityMap;

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		mapA = new HashMap<String, String>();
		mapA.put("hoge", "hogeA");
		mapA.put("piyo", "piyoA");
		mapB = new HashMap<String, String>();
		mapB.put("hoge", "hogeB");
		mapB.put("naru", "naruB");
		priorityMap = new MapIterableMap<String, String>(Utils.list(mapA).list(mapB));
	}

	public void testGet1() {
		final String key = "hoge";
		assertEquals(mapA.get(key), priorityMap.get(key));
		assertNotSame(mapB.get(key), priorityMap.get(key));
	}

	public void testGet2() {
		final String key = "piyo";
		assertEquals(mapA.get(key), priorityMap.get(key));
		assertNotSame(mapB.get(key), priorityMap.get(key));
	}

	public void testGet3() {
		final String key = "naru";
		assertNotSame(mapA.get(key), priorityMap.get(key));
		assertEquals(mapB.get(key), priorityMap.get(key));
	}

	public void testGet4() {
		final String key = "hodo";
		assertNull(priorityMap.get(key));
	}

	public void testPut1() {
		final String key = "hoge";
		final String value = "hogeA2";
		priorityMap.put(key, value);
		assertEquals(mapA.get(key), priorityMap.get(key));
		assertNotSame(mapB.get(key), priorityMap.get(key));
		assertEquals(value, mapA.get(key));

	}

	public void testPut2() {
		final String key = "piyo";
		final String value = "piyoA2";
		priorityMap.put(key, value);
		assertEquals(mapA.get(key), priorityMap.get(key));
		assertNotSame(mapB.get(key), priorityMap.get(key));
		assertEquals(value, mapA.get(key));
	}

	public void testPut3() {
		final String key = "naru";
		final String value = "naruA2";
		priorityMap.put(key, value);
		assertEquals(mapA.get(key), priorityMap.get(key));
		assertNotSame(mapB.get(key), priorityMap.get(key));
		assertEquals(value, mapA.get(key));
	}

	public void testPut5() {
		final Map<String, String> emptyMap = Collections.emptyMap();
		priorityMap = new MapIterableMap<String, String>(Collections.singleton(emptyMap));
		try {
			priorityMap.put("key0", "value0");
			fail();
		} catch (final UnsupportedOperationException expected) {
		}
	}

	public void testPutEmpty() {
		final Map<String, String> map = new MapIterableMap<String, String>(
				new ArrayList<Map<String, String>>());
		assertNull(map.put("a", "b"));
	}

	public void testRemove() {
		priorityMap = new MapIterableMap<String, String>(
				Collections.singleton(Collections.singletonMap("key0", "value0")));
		try {
			priorityMap.remove("key0");
			fail();
		} catch (final UnsupportedOperationException expected) {
		}
	}
}
