/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.web;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

/**
 * 各スコープを属性として持つコンテキストです。
 * 
 * セッションスコープとアプリケーションスコープは
 * 複数のスレッドからアクセスされる可能性があるので、
 * {@link Map}ではなく{@link ConcurrentMap}として定義することにより
 * {@link woolpack.fn.Fn}実装クラスにおける並行性の制御を容易にします。
 * @author nakamura
 *
 */
public interface WebContext {
	Map<String, List<Object>> getInput();
	void setInput(Map<String, List<Object>> input);
	Map<String, Object> getRequest();
	ConcurrentMap<String, Object> getSession();
	ConcurrentMap<String, Object> getApplication();
	Object getContainer();
	void setContainer(final Object container);
}
