<?php
/*
Plugin Name: Search Everything
Plugin URI: http://dancameron.org/wordpress/wordpress-plugins/search-everything-wordpress-plugin/
Description: Adds search functionality with little setup. Including the option to search pages, attachments, drafts, comments and custom fields (metadata).  wp-admin options page added to customize default searches.
Heavy props to <a href="http://kinrowan.net">Cori Schlegel</a> for making the options panel and additional searches possible. 
Version: 2.2 
Author: Dan Cameron
Author URI: http://dancameron.org
*/

/*  Daniel Cameron  (email : dancameron@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


load_plugin_textdomain('search_everything',$path = 'wp-content/plugins');

//add filters based upon option settings

//logging
$logging = 0;

function SEv_log($msg) {
	global $logging;
	if ($logging) {
		$fp = fopen("logfile.log","a+");
		$date = date("Y-m-d H:i:s ");
		$source = "search-everything plugin: ";
		fwrite($fp, "\n\n".$date."\n".$source."\n".$msg);
		fclose($fp);
	}
	return true;
	}



//add filters based upon option settings
if ("true" == get_option('SEv_use_page_search')) {
	add_filter('posts_where', 'SEv_search_pages');
	SEv_log("searching pages");
	}

if ("true" == get_option('SEv_use_comment_search')) {
	add_filter('posts_where', 'SEv_search_comments');
	add_filter('posts_join', 'SEv_comments_join');
	SEv_log("searching comments");
	}

if ("true" == get_option('SEv_use_draft_search')) {
	add_filter('posts_where', 'SEv_search_draft_posts');
	SEv_log("searching drafts");
	}

if ("true" == get_option('SEv_use_attachment_search')) {
	add_filter('posts_where', 'SEv_search_attachments');
	SEv_log("searching attachments");
	}

if ("true" == get_option('SEv_use_metadata_search')) {
	add_filter('posts_where', 'SEv_search_metadata');
	add_filter('posts_join', 'SEv_search_metadata_join');
	SEv_log("searching metadata");
	}


//search pages
function SEv_search_pages($where) {
	global $wp_query;
	if (!empty($wp_query->query_vars['s'])) {
		$where = str_replace(' AND (post_status = "publish"', ' AND (post_status = "publish" or post_status = "static"', $where);
	}

	SEv_log("pages where: ".$where);
	return $where;
}

//search drafts
function SEv_search_draft_posts($where) {
	global $wp_query;
	if (!empty($wp_query->query_vars['s'])) {
		$where = str_replace(' AND (post_status = "publish"', ' AND (post_status = "publish" or post_status = "draft"', $where);
	}

	SEv_log("drafts where: ".$where);
	return $where;
}

//search attachments
function SEv_search_attachments($where) {
	global $wp_query;
	if (!empty($wp_query->query_vars['s'])) {
		$where = str_replace(' AND (post_status = "publish"', ' AND (post_status = "publish" or post_status = "attachment"', $where);
		$where = str_replace('AND post_status != "attachment"','',$where);
	}

	SEv_log("attachments where: ".$where);
	return $where;
}

//search comments
function SEv_search_comments($where) {
global $wp_query;
	if (!empty($wp_query->query_vars['s'])) {
		$where .= " OR (comment_content LIKE '%" . $wp_query->query_vars['s'] . "%') ";
	}

	SEv_log("comments where: ".$where);

	return $where;
}

//join for searching comments
function SEv_comments_join($join) {
	global $wp_query, $wpdb;

	if (!empty($wp_query->query_vars['s'])) {

		if ('true' == get_option('SEv_approved_comments_only')) {
			$comment_approved = " AND comment_approved =  '1'";
		} else {
			$comment_approved = '';
		}

		$join .= "LEFT JOIN $wpdb->comments ON ( comment_post_ID = ID " . $comment_approved . ") ";
	}
	SEv_log("comments join: ".$join);
	return $join;
}

//search metadata
function SEv_search_metadata($where) {
global $wp_query;
	if (!empty($wp_query->query_vars['s'])) {
		$where .= " OR meta_value LIKE '%" . $wp_query->query_vars['s'] . "%' ";
	}

	SEv_log("metadata where: ".$where);

	return $where;
}

//join for searching metadata
function SEv_search_metadata_join($join) {
	global $wp_query, $wpdb;

	if (!empty($wp_query->query_vars['s'])) {

		$join .= "LEFT JOIN $wpdb->postmeta ON $wpdb->posts.ID = $wpdb->postmeta.post_id ";
	}
	SEv_log("metadata join: ".$join);
	return $join;
}


//build admin interface
function SEv_option_page() {

global $wpdb, $table_prefix;

	if ( isset($_POST['SEv_update_options']) ) {

		$errs = array();

		if ( !empty($_POST['search_pages']) ) {
			update_option('SEv_use_page_search', "true");
		} else {
			update_option('SEv_use_page_search', "false");
		}

		if ( !empty($_POST['search_comments']) ) {
			update_option('SEv_use_comment_search', "true");
		} else {
			update_option('SEv_use_comment_search', "false");
		}

		if ( !empty($_POST['appvd_comments']) ) {
			update_option('SEv_approved_comments_only', "true");
		} else {
			update_option('SEv_approved_comments_only', "false");
		}

		if ( !empty($_POST['search_drafts']) ) {
			update_option('SEv_use_draft_search', "true");
		} else {
			update_option('SEv_use_draft_search', "false");
		}

		if ( !empty($_POST['search_attachments']) ) {
			update_option('SEv_use_attachment_search', "true");
		} else {
			update_option('SEv_use_attachment_search', "false");
		}

		if ( !empty($_POST['search_metadata']) ) {
			update_option('SEv_use_metadata_search', "true");
		} else {
			update_option('SEv_use_metadata_search', "false");
		}

		if ( empty($errs) ) {
			echo '<div id="mesSEvge" class="updated fade"><p>Options updated!</p></div>';
		} else {
			echo '<div id="mesSEvge" class="error fade"><ul>';
			foreach ( $errs as $name => $msg ) {
				echo '<li>'.wptexturize($msg).'</li>';
			}
			echo '</ul></div>';
	 }
	} // End if update

	//set up option checkbox values
	if ('true' == get_option('SEv_use_page_search')) {
		$page_search = 'checked="true"';
	} else {
		$page_search = '';
	}

	if ('true' == get_option('SEv_use_comment_search')) {
		$comment_search = 'checked="true"';
	} else {
		$comment_search = '';
	}

	if ('true' == get_option('SEv_approved_comments_only')) {
		$appvd_comment = 'checked="true"';
	} else {
		$appvd_comment = '';
	}

	if ('true' == get_option('SEv_use_draft_search')) {
		$draft_search = 'checked="true"';
	} else {
		$draft_search = '';
	}

	if ('true' == get_option('SEv_use_attachment_search')) {
		$attachment_search = 'checked="true"';
	} else {
		$attachment_search = '';
	}

	if ('true' == get_option('SEv_use_metadata_search')) {
		$metadata_search = 'checked="true"';
	} else {
		$metadata_search = '';
	}

	?>

	<div style="width:75%;" class="wrap" id="SEv_options_panel">
	<h2><?php echo _e('Search Everything','search_everything'); ?></h2>

	<div id="searchform"><?php include (TEMPLATEPATH . '/searchform.php'); ?></div>

	<p><?php _e('Select the options you would like to enable for seaching.','search_everything'); ?><br />
	<?php _e('Any items selected here will be searched in every search query on the site; in addition to the built-in post search.','search_everything'); ?><br />
	<?php _e('use the search box above to test your results (this may not work with some themes).','search_everything'); ?></p>

	<form method="post">

	<table id="search_options" cell-spacing="2" cell-padding="2">
		<tr>
			<td class="col1"><input type="checkbox" name="search_pages" value="<?php echo get_option('SEv_use_page_search'); ?>" <?php echo $page_search; ?> /></td>
			<td class="col2"><?php _e('Search pages','search_everything'); ?></td>
		</tr>
		<tr>
			<td class="col1"><input type="checkbox" name="search_comments" value="<?php echo get_option('SEv_use_comment_search'); ?>" <?php echo $comment_search; ?> /></td>
			<td class="col2"><?php _e('Search all comments','search_everything'); ?></td>
		</tr>
		<tr class="child_option">
			<td>&nbsp;</td>
			<td>
				<table>
					<tr>
						<td class="col1"><input type="checkbox" name="appvd_comments" value="<?php echo get_option('SEv_approved_comments_only'); ?>" <?php echo $appvd_comment; ?> /></td>
						<td class="col2"><?php _e('Search approved comments only','search_everything'); ?></td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td class="col1"><input type="checkbox" name="search_drafts" value="<?php echo get_option('SEv_use_draft_search'); ?>" <?php echo $draft_search; ?> /></td>
			<td class="col2"><?php _e('Search unpublished drafts','search_everything'); ?></td>
		</tr>
		<tr>
			<td class="col1"><input type="checkbox" name="search_attachments" value="<?php echo get_option('SEv_use_attachment_search'); ?>" <?php echo $attachment_search; ?> /></td>
			<td class="col2"><?php _e('Search attachments','search_everything'); ?></td>
		</tr>
		<tr>
			<td class="col1"><input type="checkbox" name="search_metadata" value="<?php echo get_option('SEv_use_metadata_search'); ?>" <?php echo $metadata_search; ?> /></td>
			<td class="col2"><?php _e('Search custom fields (metadata)','search_everything'); ?></td>
		</tr>
	</table>

	<p class="submit">
	<input type="submit" name="SEv_update_options" value="<?php _e('Update &raquo;','search_everything'); ?>"/>
	</p>
	</form>

	</div>

	<?php
}	//end SEv_option_page

function SEv_add_options_panel() {
	$SEv_pluginname = __('Search Everything','search_everything');
	add_options_page($SEv_pluginname, $SEv_pluginname, 1, 'SEv_options_page', 'SEv_option_page');
}
add_action('admin_menu', 'SEv_add_options_panel');

//styling options page
function SEv_options_style() {
	?>
	<style>

	table#search_options {
		table-layout: auto;
 	}


 	#search_options td.col1, #search_options th.col1 {
		width: 30px;
		text-align: left;
  	}

 	#search_options td.col2, #search_options th.col2 {
		width: 280px;
		margin-left: -15px;
		text-align: left;
  	}

  	#search_options tr.child_option {
		margin-left: 15px;
		margin-top; -3px;
   }

   #SEv_options_panel p.submit {
		text-align: left;
   }

	div#searchform div {
		margin-left: auto;
		margin-right: auto;
		margin-top: 5px;
		margin-bottom: 5px;
 	}

 	</style>

<?php
}


add_action('admin_head', 'SEv_options_style');

?>