<?php
/*
Plugin Name: Popularity bar graph
Plugin URI: http://wppluginsj.sourceforge.jp/popularity-bargraph/
Description: Display post popularity bar graph on your blog.
Version: 0.1.1
Author: wokamoto
Author URI: http://dogmap.jp/
*/ 

if(strstr($_SERVER['PHP_SELF'], 'popularity-bargraph.php') && isset($_GET['css'])) {
 // Echo Dynamic CSS (.css)
 $bar_graph_color    = '#D6E7FD';
 $bar_graph_bg_color = '#83B5E2';

 // Class Name
 $akpc_class_name = 'akpc_pop';

 header("Content-Type:text/css");
?>
dl.<?php echo $akpc_class_name; ?> {
 clear:both;
 padding:0.25em 0;
 margin:0;
 height:18px;
}
dl.<?php echo $akpc_class_name; ?> dt {
 float:left;
 display:block;
 position:relative;
 padding:0 2px 0 0;
 margin:0;
}
dl.<?php echo $akpc_class_name; ?> dd {
 float:left;
 display:block;
 position:relative;
 background-color:<?php echo $bar_graph_bg_color; ?>;
 padding:1px;
 margin:3px 0 0 20px;
 height:12px;
 width:120px;
}
dl.<?php echo $akpc_class_name; ?> dd div {
 float:left;
 position:relative;
 background-color:<?php echo $bar_graph_color; ?>;
 height:12px;
 text-align:right;
}
dl.<?php echo $akpc_class_name; ?> dd strong {
 position:absolute;
 right:0;
 top:-0.3em;
 text-align:left;
 font-size:0.75em;
}
<?php

} else {

 function akpc_bargraph($post_id = '', $display = true, $akpc_class_name = 'akpc_pop', $akpc_pop_str = '<dl class="%1s"><dt>%2$s</dt><dd><div style="width:%3$s;"><strong>%3$s</strong></div></dd></dl>%4$s') {
  if (!class_exists('ak_popularity_contest')) {return;}

  global $akpc;

  if ($post_id == '') {global $post; $post_id = $post->ID;}
  $wk_post_rank = $akpc->get_post_rank($post_id);

  if (!(function_exists('is_mobile') && is_mobile())) {
   $akpc_title = 'Popularity:';
   $akpc_help = '';
   $wk_popularity = '0%';
   if (strstr($wk_post_rank, '%') != false) {
    if (preg_match('/ *(.*[:：]) *(\d+%)(.*)/', $wk_post_rank, $matches) > 0) {
     $akpc_title = $matches[1];
     $wk_popularity = $matches[2];
     $akpc_help = $matches[3];
    }
    unset ($matches);
   }
   $akpc_pop_str = sprintf($akpc_pop_str, $akpc_class_name, $akpc_title, $wk_popularity, $akpc_help);
  } else {
   $akpc_pop_str = $wk_post_rank;
  }

  if ($display) {
   echo $akpc_pop_str."\n";
  } else {
   return $akpc_pop_str;
  }
 }

 function akpc_content_pop_bargraph($content) {
  if (!class_exists('ak_popularity_contest')) {return $content;}
  if (function_exists('is_mobile') && is_mobile()) {return $content;}

  $akpc_class_name = 'akpc_pop';

  if (strstr($content,'<p class="'.$akpc_class_name.'">')) {
   global $akpc,$post;
   $wk_post_rank = '<p class="'.$akpc_class_name.'">'.$akpc->get_post_rank($post->ID).'</p>';
   $wk_post_rank_bargraph = akpc_bargraph($post->ID, false, $akpc_class_name);
   $content = str_replace($wk_post_rank, $wk_post_rank_bargraph, $content);
   //$content = preg_replace('/\<p class\="(.*)"\> *(.*[:：]) *(\d+%)(.*)\<\/p\>/i', '<dl class="$1"><dt>$2</dt><dd><div style="width:$3;"><strong>$3</strong></div></dd></dl>$4', $content);
  }
  return $content;
 }

 function akpc_bargraph_css_add() {
  if (!class_exists('ak_popularity_contest')) {return;}
  if (function_exists('is_mobile') && is_mobile()) {return;}

  echo '<link rel="stylesheet" href="'.get_settings('siteurl').'/wp-content/plugins/popularity-bargraph.php?css" type="text/css" media="screen" />'."\n";
 }

 add_action('the_content', 'akpc_content_pop_bargraph',999);
 add_action('the_excerpt', 'akpc_content_pop_bargraph',999);
 add_action('wp_head', 'akpc_bargraph_css_add');
}
?>
