<?php
/* ==================================================
 *   Ktai Admin Process Posts
 *   based on wp-admin/post.php of WP 2.3
   ================================================== */

require_once dirname(__FILE__) . '/admin.php';
$parent_file = 'edit.php';
$submenu_file = 'edit.php';

wp_reset_vars(array('action', 'safe_mode', 'withcomments', 'posts', 'content', 'edited_post_title',));

if (isset( $_POST['deletepost'])) {
	$action = 'delete';
}
switch($action) {
case 'post':
	$parent_file = 'post-new.php';
	$submenu_file = 'post-new.php';
	check_admin_referer('add-post');
	$post_ID = 'post' == $action ? $KS_Admin->write_post() : $KS_Admin->edit_post();
	// Redirect.
	if (!empty($_POST['mode'])) {
		$location = 'post-new.php';
	} else {
		$location = "post-new.php?posted=$post_ID";
	}
	if (isset($_POST['save'])) {
		$location = "post.php?action=edit&post=$post_ID";
	}
	if (empty($post_ID)) {
		$location = 'post-new.php';
	}
	$KS_Admin->redirect($location);
	exit();
	break;
case 'edit':
	$title = __('Edit');
	$editing = true;
	$post_ID = $p = (int) $_GET['post'];
	$post = get_post($post_ID);

	if ( empty($post->ID) ) {
		Ktai_Style::ks_die(__("You attempted to edit a post that doesn't exist. Perhaps it was deleted?"));
	}
	if ( 'page' == $post->post_type ) {
		$KS_Admin->redirect("page.php?action=edit&post=$post_ID");
		exit();
	}
	$post = get_post_to_edit($post_ID);
	if ( !current_user_can('edit_post', $post_ID) ) {
		Ktai_Style::ks_die(__('You are not allowed to edit this post.'));
	}
	include dirname(__FILE__) . '/admin-header.php';
	include dirname(__FILE__) . '/edit-form.php';
	$referer = $KS_Admin->get_referer();
	if ($referer) {
		echo '<div><img localsrc="64" alt="' . __('&lt;-', 'ktai_style') . '" />' . sprintf(__('Back to <a href="%s">the previous page</a>.', 'ktai_style'), attribute_escape($referer)) . '</div>';
	}
	break;
case 'editpost':
	$post_ID = (int) $_POST['post_ID'];
	check_admin_referer('update-post_' . $post_ID);
	$post_ID = $KS_Admin->edit_post();
	if ( 'post' == $_POST['originalaction'] ) {
		if (! empty($_POST['mode'])) {
			$location = 'post-new.php';
		} else {
			$location = "post-new.php?posted=$post_ID";
		}
		if ( isset($_POST['save']) )
			$location = "post.php?action=edit&post=$post_ID";
	} else {
		$referredby = '';
		if ( !empty($_POST['referredby']) )
			$referredby = preg_replace('|https?://[^/]+|i', '', $_POST['referredby']);
		$referer = preg_replace('|https?://[^/]+|i', '', $KS_Admin->get_referer());

		if ($_POST['save']) {
			$location = "post.php?action=edit&post=$post_ID";
		} elseif (!empty($referredby) && $referredby != $referer) {
			$location = $_POST['referredby'];
			if ( $_POST['referredby'] == 'redo' )
				$location = get_permalink( $post_ID );
		} else {
			$location = 'post-new.php';
		}
	}

	$KS_Admin->redirect($location); // Send user on their way while we keep working
	exit();
	break;
case 'delete':
	$post_id = (isset($_GET['post'])) ? intval($_GET['post']) : intval($_POST['post_ID']);
	check_admin_referer('delete-post_' . $post_id);
	$post = & get_post($post_id);
	if (! current_user_can('delete_post', $post_id)) {
		Ktai_Style::ks_die(__('You are not allowed to delete this post.'));
	}
	if ( $post->post_type == 'attachment' ) {
		if (! wp_delete_attachment($post_id)) {
			Ktai_Style::ks_die(__('Error in deleting...'));
		}
	} else {
		if (! wp_delete_post($post_id)) {
			Ktai_Style::ks_die(__('Error in deleting...'));
		}
	}
	$sendback = $KS_Admin->get_referer();
	if (strpos($sendback, 'post.php') !== false) {
		$sendback = ks_admin_url(FALSE) . 'post-new.php';
	}
	$sendback = preg_replace('|[^a-z0-9-~+_.?#=&;,/:]|i', '', $sendback);
	$KS_Admin->redirect($sendback);
	exit();
	break;
default:
	$KS_Admin->redirect('edit.php');
	exit();
	break;
} // end switch
include dirname(__FILE__) . '/admin-footer.php'; 
?>