/**
 * jQuery lightpop plugin
 * This jQuery plugin was inspired on jQuery lightBox plugin by Leandro Vieira Pinho (http://leandrovieira.com/projects/jquery/lightpop/)
 * @name jquery-lightpop.js
 * @author wokamoto - http://dogmap.jp
 * @version 0.1
 * @date December 20, 2007
 * @category jQuery plugin
 * @copyright (c) 2007 wokamoto (dogmap.jp)
 * @license  Released under the GPL license (http://www.gnu.org/copyleft/gpl.html)
 * @example http://dogmap.jp/lightpop_sample/sample.html
 */
(function(jQuery){
jQuery.fn.lightpop = function(settings){
 settings = jQuery.extend({
   overlayBgColor:	'#000'
  ,overlayOpacity:	0.8
  ,contentBorder:	'none'
  ,imageLoading:	'images/lightpop-ico-loading.gif'
  ,imageBtnPrev:	'images/lightpop-btn-prev.gif'
  ,imageBtnNext:	'images/lightpop-btn-next.gif'
  ,imageBtnClose:	'images/lightpop-btn-close.gif'
  ,imageBlank:		'images/lightpop-blank.gif'
  ,imageBtnPrevWidth:	63
  ,imageBtnNextWidth:	63
  ,imageBtnCloseWidth:	66
  ,containerBorderSize:	10
  ,containerResizeSpeed:400
  ,txtImage:		'Image'
  ,txtOf:		'of'
  ,keyToClose:		'c'
  ,keyToPrev:		'p'
  ,keyToNext:		'n'
  ,flvplayer:		'flvplayer.swf'
  ,iconAdd:		true
  ,iconPath:		'images/'
 }, settings);

 var fileTypes = new Array(
  {
   type: 'Image'
  ,match: function(strUrl){return (strUrl.match(/\.(jpe?g|gif|png|bmp)[\?]?.*$/i) != null);}
  ,set: function(contentNo){
    var objImageloader = new Image();
    objImageloader.onload = function(){
     var strSrc = '<img src="' + this.src + '" />';
     contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], {content:strSrc, width:this.width, height:this.height, later:(jQuery.browser.msie ? 250 : 100)});
     set_content_to_view(contentNo);
     this.onload = function(){};
    };
    objImageloader.src = contentInfo[contentNo].href;
   }
  ,preload: function(contentNo){
    var objImagePreloader = new Image();
    objImagePreloader.src = contentInfo[contentNo].href;
   }
  }
 ,{
   type: 'Video'
  ,match: function(strUrl){return (strUrl.match(/\.(flv|swf|rm|mov|3gp|mp4|asf|avi|mpg|wmv)[\?]?.*$/i) != null);}
  ,set: function(contentNo){
     var arrSizes = get_sizes_from_str(contentInfo[contentNo].href);
     var strUrl = contentInfo[contentNo].href.replace(/\?.*$/, '');
     var strSrc;
     switch(strUrl.match(/\.(flv|swf|rm|mov|3gp|mp4|asf|avi|mpg|wmv)$/i)[1]){
      case 'flv':
       strUrl = settings.flvplayer + '?file=' + strUrl;
      case 'swf':
       strSrc = '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,22,0" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '"><param name="movie" value="' + strUrl + '" /><param name="quality" value="high" /><param name="bgcolor" value="#000000" /><param name="wmode" value="transparent" /><embed src="' + strUrl + '" quality="high" bgcolor="#000000"  width="' + arrSizes[0] + '" height="' + arrSizes[1] + '" align="" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" wmode="transparent"></embed></object>';
       break;
      case 'rm':
       strSrc = '<object classid="clsid:cfcdaa03-8be4-11cf-b84b-0020afbbccfa" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '"><param name="src" value="' + strUrl + '" /><param name="autostart" value="true" /><param name="controls" value="imagewindow,controlpanel" /><embed src="' + strUrl + '" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '" autostart="true" controls="imagewindow,controlpanel" type="audio/x-pn-realaudio-plugin"></embed></object>';
       break;
      case 'mov':
      case 'mp4':
      case '3gp':
       arrSizes[1] += 20;
       strSrc = '<object classid="clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B" codebase="http://www.apple.com/qtactivex/qtplugin.cab" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '"><param name="src" value="' + strUrl + '" /><param name="href" value="' + strUrl + '" /><param name="controller" value="true" /><param name="pluginspage" value="http://www.apple.com/quicktime/download/" /><param name="autoplay" value="true" /><param name="bgcolor" value="000000" /><embed src="' + strUrl + '" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '" bgcolor="000000" autoplay="true" controller="true" src="' + strUrl + '" type="video/quicktime" pluginspage="http://www.apple.com/quicktime/download/"></embed></object>';
       break;
      default:
       arrSizes[1] += 20;
       strSrc = '<object classid="clsid:6BF52A52-394A-11d3-B153-00C04F79FAA6" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '" type="application/x-oleobject"><param name="url" value="' + strUrl + '" /><param name="autostart" value="true" /><param name="uiMode" value="full" /><embed src="' + strUrl + '" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '" autostart="true" uiMode="full" type="application/x-mplayer2" pluginspage="http://www.microsoft.com/windows/mediaplayer/"></embed></object>';
       break;
     }
     contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], {content:strSrc, width:arrSizes[0], height:arrSizes[1], later:500});
     set_content_to_view(contentNo);
    }
  ,icon_css: {background:'transparent url(' + settings.iconPath + 'icon-video.png) no-repeat scroll 1px 0pt', 'padding-left':'18px'}
  }
 ,{
   type: 'YouTube'
  ,match: function(strUrl){return (strUrl.match(/^http:\/\/.+\.youtube\..+\/watch/i) != null);}
  ,set: function(contentNo){
     var arrSizes = get_sizes_from_str(contentInfo[contentNo].href, [425,355]);
     var strUrl = contentInfo[contentNo].href.replace(/&.*$/i,'').replace(/^http.*youtube.*watch.*?v=(.*)$/i,'http://www.youtube.com/v/$1');
     var strSrc = '<object data="' + strUrl + '" type="application/x-shockwave-flash" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '"><param name="movie" value="' + strUrl + '" /><param name="wmode" value="transparent" /></object>';
     contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], {content:strSrc, width:arrSizes[0], height:arrSizes[1], later:1000});
     set_content_to_view(contentNo);
    }
  ,icon_css: {background:'transparent url(' + settings.iconPath + 'icon-youtube.png) no-repeat scroll 1px 0pt', 'padding-left':'18px'}
  }
 ,{
   type: 'metacafe'
  ,match: function(strUrl){return (strUrl.match(/^http:\/\/.+\.metacafe\..+\/watch/i) != null);}
  ,set: function(contentNo){
     var arrSizes = get_sizes_from_str(contentInfo[contentNo].href, [400,345]);
     var strUrl = contentInfo[contentNo].href.replace(/&.*$/i,'').replace(/\/$/i,'').replace(/^http.*metacafe.*watch\/(.*)$/i, 'http://www.metacafe.com/fplayer/$1.swf');
     var strSrc = '<object data="' + strUrl + '" type="application/x-shockwave-flash" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '"><param name="movie" value="' + strUrl + '" /><param name="wmode" value="transparent" /></object>';
     contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], {content:strSrc, width:arrSizes[0], height:arrSizes[1], later:1000});
     set_content_to_view(contentNo);
    }
  ,icon_css: {background:'transparent url(' + settings.iconPath + 'icon-metacafe.png) no-repeat scroll 1px 0pt', 'padding-left':'18px'}
  }
 ,{
   type: 'Contents'
  ,match: function(strUrl){return (strUrl.match(window.location.host) != null);}
  ,set: function(contentNo){
     jQuery.get(contentInfo[contentNo].href, function(responseText, status){
      var arrSizes = get_sizes_from_str(contentInfo[contentNo].href);
      if (arrSizes == null) {
       var arrPageSizes = get_page_sizes();
       arrSizes = new Array(Math.round(arrPageSizes[0] / 4), Math.round(arrPageSizes[1] / 4));
      }
      var strSrc = '<div>' + responseText.replace(/[\r\n]/g, '').replace(/.*<body.*?>(.*?)<\/body>.*$/, '$1').replace(/<script.*?>.*<\/script>/g, '') + '</div>';
      contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], {content:strSrc, width:arrSizes[0], height:arrSizes[1], later:500, callback:function(){jQuery('#lightpop-loading').hide();}});
      set_content_to_view(contentNo);
     });
    }
  ,content_css: {'text-align':'left', 'line-height':'1.2em'}
  }
 );

 var contentInfo = new Array();

 var initialize = function(jQueryObj){
  // get button width
  if(!settings.imageBtnPrevWidth){
   var objImageBtnPrev = new Image();
   objImageBtnPrev.onload = function(){settings.imageBtnPrevWidth = this.width; this.onload = function(){};};
   objImageBtnPrev.src = settings.imageBtnPrev;
  }

  if(!settings.imageBtnNextWidth){
   var objImageBtnNext = new Image();
   objImageBtnNext.onload = function(){settings.imageBtnNextWidth = this.width; this.onload = function(){};};
   objImageBtnNext.src = settings.imageBtnNext;
  }

  if(!settings.imageBtnCloseWidth){
   var objImageBtnClose = new Image();
   objImageBtnClose.onload = function(){settings.imageBtnCloseWidth = this.width; this.onload = function(){};};
   objImageBtnClose.src = settings.imageBtnClose;
  }

  // get matched object
  var domMatchedObj = new Array();
  var intImage = 0;
  contentInfo.length = 0;
  jQueryObj.filter('a').each(function() {
   if (this.getAttribute('href').match(/^https?:/i) == null) {
    if (this.getAttribute('href').match(/^\//i) == null) {
     this.setAttribute('href', window.location.href.replace(/^(.*\/).*$/i, '$1') + this.getAttribute('href').replace(/^\/?(.*)$/i, '$1'));
    } else {
     this.setAttribute('href', window.location.protocol + '//' + window.location.hostname + '/' + this.getAttribute('href'));
    }
   }
   for (var optindex = 0; optindex < fileTypes.length; optindex++) {
    if (fileTypes[optindex].match(this.getAttribute('href'))) {
     if (settings.iconAdd && fileTypes[optindex].icon_css) {jQuery(this).css(fileTypes[optindex].icon_css);}
     contentInfo.push({
      index: optindex,
      type:  (fileTypes[optindex].type ? fileTypes[optindex].type : settings.txtImage),
      href:  this.getAttribute('href'),
      title: (this.getAttribute('title') != null ? this.getAttribute('title') : this.innerHTML)
     });
     jQuery(this).unbind('click').click((function(i){return function(){start_lightpop(i); return false;}}).call(this, intImage));
     domMatchedObj.push(this);
     intImage++;
     break;
    }
   }
  });
  return new jQuery(domMatchedObj);
 }

 var start_lightpop = function(intClickedContent){
  // hide embed, object, select element
  jQuery('embed, object, select').css({visibility:'hidden'});

  // set interface
  jQuery('body').append(jQuery('<div id="jquery-overlay"></div><div id="jquery-lightpop"><div id="lightpop-container"><div id="lightpop-container-content-box"><div id="lightpop-container-content"><div id="lightpop-content"></div><div style="" id="lightpop-nav"><a href="#" id="lightpop-nav-btnPrev"></a><a href="#" id="lightpop-nav-btnNext"></a></div><div id="lightpop-loading"><a href="#" id="lightpop-loading-link"><img src="'+settings.imageLoading+'"></a></div></div></div><div id="lightpop-container-content-data-box"><div id="lightpop-container-content-data"><div id="lightpop-content-details"><span id="lightpop-content-details-caption"></span><span id="lightpop-content-details-currentNumber"></span></div><div id="lightpop-secNav"><a href="#" id="lightpop-secNav-btnClose"><img src="'+settings.imageBtnClose+'"></a></div></div></div></div></div>').hide());

  // set interface CSS
  var arrPageSizes  = get_page_sizes();
  var arrPageScroll = get_page_scroll();
  jQuery('#jquery-overlay').css({position:'absolute', top:0, left:0, 'z-index':90, 'background-color':settings.overlayBgColor, opacity:settings.overlayOpacity, width:arrPageSizes[0], height:arrPageSizes[1]});
  jQuery('#jquery-lightpop').css({position:'absolute', top:arrPageScroll[1] + Math.round(arrPageSizes[3] / 10), left:arrPageScroll[0], width:'100%', 'z-index':100, 'text-align':'center', 'line-height':0, border:'none'});
  jQuery('#jquery-lightpop a img').css({border:'none'});
  jQuery('#lightpop-container').css({position:'relative', width:'250px', height:'250px', 'background-color':'transparent', margin:'0 auto', border:'none', overflow:'hidden'});
  jQuery('#lightpop-container-content-box').css({position:'relative', 'background-color':'transparent', width:'250px', height:'250px', margin:'0 auto', overflow:'hidden'});
  jQuery('#lightpop-container-content').css({padding:'10px'});
  jQuery('#lightpop-loading').css({position:'absolute', top:'40%', left:0, height:'25%', width:'100%', 'text-align':'center', 'line-height':0});
  jQuery('#lightpop-nav').css({position:'absolute', top:0, left:0, height:'10px', width:'100%', 'z-index':10});
  jQuery('#lightpop-nav a').css({outline:'none'});
  jQuery('#lightpop-nav-btnPrev, #lightpop-nav-btnNext').css({height:'100%', zoom:1, display:'block'});
  jQuery('#lightpop-nav-btnPrev').css({width:settings.imageBtnPrevWidth, left:0, float:'left'});
  jQuery('#lightpop-nav-btnNext').css({width:settings.imageBtnNextWidth, right:0, float:'right'});
  jQuery('#lightpop-container-content-data-box').css({font:'10px Verdana, Helvetica, sans-serif', 'background-color':'transparent', margin:'0 auto', 'line-height':'1.4em', overflow:'auto', width:'100%', padding:'0 10px 0'});
  jQuery('#lightpop-container-content-data').css({padding:'0 10px', color:'#666'});
  jQuery('#lightpop-content-details').css({width:'70%', float:'left', 'text-align':'left'});
  jQuery('#lightpop-content-details-caption').css({'font-weight':'bold'});
  jQuery('#lightpop-content-details-currentNumber').css({display:'block', clear:'left', 'padding-bottom':'1.0em'});
  jQuery('#lightpop-secNav-btnClose').css({width:settings.imageBtnCloseWidth, float:'right', 'padding-bottom':'0.7em'});

  // show interface
  jQuery('#jquery-overlay').fadeIn(settings.containerResizeSpeed, function(){
   jQuery('#jquery-lightpop').show();
   jQuery(this).click(function(){finish_lightpop();});
  });
  jQuery('#lightpop-loading-link, #lightpop-secNav-btnClose').click(function(){finish_lightpop(); return false;});
  window_resize(true);

  // set content
  set_content(intClickedContent);
 }

 var set_content = function(contentNo){
  jQuery('#lightpop-content').children().remove();
  jQuery('#lightpop-content, #lightpop-nav, #lightpop-nav-btnPrev, #lightpop-nav-btnNext, #lightpop-content-details, #lightpop-content-details-caption, #lightpop-content-details-currentNumber, #lightpop-secNav-btnClose').hide();
  jQuery('#lightpop-container').css({'background-color':'transparent', border:'none'}).show();
  jQuery('#lightpop-container-content-box').css({'background-color':'#fff', border:settings.contentBorder}).show();
  jQuery('#lightpop-loading').css({position:'absolute', 'margin-top':0}).show();
  jQuery('#lightpop-container-content-data-box').slideUp('fast');
  if (contentInfo[contentNo].content) {
   set_content_to_view(contentNo);
  } else {
   fileTypes[contentInfo[contentNo].index].set(contentNo);
  }
 };

 var set_content_to_view = function(contentNo){
  jQuery('#lightpop-content').append(jQuery(contentInfo[contentNo].content));
  setTimeout(function(){
   show_container(contentNo);
   if (contentInfo[contentNo].callback) {contentInfo[contentNo].callback();}
  }, contentInfo[contentNo].later);
 };

 var show_container = function(contentNo){
  var intWidth  = (contentInfo[contentNo].width  + (settings.containerBorderSize * 2));
  var intHeight = (contentInfo[contentNo].height + (settings.containerBorderSize * 2));

  // show content
  jQuery('#lightpop-container').css({width:'100%', height:intHeight});
  jQuery('#lightpop-container-content-box').animate({width:intWidth, height:intHeight}, settings.containerResizeSpeed, function(){
   jQuery(this).css({'background-color':'transparent', border:'none'});
   jQuery('#lightpop-container').css({width:intWidth, 'background-color':'#fff', border:settings.contentBorder});
   jQuery('#lightpop-loading').css({position:'relative', 'margin-top':document.getElementById('lightpop-loading').offsetTop});
   if (fileTypes[contentInfo[contentNo].index].content_css) {jQuery('#lightpop-content').children().css(fileTypes[contentInfo[contentNo].index].content_css);}

   jQuery('#lightpop-content').fadeIn(function(){
     // set content data
     jQuery('#lightpop-container-content-data-box').css({width:contentInfo[contentNo].width}).show(function(){
      jQuery('#lightpop-content-details-caption').html(contentInfo[contentNo].title);
      jQuery('#lightpop-content-details-currentNumber').html(contentInfo[contentNo].type + (contentInfo.length > 1 ? ' ' + (contentNo + 1) + ' ' + settings.txtOf + ' ' + contentInfo.length : ''));
      jQuery('#lightpop-content-details, #lightpop-content-details-caption, #lightpop-content-details-currentNumber, #lightpop-secNav-btnClose').show();
      jQuery('#lightpop-container').animate({width:intWidth, height:intHeight + jQuery(this).height()}, 'fast');
     });

     // set navigation
     jQuery('#lightpop-nav').show(function(){
      jQuery('#lightpop-nav-btnPrev, #lightpop-nav-btnNext').css({height:Math.round(contentInfo[contentNo].height / 3), background:'transparent url(' + settings.imageBlank + ') no-repeat'}).unbind();
      if(contentNo != 0){
       jQuery('#lightpop-nav-btnPrev').hover(
        function(){jQuery(this).css({background:'url(' + settings.imageBtnPrev + ') left 30% no-repeat'});},
        function(){jQuery(this).css({background:'transparent url(' + settings.imageBlank + ') no-repeat'});}
       ).show().click((function(i){return function(){set_content(i); return false;}}).call(this, contentNo - 1));
      }
      if(contentNo != (contentInfo.length - 1)){
       jQuery('#lightpop-nav-btnNext').hover(
        function(){jQuery(this).css({background:'url(' + settings.imageBtnNext + ') right 30% no-repeat'});},
        function(){jQuery(this).css({background:'transparent url(' + settings.imageBlank + ') no-repeat'});}
       ).show().click((function(i){return function(){set_content(i); return false;}}).call(this, contentNo + 1));
      }
      keyboard_navigation(true, contentNo);
     });
   });

   // preload neighbor contents
   if((contentInfo.length - 1) > contentNo){
    if(fileTypes[contentInfo[contentNo + 1].index].preload){
     fileTypes[contentInfo[contentNo + 1].index].preload(contentNo + 1);
    }
   }
   if(contentNo > 0){
    if(fileTypes[contentInfo[contentNo - 1].index].preload){
     fileTypes[contentInfo[contentNo - 1].index].preload(contentNo - 1);
    }
   }
  });
 };

 var keyboard_navigation = function(enable, contentNo){
  jQuery(document).unbind('keydown');
  if (enable) {
   jQuery(document).keydown(function(objEvent){
    var key,keycode,escapeKey;
    if(objEvent == null){
     keycode = event.keyCode;
     escapeKey = 27;
    } else {
     keycode = objEvent.keyCode;
     escapeKey = objEvent.DOM_VK_ESCAPE;
    }
    key = String.fromCharCode(keycode).toLowerCase();
    if ((key == settings.keyToClose) || (key == 'x') || (keycode == escapeKey)) {
     finish_lightpop();
    } else if ((key == settings.keyToPrev) || (keycode == 37)) {
     if(contentNo != 0){set_content(contentNo - 1);}
    } else if ((key == settings.keyToNext) || (keycode == 39)) {
     if(contentNo != (contentInfo.length - 1)){set_content(contentNo + 1);}
    }
   });
  }
 }

 var window_resize = function(enable){
  jQuery(window).unbind('resize');
  if (enable) {
   jQuery(window).resize(function(){
    var arrPageSizes  = get_page_sizes();
    var arrPageScroll = get_page_scroll();
    jQuery('#jquery-overlay').css({width:arrPageSizes[0], height:arrPageSizes[1]});
    jQuery('#jquery-lightpop').css({top:arrPageScroll[1] + Math.round(arrPageSizes[3] / 10), left:arrPageScroll[0]});
   });
  }
 }

 var get_sizes_from_str = function(strText, arrDefaultSizes){
  var intWidth = 0, intHeight = 0;
  if (arrDefaultSizes) {
   intWidth  = arrDefaultSizes[0];
   intHeight = arrDefaultSizes[1];
  }
  var arrText = strText.toLowerCase().replace(/[\r\n]/g,'').replace(/["']/g,'').match(/(width|height)=([0-9]+)/ig);
  if (arrText) {
   jQuery.each(arrText, function(){
    if (this.match(/^width=[0-9]+$/i))  {intWidth  = Number(this.replace(/^width=([0-9]+)$/, '$1'));}
    if (this.match(/^height=[0-9]+$/i)) {intHeight = Number(this.replace(/^height=([0-9]+)$/,'$1'));}
   });
  }
  if(intWidth == 0 && intHeight == 0){
   return null;
  } else {
   return new Array(intWidth, intHeight);
  }
 }

 var get_page_sizes = function(){
  var xScroll,yScroll;
  if (window.innerHeight && window.scrollMaxY) {
   xScroll = window.innerWidth  + window.scrollMaxX;
   yScroll = window.innerHeight + window.scrollMaxY;
  } else if (document.body.scrollHeight > document.body.offsetHeight) {
   xScroll = document.body.scrollWidth;
   yScroll = document.body.scrollHeight;
  } else {
   xScroll = document.body.offsetWidth;
   yScroll = document.body.offsetHeight;
  }
  var windowWidth, windowHeight, pageHeight, pageWidth;
  if (self.innerHeight) {
   if(document.documentElement.clientWidth){
    windowWidth = document.documentElement.clientWidth;
   } else {
    windowWidth = self.innerWidth;
   }
   windowHeight = self.innerHeight;
  } else if (document.documentElement && document.documentElement.clientHeight) {
   windowWidth  = document.documentElement.clientWidth;
   windowHeight = document.documentElement.clientHeight;
  } else if (document.body) {
   windowWidth  = document.body.clientWidth;
   windowHeight = document.body.clientHeight;
  }
  pageWidth  = (xScroll < windowWidth  ? xScroll : windowWidth);
  pageHeight = (yScroll < windowHeight ? windowHeight : yScroll);
  return new Array(pageWidth, pageHeight, windowWidth, windowHeight);
 };

 var get_page_scroll = function(){
  var xScroll, yScroll;
  if(self.pageYOffset){
   yScroll = self.pageYOffset;
   xScroll = self.pageXOffset;
  }else if(document.documentElement && document.documentElement.scrollTop){
   yScroll = document.documentElement.scrollTop;
   xScroll = document.documentElement.scrollLeft;
  }else if(document.body){
   yScroll = document.body.scrollTop;
   xScroll = document.body.scrollLeft;
  }
  return new Array(xScroll, yScroll);
 };

 var finish_lightpop = function(){
  jQuery('object',jQuery('#jquery-lightpop')).css({visibility:'hidden'}).remove();
  jQuery('#lightpop-loading').children().remove();
  jQuery('#jquery-lightpop').slideUp(function(){
   jQuery(this).remove();
   jQuery('#jquery-overlay').fadeOut(function(){jQuery(this).remove();});
   // show embed, object, select element
   jQuery('embed, object, select').css({visibility:'visible'});
  });
  keyboard_navigation(false);
  window_resize(false);
 }

 return initialize(this);
};})(jQuery);
