<?php
/*
Plugin Name: WP-lightpop
Version: 0.1.2
Plugin URI: http://wppluginsj.sourceforge.jp/wp-lightpop/
Description: Add overlay images and videos (and more) to Your Wordpress site.
Author: wokamoto
Author URI: http://dogmap.jp/

 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html
*/

class LightPopController {
  var $plugin_name = 'wp-lightpop';
  var $options = array();
  var $options_default = array();
  var $note,$error;
  var $js_type = array(0 => 'jQuery', 1 => 'jQuery.noConflict');

  /*
  * Constructor
  */
  function LightPopController() {
    $this->note = '';
    $this->error = 0;

    $this->options_default = array(
      'overlayBgColor'       => "#000"
     ,'overlayOpacity'       => 0.8
     ,'contentBorder'        => "none"
     ,'imageLoading'         => "images/lightpop-ico-loading.gif"
     ,'imageBtnPrev'         => "images/lightpop-btn-prev.gif"
     ,'imageBtnNext'         => "images/lightpop-btn-next.gif"
     ,'imageBtnClose'        => "images/lightpop-btn-close.gif"
     ,'imageBlank'           => "images/lightpop-blank.gif"
     ,'imageBtnPrevWidth'    => 63
     ,'imageBtnNextWidth'    => 63
     ,'imageBtnCloseWidth'   => 66
     ,'containerBorderSize'  => 10
     ,'containerResizeSpeed' => 400
     ,'txtImage'             => "Image"
     ,'txtOf'                => "of"
     ,'keyToClose'           => "c"
     ,'keyToPrev'            => "p"
     ,'keyToNext'            => "n"
     ,'flvplayer'            => "flvplayer.swf"
     ,'iconAdd'              => 1
     ,'iconPath'             => "images/"
   );

    $wkoptions = get_option($this->plugin_name." Options");
    if (!is_array($wkoptions)) {
      $this->options['plugin_uri'] = trailingslashit(get_settings('siteurl')).'wp-content/plugins/'.basename(dirname(__FILE__));
      $plugin_root = preg_replace('/^https?:\/\/[^\/]*/i' , '', $this->options['plugin_uri']);

      $this->options['js_type']              = strtolower($this->js_type[0]);
      $this->options['load_framework']       = 0;
      $this->options['targetCSS']            = "a[@rel*=lightbox]";

      $this->options['overlayBgColor']       = $this->options_default['overlayBgColor'];
      $this->options['overlayOpacity']       = $this->options_default['overlayOpacity'];
      $this->options['contentBorder']        = $this->options_default['contentBorder'];
      $this->options['imageLoading']         = $plugin_root."/".$this->options_default['imageLoading'];
      $this->options['imageBtnPrev']         = $plugin_root."/".$this->options_default['imageBtnPrev'];
      $this->options['imageBtnNext']         = $plugin_root."/".$this->options_default['imageBtnNext'];
      $this->options['imageBtnClose']        = $plugin_root."/".$this->options_default['imageBtnClose'];
      $this->options['imageBlank']           = $plugin_root."/".$this->options_default['imageBlank'];
      $this->options['imageBtnPrevWidth']    = $this->options_default['imageBtnPrevWidth'];
      $this->options['imageBtnNextWidth']    = $this->options_default['imageBtnNextWidth'];
      $this->options['imageBtnCloseWidth']   = $this->options_default['imageBtnCloseWidth'];
      $this->options['containerBorderSize']  = $this->options_default['containerBorderSize'];
      $this->options['containerResizeSpeed'] = $this->options_default['containerResizeSpeed'];
      $this->options['txtImage']             = $this->options_default['txtImage'];
      $this->options['txtOf']                = $this->options_default['txtOf'];
      $this->options['keyToClose']           = $this->options_default['keyToClose'];
      $this->options['keyToPrev']            = $this->options_default['keyToPrev'];
      $this->options['keyToNext']            = $this->options_default['keyToNext'];
      $this->options['flvplayer']            = $plugin_root."/".$this->options_default['flvplayer'];
      $this->options['iconAdd']              = $this->options_default['iconAdd'];
      $this->options['iconPath']             = $plugin_root."/".$this->options_default['iconPath'];

      $this->options['lightpop_option'] = '{'
       .($this->options['overlayBgColor'] != $this->options_default['overlayBgColor'] ? 'overlayBgColor:"'.$this->options['overlayBgColor'].'",' : '')
       .($this->options['overlayOpacity'] != $this->options_default['overlayOpacity'] ? 'overlayOpacity:'.$this->options['overlayOpacity'].',' : '')
       .($this->options['contentBorder'] != $this->options_default['contentBorder'] ? 'contentBorder:"'.$this->options['contentBorder'].'",' : '')
       .($this->options['imageBtnPrevWidth'] != $this->options_default['imageBtnPrevWidth'] ? 'imageBtnPrevWidth:'.$this->options['imageBtnPrevWidth'].',' : '')
       .($this->options['imageBtnNextWidth'] != $this->options_default['imageBtnNextWidth'] ? 'imageBtnNextWidth:'.$this->options['imageBtnNextWidth'].',' : '')
       .($this->options['imageBtnCloseWidth'] != $this->options_default['imageBtnCloseWidth'] ? 'imageBtnCloseWidth:'.$this->options['imageBtnCloseWidth'].',' : '')
       .($this->options['containerBorderSize'] != $this->options_default['containerBorderSize'] ? 'containerBorderSize:'.$this->options['containerBorderSize'].',' : '')
       .($this->options['containerResizeSpeed'] != $this->options_default['containerResizeSpeed'] ? 'containerResizeSpeed:'.$this->options['containerResizeSpeed'].',' : '')
       .($this->options['txtImage'] != $this->options_default['txtImage'] ? 'txtImage:"'.$this->options['txtImage'].'",' : '')
       .($this->options['txtOf'] != $this->options_default['txtOf'] ? 'txtOf:"'.$this->options['txtOf'].'",' : '')
       .($this->options['keyToClose'] != $this->options_default['keyToClose'] ? 'keyToClose:"'.$this->options['keyToClose'].'",' : '')
       .($this->options['keyToPrev'] != $this->options_default['keyToPrev'] ? 'keyToPrev:"'.$this->options['keyToPrev'].'",' : '')
       .($this->options['keyToNext'] != $this->options_default['keyToNext'] ? 'keyToNext:"'.$this->options['keyToNext'].'",' : '')
       .($this->options['iconAdd'] != $this->options_default['iconAdd'] ? 'iconAdd:'.($this->options['iconAdd'] == 1 ? 'true' : 'false').',' : '')
       .'imageLoading:"'.$this->options['imageLoading'].'",'
       .'imageBtnPrev:"'.$this->options['imageBtnPrev'].'",'
       .'imageBtnNext:"'.$this->options['imageBtnNext'].'",'
       .'imageBtnClose:"'.$this->options['imageBtnClose'].'",'
       .'imageBlank:"'.$this->options['imageBlank'].'",'
       .'flvplayer:"'.$this->options['flvplayer'].'",'
       .'iconPath:"'.$this->options['iconPath'].'"'
       .'}';

      $this->update_options();
    } else {
      $this->options = $wkoptions;
    }
  }

  /*
  * Handles Add/strips slashes to the given array
  */
  function stripArray($array) {
    if(is_array($array)) {
      // If already slashed, strip.
      foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
    } else {
      return $array;
    }
    return $slashed_array;
  }

  function update_options() {
    update_option($this->plugin_name." Options", $this->options);
  }

  function addHeadJs() {
    if ($this->options['load_framework'] == '1') {
      echo '<script type="text/javascript" src="'.$this->options['plugin_uri'].'/js/jquery.js"></script>'."\n";
    }
    if ($this->options['js_type'] == strtolower($this->js_type[1])) {
      echo '<script type="text/javascript">jQuery.noConflict();</script>'."\n";
    }
    echo '<script type="text/javascript" src="'.$this->options['plugin_uri'].'/js/jquery.lightpop.js"></script>'."\n";
  }

  function addLightPopJs() {
    if (!isset($this->options['lightpop_option'])) {
      $this->options['lightpop_option'] = '{'
       .($this->options['overlayBgColor'] != $this->options_default['overlayBgColor'] ? 'overlayBgColor:"'.$this->options['overlayBgColor'].'",' : '')
       .($this->options['overlayOpacity'] != $this->options_default['overlayOpacity'] ? 'overlayOpacity:'.$this->options['overlayOpacity'].',' : '')
       .($this->options['contentBorder'] != $this->options_default['contentBorder'] ? 'contentBorder:"'.$this->options['contentBorder'].'",' : '')
       .($this->options['imageBtnPrevWidth'] != $this->options_default['imageBtnPrevWidth'] ? 'imageBtnPrevWidth:'.$this->options['imageBtnPrevWidth'].',' : '')
       .($this->options['imageBtnNextWidth'] != $this->options_default['imageBtnNextWidth'] ? 'imageBtnNextWidth:'.$this->options['imageBtnNextWidth'].',' : '')
       .($this->options['imageBtnCloseWidth'] != $this->options_default['imageBtnCloseWidth'] ? 'imageBtnCloseWidth:'.$this->options['imageBtnCloseWidth'].',' : '')
       .($this->options['containerBorderSize'] != $this->options_default['containerBorderSize'] ? 'containerBorderSize:'.$this->options['containerBorderSize'].',' : '')
       .($this->options['containerResizeSpeed'] != $this->options_default['containerResizeSpeed'] ? 'containerResizeSpeed:'.$this->options['containerResizeSpeed'].',' : '')
       .($this->options['txtImage'] != $this->options_default['txtImage'] ? 'txtImage:"'.$this->options['txtImage'].'",' : '')
       .($this->options['txtOf'] != $this->options_default['txtOf'] ? 'txtOf:"'.$this->options['txtOf'].'",' : '')
       .($this->options['keyToClose'] != $this->options_default['keyToClose'] ? 'keyToClose:"'.$this->options['keyToClose'].'",' : '')
       .($this->options['keyToPrev'] != $this->options_default['keyToPrev'] ? 'keyToPrev:"'.$this->options['keyToPrev'].'",' : '')
       .($this->options['keyToNext'] != $this->options_default['keyToNext'] ? 'keyToNext:"'.$this->options['keyToNext'].'",' : '')
       .($this->options['iconAdd'] != $this->options_default['iconAdd'] ? 'iconAdd:'.($this->options['iconAdd'] == 1 ? 'true' : 'false').',' : '')
       .'imageLoading:"'.$this->options['imageLoading'].'",'
       .'imageBtnPrev:"'.$this->options['imageBtnPrev'].'",'
       .'imageBtnNext:"'.$this->options['imageBtnNext'].'",'
       .'imageBtnClose:"'.$this->options['imageBtnClose'].'",'
       .'imageBlank:"'.$this->options['imageBlank'].'",'
       .'flvplayer:"'.$this->options['flvplayer'].'",'
       .'iconPath:"'.$this->options['iconPath'].'"'
       .'}';
      $this->update_options();
    }

    $jQuery = ($this->options['js_type'] == strtolower($this->js_type[0]) ? '$' : 'jQuery');
    echo '<script type="text/javascript">';
    echo $jQuery.'(function(){';
    echo 'var lightpop_options = '.$this->options['lightpop_option'].';';
    foreach(preg_split('/[\n\r]/',$this->options['targetCSS']) as $value) {
     if (trim($value) != '') {echo $jQuery.'("'.trim($value).'").lightpop(lightpop_options);';}
    }
    echo '});';
    echo '</script>'."\n";
  }

  function addAdminMenu() {
    add_options_page(__('LightPop', 'wp-lightpop'), __('LightPop', 'wp-lightpop'), 9, basename(__FILE__), array($this,'optionPage'));
  }

  function optionPage() {
    // options update
    if(isset($_POST['ap_options_update'])) {
      // strip slashes array
      $_POST = $this->stripArray($_POST);

      // get options
      $this->options['js_type'] = strtolower($this->js_type[$_POST['js_type']]);
      $this->options['load_framework'] = $_POST['load_framework'];
      $this->options['targetCSS'] = $_POST['ap_targetCSS'];
      $this->options['overlayBgColor'] = $_POST['ap_overlayBgColor'];
      $this->options['overlayOpacity'] = $_POST['ap_overlayOpacity'];
      $this->options['contentBorder'] = $_POST['ap_contentBorder'];
      $this->options['imageLoading'] = $_POST['ap_imageLoading'];
      $this->options['imageBtnPrev'] = $_POST['ap_imageBtnPrev'];
      $this->options['imageBtnNext'] = $_POST['ap_imageBtnNext'];
      $this->options['imageBtnClose'] = $_POST['ap_imageBtnClose'];
      $this->options['imageBlank'] = $_POST['ap_imageBlank'];
      $this->options['imageBtnPrevWidth'] = $_POST['ap_imageBtnPrevWidth'];
      $this->options['imageBtnNextWidth'] = $_POST['ap_imageBtnNextWidth'];
      $this->options['imageBtnCloseWidth'] = $_POST['ap_imageBtnCloseWidth'];
      $this->options['containerBorderSize'] = $_POST['ap_containerBorderSize'];
      $this->options['containerResizeSpeed'] = $_POST['ap_containerResizeSpeed'];
      $this->options['txtImage'] = $_POST['ap_txtImage'];
      $this->options['txtOf'] = $_POST['ap_txtOf'];
      $this->options['keyToClose'] = $_POST['ap_keyToClose'];
      $this->options['keyToPrev'] = $_POST['ap_keyToPrev'];
      $this->options['keyToNext'] = $_POST['ap_keyToNext'];
      $this->options['flvplayer'] = $_POST['ap_flvplayer'];
      $this->options['iconAdd'] = $_POST['ap_iconAdd'];
      $this->options['iconPath'] = $_POST['ap_iconPath'];
      $this->options['plugin_uri'] = trailingslashit(get_settings('siteurl')).'wp-content/plugins/'.basename(dirname(__FILE__));
      $_POST = '';

      $this->options['lightpop_option'] = '{'
       .($this->options['overlayBgColor'] != $this->options_default['overlayBgColor'] ? 'overlayBgColor:"'.$this->options['overlayBgColor'].'",' : '')
       .($this->options['overlayOpacity'] != $this->options_default['overlayOpacity'] ? 'overlayOpacity:'.$this->options['overlayOpacity'].',' : '')
       .($this->options['contentBorder'] != $this->options_default['contentBorder'] ? 'contentBorder:"'.$this->options['contentBorder'].'",' : '')
       .($this->options['imageBtnPrevWidth'] != $this->options_default['imageBtnPrevWidth'] ? 'imageBtnPrevWidth:'.$this->options['imageBtnPrevWidth'].',' : '')
       .($this->options['imageBtnNextWidth'] != $this->options_default['imageBtnNextWidth'] ? 'imageBtnNextWidth:'.$this->options['imageBtnNextWidth'].',' : '')
       .($this->options['imageBtnCloseWidth'] != $this->options_default['imageBtnCloseWidth'] ? 'imageBtnCloseWidth:'.$this->options['imageBtnCloseWidth'].',' : '')
       .($this->options['containerBorderSize'] != $this->options_default['containerBorderSize'] ? 'containerBorderSize:'.$this->options['containerBorderSize'].',' : '')
       .($this->options['containerResizeSpeed'] != $this->options_default['containerResizeSpeed'] ? 'containerResizeSpeed:'.$this->options['containerResizeSpeed'].',' : '')
       .($this->options['txtImage'] != $this->options_default['txtImage'] ? 'txtImage:"'.$this->options['txtImage'].'",' : '')
       .($this->options['txtOf'] != $this->options_default['txtOf'] ? 'txtOf:"'.$this->options['txtOf'].'",' : '')
       .($this->options['keyToClose'] != $this->options_default['keyToClose'] ? 'keyToClose:"'.$this->options['keyToClose'].'",' : '')
       .($this->options['keyToPrev'] != $this->options_default['keyToPrev'] ? 'keyToPrev:"'.$this->options['keyToPrev'].'",' : '')
       .($this->options['keyToNext'] != $this->options_default['keyToNext'] ? 'keyToNext:"'.$this->options['keyToNext'].'",' : '')
       .($this->options['iconAdd'] != $this->options_default['iconAdd'] ? 'iconAdd:'.($this->options['iconAdd'] == 1 ? 'true' : 'false').',' : '')
       .'imageLoading:"'.$this->options['imageLoading'].'",'
       .'imageBtnPrev:"'.$this->options['imageBtnPrev'].'",'
       .'imageBtnNext:"'.$this->options['imageBtnNext'].'",'
       .'imageBtnClose:"'.$this->options['imageBtnClose'].'",'
       .'imageBlank:"'.$this->options['imageBlank'].'",'
       .'flvplayer:"'.$this->options['flvplayer'].'",'
       .'iconPath:"'.$this->options['iconPath'].'"'
       .'}';

      // Done!
      $this->update_options();
      $this->note .= __('<strong>Done!</strong>', 'wp-lightpop');
    }

    // Add Options
    $out .= '<div class="wrap">'."\n";
    $out .= '<h2>'.__('WP-LightPop Options', 'wp-lightpop').'</h2><br />'."\n";
    $out .= '<form method="post" id="update_options" action="'.$_SERVER['REQUEST_URI'].'">'."\n";

    $out .= '<table>'."\n";

    // Choose Javascript Framework
    $out .= '<tr>';
    $out .= '<td><strong>'.__('jQuery Type', 'wp-lightpop').'</strong></td>';
    $out .= '<td>';
    $out .= '<select name="js_type">';
    for ($i = 0; $i < sizeof($this->js_type); $i++) {
      $out .= '<option value="'.$i.'"'.($this->options['js_type'] == strtolower($this->js_type[$i]) ? ' selected="selected"' : '').'>'.__($this->js_type[$i], 'wp-lightpop').'</option>';
    }
    $out .= '</select>';
    $out .= '&nbsp;<input type="checkbox" name="load_framework" value="1" style="margin-right:0.5em" '.($this->options['load_framework']==1?' checked':'').' />'.__('Add Header', 'wp-lightpop');
    $out .= '</td>';
    $out .= '</tr>'."\n";

    // Target CSS
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Target Element', 'wp-lightpop').'</strong></td>';
    $out .= '<td><textarea name="ap_targetCSS" cols="100" rows="5">'.$this->options['targetCSS'].'</textarea></td>';
    $out .= '</tr>'."\n";

    // icon add
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Link icon', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="checkbox" name="ap_iconAdd" value="1" style="margin-right:0.5em" '.($this->options['iconAdd']==1?' checked':'').' />'.__('Before link', 'wp-lightpop').'</td>';
    $out .= '</tr>'."\n";

    $out .= '</table>'."\n";

    $out .= '<a href="#" onclick="javascript:document.getElementById('."'".'lightpop-more-options'."'".').style.display='."'".'block'."'".';this.style.display='."'".'none'."'".';return false;">'.__('More options', 'wp-lightpop').'</a><br />'."\n";

    $out .= '<div id="lightpop-more-options" style="display:none"><table>'."\n";

    // overlay
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Overlay', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Background color', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_overlayBgColor" size="10" value="'.$this->options['overlayBgColor'].'"/></td>';
    $out .= '<td><strong>'.__('Opacity', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_overlayOpacity" size="5" value="'.$this->options['overlayOpacity'].'"/></td>';
    $out .= '<td colspan=2></td>';
    $out .= '</tr>'."\n";

    // content border
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Content', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Border CSS', 'wp-lightpop').'</strong></td>';
    $out .= '<td colspan=3><input type="text" name="ap_contentBorder" size="75" value="'.$this->options['contentBorder'].'"/></td>';
    $out .= '<td colspan=2></td>';
    $out .= '</tr>'."\n";

    // Container
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Container', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Border size', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_containerBorderSize" size="5" value="'.$this->options['containerBorderSize'].'"/></td>';
    $out .= '<td><strong>'.__('Resize speed', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_containerResizeSpeed" size="5" value="'.$this->options['containerResizeSpeed'].'"/></td>';
    $out .= '<td colspan=2></td>';
    $out .= '</tr>'."\n";

    // Prev button image
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Prev button', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Image path', 'wp-lightpop').'</strong></td>';
    $out .= '<td colspan=3><input type="text" name="ap_imageBtnPrev" size="75" value="'.$this->options['imageBtnPrev'].'"/></td>';
    $out .= '<td><strong>'.__('width', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_imageBtnPrevWidth" size="5" value="'.$this->options['imageBtnPrevWidth'].'"/></td>';
    $out .= '</tr>'."\n";

    // Next button image
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Next button', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Image path', 'wp-lightpop').'</strong></td>';
    $out .= '<td colspan=3><input type="text" name="ap_imageBtnNext" size="75" value="'.$this->options['imageBtnNext'].'"/></td>';
    $out .= '<td><strong>'.__('width', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_imageBtnNextWidth" size="5" value="'.$this->options['imageBtnNextWidth'].'"/></td>';
    $out .= '</tr>'."\n";

    // Close button image
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Close button', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Image path', 'wp-lightpop').'</strong></td>';
    $out .= '<td colspan=3><input type="text" name="ap_imageBtnClose" size="75" value="'.$this->options['imageBtnClose'].'"/></td>';
    $out .= '<td><strong>'.__('width', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_imageBtnCloseWidth" size="5" value="'.$this->options['imageBtnCloseWidth'].'"/></td>';
    $out .= '</tr>'."\n";

    // Loading image
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Loading', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Image path', 'wp-lightpop').'</strong></td>';
    $out .= '<td colspan=3><input type="text" name="ap_imageLoading" size="75" value="'.$this->options['imageLoading'].'"/></td>';
    $out .= '<td colspan=2></td>';
    $out .= '</tr>'."\n";

    // Blank image
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Blank', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Image path', 'wp-lightpop').'</strong></td>';
    $out .= '<td colspan=3><input type="text" name="ap_imageBlank" size="75" value="'.$this->options['imageBlank'].'"/></td>';
    $out .= '<td colspan=2></td>';
    $out .= '</tr>'."\n";

    // Navigation text
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Navigation', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Default text', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_txtImage" size="10" value="'.$this->options['txtImage'].'"/></td>';
    $out .= '<td><strong>'.__('text of', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_txtOf" size="5" value="'.$this->options['txtOf'].'"/></td>';
    $out .= '<td colspan=2></td>';
    $out .= '</tr>'."\n";

    // Key navigation
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Key bind', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('to Prev', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_keyToPrev" size="5" value="'.$this->options['keyToPrev'].'"/></td>';
    $out .= '<td><strong>'.__('to Next', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_keyToNext" size="5" value="'.$this->options['keyToNext'].'"/></td>';
    $out .= '<td><strong>'.__('to Close', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_keyToClose" size="5" value="'.$this->options['keyToClose'].'"/></td>';
    $out .= '</tr>'."\n";

    // icon add
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Link icon', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Image path', 'wp-lightpop').'</strong></td>';
    $out .= '<td colspan=3><input type="text" name="ap_iconPath" size="75" value="'.$this->options['iconPath'].'"/></td>';
    $out .= '<td colspan=2></td>';
    $out .= '</tr>'."\n";

    // flvplayer
    $out .= '<tr>';
    $out .= '<td colspan=2><strong>'.__('FLV player path', 'wp-lightpop').'</strong></td>';
    $out .= '<td colspan=3><input type="text" name="ap_flvplayer" size="75" value="'.$this->options['flvplayer'].'"/></td>';
    $out .= '<td colspan=2></td>';
    $out .= '</tr>'."\n";

    $out .= '</table></div>'."\n";

    // Add Update Button
    $out .= '<div style="text-align:right"><input type="submit" name="ap_options_update" value="'.__('Update Options', 'wp-lightpop').'" class="button" style="font-size:11px;" /></div>';
    $out .= '</form></div>'."\n";

    // Note snuff
    if(!empty($this->note)) {$this->note  = '<div id="message" class="updated fade"><p>'.$this->note.'</p></div>'."\n";}

    // If any error, dont display body
    if($this->error>0) {$out = '';}

    // Output
    echo $this->note."\n";
    echo $out."\n";
  }

}//class

load_plugin_textdomain('wp-lightpop','wp-content/plugins/wp-lightpop');

$wpLightPop = new LightPopController();

add_action('admin_menu', array(&$wpLightPop,'addAdminMenu'));
add_action('wp_head',array(&$wpLightPop,'addHeadJs'),999);
add_action('wp_footer',array(&$wpLightPop,'addLightPopJs'),999);

unset($wpLightPop);
?>