<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS. */

/* ==================================================
 *   Ktai_Service_Softbank class
   ================================================== */

class Ktai_Service_Softbank extends Ktai_Services {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->user_agent = $user_agent;
	$this->operator   = 'SoftBank';
	$this->charset    = 'SJIS-win';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => "\x1b\$Gv\x0f",
		'icon_biggrin.gif'   => "\x1b\$P5\x0f",
		'icon_sad.gif'       => "\x1b\$P!\x0f",
		'icon_surprised.gif' => "\x1b\$P\$\x0f",
		'icon_eek.gif'       => "\x1b\$P0\x0f",
		'icon_confused.gif'  => "\x1b\$P'\x0f",
		'icon_cool.gif'      => "\x1b\$F4\x0f",
		'icon_mad.gif'       => "\x1b\$P6\x0f",
		'icon_razz.gif'      => "\x1b\$P)\x0f",
		'icon_neutral.gif'   => "\x1b\$P\"\x0f", //" #syntax highlighting fix
		'icon_wink.gif'      => "\x1b\$P%\x0f",
		'icon_lol.gif'       => "\x1b\$P)\x0f",
		'icon_redface.gif'   => "\x1b\$P-\x0f",
		'icon_cry.gif'       => "\x1b\$P1\x0f",
		'icon_evil.gif'      => "\x1b\$P6\x0f",
		'icon_twisted.gif'   => "\x1b\$P6\x0f",
		'icon_rolleyes.gif'  => "\x1b\$P7\x0f",
		'icon_exclaim.gif'   => "\x1b\$GA\x0f",
		'icon_question.gif'  => "\x1b\$G@\x0f",
		'icon_idea.gif'      => "\x1b\$E/\x0f",
		'icon_arrow.gif'     => "\x1b\$FT\x0f",
		'icon_mrgreen.gif'   => "\x1b\$Gv\x0f",
	);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 * Reference: http://developers.softbankmobile.co.jp/dp/tool_dl/web/picword_top.php
 *            http://www.au.kddi.com/ezfactory/tec/spec/3.html
 */
public function convert_char($buffer) {
	$chars = array (
		'1'   => "\x1b\$Fr\x0f", // warning (!)
		'2'   => "\x1b\$OW\x0f", // exclamation (!)
		'3'   => "\x1b\$OV\x0f", // question (?)
		'4'   => 'Q',        // question (Q)
		'5'   => "\x1b\$F[\x0f", // left triangle
		'6'   => "\x1b\$FZ\x0f", // right triangle
		'7'   => "\x1b\$F]\x0f", // double left triangle
		'8'   => "\x1b\$F\\\x0f", // double right triangle
		'15'  => "\x1b\$Gl\x0f", // moon (3days)
		'16'  => "\x1b\$E]\x0f", // thunder
		'25'  => "\x1b\$GF\x0f", // watch (3 o'clock)
		'29'  => "\x1b\$FR\x0f", // up arrow
		'30'  => "\x1b\$FS\x0f", // down arrow
		'32'  => '',  // down triangle
		'33'  => '',  // up triangle
		'34'  => '',  // double down triangle
		'35'  => '',  // double up triangle
		'42'  => "\x1b\$FW\x0f", // up-left arrow
		'43'  => "\x1b\$FX\x0f", // down-right arrow
		'44'  => "\x1b\$Gj\x0f", // sun
		'45'  => "\x1b\$G6\x0f", // baseball
		'46'  => "\x1b\$GF\x0f", // clock
		'48'  => "\x1b\$OE\x0f", // bell (chapel)
		'50'  => "\x1b\$G\"\x0f", // face (female) //" #syntax highlighting fix
		'51'  => "\x1b\$GB\x0f", // heart
		'52'  => "\x1b\$Gd\x0f", // bar (martini)
		'53'  => "\x1b\$E0\x0f", // four-leaf clover
		'54'  => "\x1b\$QW\x0f", // trade mark (TM)
		'55'  => "\x1b\$OS\x0f", // multiply (cross)
		'56'  => "\x1b\$O!\x0f", // note
		'61'  => "\x1b\$OS\x0f", // cross
		'63'  => "\x1b\$FT\x0f", // right arrow
		'64'  => "\x1b\$FU\x0f", // left arrow
		'65'  => "\x1b\$Ge\x0f", // magcup (tea room)
		'68'  => "\x1b\$Gv\x0f", // smile
		'69'  => "\x1b\$OO\x0f", // star
		'70'  => "\x1b\$FV\x0f", // up-right arrow
		'71'  => "\x1b\$FY\x0f", // down-left arrow
		'72'  => "\x1b\$GT\x0f", // jewelry
		'74'  => "\x1b\$Gr\x0f", // dog
		'75'  => "\x1b\$OU\x0f", // star
		'76'  => "\x1b\$ON\x0f", // spark
		'77'  => "\x1b\$E/\x0f", // lamp
		'80'  => "\x1b\$G!\x0f", // face (male)
		'81'  => "\x1b\$Fn\x0f", // copyright mark
		'82'  => "\x1b\$Fo\x0f", // registered mark
		'83'  => "\x1b\$E>\x0f", // briefcase
		'85'  => "\x1b\$G)\x0f", // telephone (fixed)
		'86'  => "\x1b\$O!\x0f", // pop up memo
		'88'  => '',    // up triangle
		'89'  => '',    // down triangle
		'94'  => "\x1b\$G(\x0f", // camera
		'95'  => "\x1b\$Gk\x0f", // rain
		'96'  => "\x1b\$PK\x0f", // american football
		'97'  => "\x1b\$Eh\x0f", // book
		'98'  => "\x1b\$EW\x0f", // keep out sign
		'99'  => "\x1b\$En\x0f", // traffic signal
		'100' => "\x1b\$Eh\x0f", // book
		'101' => "\x1b\$Eh\x0f", // book
		'102' => "\x1b\$Eh\x0f", // book
		'103' => "\x1b\$O!\x0f", // document
		'104' => "\x1b\$O3\x0f", // scissors
		'105' => "\x1b\$O!\x0f", // daily calender
		'106' => "\x1b\$EE\x0f", // ticket
		'107' => "\x1b\$Gi\x0f", // cloud
		'108' => "\x1b\$E#\x0f", // mail envelope
		'109' => "\x1b\$EO\x0f", // money
		'110' => "\x1b\$G]\x0f", // movie/video camera
		'111' => "\x1b\$Q'\x0f", // handheld video camera
		'112' => "\x1b\$GV\x0f", // home
		'113' => "\x1b\$O\$\x0f", // flower (tulip)
		'116' => "\x1b\$F1\x0f", // glasses / eye
		'118' => '', // next item /return mark
		'119' => "\x1b\$E4\x0f", // magnifier (search)
		'120' => "\x1b\$G_\x0f", // key
		'124' => "\x1b\$E^\x0f", // shoe (high-heel)
		'125' => "\x1b\$Ez\x0f", // sedan (car)
		'140' => "\x1b\$FP\x0f", // leftside finger
		'141' => "\x1b\$FQ\x0f", // rightside finger
		'143' => "\x1b\$O!\x0f", // clip
		'144' => "\x1b\$E2\x0f", // present box
		'146' => "\x1b\$Gc\x0f", // knife and fork
		'149' => "\x1b\$O!\x0f", // pencil
		'151' => "\x1b\$E#\x0f", // envelope
		'152' => "\x1b\$E6\x0f", // spanner / hammer
		'155' => "\x1b\$G)\x0f", // telephone (handset)
		'156' => "\x1b\$GX\x0f", // factory
		'161' => "\x1b\$G*\x0f", // mobile phone
		'168' => "\x1b\$G=\x0f", // air plane
		'169' => "\x1b\$EU\x0f", // boat (ship)
		'172' => "\x1b\$G>\x0f", // electric train
		'176' => "\x1b\$O.\x0f", // smoking
		'177' => "\x1b\$F(\x0f", // no smoking
		'178' => "\x1b\$F*\x0f", // wheel chair
		'179' => "\x1b\$F)\x0f", // beginner driver mark
		'180' => "\x1b\$F<\x0f", // one
		'181' => "\x1b\$F=\x0f", // two
		'182' => "\x1b\$F>\x0f", // three
		'183' => "\x1b\$F?\x0f", // four
		'184' => "\x1b\$F@\x0f", // five
		'185' => "\x1b\$FA\x0f", // six
		'186' => "\x1b\$FB\x0f", // seven
		'187' => "\x1b\$FC\x0f", // eight
		'188' => "\x1b\$FD\x0f", // nine
		'190' => "\x1b\$Pc\x0f", // storm
		'191' => "\x1b\$Gh\x0f", // snowball
		'192' => "\x1b\$F_\x0f", // Aries (Ram)
		'193' => "\x1b\$F`\x0f", // Taurus (Bull)
		'194' => "\x1b\$Fa\x0f", // Gemini (Twins)
		'195' => "\x1b\$Fb\x0f", // Cancer (Crab)
		'196' => "\x1b\$Fc\x0f", // Leo (Lion)
		'197' => "\x1b\$Fd\x0f", // Virgo (Virgin)
		'198' => "\x1b\$Fe\x0f", // Libra (Scales)
		'199' => "\x1b\$Ff\x0f", // Scorpius (Scorpion)
		'200' => "\x1b\$Fg\x0f", // Sagittarius (Archer)
		'201' => "\x1b\$Fh\x0f", // Capricornus (Goat)
		'202' => "\x1b\$Fi\x0f", // Aquarius (Water Bearer)
		'203' => "\x1b\$Fj\x0f", // Pisces (Fishes)
		'204' => "\x1b\$Fk\x0f", // Ophiuchus (Serpent Bearer)
		'205' => "\x1b\$Et\x0f", // Automatic Teller Machine
		'206' => "\x1b\$Ev\x0f", // convenience store
		'207' => "\x1b\$Eq\x0f", // toilet
		'208' => "\x1b\$Eo\x0f", // parking
		'209' => "\x1b\$Ep\x0f", // bus stop
		'210' => "\x1b\$Ek\x0f", // location simble (parabola antenna)
		'211' => "\x1b\$F\"\x0f", // port (anchor) //" #syntax highlighting fix
		'212' => "\x1b\$Em\x0f", // bank
		'213' => "\x1b\$GZ\x0f", // gas station
		'215' => "\x1b\$EV\x0f", // bicycle
		'216' => "\x1b\$Ey\x0f", // bus
		'217' => "\x1b\$G?\x0f", // shinkansen (bullet train)
		'218' => "\x1b\$E5\x0f", // marathon
		'219' => "\x1b\$G8\x0f", // football (soccer)
		'220' => "\x1b\$G5\x0f", // tennis
		'221' => "\x1b\$G3\x0f", // snow board
		'222' => "\x1b\$ER\x0f", // checker flag
		'223' => "\x1b\$ED\x0f", // amusement park
		'224' => "\x1b\$EC\x0f", // spa
		'226' => "\x1b\$OD\x0f", // movie (clapper board)
		'227' => "\x1b\$Pk\x0f", // night scene
		'233' => "\x1b\$EO\x0f", // doller bag
		'234' => "\x1b\$GS\x0f", // christmas tree
		'235' => "\x1b\$GP\x0f", // cherry blossom
		'239' => "\x1b\$Gf\x0f", // short cake
		'244' => "\x1b\$Ob\x0f", // onigiri (rise ball)
		'245' => "\x1b\$E@\x0f", // hamberger (fast food)
		'251' => "\x1b\$Go\x0f", // cat
		'257' => "\x1b\$Gv\x0f", // laugh face
		'258' => "\x1b\$Gy\x0f", // angry face
		'259' => "\x1b\$Gw\x0f", // sad face
		'260' => "\x1b\$Gx\x0f", // tired face
		'261' => "\x1b\$E\\\x0f", // Sleepy (Zzz)
		'262' => "\x1b\$OT\x0f", // angry
		'263' => "\x1b\$E(\x0f", // tear
		'264' => "\x1b\$E%\x0f", // bleah
		'265' => "\x1b\$GC\x0f", // heart break
		'266' => "\x1b\$OG\x0f", // double hearts
		'268' => "\x1b\$O1\x0f", // bomb
		'273' => "\x1b\$G#\x0f", // kiss mark
		'278' => "\x1b\$F\$\x0f", // flower circle
		'279' => "\x1b\$O5\x0f", // secret
		'281' => "\x1b\$G-\x0f", // punch
		'282' => "\x1b\$OP\x0f", // dashing
		'287' => "\x1b\$P@\x0f", // ok hand sign
		'288' => "\x1b\$EJ\x0f", // TV set
		'289' => "\x1b\$G\\\x0f", // microphone (kara-oke)
		'290' => "\x1b\$EO\x0f", // wallet
		'291' => "\x1b\$OF\x0f", // musical note
		'294' => "\x1b\$O*\x0f", // music (headphone)
		'295' => "\x1b\$O<\x0f", // rouge
		'299' => "\x1b\$F6\x0f", // free
		'300' => "\x1b\$EF\x0f", // CD/DVD
		'303' => "\x1b\$F3\x0f", // updated
		'305' => '[]',  // fog
		'306' => "\x1b\$G4\x0f", // golf
		'307' => "\x1b\$PJ\x0f", // basket ball
		'309' => "\x1b\$Q\"\x0f", // art   //" #syntax highlighting fix
		'310' => "\x1b\$Q#\x0f", // performance
		'311' => "\x1b\$Q&\x0f", // event (circus)
		'312' => "\x1b\$O4\x0f", // ribbon
		'313' => "\x1b\$Ok\x0f", // birthday
		'314' => "\x1b\$F.\x0f", // spade mark (cards)
		'315' => "\x1b\$F-\x0f", // diamond mark (cards)
		'316' => "\x1b\$F/\x0f", // pam mark (cards)
		'317' => "\x1b\$P9\x0f", // eyes
		'318' => "\x1b\$P;\x0f", // ear
		'319' => "\x1b\$G1\x0f", // scissors (hands)
		'320' => "\x1b\$G2\x0f", // paper (hands)
		'321' => "\x1b\$Gl\x0f", // new moon
		'322' => "\x1b\$Gl\x0f", // eclipsed moon
		'323' => "\x1b\$Gl\x0f", // half moon
		'324' => '[CL]', // clear button
		'325' => "\x1b\$FE\x0f", // zero
		'326' => "\x1b\$Fm\x0f",  // ok
		'327' => "\x1b\$Gx\x0f", // very tired face
		'333' => "\x1b\$O`\x0f", // ramen (donburi)
		'334' => "\x1b\$F2\x0f", // new
		'337' => "\x1b\$G,\x0f", // personal computer
		'339' => "\x1b\$GR\x0f", // rose
		'340' => "\x1b\$GW\x0f", // church
		'341' => "\x1b\$PT\x0f", // subway
		'342' => "\x1b\$G[\x0f", // Mt.Fuji
		'343' => "\x1b\$O*\x0f", // music
		'354' => "\x1b\$E.\x0f", // crown
		'358' => "\x1b\$E8\x0f", // read leaves
		'375' => "\x1b\$Es\x0f", // post office
		'376' => "\x1b\$Eu\x0f", // hospital
		'377' => "\x1b\$Ew\x0f", // school
		'378' => "\x1b\$Ex\x0f", // hotel
		'379' => "\x1b\$F\"\x0f", // ship  //" #syntax highlighting fix
		'380' => "\x1b\$F'\x0f", // prohibited for U-18
		'381' => "\x1b\$F+\x0f", // anntena mark
		'382' => "\x1b\$F4\x0f", // cool
		'383' => "\x1b\$FG\x0f", // discount mark
		'384' => "\x1b\$FH\x0f", // service mark
		'385' => "\x1b\$FI\x0f", // ID mark
		'386' => "\x1b\$FJ\x0f", // full mark
		'387' => "\x1b\$FK\x0f", // vacant mark
		'388' => "\x1b\$FL\x0f", // reserved mark
		'389' => "\x1b\$FM\x0f", // in-business mark
		'390' => "\x1b\$FN\x0f", // upside finger
		'391' => "\x1b\$FO\x0f", // downside finger
		'393' => "\x1b\$Fp\x0f", // manner mode
		'394' => "\x1b\$Fq\x0f", // power off
		'395' => "\x1b\$O!\x0f", // make a memo
		'400' => "\x1b\$O+\x0f", // tokkkuri,ochoko
		'401' => "\x1b\$Gg\x0f", // beer (cheers)
		'410' => "\x1b\$O?\x0f", // hair salon
		'414' => "\x1b\$F,\x0f", // heart mark (cards)
		'421' => "\x1b\$G3\x0f", // ski
		'422' => "\x1b\$OR\x0f", // oval
		'423' => "\x1b\$OX\x0f", // green tea
		'424' => "\x1b\$OY\x0f", // bread
		'434' => "\x1b\$Oe\x0f", // apple
		'508' => "\x1b\$O!\x0f", // edit (pen)
		'715' => "\x1b\$QB\x0f", // fish
		'728' => "\x1b\$QV\x0f", // foot print
		'729' => "\x1b\$G'\x0f", // shoe
		'803' => "\x1b\$OH\x0f", // swing heart
		'804' => "\x1b\$QC\x0f", // chick
		'805' => '', // jeans
		'806' => "\x1b\$OI\x0f", // love letter
		'810' => "\x1b\$P^\x0f", // tidal wave
		'811' => "\x1b\$Pg\x0f", // twin leave
		'812' => "\x1b\$Pa\x0f", // snail
		'817' => "\x1b\$G0\x0f", // rock (hands)
		'818' => "\x1b\$F0\x0f", // number sign (#)
		'\\d+' => '',   // (catch all)
	);
	$pat = preg_replace('/^(.*)$/', '!<img localsrc="$1"( alt="[^"\\\\\\\\]*?(\\\\\\\\.[^"\\\\\\\\]*)*")? ?/?>!', array_keys($chars));
	$buffer = preg_replace($pat, $chars, $buffer);
	$count = 1;
	while ($count) {
		$buffer = preg_replace("/(\x1b\\\$[A-Z])([\x21-\x7e]+)\x0f\\1/", '$1$2', $buffer, -1, $count);
	}
	return parent::convert_char($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Softbank_PDC class
   ================================================== */

class Ktai_Service_Softbank_PDC extends Ktai_Service_Softbank {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->theme      = ks_option('ks_theme_sb_pdc');
	$this->type       = 'PDC';
	preg_match('!^J-PHONE/(\d\.\d+)/([-_.a-zA-Z0-9]+)/?(SN([-_.a-zA-Z0-9]*))? ?!', $user_agent, $specs);
	$this->term_name  = @$_SERVER['HTTP_X_JPHONE_MSNAME'];
	$this->term_name  = $this->term_name ? $this->term_name : $specs[2];
	$this->term_ID    = @$specs[4];
	$this->sub_ID     = @$_SERVER['HTTP_X_JPHONE_UID'];
	$this->page_size  = 6000;
	if ($specs[1] < 4.0) {
		$this->cache_size = 6144;
		$this->require_id_msg = __("ERROR: Can't post a comment. We request your terminal's serial number but your phone does not available to send it.", 'ktai_style');
	} else {
		$this->cache_size = 12288;
		$this->require_id_msg = __("ERROR: Please configure to allow sending your terminal's serial number.<br />Go Yahoo! Keitai &gt; My Softbank (User Support) &gt; Misc Change Application &gt; Serial Number Sending Preference.", 'ktai_style');
	}
	$this->mime_type  = 'text/html';
	$this->preamble   = '';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
	$buffer = preg_replace('!<h([1-6])(.*?)</h\\1>!', '<p$2</p>', $buffer);
	$buffer = preg_replace('#<img src="([^>]*?)\.gif"#', '<img src="\\1.png"', $buffer);
	return parent::shrink_pre_split($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = str_replace('&nbsp;', ' ', $buffer);
	$buffer = preg_replace('!\s*</(li|dt|dd|option)>\s*!', '', $buffer);
	$buffer = preg_replace('!<([-~_= a-zA-Z0-9%.,:;\'"#*/+]+?) ?/>!', '<$1>', $buffer); //"
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Softbank_3G class
   ================================================== */

class Ktai_Service_Softbank_3G extends Ktai_Service_Softbank {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->theme      = ks_option('ks_theme_sb_3g');
	$this->type       = '3G';
	preg_match('!^(Vodafone|SoftBank)/\d\.\d+/([-_.a-zA-Z0-9]+)/[-_.a-zA-Z0-9]+/(SN([-_.a-zA-Z0-9]*))? !', $user_agent, $specs);
	$this->term_name  = @$_SERVER['HTTP_X_JPHONE_MSNAME'];
	$this->term_name  = $this->term_name ? $this->term_name : $specs[2];
	$this->term_ID    = $specs[4];
	$this->sub_ID     = @$_SERVER['HTTP_X_JPHONE_UID'];
	$this->page_size  = 10000;
	$this->cache_size = 102400;
	$this->require_id_msg = __("ERROR: Please configure to allow sending your terminal's serial number.<br />Go Yahoo! Keitai &gt; My Softbank (User Support) &gt; Misc Change Application &gt; Serial Number Sending Preference.", 'ktai_style');
	$this->mime_type  = 'text/html';
//	$this->mime_type  = 'application/xhtml+xml';
	$this->preamble   = '<?xml version="1.0" encoding="__CHARSET__"?>
<!DOCTYPE html PUBLIC "-//J-PHONE//DTD XHTML Basic 1.0 Plus//EN" "xhtml-basic10-plus.dtd">';
	return;
}

// ===== End of class ====================
}
?>
