<?php
/*
Plugin Name: akismet-multibyteview for Akismet 2.1.x
Plugin URI: http://wppluginsj.sourceforge.jp/akismet-multibyteview/
Description: Akismet のコメント管理とダッシュボードにマルチバイト文字を含むコメント情報を表示する機能を追加します。
Author: hiromasa & <a href="http://bono.s201.xrea.com/">bono</a>
Version: 2.1.3
Author URI: http://another.maple4ever.net/
**/

/*  Copyright 2008 hiromasa & bono (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * AkismetMultibyteView - WordPress Interface Define
 *****************************************************************************/

if(!(defined('ABSPATH') && defined('WPINC'))) return;
if(!is_admin()) return;

/******************************************************************************
 * AkismetMultibyteView
 * 
 * @author		hiromasa
 * @version		2.1.3
 * 
 *****************************************************************************/
class AkismetMultibyteView {
	
	var $plugin_name;
	var $plugin_uri;
	
	var $akismet_admin_uri;
	
	/**
	 * the constructor
	 * 
	 * @param none
	 * @return none
	 */
	function AkismetMultibyteView() {
		
		$this->plugin_name = 'akismet-multibyteview';
		
		$this->plugin_uri  = get_settings('siteurl');
		$this->plugin_uri .= '/wp-content/plugins/akismet-multibyteview/';
		
		$this->akismet_admin_uri = 'edit-comments.php?page=akismet-admin';
		
	}
	
	/**
	 * WordPress Admin Interface 
	 * 
	 * @param none
	 * @return none
	 */
	function echoAdminHead() {
		
		echo '<script type="text/javascript" src="';
		echo $this->plugin_uri . 'akismet-multibyteview.js">';
		echo '</script>'  . "\n";
		
	}
	
	/**
	 * WordPress Admin Interface
	 *
	 * @param none
	 * @return none
	 */
	function echoAdminFooter() {
		
		echo '<div id="AkismetMutibyteMenu" style="padding: 0 1em 0 1em; text-align: right;">' . "\n";
		echo '<img src="../wp-content/plugins/akismet-multibyteview/arrow.png" />';
		echo '</div>' . "\n";
		
	}
	
	/**
	 * WordPress Admin Interface
	 * 
	 * @param none
	 * @return none
	 */
	function hookAkismetQuery($query) {
		
		global $wpdb;
		
		$addQuery
			= ' AND LENGTH(comment_content) <> CHAR_LENGTH(comment_content) ';
		$patch = '-';
		
		$matches = array();
		// SELECT COUNT(*) FROM wp_comments WHERE comment_approved = 'spam' AND comment_type = '' 
		$pattern
			= "/(SELECT COUNT\(\*\) FROM $wpdb->comments WHERE comment_approved = 'spam'  AND comment_type = '.*' )/";
		if(preg_match($pattern, $query, $matches)) {
			$query = $matches[1] . $addQuery;
			$patch = '+';
		}
		
		$matches = array();
		//SELECT * FROM wp_comments WHERE comment_approved = 'spam' AND comment_type = '' ORDER BY comment_date DESC LIMIT 0, 50
		$pattern
			= "/(SELECT \* FROM $wpdb->comments WHERE comment_approved = 'spam'  AND comment_type = '.*')(  ORDER BY comment_date DESC LIMIT \d+, \d+)/";
		if(preg_match($pattern, $query, $matches)) {
			$query = $matches[1] . $addQuery . $matches[2];
			$patch = '+';
		}
		
		//for debug..
		//echo $patch . $query . '<br />';
		
		return $query;
		
	}
	
	
	
	/**
	 * WordPress Admin Interface
	 * 
	 * @param none
	 * @return none
	 */
	function echoAkismetTabs() {
		
		global $wpdb;
		
		$totals = $wpdb->get_results( "SELECT comment_type, COUNT(*) AS cc FROM $wpdb->comments WHERE comment_approved = 'spam'  AND LENGTH(comment_content) <> CHAR_LENGTH(comment_content) GROUP BY comment_type" );
		foreach ( $totals as $type ) {
			if ( '' == $type->comment_type ) $type->comment_type = 'comments';
			$show = ucwords( $type->comment_type );
			$type->cc = number_format( $type->cc );
			$extra = (isset($_GET['multibyte']) && $_GET['ctype'] == $type->comment_type ) ? ' class="active" ' : '';
			$under = (isset($_GET['multibyte']) && $_GET['ctype'] == $type->comment_type ) ? " style='text-decoration: underline;'" : '';
			echo "<li $extra $id><a href='edit-comments.php?multibyte=true&amp;page=akismet-admin&amp;ctype=$type->comment_type' $under>マルチバイト$show ($type->cc)</a></li>";
		}
		
	}
	
	/**
	 * WordPress Admin Interface
	 *  - AkismetMultibyteCount by bono (http://bono.s201.xrea.com/2007/10/536-wp_akismet-multibyte-count/)
	 * 
	 * @param none
	 * @return none
	 */
	function akismet_stats_mbinfo() {
		
		if ( function_exists('ksd_spam_count') ) {
			$spam_count = ksd_spam_count(); // 古い Akismet で、現在捕獲中のスパム数を取得
		} else {
			$spam_count = akismet_spam_count();
		}
		if ( !$spam_count )
			return;
		$mbs_count = $this->spam_mb_count();
		
		echo '<div>' . "\n";
		echo '<h3>' . __('Spam') . ' （日本語を含むコメント）</h3>' . "\n";
		
		echo '<ul><li>'.sprintf(__('There are currently %1$s comments identified as spam.'), number_format($spam_count) ).'</li>';
		if ( $mbs_count ) {
			echo
				'<li><a href="' . "./{$this->akismet_admin_uri}&amp;ctype=comments&amp;multibyte=true" .
				'"><strong>要チェック</strong></a>： スパムじゃないかもしれないコメントを ' .
				$mbs_count.' 件捕獲中です。</li>';
		} else {
			echo '<li>この中に日本語を含むものはありません。</li>';
		}
		echo '</ul>';
		echo '</div>' . "\n";
		
	}
	
	/**
	 * spam_mb_count
	 * 
	 * @param none
	 * @return $count
	 */
	function spam_mb_count() {
		
		global $wpdb;
		$count = $wpdb->get_var("SELECT COUNT(comment_ID) FROM $wpdb->comments WHERE comment_approved = 'spam' AND LENGTH(comment_content) <> CHAR_LENGTH(comment_content)");
		return $count;
		
	}
	
}

/******************************************************************************
 * AkismetMultibyteView - WordPress Interface Define
 *****************************************************************************/

$akismetMultibyteView = new AkismetMultibyteView();

add_action('activity_box_end', array(&$akismetMultibyteView, 'akismet_stats_mbinfo'), 11);

if(strpos($_GET['page'], 'akismet-admin') === false) return;

add_action('akismet_tabs', array(&$akismetMultibyteView, 'echoAkismetTabs'));

if(isset($_GET['multibyte'])) {
	add_filter('query',  array(&$akismetMultibyteView, 'hookAkismetQuery'));
}
?>
 