<?php
/*
Plugin Name: Robots Meta
Plugin URI: http://www.joostdevalk.nl/wordpress/robots-meta/
Description: This plugin allows you to add all the appropriate robots meta tags to your pages and feeds and handle unused archives.
Author: Joost de Valk
Version: 2.9.1
Author URI: http://www.joostdevalk.nl/
*/

if ( ! class_exists( 'RobotsMeta_Admin' ) ) {

	class RobotsMeta_Admin {

		function add_config_page() {
			global $wpdb;
			if ( function_exists('add_submenu_page') ) {
				add_submenu_page('plugins.php','Robots Meta Configuration', 'Robots Meta', 1, basename(__FILE__),array('RobotsMeta_Admin','config_page'));
			}
		} // end add_config_page()

		function robotsmeta_insert_post($pID) {
			global $wpdb;
			extract($_POST);
			$wpdb->query("UPDATE $wpdb->posts SET robotsmeta = '$robotsmeta' WHERE ID = $pID");
		}
		function noindex_option() {
			global $post;
			$robotsmeta = $post->robotsmeta;
			if (!isset($robotsmeta) || $robotsmeta == "") {
				$robotsmeta = "index,follow";
			}
			if ( current_user_can('edit_posts') ) { ?>
			<fieldset id="robotsmeta-noindexoption" class="dbx-box">
			<h3 class="dbx-handle">Robots Meta</h3>
			<div class="dbx-content">
				<label for="meta_robots_index_follow" class="selectit"><input id="meta_robots_index_follow" name="robotsmeta" type="radio" value="index,follow" <?php if ($robotsmeta == "index,follow") echo 'checked="checked"'?>/>index, follow</label>
				<label for="meta_robots_index_nofollow" class="selectit"><input id="meta_robots_index_nofollow" name="robotsmeta" type="radio" value="index,nofollow" <?php if ($robotsmeta == "index,nofollow") echo 'checked="checked"'?>/>index, nofollow</label>
				<label for="meta_robots_noindex_follow" class="selectit"><input id="meta_robots_noindex_follow" name="robotsmeta" type="radio" value="noindex,follow" <?php if ($robotsmeta == "noindex,follow") echo 'checked="checked"'?>/>noindex, follow</label>
				<label for="meta_robots_noindex_nofollow" class="selectit"><input id="meta_robots_noindex_nofollow" name="robotsmeta" type="radio" value="noindex,nofollow" <?php if ($robotsmeta == "noindex,nofollow") echo 'checked="checked"'?>/>noindex, nofollow</label>
			</div>
			</fieldset>
			<?php }
		}
		
		function config_page() {
			if ( isset($_POST['submitrobots']) ) {
				if (!current_user_can('manage_options')) die(__('You cannot edit the robots.txt file.'));
				check_admin_referer('robots-meta-udpaterobotstxt');
				
				if (file_exists("../robots.txt")) {
					$robots_file = "../robots.txt";
				} else if (file_exists("../../robots.txt")) {
					$robots_file = "../../robots.txt";
				} else {
					$robots_file = false;
				}
				
				$robotsnew = stripslashes($_POST['robotsnew']);
				if ($robots_file != false && is_writeable($robots_file)) {
					$f = fopen($robots_file, 'w+');
					fwrite($f, $robotsnew);
					fclose($f);
				}
			}
			if ( isset($_POST['submithtaccess']) ) {
				if (!current_user_can('manage_options')) die(__('You cannot edit the .htaccess.'));
				check_admin_referer('robots-meta-udpatehtaccesstxt');

				if (file_exists("../.htaccess")) {
					$htaccess_file = "../.htaccess";
				} else if (file_exists("../../.htaccess")) {
					$htaccess_file = "../../.htaccess";
				} else {
					$htaccess_file = false;
				}

				$htaccessnew = stripslashes($_POST['htaccessnew']);
				if (is_writeable($htaccess_file)) {
					$f = fopen($htaccess_file, 'w+');
					fwrite($f, $htaccessnew);
					fclose($f);
				}

			}
			if ( isset($_POST['submit']) ) {
				if (!current_user_can('manage_options')) die(__('You cannot edit the Robots Meta options.'));
				check_admin_referer('robots-meta-udpatesettings');
				
				if (isset($_POST['admin'])) {
					$options['admin'] = true;
				} else {
					$options['admin'] = false;
				}

				if (isset($_POST['allfeeds'])) {
					$options['commentfeeds'] = true;
					$options['allfeeds'] = true;
				} else {
					$options['allfeeds'] = false;
				}

				if (isset($_POST['commentfeeds'])) {
					$options['commentfeeds'] = true;
				} else {
					$options['commentfeeds'] = false;
				}

				if (isset($_POST['disableauthor'])) {
					$options['disableauthor'] = true;
				} else {
					$options['disableauthor'] = false;
				}

				if (isset($_POST['disabledate'])) {
					$options['disabledate'] = true;
				} else {
					$options['disabledate'] = false;
				}

				if (isset($_POST['disableexplanation'])) {
					$options['disableexplanation'] = true;
				} else {
					$options['disableexplanation'] = false;
				}

				if (isset($_POST['login'])) {
					$options['login'] = true;
				} else {
					$options['login'] = false;
				}

				if (isset($_POST['noindexauthor'])) {
					$options['noindexauthor'] = true;
				} else {
					$options['noindexauthor'] = false;
				}

				if (isset($_POST['noindexcat'])) {
					$options['noindexcat'] = true;
				} else {
					$options['noindexcat'] = false;
				}

				if (isset($_POST['noindexdate'])) {
					$options['noindexdate'] = true;
				} else {
					$options['noindexdate'] = false;
				}
				
				if (isset($_POST['noindextag'])) {
					$options['noindextag'] = true;
				} else {
					$options['noindextag'] = false;
				}
				
				if (isset($_POST['nofollowcatsingle'])) {
					$options['nofollowcatsingle'] = true;
				} else {
					$options['nofollowcatsingle'] = false;
				}

				if (isset($_POST['nofollowcatpage'])) {
					$options['nofollowcatpage'] = true;
				} else {
					$options['nofollowcatpage'] = false;
				}

				if (isset($_POST['nofollowindexlinks'])) {
					$options['nofollowindexlinks'] = true;
				} else {
					$options['nofollowindexlinks'] = false;
				}

				if (isset($_POST['nofollowmeta'])) {
					$options['nofollowmeta'] = true;
				} else {
					$options['nofollowmeta'] = false;
				}

				if (isset($_POST['nofollowtaglinks'])) {
					$options['nofollowtaglinks'] = true;
				} else {
					$options['nofollowtaglinks'] = false;
				}

				if (isset($_POST['noodp'])) {
					$options['noodp'] = true;
				} else {
					$options['noodp'] = false;
				}

				if (isset($_POST['noydir'])) {
					$options['noydir'] = true;
				} else {
					$options['noydir'] = false;
				}
				
				if (isset($_POST['pagedhome'])) {
					$options['pagedhome'] = true;
				} else {
					$options['pagedhome'] = false;
				}

				if (isset($_POST['search'])) {
					$options['search'] = true;
				} else {
					$options['search'] = false;
				}

				if (isset($_POST['redirectsearch'])) {
					$options['redirectsearch'] = true;
				} else {
					$options['redirectsearch'] = false;
				}

				if (isset($_POST['trailingslash'])) {
					$options['trailingslash'] = true;
				} else {
					$options['trailingslash'] = false;
				}
				
				if (isset($_POST['googleverify'])) {
					$options['googleverify'] = $_POST['googleverify'];
				}

				if (isset($_POST['msverify'])) {
					$options['msverify'] = $_POST['msverify'];
				}

				if (isset($_POST['yahooverify'])) {
					$options['yahooverify'] = $_POST['yahooverify'];
				}

				if (isset($_POST['version'])) {
					$options['version'] = $_POST['version'];
				}
				$opt = serialize($options);
				update_option('RobotsMeta', $opt);
			}
			
			$opt  = get_option('RobotsMeta');
			$options = unserialize($opt);
			if ($options['allfeeds']) {
				$options['comments'] = true;
			}

			if (file_exists("../robots.txt")) {
				$robots_file = "../robots.txt";
			} else if (file_exists("../../robots.txt")) {
				$robots_file = "../../robots.txt";
			} else {
				$robots_file = false;
				$error = 1;
			}
			
			if (!$error && filesize($robots_file) > 0) {
				$f = fopen($robots_file, 'r');
				$content = fread($f, filesize($robots_file));
				$content = htmlspecialchars($content);
			}

			$error = 0;
			if (file_exists("../.htaccess")) {
				$htaccess_file = "../.htaccess";
			} else if (file_exists("../../.htaccess")) {
				$htaccess_file = "../../.htaccess";
			} else {
				$htaccess_file = false;
				$error = 1;
			}

			if (!$error && filesize($htaccess_file) > 0) {
				$f = fopen($htaccess_file, 'r');
				$contentht = fread($f, filesize($htaccess_file));
				$contentht = htmlspecialchars($contentht);
			}
			
			?>
			<div class="wrap">
				<style type="text/css" media="screen">
					p {
						max-width: 600px;
					}
				</style>
				<h2>Robots Meta （ロボット・メタ）の定義づけ</h2>
				<fieldset>
					<form action="" method="post" id="robotsmeta-conf">
						<?php if (function_exists('wp_nonce_field')) { wp_nonce_field('robots-meta-udpatesettings'); } ?>
						<input type="hidden" value="<?php echo $options['version']; ?>" name="version"/>
						<h3>RSSフィード</h3>
						<span style="float: right; margin-top: -30px;" class="submit"><input type="submit" name="submit" value="保存 &raquo;" /></span>
<?php
	global $wp_version;
	if ($wp_version >= "2.3") {
?>							
						<table>
							<tr>
								<td style="width: 30px;">
									<input type="checkbox" id="commentfeeds" name="commentfeeds" <?php if ( $options['commentfeeds'] == true ) echo ' checked="checked" '; ?>/></td>
								<td>
									<label for="commentfeeds"><code>noindex</code> コメントRSSフィード</label>
								</td>
							</tr>
						</table>
		<?php if (!$options['disableexplanation']) { ?>
						<p>
							検索エンジンによるコメントフィードのインデキシング（登録）を拒否します。
						</p>
	<?php } ?>
<?php } ?>
						<table>
							<tr>
								<td style="width: 30px;">
									<input type="checkbox" id="allfeeds" name="allfeeds" <?php if ( $options['allfeeds'] == true ) echo ' checked="checked" '; ?>/> 
								</td>
								<td>
									<label for="allfeeds"><code>noindex</code> <strong>すべての</strong> RSSフィード</label>
								</td>
							</tr>
						</table>
		<?php if (!$options['disableexplanation']) { ?>
						<p>
							検索エンジンによる<strong>すべての</strong>フィードのインデキシング（登録）を拒否します。しかしこれは勧められません。
						</p>
	<?php } ?>
						<h3>検索エンジンによる以下のページのインデキシング（登録）を拒否：</h3>
						<table>
							<tr>
								<td style="width: 30px;">
									<input type="checkbox" id="search" name="search" <?php if ( $options['search'] == true ) echo ' checked="checked" '; ?>/></td>
								<td>
									<label for="search">検索結果のページ</label>
								</td>
							</tr>
							<tr>
								<td style="width: 30px;">
									<input type="checkbox" id="redirectsearch" name="redirectsearch" <?php if ( $options['redirectsearch'] == true ) echo ' checked="checked" '; ?>/></td>
								<td>
									<label for="redirectsearch">参照元が外部の場合、検索結果ページをリダイレクトする</label>
								</td>
							</tr>
							<tr>
								<td style="width: 30px;">
									<input type="checkbox" id="pagedhome" name="pagedhome" <?php if ( $options['pagedhome'] == true ) echo ' checked="checked" '; ?>/></td>
								<td>
									<label for="pagedhome">ホームページでページ分割されたサブページ</label>
								</td>
							</tr>
							<tr>
								<td style="width: 30px;">
									<input type="checkbox" id="logininput" name="login" <?php if ( $options['login'] == true ) echo ' checked="checked" '; ?>/>
								</td>
								<td>
									<label for="logininput">ログインと登録ページ</label>
								</td>
							</tr>
							<tr>
								<td>
									<input type="checkbox" id="admin" name="admin" <?php if ( $options['admin'] == true ) echo ' checked="checked" '; ?>/>
								</td>
								<td>
									<label for="admin">すべての管理ページ</label>
								</td>
							</tr>
							<tr>
								<td>
									<input type="checkbox" id="noindexauthor" name="noindexauthor" <?php if ( $options['noindexauthor'] == true ) echo ' checked="checked" '; ?>/></td>
								<td>
									<label for="noindexauthor">Author（投稿者）アーカイブ</label>
								</td>
							</tr>
							<tr>
								<td>
									<input type="checkbox" id="noindexcat" name="noindexcat" <?php if ( $options['noindexcat'] == true ) echo ' checked="checked" '; ?>/></td>
								<td>
									<label for="noindexcat">カテゴリーアーカイブ</label>
								</td>
							</tr>
							<tr>
								<td>
									<input type="checkbox" id="noindexdate" name="noindexdate" <?php if ( $options['noindexdate'] == true ) echo ' checked="checked" '; ?>/></td>
								<td>
									<label for="noindexdate">データベースアーカイブ</label>
								</td>
							</tr>
							<tr>
								<td>
									<input type="checkbox" id="noindextag" name="noindextag" <?php if ( $options['noindextag'] == true ) echo ' checked="checked" '; ?>/></td>
								<td>
									<label for="noindextag">タグアーカイブ</label>
								</td>
							</tr>
						</table>
		<?php if (!$options['disableexplanation']) { ?>
						<p>
							解説： 例えば一行目のオプションを選択した場合、<code>noindex,follow</code> というロボットタグによって、検索結果ページのインデキシング（登録）を拒否する（noindex）、という指定となります。そしてここの <code>follow</code> というタグは、検索結果ページの中にあるリンクは辿って行ってもよし、という意味です。以下、それぞれのページに対して同様の指示をロボットに対して出しています。<br/>
						</p>
		<?php } ?>
						<h3>DMOZ と Yahoo! ディレクトリーのセッティング</h3>
						<table>
							<tr>
								<td style="width: 30px;">
									<input type="checkbox" id="noodp" name="noodp" <?php if ( $options['noodp'] == true ) echo ' checked="checked" '; ?>/></td>
								<td>
									<label for="noodp"><code>noodp</code> メタタグを追加する</label>
								</td>
							</tr>
							<tr>
								<td>
									<input type="checkbox" id="noydir" name="noydir" <?php if ( $options['noydir'] == true ) echo ' checked="checked" '; ?>/>
								</td>
								<td>
									<label for="noydir"><code>noydir</code> メタタグを追加する</label>
								</td>
							</tr>
						</table>
		<?php if (!$options['disableexplanation']) { ?>
						<p>
							noodp は、このサイトにおいて、DMOZ（ディーモズ）のdescription（説明文）を、検索エンジン上の検索結果表示で使用することを拒否します。ちなみにDMOZはGoogleが使っています。<br/>
							<br/>
							noydir は、このサイトにおいて、Yahoo! ディレクトリーのdescription（説明文）を、Yahoo!の検索結果表示で使用することを拒否します。<br/>
						</p>
		<?php } ?>
<?php
	if ($wp_version >= "2.3") {
?>						<h3>パーマリンク（記事/ページの固定URL）のセッティング</h3>
						<table>
							<tr>
								<td style="width: 30px;">
									<input type="checkbox" id="trailingslash" name="trailingslash" <?php if ( $options['trailingslash'] == true ) echo ' checked="checked" '; ?>/></td>
								<td>
									<label for="trailingslash">すべてのカテゴリーとタグのURLに trailing slash（トレーリング・スラッシュ、URL末尾のスラッシュ"/"のこと）を追加する</label>
								</td>
							</tr>
						</table>
		<?php if (!$options['disableexplanation']) { ?>
						<p>
							記事のパーマリンクの末尾を <code>.html</code> や"/"以外のものに指定していたとしても、上記を選択することで記事以外すべてのページに trailing slash が追加されます。
						</p>
		<?php } ?>
<?php
	}
?>						<h3>アーカイブのセッティング</h3>
						<table>
							<tr>
								<td style="width: 30px;">
									<input type="checkbox" id="disableauthor" name="disableauthor" <?php if ( $options['disableauthor'] == true ) echo ' checked="checked" '; ?>/></td>
								<td>
									<label for="disableauthor">Author（投稿者）アーカイブを無効にする</label>
								</td>
							</tr>
							<tr>
								<td>
									<input type="checkbox" id="disabledate" name="disabledate" <?php if ( $options['disabledate'] == true ) echo ' checked="checked" '; ?>/></td>
								<td>
									<label for="disabledate">データベースアーカイブを無効にする</label>
								</td>
							</tr>
						</table>
		<?php if (!$options['disableexplanation']) { ?>
						<p>
							ブログの投稿者が一人だけの場合、Author（投稿者）アーカイブはホームページとまったく同じような見え方をしています。ご自分でリンクを設定していなかったとしても、他からリンクを貼られてしまう可能性はあります。ここでの選択は、Author（投稿者）アーカイブへのリンクが必ずホームページに301リダイレクトされるようにします。
						</p>
						<p>
							データベースアーカイブについても同様のことが云えます。ホームページと酷似している可能性が高いということです。つまり、重複コンテンツと見なされてしまうかもしれません。
						</p>
		<?php } ?>
						<h3>内部の nofollow セッティング</h3>
						<table>
							<tr>
								<td style="width: 30px;">
									<input type="checkbox" id="nofollowcatpage" name="nofollowcatpage" <?php if ( $options['nofollowcatpage'] == true ) echo ' checked="checked" '; ?>/></td>
								<td>
									<label for="nofollowcatpage">各種ページにおけるカテゴリーリストを Nofollow にする</label>
								</td>
							</tr>
							<tr>
								<td>
									<input type="checkbox" id="nofollowcatsingle" name="nofollowcatsingle" <?php if ( $options['nofollowcatsingle'] == true ) echo ' checked="checked" '; ?>/>
								</td>
								<td>
									<label for="nofollowcatsingle">記事におけるカテゴリーリストを Nofollow にする</label>
								</td>
							</tr>
							<tr>
								<td>
									<input type="checkbox" id="nofollowindexlinks" name="nofollowindexlinks" <?php if ( $options['nofollowindexlinks'] == true ) echo ' checked="checked" '; ?>/>
								</td>
								<td>
									<label for="nofollowindexlinks">フロントページにおける外部リンクを Nofollow にする</label>
								</td>
							</tr>
							<tr>
								<td>
									<input type="checkbox" id="nofollowtaglinks" name="nofollowtaglinks" <?php if ( $options['nofollowtaglinks'] == true ) echo ' checked="checked" '; ?>/>
								</td>
								<td>
									<label for="nofollowtaglinks">タグページへのリンクを Nofollow にする</label>
								</td>
							</tr>
						</table>
		<?php if (!$options['disableexplanation']) { ?>
						<p>
							もしすべてのシングルポスト（記事）やページでカテゴリーリストが設置されているのならば、それらのリンク先へ「グーグルページランク」をとりこぼしているかもしれません。上の2つを選択すれば、カテゴリーページへの nofollow となり、本来の目的であるシングルポストおよび特定のページのランクを高める効果があります。
							</p>
		<?php } ?>
						<table>
							<tr>
								<td style="width: 30px;">
									<input type="checkbox" id="nofollowmeta" name="nofollowmeta" <?php if ( $options['nofollowmeta'] == true ) echo ' checked="checked" '; ?>/>
								</td>
								<td>
									<label for="nofollowmeta">ログインと登録リンクを Nofollow にする</label>
								</td>
							</tr>
						</table>
		<?php if (!$options['disableexplanation']) { ?>
						<p>
							管理画面のページランクがPR5になっていたなんてことがあるかもしれません。そんなところにページランクを漏らすのはもったいないです！
						</p>
		<?php } ?>
						<h3>このプラグインのセッティング</h3>
						<table>
							<tr>
								<td style="width: 30px;">
									<input type="checkbox" id="disableexplanation" name="disableexplanation" <?php if ( $options['disableexplanation'] == true ) echo ' checked="checked" '; ?>/></td>
								<td>
									<label for="disableexplanation">上記のそれぞれの解説文を隠す。</label>
								</td>
							</tr>
						</table>
						
						<h3>Google、Yahoo!、そして MSN のウェブマスターツールの確認</h3>
						<table>
							<tr>
								<td style="width:400px;">
									<input size="50" type="text" id="googleverify" name="googleverify" <?php echo 'value="'.$options['googleverify'].'" '; ?>/>
								</td>
								<td>
									<label for="googleverify">Google Webmaster Tools（ウェブマスターツール）のメタタグ</label>
								</td>
							</tr>
							<tr>
								<td>
									<input size="50" type="text" id="yahooverify" name="yahooverify" <?php echo 'value="'.$options['yahooverify'].'" '; ?>/>
								</td>
								<td>
									<label for="yahooverify">Yahoo! Site Explorer（サイトエクスプローラー）のメタタグ</label>
								</td>
							</tr>
							<tr>
								<td>
									<input size="50" type="text" id="msverify" name="msverify" <?php echo 'value="'.$options['msverify'].'" '; ?>/>
								</td>
								<td>
									<label for="msverify">Microsoft Webmaster Tools（ウェブマスターツール）のメタタグ</label>
								</td>
							</tr>
						</table>
						
						<span style="float: right; margin-top: -30px;" class="submit"><input type="submit" name="submit" value="保存 &raquo;" /></span>
					</form>
				</fieldset>
				<br/><br/>
<?php if ($robots_file != false) { ?>
				<h2>Robots.txt</h2>
				<fieldset>
					<form action="" method="post" id="robotstxt">
						<?php wp_nonce_field('robots-meta-udpaterobotstxt'); ?>
						<?php
							if (! is_writeable($robots_file)) {
								echo "<p><em>robots.txt が書き込み可能な設定であればこちらで編集できます。</em></p>";
								$disabled = 'disabled="disabled"';
							} else {
								echo "<p>robots.txt の編集：</p>";
								$disabled = "";
							}
						?>
						<textarea cols="60" <?php echo $disabled; ?> rows="15" name="robotsnew"><?php echo $content ?></textarea>
						<?php if ($disabled == "") { ?>
						<span style="float: right; margin-top: -30px;" class="submit"><input type="submit" name="submitrobots" value="Robots.txtを保存 &raquo;" /></span>
						<?php } ?>
					</form>
				</fieldset>
				<br/><br/>
<?php
}
if ($htaccess_file != false) {
?>
				<h2>.htaccess</h2>
				<fieldset>
					<form action="" method="post" id="htaccess">
						<?php wp_nonce_field('robots-meta-udpatehtaccesstxt'); ?>
						<?php
							if (! is_writeable($htaccess_file)) {
								echo "<p><em>.htaccess が書き込み可能な設定であればこちら編集できます。</em></p>";
								$disabled = 'disabled="disabled"';
							} else {
								echo "<p>.htaccess の編集：</p>";
								$disabled = "";
							}
						?>
						<textarea cols="60" <?php echo $disabled; ?> rows="15" name="htaccessnew"><?php echo $contentht ?></textarea>
						<?php if ($disabled == "") { ?>
						<span style="float: right; margin-top: -30px;" class="submit"><input type="submit" name="submithtaccess" value=".htaccessを保存 &raquo;" /></span>
						<?php } ?>
					</form>
				</fieldset>
<?php } ?>
			</div>
			<?php
		}	// end add_config_page()
	} // end class RobotsMeta
}

function noindex_feed() {
	echo '<xhtml:meta xmlns:xhtml="http://www.w3.org/1999/xhtml" name="robots" content="noindex" />'."\n";
}

function noindex_page() {
	echo '<meta name="robots" content="noindex" />'."\n";
}

function meta_robots() {
	$opt  = get_option('RobotsMeta');
	$options = unserialize($opt);
	
	$meta = "";
	if (is_single() || is_page()) {
		global $post;
		if ($post->robotsmeta != "index,follow") {
			$meta = $post->robotsmeta;	
		}
	} else if ( (is_author() && $options['noindexauthor']) || (is_category() && $options['noindexcat']) || (is_date() && $options['noindexdate']) || (function_exists(is_tag) && is_tag() && $options['noindextag']) || (is_search() && $options['search']) ) {
		$meta .= "noindex,follow";
	} else if (is_home()) {
		if ($options['pagedhome'] && get_query_var('paged') > 1) {
			$meta .= "noindex,follow";
		}
	}
	if ($options['noodp']) {
		if ($meta != "") {
			$meta .= ",";
		}
		$meta .= "noodp";
	} 
	if ($options['noydir']) {
		if ($meta != "") {
			$meta .= ",";
		}
		$meta .= "noydir";
	}
	if ($meta != "" && $meta != "index,follow") {
		echo '<!--Meta tags added by Robots Meta: http://www.joostdevalk.nl/wordpress/meta-robots-wordpress-plugin/ -->'."\n";
		echo '<meta name="robots" content="'.$meta.'" />'."\n";
	}
} 

function add_trailingslash($url, $type) {
	// trailing slashes for everything except is_single()
	// Thanks to Mark Jaquith for this
	if ( 'single' === $type ) {
		return $url;
	} else {
		return trailingslashit($url);
	}
}

function search_redirect() {
	if ($_GET['s'] &&  strpos($_SERVER['HTTP_REFERER'], get_bloginfo('url')) === false) {
		wp_redirect(get_bloginfo('url'),301);
		exit;
	}
}

function archive_redirect() {
	global $wp_query;
	
	$opt  = get_option('RobotsMeta');
	$options = unserialize($opt);
	
	if ($options['disabledate'] && $wp_query->is_date) {
		wp_redirect(get_bloginfo('url'),301);
		exit;
	}
	if ($options['disableauthor'] && $wp_query->is_author) {
		wp_redirect(get_bloginfo('url'),301);
		exit;
	}
}

function nofollow_link($output) {
	return str_replace('<a ','<a rel="nofollow" ',$output);
}

function nofollow_category_listing($output) {
	$opt  = get_option('RobotsMeta');
	$options = unserialize($opt);
	
	if ( ($options['nofollowcatsingle'] && (is_single() || is_search()) ) || ($options['nofollowcatpage'] && is_page() ) ) {
		$output = nofollow_link($output);
		return $output;
	} else {
		return $output;
	}
}

function google_verify() {
	if (is_home() || (function_exists('is_frontpage') && is_frontpage()) ) {
		$opt  = get_option('RobotsMeta');
		$options = unserialize($opt);
		echo '<meta name="verify-v1" content="'.$options['googleverify'].'" />'."\n";
	}
}

function yahoo_verify() {
	if (is_home() || (function_exists('is_frontpage') && is_frontpage()) ) {
		$opt  = get_option('RobotsMeta');
		$options = unserialize($opt);
		echo '<meta name="y_key" content="'.$options['yahooverify'].'" />'."\n";
	}
}

function ms_verify() {
	if (is_home() || (function_exists('is_frontpage') && is_frontpage()) ) {
		$opt  = get_option('RobotsMeta');
		$options = unserialize($opt);
		echo '<meta name="msvalidate.01" content="'.$options['msverify'].'" />'."\n";
	}
}

function add_nofollow($matches) {
	$origin = get_bloginfo('wpurl');
	if ((strpos($matches[2],$origin)) === false && ( strpos($matches[1],'rel="nofollow"') === false ) && ( strpos($matches[3],'rel="nofollow"') === false ) ) {
		$nofollow = ' rel="nofollow" ';
	} else {
		$nofollow = '';
	}
	return '<a href="' . $matches[2] . '"' . $nofollow . $matches[1] . $matches[3] . '>' . $matches[4] . '</a>';
}

function nofollow_index($output) {
	// Loop through the content of each post and add a nofollow when it's on the main page or a category page.
	if (is_home() || is_category()) {
		$anchorPattern = '/<a (.*?)href="(.*?)"(.*?)>(.*?)<\/a>/i';
		$output = preg_replace_callback($anchorPattern,'add_nofollow',$output);
	}
	return $output;
}

function nofollow_taglinks($output) {
	$output = str_replace('rel="tag"','rel="nofollow tag"',$output);
	return $output;
}
function robotsmeta_update() {
	global $wpdb;
	$opt  = get_option('RobotsMeta');
	$options = unserialize($opt);
	if ($options['version'] < "2.3") {
		echo $wpdb->get_col_info('robotsmeta');
		$wpdb->query("ALTER TABLE $wpdb->posts ADD COLUMN robotsmeta varchar(64)");
		$options['version'] = "2.3";
	}
	if ($options['version'] < "25") {
		$options['version'] = "25";
	}
	$opt = serialize($options);
	update_option('RobotsMeta', $opt);
}

$opt  = get_option('RobotsMeta');
$options = unserialize($opt);

global $wp_version;
if ($wp_version >= "2.3") {
	if ($options['allfeeds'] || $options['commentfeeds']) {
		add_action('commentsrss2_head', 'noindex_feed');
	}
	if ($options['trailingslash']) {
		add_filter('user_trailingslashit', 'add_trailingslash', 10, 2);
	}
}
if ($options['allfeeds']) {
	add_action('rss_head', 'noindex_feed');
	add_action('rss2_head', 'noindex_feed');
}

add_action('wp_head', 'meta_robots');

if ($options['login']) {
	add_action('login_head', 'noindex_page');
}
if ($options['admin']) {
	add_action('admin_head', 'noindex_page');
}
if ($options['disabledate'] || $options['disableauthor']) {
	add_action('wp', 'archive_redirect');
}
if ($options['redirectsearch']) {
	add_action('init', 'search_redirect');
}
if ($options['nofollowcatsingle'] || $options['nofollowcatpage']) {
	add_filter('wp_list_categories','nofollow_category_listing');
}
if ($options['nofollowmeta']) {
	add_filter('loginout','nofollow_link');
	add_filter('register','nofollow_link');
}
if ($options['nofollowtaglinks']) {
	add_filter('the_tags','nofollow_taglinks');
}
if ($options['googleverify']) {
	add_action('wp_head', 'google_verify');
}
if ($options['yahooverify']) {
	add_action('wp_head', 'yahoo_verify');
}
if ($options['msverify']) {
	add_action('wp_head', 'ms_verify');
}
if ($options['nofollowindexlinks']) {
	add_filter('the_content','nofollow_index');
}
add_action('admin_menu', array('RobotsMeta_Admin','add_config_page'));
add_action('dbx_post_sidebar', array('RobotsMeta_Admin','noindex_option'));
add_action('dbx_page_sidebar', array('RobotsMeta_Admin','noindex_option'));
add_action('wp_insert_post', array('RobotsMeta_Admin','robotsmeta_insert_post'));
if ($options['version'] < '25') {
	robotsmeta_update();
}
?>
