/**
 * quick comments for WordPress
 * Post comments quickly without leaving or refreshing the page.
 * @name quick-comments-0.4.0.js
 * @author wokamoto - http://dogmap.jp
 * @version 0.4.0
 * @date June 27, 2008
 * @copyright (c) 2008 wokamoto (dogmap.jp)
 * @license  Released under the GPL license (http://www.gnu.org/copyleft/gpl.html)
 * @requires jQuery v1.2.3 or later and jQuery.blockUI v2.08 or later
 */

jQuery(function(){
  var qc_opt = jQuery.extend({
    form:'form#commentform'
   ,list:'ol.commentlist:first'
   ,requireNameEmail:false
   ,errMsgNameEmail:'Error: please fill the required fields (name, email).'
   ,errMsgCommentNone:'Error: please type a comment.'
   ,errMsgEmail:'Error: please enter a valid email address.'
   ,message:'wait...'
   ,loader:'ajax-loader.gif'
   ,messageCSS:{border:'1px solid #8C8C8C', font:'normal 12px Arial'}
   ,overlayCSS:{backgroundColor:'#FFF', opacity:'0.6'}
   ,effect:0
   }, quickCommentsL10n);

  // get comment form
  var f = jQuery(qc_opt.form);
  f.append('<input type="hidden" name="quick-comments" id="quick-comments" value="1" />');

  var default_comment = jQuery('textarea', qc_opt.form).val();
  default_comment = (typeof default_comment == 'undefined' ? '' : default_comment);

  // comment form AJAX submit
  f.ajaxStart(function(){
   this.submit.disabled = true; // disable submit
   jQuery(this).block({
     message: '<div style="margin:0 auto;padding:0 1em 0;"><p style="margin:1.5em 0;white-space: nowrap;"><img src="' + qc_opt.loader + '" alt="loading" style="margin-right:.25em;" />' + qc_opt.message + '</p></div>'
    ,css: qc_opt.messageCSS
    ,overlayCSS: qc_opt.overlayCSS
   })
  });

  f.ajaxError(function(request, settings){
   alert(settings.responseText.replace(/[\r\n]/g, '').replace(/.*<p>(.*?)<\/p>.*/i, '$1'));
  });

  f.ajaxStop(function(){
   this.submit.disabled = false; // enable submit
   jQuery(this).unblock();
  });

  f.unbind('submit').submit(function(){
   var author_name  = jQuery('input[@name=author]', jQuery(this)).val();
   var author_email = jQuery('input[@name=email]', jQuery(this)).val();
   var comment_text = jQuery('textarea:last', jQuery(this)).val();

   author_name  = (typeof author_name == 'undefined'  ? '' : author_name);
   author_email = (typeof author_email == 'undefined' ? '' : author_email);
   comment_text = (typeof comment_text == 'undefined' ? '' : comment_text);

   // require Name & Email
   if (qc_opt.requireNameEmail && (author_name == "" || author_email  == "")) {
    alert (qc_opt.errMsgNameEmail);
    return false;
   }

   // valid Email ?
   if (author_email != "" && !(/^([a-z0-9+_]|\-|\.)+@(([a-z0-9_]|\-)+\.)+[a-z]{2,6}$/).test(author_email)) {
    alert (qc_opt.errMsgEmail);
    return false;
   }

   // type Comment ?
   if (comment_text == "" || comment_text == default_comment) {
    alert (qc_opt.errMsgCommentNone);
    return false;
   }

   // IE Hack
   if (jQuery.browser.msie) {
    var redirect_to = jQuery('input[@name=redirect_to]', jQuery(this));
    if (redirect_to.size() < 1) f.append('<input type="hidden" name="redirect_to" id="redirect_to" />');
    date = new Date();
    redirect_to.attr('value', redirect_to.attr('value') + '?comments=' + date.getYear() + date.getMonth() + date.getDate());
   }

   var url = jQuery(this).attr('action');
   var param = jQuery('input, textarea', jQuery(this)).serialize();
   jQuery.post(
    url,
    param,
    function(responseText, status) {
     // Add comment list
     var list_id = (qc_opt.list).replace(/^.*[#\.]/, '').replace(/:.*$/, '');
     var list = jQuery(qc_opt.list);
     if (list.size() <= 0) {
      var element = (qc_opt.list).replace(/^([^#\.].*)[#\.].*$/, '$1');
      list = jQuery('<' + element + ' ' + ((/^#/).test(qc_opt.list) ? 'id' : 'class') + '="' + list_id + '"></' + element + '>');
      jQuery(qc_opt.form).prepend(list);
     }
     var body_html = responseText.replace(/[\r\n]/g, '').replace(/^.*<body ?[^>]*>(.*)<\/body>.*$/i, '$1');
     var comments;

     switch (qc_opt.effect) {
     case 1:
      comments = jQuery(qc_opt.list, jQuery('<div>'+body_html+'</div>')).children('li:last, dt:last, dd:last').hide();
      if (comments.size() > 0) {
       list.append(comments.slideDown('fast'));
       jQuery('textarea', jQuery(qc_opt.form)).val(''); // Reset comment
      } else {
       alert(responseText.replace(/[\r\n]/g, '').replace(/^.*<body ?[^>]*>(.*)<\/body>.*$/i, '$1').replace(/<[^>]*>/, ''));
      }
      break;

     default:
      comments = jQuery(qc_opt.list, jQuery(body_html)).children();
      if (comments.size() > 0) {
       list.animate({opacity:'hide'},'normal', function(){
        jQuery(this).empty().append(comments).animate({opacity:'show'},'fast');
       });
       jQuery('textarea', jQuery(qc_opt.form)).val(''); // Reset comment
      } else {
       alert(responseText.replace(/[\r\n]/g, '').replace(/^.*<body ?[^>]*>(.*)<\/body>.*$/i, '$1').replace(/<[^>]*>/, ''));
      }
      break;
     }
    }
   );
   return false;
  });
});
