<?php
/*
Plugin Name: WP-Cron-Dashboard
Plugin URI: http://
Description: Pseudo Cron Dashboard Display for Wordpress
Author: Martin Cleaver and Joost de Valk and wokamoto
Version: 1.0.1
Author URI: http://martin.cleaver.org/ 
Author URI: http://www.joostdevalk.nl/
Author URI: http://dogmap.jp/
*/

// Based on http://blog.slaven.net.au/archives/2007/02/01/timing-is-everything-scheduling-in-wordpress/

load_plugin_textdomain('wp-cron-dashboard','wp-content/plugins/wp-cron-dashboard');

function wp_cron_add_pages($s) {
	global $wp_version;

	// User Level Permission
	//  -- Subscriber = 0,Contributor = 1,Author = 2,Editor= 7,Administrator = 9
	$user_level = 9;

	add_submenu_page(version_compare($wp_version, "2.7", ">=") ? 'tools.php' : 'edit.php', 'wp-cron', 'WP-Cron', $user_level, __FILE__, 'wp_cron_menu');
//	add_submenu_page('index.php', 'wp-cron', 'WP-Cron', 1, __FILE__, 'wp_cron_menu');
	return $s;
}
add_action('admin_menu', 'wp_cron_add_pages');

function wp_cron_menu() {
	global $wp_filter;

	$note = '';
	$out = '';
	$datetime_format = get_option("date_format")." @".get_option("time_format");

	if (isset($_POST['submit'])) {
		wp_unschedule_event($_POST['time'], $_POST['procname']);

		// Note snuff
		$note .= '<div id="message" class="updated fade"><p>';
		$note .= __('Sucessfully unscheduled','wp-cron-dashboard')." ".$_POST['procname']." (".date($datetime_format,$_POST['time']).")";
		$note .= '</p></div>'."\n";
	}

	$out .= '<div class="wrap">'."\n";
	$out .= '<h2>'.__('Overview of tasks scheduled for WP-Cron','wp-cron-dashboard').'</h2>'."\n";

	$out .= mrjc_show_cron_schedules($datetime_format);
	$out .= '<br/>'."\n";

	$out .= __('Current date/time is','wp-cron-dashboard').": <strong>".date($datetime_format)."</strong>\n";
	$out .= "</div>";

	// Output
	echo $note.$out."\n";
}

function mrjc_show_cron_schedules($datetime_format = '') {
	if ($datetime_format == '') {$datetime_format = get_option("date_format")." @".get_option("time_format");}

	$ans = '';
	$timeslots = _get_cron_array();
	if ( empty($timeslots) ) {
		$ans .= '<div style="margin:.5em 0;width:100%;">';
		$ans .= __('Nothing scheduled','wp-cron-dashboard');
		$ans .= '</div>'."\n";
	} else {
		$count = 1;
		foreach ( $timeslots as $time => $tasks ) {
			$ans .= '<div style="margin:.5em 0;width:100%;">';
			$ans .= sprintf(__('Anytime after <strong>%s</strong> execute tasks','wp-cron-dashboard'), date($datetime_format,$time));
			$ans .= '</div>'."\n";
			foreach ($tasks as $procname => $task) {
				$ans .= '<div id="tasks-'.$count.'" style="margin:.5em;width:70%;">'."\n";

				$ans .= __('Entry #','wp-cron-dashboard').$count.': '.$procname."\n";
				// Add in delete button for each entry.
				$ans .= '<form method="post">'."\n";
				$ans .= '<input type="hidden" name="procname" value="'.$procname.'"/>'."\n";
				$ans .= '<input type="hidden" name="time" value="'.$time.'"/>'."\n";
				$ans .= '<input name="submit" style="float:right; margin-top: -20px;" type="submit" value="'.__('Delete','wp-cron-dashboard').'"/>'."\n";
				$ans .= '</form>'."\n";

				$ans .= "</div>\n";
				$count++;
			}
		}
		unset($timeslots);
	}
	return $ans;
}

?>