<?php
/*
Plugin Name: Twicon for WordPress
Plugin URI: http://wppluginsj.sourceforge.jp/twicon/
Description: This is a simple but yet powerful plugin for wordpress that lets you show your users Twitter avatar together with their comments in your website.
Author: wokamoto
Version: 1.1.0
Author URI: http://dogmap.jp/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

  Copyright 2009 wokamoto (email : wokamoto1973@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/******************************************************************************
 * cache expired define
 *****************************************************************************/
define('TWICON_EXPIRED', 12);
define('TWICON_CACHE',   true);


/******************************************************************************
 * Require wp-config.php
 *****************************************************************************/
if( !function_exists('get_option') ) {
	$path = (defined('ABSPATH') ? ABSPATH : dirname(dirname(dirname(dirname(__FILE__)))) . '/');
	require_once(file_exists($path.'wp-load.php') ? $path.'wp-load.php' : $path.'wp-config.php');
}

// Pre-2.6 compatibility
if ( defined('ABSPATH') ) {
	if( !defined('WP_CONTENT_DIR') )
		define( 'WP_CONTENT_DIR', ABSPATH . 'wp-content' );
	if( !defined('WP_CONTENT_URL') )
		define( 'WP_CONTENT_URL', get_option('siteurl') . '/wp-content');
	if ( !defined('WP_PLUGIN_DIR') )
		define( 'WP_PLUGIN_DIR', WP_CONTENT_DIR . '/plugins' );
	if ( !defined('WP_PLUGIN_URL') )
		define( 'WP_PLUGIN_URL', WP_CONTENT_URL . '/plugins' );
}

// Require Class Snoopy
if (!class_exists('Snoopy'))
	require_once(ABSPATH . WPINC . '/class-snoopy.php');


/******************************************************************************
 * twiconController Class
 *****************************************************************************/
class twiconController {
	var $_avatars;
	var $_meta_value;
	var $_cache_path;
	var $_option_update;

	/**********************************************************
	* Constructor
	***********************************************************/
	function twiconController() {
		$this->__construct();
	}
	function __construct() {
		$this->_avatars = get_option('twicon');
		$this->_meta_value = array();
		$this->_option_update = false;
		$this->_cache_path = '';

		if (defined('TWICON_CACHE') && TWICON_CACHE) {
			$this->_cache_path = WP_CONTENT_DIR . '/cache/twicon/';
			if( !file_exists($this->_cache_path) )
				@mkdir($this->_cache_path, 0777);
		}
	}

	// Function updateAvatars
	function updateAvatars() {
		if ( $this->_option_update )
			update_option('twicon', $this->_avatars);
	}

	// Function getAvatar
	function getAvatar($avatar, $id_or_email, $size = '96', $default = '', $alt = false) {
		$result = $this->_get_twicon_url($id_or_email);

		// If User has twitter
		if(isset($result['profile_image_url']) && $result['profile_image_url'] !== false) {
			$safe_alt = ( false === $alt ? '': attribute_escape( $alt ));

			if ( !is_numeric($size) )
				$size = '96';

			if ( defined('TWICON_CACHE') && TWICON_CACHE ) {
				$suffix = '_bigger';
			} else {
				if ($size <= '24')
					$suffix = '_mini';
				else if ($size <= '48')
					$suffix = '_normal';
				else if ($size <= '73')
					$suffix = '_bigger';
				else
					$suffix = '_normal';
			}

			$image = $result['profile_image_url'];
			if ( strpos($image, 'static.twitter.com') === false ) {
				$wherestop = strrpos($image, '_');
				if ($wherestop !== false) {
					$length = strlen( $image  );
					$takeof = $length - $wherestop;
					$keepit = $length - 4;
					$fileextension = substr($image, $keepit, 4);
					$image = substr($image, 0, -$takeof) . $suffix . $fileextension;
				}
				if ( defined('TWICON_CACHE') && TWICON_CACHE && strpos($image, get_option('siteurl')) === false ) {
					$image = WP_PLUGIN_URL
						. '/' . basename(dirname(__FILE__))
						. '/' . basename(__FILE__)
						. '?url=' . urlencode($image)
						. '&size=' . $size;
				}

				$avatar = preg_replace('/^(<img.*src=[\'"])[^\'"]*([\'"].* \/>)$/i', '$1'.$image.'$2', $avatar);
			}

		}

		return $avatar;
	}

	// Function getImage
	function getImage($img_url, $img_size){
		$url = parse_url($img_url);
		if($url == false)
			die();
		if(is_numeric($img_size) == false || $img_size > 96)
			die();

		$id = '';
		$find_url = substr($img_url, 0, strrpos($img_url, '_'));
		foreach($this->_avatars as $key => $avatar) {
			$search_url = substr($avatar['profile_image_url'], 0, strrpos($avatar['profile_image_url'], '_'));
			if($search_url == $find_url) {
				$id = $key;
				break;
			}
		}
		unset($avatar);

		$cache_file = $this->_cache_path . md5($img_url . $img_size);
		$expired = isset($this->_avatars[$id])
			? $this->_avatars[$id]['expiration_date']
			: $this->_expiration_date();

		if( file_exists($cache_file) && filemtime($cache_file) < $expired )
			$img = imagecreatefrompng($cache_file);
		else
			$img = $this->_get_resize_image($img_url, $img_size, $cache_file, $id);

		header('Content-Type: image/png');
		header('Expires: '.gmdate('D, d M Y H:i:s', $expired).' GMT');
		imagepng($img);
		imagedestroy($img);
	}

	// Function _expiration_date
	function _expiration_date(){
		return time() + TWICON_EXPIRED * 60 * 60;
	}

	// Function _get_twicon_url
	function _get_twicon_url($id_or_email){
		$result['profile_image_url'] = false;
		$result['expiration_date'] = $this->_expiration_date();

		$email = '';
		$post_id = '';
		$comment_id = '';

		if ( is_numeric($id_or_email) ) {
			$id = (int) $id_or_email;
			$user = get_userdata($id);
			if ( $user )
				$email = $user->user_email;

		} elseif ( is_object($id_or_email) ) {
			 // No avatar for pingbacks or trackbacks
			if ( isset($id_or_email->comment_type) && '' != $id_or_email->comment_type && 'comment' != $id_or_email->comment_type )
				return $result;

			if ( !empty($id_or_email->user_id) ) {
				$id = (int) $id_or_email->user_id;
				$user = get_userdata($id);
				if ( $user )
					$email = $user->user_email;
				unset($user);
			} elseif ( !empty($id_or_email->comment_author_email) ) {
				$email = $id_or_email->comment_author_email;
			}

			if ( !empty($id_or_email->comment_post_ID) )
				$post_id = $id_or_email->comment_post_ID;

			if ( !empty($id_or_email->comment_ID) )
				$comment_id = $id_or_email->comment_ID;

		} else {
			$email = $id_or_email;

		}

		// No avatar
		if (empty($email))
			return $result;

		$id = '';
		$twitter_id = $this->_get_twitter_id($post_id, $comment_id);
		if ( $twitter_id === false ) {
			$id = $email;
			$request = 'http://twitter.com/users/show/show.xml?email='.urlencode($id);
		} else {
			$id = $twitter_id;
			$request = 'http://twitter.com/users/show/'.$id.'.xml';
		}

		return (!empty($id) ? $this->_get_twitter_status($id, $request) : $result);
	}

	// Function _get_twitter_id
	function _get_twitter_id($post_id, $comment_id){
		if ( empty($post_id) || empty($comment_id) || !defined('QC_NOTIFY_TWITTER') )
			return false;

		if ( !isset($this->_meta_value[$post_id]) )
			$this->_meta_value[$post_id] = maybe_unserialize(get_post_meta($post_id, QC_NOTIFY_TWITTER, true));

		$twitter_id = false;
		if ( is_array($this->_meta_value[$post_id]) ) {
			foreach ($this->_meta_value[$post_id] as $key => $val) {
				if (!empty($key) && in_array($comment_id, $val, false)) {
					$twitter_id = $key;
					break;
				}
			}
			unset($val);
		}

		return $twitter_id;
	}

	// Function _get_twitter_status
	function _get_twitter_status($id, $url){
		if (isset($this->_avatars[$id]) && isset($this->_avatars[$id]['expiration_date']) && time() < $this->_avatars[$id]['expiration_date'] )
			return $this->_avatars[$id];

		$snoopy = new Snoopy;
		$snoopy->read_timeout = 30;
		$snoopy->timed_out = true;
		$snoopy->submit($url);
		$response = $snoopy->results;
		$http_code = $snoopy->response_code;
		unset($snoopy);

		if(strpos($http_code, '200') !== FALSE && preg_match('/<profile_image_url>([^<]*)<\/profile_image_url>/i', $response, $matched))
			$this->_avatars[$id]['profile_image_url'] = $matched[1];
		else
			$this->_avatars[$id]['profile_image_url'] = false;
		$this->_avatars[$id]['expiration_date'] = $this->_expiration_date();
		unset($matched);

		$this->_option_update = true;

		return $this->_avatars[$id];
	}

	// Function _get_resize_image
	function _get_resize_image($img_url, $img_size = 96, $cache_file = '', $id = '') {
		$img_resized = imagecreatetruecolor($img_size, $img_size);
		$bgc = imagecolorallocate($img_resized, 255, 255, 255);
		imagefilledrectangle($img_resized, 0, 0, $img_size, $img_size, $bgc);

		if( empty($id) )
			return $img_resized;

		$snoopy = new Snoopy;
		$snoopy->read_timeout = 5;
		$snoopy->timed_out = true;
		$snoopy->fetch($img_url);
		$imgbin = $snoopy->results;
		$http_code = $snoopy->response_code;
		unset($snoopy);

		if(strpos($http_code, '200') === false)
			return $img_resized;

		$img = @imagecreatefromstring($imgbin);
		if($img === false)
			return $img_resized;

		$img_width = imagesx($img);
		$img_height = imagesx($img);
		imagecopyresampled(
			$img_resized,
			$img,
			0, 0, 0, 0,
			$img_size, $img_size,
			$img_width, $img_height);

		@imagepng($img_resized, $cache_file);

		return $img_resized;
	}
}


/******************************************************************************
 * Go Go Go!
 *****************************************************************************/
global $twicon;

$twicon = new twiconController();

if (strpos( $_SERVER['PHP_SELF'], basename(__FILE__)) === false ) {
	// Add WordPress Filter
	add_filter('get_avatar', array(&$twicon, 'getAvatar'), 10, 5);
	add_action('shutdown', array(&$twicon, 'updateAvatars'));

} elseif ( isset($_GET['url']) && defined('TWICON_CACHE') && TWICON_CACHE ) {
	// Get Image from Cache
	$img_url = stripslashes($_GET['url']);
	$img_size = stripslashes($_GET['size']);

	$twicon->getImage($img_url, $img_size);
}
?>