<?php
/* これは文字化け防止のための日本語文字列です。
   このソースファイルは UTF-8 で保存されています。
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with UTF-8.
 */

/* ==================================================
 *   Ktai_Entry_Operator class
   ================================================== */

class Ktai_Entry_Operator {

/* ==================================================
 * @param	string   $buffer
 * @param	string   $charset
 * @return	string   $buffer
 */
protected function pickup_iso_pics($buffer, $charset, $pics) {
	if ($charset == 'auto') {
		$charset = mb_detect_encoding($buffer, KE_DETECT_ORDER);
		Ktai_Entry::logging("Detect content encoding as '$charset' to pickup pictgrams.");
	}
	if (strtolower($charset) == 'iso-2022-jp') {
		for ($offset = 0 , $replace = 'X' ;
			 preg_match('/\x1b\$B([\x21-\x7e]+)\x1b\(B/', $buffer, $sequence, PREG_OFFSET_CAPTURE, $offset); //)
			 $offset += strlen($replace)) 
		{
			$orig    = $sequence[0][0];
			$offset  = $sequence[0][1];
			$chars   = $sequence[1][0];
			$replace = "\x1b\$B";
			for ($i = 0 ; $i < strlen($chars) -1 ; $i += 2) {
				if (isset($pics[$chars[$i] . $chars[$i+1]])) {
					$replace .= sprintf("\x1b(B<img localsrc=\"%s\" />\x1b\$B", $pics[$chars[$i] . $chars[$i+1]]); //)
				} else {
					$replace .= $chars[$i] . $chars[$i+1];
				}
			}
			$replace .= "\x1b(B"; //)
			$replace = str_replace("\x1b\$B\x1b(B", '', $replace); //)
			$buffer = substr_replace($buffer, $replace, $offset, strlen($orig));	
		}
	}
	return $buffer;
}

/* ==================================================
 * @param	string   $buffer
 * @param	string   $charset
 * @return	string   $buffer
 */
protected function pickup_docomo_sjis($buffer, $charset, $pics) {
	mb_regex_encoding('SJIS-win');
	$replaced = mb_ereg_replace(
		"([\xf8\x40-\xf8\x5b]|[\xf8\x5d-\xf8\xfc]|[\xf9\x40-\xf9\x5b]|[\xf9\x5d-\xf9\xfc])", 
		'isset($pics["\1"]) ? 
		"<img localsrc=\"" . $pics["\1"] . "\" />" : 
		"<img localsrc=\"d\" alt=\"" . "[0x" . bin2hex("\1") . "]\" />"', 
		$buffer, 'e');
	if ($replaced) {
		$replaced = mb_ereg_replace("\xf8\x5c", '<img localsrc="d" alt="[0xf85c]" />', $replaced);
		$replaced = mb_ereg_replace("\xf9\x5c", '<img localsrc="' . $pics["\xf9\x5c"] . '" />', $replaced);
	}
	return $replaced ? $replaced : $buffer;
}

/* ==================================================
 * @param	string   $buffer
 * @param	string   $charset
 * @return	string   $buffer
 */
protected function pickup_sbm_sjis($buffer, $charset, $pics) {
	mb_regex_encoding('SJIS-win');
	$replaced = mb_ereg_replace(
		"([\xf7\x40-\xf7\x5b]|[\xf7\x5d-\xf7\xfc]|[\xf9\x40-\xf9\x5b]|[\xf9\x5d-\xf9\xfc]|[\xfb\x40-\xfb\x5b]|[\xfb\x5d-\xfb\xfc])", 
		'isset($pics["\1"]) ? 
		"<img localsrc=\"" . $pics["\1"] . "\" />" : 
		"<img localsrc=\"se\" alt=\"" . "[0x" . bin2hex("\1") . "]\" />"', 
		$buffer, 'e');
	if ($replaced) {
		$replaced = mb_ereg_replace("\xf7\x5c", '<img localsrc="se11c" />', $replaced);
		$replaced = mb_ereg_replace("\xf9\x5c", '<img localsrc="se01c" />', $replaced);
		$replaced = mb_ereg_replace("\xfb\x5c", '<img localsrc="se41c" />', $replaced);	}
	return $replaced ? $replaced : $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Entry_EZweb class
   ================================================== */

class Ktai_Entry_EZweb extends Ktai_Entry_Operator {
	// http://www.au.kddi.com/ezfactory/tec/spec/3.html
	static public $pics_iso = array (
		"\x75\x3a" => '1'  , // 「!」
		"\x75\x3b" => '2'  , // 「!」
		"\x75\x3c" => '3'  , // 「?」
		"\x77\x29" => '4'  , // 「Q」
		"\x77\x2a" => '5'  , // 左向き三角1
		"\x77\x2b" => '6'  , // 右向き三角1
		"\x77\x2c" => '7'  , // 左向き三角2
		"\x77\x2d" => '8'  , // 右向き三角2
		"\x77\x2e" => '9'  , // 小四角 1
		"\x77\x2f" => '10' , // 小四角 2
		"\x77\x30" => '11' , // インフォメーションシンボル
		"\x75\x7a" => '12' , // ワイングラス
		"\x76\x6c" => '13' , // スピーカー
		"\x77\x76" => '14' , // ドルマーク
		"\x76\x5e" => '15' , // 月 1
		"\x75\x40" => '16' , // いなずま
		"\x77\x31" => '17' , // 中四角 1
		"\x77\x32" => '18' , // 中四角 2
		"\x77\x33" => '19' , // 小菱形 1
		"\x77\x34" => '20' , // 小菱形 2
		"\x77\x35" => '21' , // 中四角 1
		"\x77\x36" => '22' , // 中四角 2
		"\x77\x37" => '23' , // 小菱形 1
		"\x77\x38" => '24' , // 小菱形 2
		"\x77\x77" => '25' , // 腕時計
		"\x77\x39" => '26' , // プラス
		"\x77\x3a" => '27' , // マイナス
		"\x77\x3b" => '28' , // 星 1
		"\x77\x3c" => '29' , // 上矢印 1
		"\x77\x3d" => '30' , // 下矢印 1
		"\x77\x3e" => '31' , // 丸に斜め線
		"\x77\x3f" => '32' , // 下三角 1
		"\x77\x40" => '33' , // 上三角 1
		"\x77\x41" => '34' , // 下三角 2
		"\x77\x42" => '35' , // 上三角 2
		"\x77\x43" => '36' , // 大菱形 1
		"\x77\x44" => '37' , // 大菱形 2
		"\x77\x45" => '38' , // 特大四角 1
		"\x77\x46" => '39' , // 特大四角 2
		"\x77\x47" => '40' , // 大丸 1
		"\x77\x48" => '41' , // 大丸 2
		"\x77\x49" => '42' , // 上矢印 2 (左上)
		"\x77\x4a" => '43' , // 下矢印 2 (右下)
		"\x75\x41" => '44' , // 太陽
		"\x75\x73" => '45' , // 野球ボール
		"\x78\x33" => '46' , // 時計
		"\x75\x42" => '47' , // 月 2 (顔つき)
		"\x76\x6d" => '48' , // ベル
		"\x77\x5d" => '49' , // プッシュピン (画鋲)
		"\x76\x55" => '50' , // 小顔
		"\x78\x34" => '51' , // ハート
		"\x75\x7b" => '52' , // マティーニ (カクテルグラス)
		"\x76\x6e" => '53' , // 四つ葉
		"\x77\x4b" => '54' , // トレードマーク (TM)
		"\x77\x4c" => '55' , // かける
		"\x77\x5e" => '56' , // 文書 1
		"\x77\x78" => '57' , // 砂時計 1
		"\x75\x35" => '58' , // 砂時計 2
		"\x77\x5f" => '59' , // フロッピーディスク 1
		"\x75\x43" => '60' , // 雪の結晶
		"\x77\x4d" => '61' , // バツ 1
		"\x77\x4e" => '62' , // バツ 2
		"\x77\x4f" => '63' , // 右矢印 1
		"\x77\x50" => '64' , // 左矢印 1
		"\x75\x7c" => '65' , // マグカップ
		"\x77\x51" => '66' , // 割る
		"\x77\x60" => '67' , // カレンダー
		"\x76\x56" => '68' , // スマイルフェイス
		"\x75\x44" => '69' , // 星 2
		"\x77\x52" => '70' , // 右矢印 2 (右上)
		"\x77\x53" => '71' , // 左矢印 2 (左下)
		"\x76\x6f" => '72' , // ジュエリー
		"\x77\x54" => '73' , // チェックマーク 1
		"\x76\x3a" => '74' , // 犬 (プードル)
		"\x75\x21" => '75' , // 星 3
		"\x75\x25" => '76' , // スパーク
		"\x75\x2f" => '77' , // 電球
		"\x76\x3b" => '78' , // 鳥
		"\x78\x2e" => '79' , // フォルダ 1 (閉)
		"\x76\x57" => '80' , // 顔 1
		"\x77\x55" => '81' , // コピーライトマーク (C)
		"\x77\x56" => '82' , // レジスタードマーク (R)
		"\x75\x55" => '83' , // ブリーフケース (ハンドバック)
		"\x78\x2f" => '84' , // フォルダ 2 (開)
		"\x78\x35" => '85' , // 電話 1 (プッシュホン)
		"\x76\x58" => '86' , // 吹き出しコメント
		"\x77\x79" => '87' , // クレジットカード
		"\x77\x57" => '88' , // 上三角 3
		"\x77\x58" => '89' , // 下三角 3
		"\x77\x70" => '90' , // USA (国旗)
		"\x75\x56" => '91' , // ノート 3
		"\x77\x61" => '92' , // クリップボード
		"\x78\x36" => '93' , // カップ
		"\x76\x70" => '94' , // カメラ
		"\x75\x45" => '95' , // 雨
		"\x75\x74" => '96' , // フットボール
		"\x77\x62" => '97' , // 本 1
		"\x75\x3d" => '98' , // 立ち入り禁止
		"\x75\x23" => '99' , // 信号
		"\x77\x63" => '100', // 本 2
		"\x77\x64" => '101', // 本 3
		"\x77\x65" => '102', // 本 4
		"\x77\x66" => '103', // 文書 2
		"\x76\x71" => '104', // はさみ
		"\x77\x67" => '105', // ひめくりカレンダー
		"\x75\x57" => '106', // チケット・キップ
		"\x75\x46" => '107', // くもり
		"\x76\x7c" => '108', // 封筒
		"\x77\x7a" => '109', // 小切手 (CHECK)
		"\x76\x72" => '110', // ビデオカメラ
		"\x77\x7b" => '111', // ハンディカム
		"\x75\x64" => '112', // 家
		"\x76\x3f" => '113', // 花 (チューリップ)
		"\x77\x7c" => '114', // ナイフ
		"\x77\x7d" => '115', // ビデオテープ
		"\x76\x59" => '116', // めがね
		"\x77\x59" => '117', // 回り矢印 1
		"\x77\x5a" => '118', // 回り矢印 2
		"\x76\x73" => '119', // むしめがね
		"\x76\x74" => '120', // 鍵
		"\x77\x68" => '121', // ノート 1
		"\x75\x58" => '122', // ノート 2 (開)
		"\x77\x7e" => '123', // ボルト & ナット
		"\x76\x75" => '124', // くつ (ハイヒール)
		"\x75\x6a" => '125', // 車
		"\x78\x21" => '126', // フロッピー 2
		"\x77\x71" => '127', // チャート (棒グラフ)
		"\x77\x72" => '128', // グラフ 1 (折れ線グラフ)
		"\x76\x76" => '129', // メールボックス
		"\x78\x22" => '130', // 懐中電灯
		"\x77\x69" => '131', // Roldex
		"\x77\x5b" => '132', // チェックマーク 2
		"\x76\x29" => '133', // はっぱ
		"\x76\x3c" => '134', // 猟犬
		"\x78\x23" => '135', // 電池
		"\x77\x5c" => '136', // スクロール
		"\x77\x6a" => '137', // がびょう
		"\x76\x77" => '138', // 錠前
		"\x78\x24" => '139', // ドル札
		"\x76\x5a" => '140', // 指差し確認左
		"\x76\x5b" => '141', // 指差し確認右
		"\x77\x6b" => '142', // 台帳
		"\x75\x59" => '143', // クリップ
		"\x76\x2a" => '144', // プレゼント
		"\x76\x78" => '145', // 名札
		"\x75\x65" => '146', // ゴハン 1 (ナイフとフォーク)
		"\x77\x6c" => '147', // 複数本
		"\x75\x6b" => '148', // トラック
		"\x75\x5a" => '149', // エンピツ
		"\x78\x25" => '150', // ロゴ (PDC社)
		"\x78\x30" => '151', // 封筒 2
		"\x78\x26" => '152', // レンチ
		"\x78\x31" => '153', // 送信 BOX
		"\x78\x32" => '154', // 受信 BOX
		"\x76\x79" => '155', // 電話 2 (受話器)
		"\x76\x86" => '156', // 工場・建物
		"\x77\x6d" => '157', // 定規 1 (直線)
		"\x75\x5b" => '158', // 定規 2 (三角)
		"\x77\x73" => '159', // グラフ 2
		"\x75\x7d" => '160', // 食事 2 (マンガ肉)
		"\x78\x27" => '161', // 電話 3 (携帯)
		"\x78\x28" => '162', // コンセント
		"\x76\x5c" => '163', // 家族
		"\x78\x29" => '164', // リンク
		"\x76\x7a" => '165', // パッケージ
		"\x76\x7b" => '166', // FAX
		"\x75\x47" => '167', // ときどき曇り
		"\x75\x6c" => '168', // 飛行機
		"\x75\x6d" => '169', // ボート (船)
		"\x76\x23" => '170', // サイコロ
		"\x78\x2a" => '171', // 新聞
		"\x75\x6e" => '172', // 電車
		"\x78\x2b" => '173', // 全部ブランク
		"\x78\x2c" => '174', // 半分ブランク
		"\x78\x2d" => '175', // 4分の1ブランク
		"\x75\x36" => '176', // 喫煙
		"\x75\x37" => '177', // 禁煙
		"\x75\x38" => '178', // 車椅子
		"\x75\x39" => '179', // 若葉マーク
		"\x76\x7d" => '180', // 四角数字 1
		"\x76\x7e" => '181', // 四角数字 2
		"\x77\x21" => '182', // 四角数字 3
		"\x77\x22" => '183', // 四角数字 4
		"\x77\x23" => '184', // 四角数字 5
		"\x77\x24" => '185', // 四角数字 6
		"\x77\x25" => '186', // 四角数字 7
		"\x77\x26" => '187', // 四角数字 8
		"\x77\x27" => '188', // 四角数字 9
		"\x77\x28" => '189', // 四角数字 10
		"\x75\x22" => '190', // 台風
		"\x75\x3e" => '191', // ゆきだるま
		"\x75\x48" => '192', // 星座 (おひつじ座)
		"\x75\x49" => '193', // 星座 (おうし座)
		"\x75\x4a" => '194', // 星座 (双子座)
		"\x75\x4b" => '195', // 星座 (かに座)
		"\x75\x4c" => '196', // 星座 (しし座)
		"\x75\x4d" => '197', // 星座 (おとめ座)
		"\x75\x4e" => '198', // 星座 (天秤座)
		"\x75\x4f" => '199', // 星座 (さそり座)
		"\x75\x50" => '200', // 星座 (いて座)
		"\x75\x51" => '201', // 星座 (やぎ座)
		"\x75\x52" => '202', // 星座 (水瓶座)
		"\x75\x53" => '203', // 星座 (うお座)
		"\x75\x54" => '204', // 星座 (へびつかい座)
		"\x75\x5c" => '205', // ATM
		"\x75\x5d" => '206', // 24 HOURS (コンビニ)
		"\x75\x5e" => '207', // トイレ
		"\x75\x5f" => '208', // パーキング
		"\x75\x60" => '209', // バス停
		"\x75\x61" => '210', // アンテナ (位置情報マーク)
		"\x75\x62" => '211', // 港 (いかりマーク)
		"\x75\x63" => '212', // 銀行
		"\x77\x6e" => '213', // ガススタンド
		"\x77\x6f" => '214', // 地図
		"\x75\x67" => '215', // 自転車
		"\x75\x68" => '216', // バス
		"\x75\x69" => '217', // 新幹線
		"\x75\x24" => '218', // マラソン
		"\x75\x6f" => '219', // サッカー
		"\x75\x70" => '220', // テニス
		"\x75\x71" => '221', // スノーボード
		"\x75\x72" => '222', // チェッカーフラッグ (モータースポーツ)
		"\x75\x26" => '223', // 遊園地
		"\x75\x75" => '224', // 温泉
		"\x75\x76" => '225', // 居酒屋 (赤ちょうちん)
		"\x75\x77" => '226', // 映画 (かちんこ)
		"\x75\x78" => '227', // 夜の橋
		"\x75\x79" => '228', // 東京タワー
		"\x75\x27" => '229', // スロット (777)
		"\x75\x28" => '230', // くす玉 (アタリのくす玉)
		"\x75\x7e" => '231', // 当選弓矢
		"\x76\x21" => '232', // ゲームのコントローラ
		"\x76\x22" => '233', // 賞金
		"\x76\x24" => '234', // クリスマスツリー
		"\x76\x25" => '235', // 花見 (さくら)
		"\x76\x26" => '236', // お化け
		"\x76\x27" => '237', // 旗 (祝日・日の丸)
		"\x76\x28" => '238', // スイカ
		"\x76\x2b" => '239', // ケーキ
		"\x76\x2c" => '240', // フライパン (目玉焼き)
		"\x76\x2d" => '241', // さくらんぼ
		"\x76\x2e" => '242', // ふぐ
		"\x76\x2f" => '243', // イチゴ
		"\x76\x30" => '244', // おにぎり
		"\x76\x31" => '245', // ハンバーガー (ファーストフード)
		"\x76\x29" => '246', // くじら
		"\x76\x32" => '247', // うさぎ
		"\x76\x33" => '248', // うま
		"\x76\x34" => '249', // さる
		"\x76\x35" => '250', // かえる
		"\x76\x36" => '251', // 猫
		"\x76\x37" => '252', // ペンギン
		"\x76\x38" => '253', // あり
		"\x76\x39" => '254', // ぶた
		"\x76\x3d" => '255', // やしのき
		"\x76\x3e" => '256', // ひまわり
		"\x75\x2a" => '257', // 顔 1 (うれしいカオ)
		"\x75\x2b" => '258', // 顔 2 (おこったカオ)
		"\x75\x2c" => '259', // 顔 3 (かなしいカオ)
		"\x75\x2d" => '260', // 顔 4 (つかれたカオ)
		"\x75\x2e" => '261', // 眠い (ZZZ...)
		"\x76\x40" => '262', // 怒り (ムカッ)
		"\x76\x41" => '263', // 雫 (涙・汗)
		"\x76\x42" => '264', // からかう (あっかんべえ)
		"\x75\x30" => '265', // ハート 2 (われている)
		"\x75\x31" => '266', // ハート 3 (大きい & 小さい)
		"\x75\x32" => '267', // スパーク 2 (キラリマーク)
		"\x75\x33" => '268', // 爆弾
		"\x75\x34" => '269', // 炎
		"\x76\x43" => '270', // 捜索 (SOS)
		"\x76\x44" => '271', // 力こぶ
		"\x76\x45" => '272', // ハート 5 (矢がささっている)
		"\x76\x46" => '273', // キスマーク
		"\x76\x47" => '274', // 宇宙人
		"\x76\x48" => '275', // なると
		"\x76\x49" => '276', // 足跡 (犬)
		"\x76\x4a" => '277', // 悪魔
		"\x76\x4b" => '278', // 花丸
		"\x76\x4c" => '279', // 丸秘
		"\x76\x4d" => '280', // 100点満点
		"\x76\x4e" => '281', // パンチ
		"\x76\x4f" => '282', // ダッシュ
		"\x76\x50" => '283', // ウンチマーク
		"\x76\x51" => '284', // 人差し指サイン
		"\x76\x52" => '285', // マル得
		"\x76\x53" => '286', // どくろ
		"\x76\x54" => '287', // おやゆびサイン (指が上)
		"\x76\x5d" => '288', // テレビ
		"\x76\x5e" => '289', // マイク
		"\x76\x5f" => '290', // 財布
		"\x76\x60" => '291', // メロディ
		"\x76\x61" => '292', // ギター (エレキ)
		"\x76\x62" => '293', // バイオリン (クラシック)
		"\x76\x63" => '294', // ヘッドフォン
		"\x76\x64" => '295', // 口紅
		"\x76\x65" => '296', // アクション (ピストル)
		"\x76\x66" => '297', // エステ
		"\x77\x74" => '298', // EZ マーク
		"\x77\x75" => '299', // 無料 (FREE)
		"\x76\x67" => '300', // CD/DVD
		"\x76\x68" => '301', // 婦人服
		"\x76\x69" => '302', // UFO
		"\x76\x6a" => '303', // 更新 (UP!)
		"\x76\x6b" => '304', // 注射器 (血)
		"\x78\x37" => '305', // 霧
		"\x78\x38" => '306', // ゴルフ
		"\x78\x39" => '307', // バスケットボール
		"\x78\x3a" => '308', // ポケットベル
		"\x78\x3b" => '309', // アート
		"\x78\x3c" => '310', // 演劇
		"\x78\x3d" => '311', // イベント (サーカス)
		"\x78\x3e" => '312', // リボン
		"\x78\x3f" => '313', // バースデー
		"\x78\x40" => '314', // スペード
		"\x78\x41" => '315', // ダイヤ
		"\x78\x42" => '316', // クラブ
		"\x78\x43" => '317', // 目
		"\x78\x44" => '318', // 耳
		"\x78\x45" => '319', // 手 (チョキ)
		"\x78\x46" => '320', // 手 (パー)
		"\x78\x47" => '321', // 新月
		"\x78\x48" => '322', // やや欠け月
		"\x78\x49" => '323', // 半月
		"\x78\x4a" => '324', // クリア
		"\x78\x4b" => '325', // 四角数字 0
		"\x78\x4c" => '326', // 決定 (OK)
		"\x78\x4d" => '327', // ふらふら (顔)
		"\x78\x4e" => '328', // かわいい
		"\x78\x4f" => '329', // どんっ (衝撃)
		"\x78\x50" => '330', // あせあせ (飛び散る汗)
		"\x78\x51" => '331', // イージープラス
		"\x78\x52" => '332', // 地球
		"\x78\x53" => '333', // ラーメン
		"\x78\x67" => '334', // NEW
		"\x78\x68" => '335', // 紳士服
		"\x78\x69" => '336', // 紳士靴
		"\x78\x6a" => '337', // パソコン
		"\x78\x6b" => '338', // ラジオ
		"\x78\x6c" => '339', // バラ
		"\x78\x6d" => '340', // チャペル
		"\x78\x6e" => '341', // 地下鉄
		"\x78\x6f" => '342', // 富士山
		"\x78\x70" => '343', // 八分音符
		"\x78\x71" => '344', // 天使
		"\x78\x72" => '345', // トラ
		"\x78\x73" => '346', // くま
		"\x78\x74" => '347', // ねずみ
		"\x78\x75" => '348', // ウィンク (顔)
		"\x78\x76" => '349', // 目がハート (顔)
		"\x78\x77" => '350', // ショッキング (顔)
		"\x78\x78" => '351', // 困り (顔)
		"\x78\x79" => '352', // たこ
		"\x78\x7a" => '353', // ロケット
		"\x78\x7b" => '354', // 王冠
		"\x78\x7c" => '355', // チュー (キスしている)
		"\x78\x7d" => '356', // ハンマー
		"\x78\x7e" => '357', // 打ち上げ花火
		"\x79\x21" => '358', // 枯れ葉
		"\x79\x22" => '359', // 仕事かばん
		"\x79\x23" => '360', // 噴水
		"\x79\x24" => '361', // キャンプ
		"\x79\x25" => '362', // 麻雀
		"\x79\x26" => '363', // VS (バーサス)
		"\x79\x27" => '364', // トロフィー
		"\x79\x28" => '365', // カメ
		"\x79\x29" => '366', // スペイン国旗
		"\x79\x2a" => '367', // ロシア国旗
		"\x79\x2b" => '368', // 工事中
		"\x79\x2c" => '369', // 風呂
		"\x79\x2d" => '370', // 祝日マーク
		"\x79\x2e" => '371', // 夕方街並み
		"\x79\x2f" => '372', // 卵割り
		"\x79\x30" => '373', // 株価
		"\x79\x31" => '374', // ポリス
		"\x79\x32" => '375', // 郵便局
		"\x79\x33" => '376', // 病院
		"\x79\x34" => '377', // 学校
		"\x79\x35" => '378', // ホテル
		"\x79\x36" => '379', // 船
		"\x79\x37" => '380', // 18禁
		"\x79\x38" => '381', // 圏内
		"\x79\x39" => '382', // COOL!
		"\x79\x3a" => '383', // 割マーク
		"\x79\x3b" => '384', // ザ・マーク
		"\x79\x3c" => '385', // IDマーク
		"\x79\x3d" => '386', // 満マーク
		"\x79\x3e" => '387', // 空マーク
		"\x79\x3f" => '388', // 指定マーク
		"\x79\x40" => '389', // 営業中マーク
		"\x79\x41" => '390', // 上指差し
		"\x79\x42" => '391', // 下指差し
		"\x79\x43" => '392', // 占い (水晶)
		"\x79\x44" => '393', // マナーモード
		"\x79\x45" => '394', // 電源OFF
		"\x79\x46" => '395', // メモする
		"\x79\x47" => '396', // ネクタイ
		"\x79\x48" => '397', // ハイビスカス
		"\x79\x49" => '398', // 花束
		"\x79\x4a" => '399', // サボテン
		"\x79\x4b" => '400', // お銚子 & 杯
		"\x79\x4c" => '401', // 乾杯 (ビール)
		"\x79\x4d" => '402', // 祝マーク
		"\x79\x4e" => '403', // 風邪薬 (カプセル)
		"\x79\x4f" => '404', // 風船
		"\x79\x50" => '405', // クラッカー
		"\x79\x51" => '406', // eznavigation
		"\x79\x52" => '407', // 帽子
		"\x79\x53" => '408', // ロングブーツ
		"\x79\x54" => '409', // ネイル
		"\x79\x55" => '410', // 美容院
		"\x79\x56" => '411', // 床屋
		"\x79\x57" => '412', // 着物
		"\x79\x58" => '413', // ビキニ
		"\x79\x59" => '414', // ハート (トランプ)
		"\x79\x5a" => '415', // 光るハート
		"\x79\x5b" => '416', // 青ハート
		"\x79\x5c" => '417', // 緑ハート
		"\x79\x5d" => '418', // 黄ハート
		"\x79\x5e" => '419', // 紫ハート
		"\x79\x5f" => '420', // きらきら
		"\x79\x60" => '421', // スキー
		"\x79\x61" => '422', // ○
		"\x79\x62" => '423', // 日本茶
		"\x79\x63" => '424', // 食パン
		"\x79\x64" => '425', // ソフトクリーム
		"\x79\x65" => '426', // ポテト
		"\x79\x66" => '427', // だんご
		"\x79\x67" => '428', // おせんべい
		"\x79\x68" => '429', // ごはん
		"\x79\x69" => '430', // スパゲティ
		"\x79\x6a" => '431', // カレー
		"\x79\x6b" => '432', // おでん
		"\x79\x6c" => '433', // 寿司
		"\x79\x6d" => '434', // りんご
		"\x79\x6e" => '435', // みかん
		"\x79\x6f" => '436', // トマト
		"\x79\x70" => '437', // なす
		"\x79\x71" => '438', // 弁当
		"\x79\x72" => '439', // 鍋
		"\x79\x73" => '440', // ふっ (顔)
		"\x79\x74" => '441', // しょんぼり (顔)
		"\x79\x75" => '442', // 勝ち誇り (顔)
		"\x79\x76" => '443', // 失敗 (顔)
		"\x79\x77" => '444', // わからん
		"\x79\x78" => '445', // 眠い
		"\x79\x79" => '446', // てれてれ (顔)
		"\x79\x7a" => '447', // 青ざめ (顔)
		"\x79\x7b" => '448', // 風邪ひき
		"\x79\x7c" => '449', // 熱 (顔)
		"\x79\x7d" => '450', // 横目 (顔)
		"\x79\x7e" => '451', // びっくり (顔)
		"\x7a\x21" => '452', // あせり (顔)
		"\x7a\x22" => '453', // 楽譜
		"\x7a\x23" => '454', // にこにこ (顔)
		"\x7a\x24" => '455', // チュー 2 (顔)
		"\x7a\x25" => '456', // チュッ (顔)
		"\x7a\x26" => '457', // 鼻
		"\x7a\x27" => '458', // 口
		"\x7a\x28" => '459', // ゴメン／お願い
		"\x7a\x29" => '460', // 拍手
		"\x7a\x2a" => '461', // OK! (指で丸サイン)
		"\x7a\x2b" => '462', // ブーイング (指が下)
		"\x7a\x2c" => '463', // バイバイ
		"\x7a\x2d" => '464', // NG (ネコ)
		"\x7a\x2e" => '465', // OK! 2 (ネコ)
		"\x7a\x2f" => '466', // 平謝り (ネコ)
		"\x7a\x30" => '467', // カップル
		"\x7a\x31" => '468', // バニー
		"\x7a\x32" => '469', // トランペット
		"\x7a\x33" => '470', // ビリヤード
		"\x7a\x34" => '471', // 水泳
		"\x7a\x35" => '472', // 消防車
		"\x7a\x36" => '473', // 救急車
		"\x7a\x37" => '474', // パトカー
		"\x7a\x38" => '475', // ジェットコースター
		"\x7a\x39" => '476', // 門松
		"\x7a\x3a" => '477', // 雛祭り
		"\x7a\x3b" => '478', // 卒業式
		"\x7a\x3c" => '479', // 入学式
		"\x7a\x3d" => '480', // こいのぼり
		"\x7a\x3e" => '481', // 傘
		"\x7a\x3f" => '482', // 花嫁
		"\x7a\x40" => '483', // かき氷
		"\x7a\x41" => '484', // 線香花火
		"\x7a\x42" => '485', // 巻き貝
		"\x7a\x43" => '486', // 風鈴
		"\x7a\x44" => '487', // ハロウィン
		"\x7a\x45" => '488', // お月見
		"\x7a\x46" => '489', // サンタ
		"\x7a\x47" => '490', // 夜／流れ星
		"\x7a\x48" => '491', // 虹
		"\x7a\x49" => '492', // ホテル 2
		"\x7a\x4a" => '493', // 日の出
		"\x7a\x4b" => '494', // シルクハット
		"\x7a\x4c" => '495', // デパート
		"\x7a\x4d" => '496', // 城 (日本)
		"\x7a\x4e" => '497', // 城 (ヨーロッパ)
		"\x7a\x4f" => '498', // 工場 2
		"\x7a\x50" => '499', // フランス国旗
		"\x77\x54" => '500', // オープンウェーブ
		"\x77\x55" => '501', // ロック確認
		"\x77\x56" => '502', // 大文字
		"\x77\x57" => '503', // 小文字
		"\x77\x58" => '504', // 数字
		"\x77\x59" => '505', // 記号
		"\x77\x5a" => '506', // アクセプト
		"\x77\x5b" => '507', // チェックボックス
		"\x77\x5c" => '508', // エディット
		"\x77\x5d" => '509', // ラジオボタン
		"\x77\x5e" => '510', // 見る (虫眼鏡)
		"\x77\x5f" => '511', // 戻る
		"\x77\x60" => '512', // お気に入り
		"\x77\x61" => '513', // 終了
		"\x77\x62" => '514', // ホーム
		"\x77\x63" => '515', // 受信箱 1
		"\x77\x64" => '516', // マーク
		"\x77\x65" => '517', // 個人 (鍵)
		"\x77\x66" => '518', // 再読み込み
		"\x7a\x51" => '700', // ドイツ国旗
		"\x7a\x52" => '701', // イタリア国旗
		"\x7a\x53" => '702', // イギリス国旗
		"\x7a\x54" => '703', // 中国国旗
		"\x7a\x55" => '704', // 韓国国旗
		"\x7a\x56" => '705', // 白人
		"\x7a\x57" => '706', // 中国人
		"\x7a\x58" => '707', // インド人
		"\x7a\x59" => '708', // おじいさん
		"\x7a\x5a" => '709', // おばあさん
		"\x7a\x5b" => '710', // 赤ちゃん
		"\x7a\x5c" => '711', // 工事現場の人
		"\x7a\x5d" => '712', // お姫様
		"\x7a\x5e" => '713', // イルカ
		"\x7a\x5f" => '714', // ダンス
		"\x7a\x60" => '715', // 熱帯魚
		"\x7a\x61" => '716', // げじげじ
		"\x7a\x62" => '717', // 象
		"\x7a\x63" => '718', // コアラ
		"\x7a\x64" => '719', // ホルスタイン
		"\x7a\x65" => '720', // ヘビ
		"\x7a\x66" => '721', // 鶏
		"\x7a\x67" => '722', // うりぼう
		"\x7a\x68" => '723', // ふたこぶらくだ
		"\x7a\x69" => '724', // A型
		"\x7a\x6a" => '725', // B型
		"\x7a\x6b" => '726', // O型
		"\x7a\x6c" => '727', // AB型
		"\x7a\x6d" => '728', // 足跡
		"\x7a\x6e" => '729', // スニーカー
		"\x7a\x6f" => '730', // 旗
		"\x7a\x70" => '731', // 上向きカーブ矢印
		"\x7a\x71" => '732', // 下向きカーブ矢印
		"\x7a\x72" => '733', // 「!?」
		"\x7a\x73" => '734', // 「!!」
		"\x7a\x74" => '735', // くるり
		"\x7a\x75" => '736', // メロン
		"\x7a\x76" => '737', // パイナップル
		"\x7a\x77" => '738', // ぶどう
		"\x7a\x78" => '739', // バナナ
		"\x7a\x79" => '740', // とうもろこし
		"\x7a\x7a" => '741', // きのこ
		"\x7a\x7b" => '742', // 栗
		"\x7a\x7c" => '743', // 桃
		"\x7a\x7d" => '744', // やきいも
		"\x7a\x7e" => '745', // ピザ
		"\x7b\x21" => '746', // ターキー
		"\x7b\x22" => '747', // 七夕笹飾り
		"\x7b\x23" => '748', // トロピカルドリンク
		"\x7b\x24" => '749', // 辰
		"\x7b\x25" => '750', // ピアノ
		"\x7b\x26" => '751', // サーフィン
		"\x7b\x27" => '752', // 釣り
		"\x7b\x28" => '753', // ボウリング
		"\x7b\x29" => '754', // なまはげ
		"\x7b\x2a" => '755', // 天狗
		"\x7b\x2b" => '756', // パンダ
		"\x7b\x2c" => '757', // あかんべー
		"\x7b\x2d" => '758', // ぶたの鼻
		"\x7b\x2e" => '759', // 花
		"\x7b\x2f" => '760', // アイスクリーム
		"\x7b\x30" => '761', // ドーナツ
		"\x7b\x31" => '762', // クッキー
		"\x7b\x32" => '763', // チョコ
		"\x7b\x33" => '764', // キャンディ (包み)
		"\x7b\x34" => '765', // キャンディ (ぺろぺろ)
		"\x7b\x35" => '766', // 見ざる (猿)
		"\x7b\x36" => '767', // 言わざる (猿)
		"\x7b\x37" => '768', // 聞かざる (猿)
		"\x7b\x38" => '769', // 火山
		"\x7b\x39" => '770', // リボンがけのハート
		"\x7b\x3a" => '771', // 英語「ABC」
		"\x7b\x3b" => '772', // プリン
		"\x7b\x3c" => '773', // ミツバチ
		"\x7b\x3d" => '774', // テントウムシ
		"\x7b\x3e" => '775', // 蜂蜜ポット
		"\x7b\x3f" => '776', // 青りんご
		"\x7b\x40" => '777', // 羽のはえたお札
		"\x7b\x41" => '778', // 目がまわる時の記号
		"\x7b\x42" => '779', // ぷー (かわいく怒)
		"\x7b\x43" => '780', // ぷー (かわいく怒) (ネコ)
		"\x7b\x44" => '781', // 天の川
		"\x7b\x45" => '782', // チュー (ネコ)
		"\x7b\x46" => '783', // にこ (ネコ)
		"\x7b\x47" => '784', // メールする
		"\x7b\x48" => '785', // 泣き笑い (ネコ)
		"\x7b\x49" => '786', // 泣き笑い (顔)
		"\x7b\x4a" => '787', // 目がハート (ネコ)
		"\x7b\x4b" => '788', // ほえー (ネコ)
		"\x7b\x4c" => '789', // ほえー (顔)
		"\x7b\x4d" => '790', // 涙ぽろり (ネコ)
		"\x7b\x4e" => '791', // 涙ぽろり (顔)
		"\x7b\x4f" => '792', // きりり (ネコ)
		"\x7b\x50" => '793', // ドレス
		"\x7b\x51" => '794', // モヤイ像
		"\x7b\x52" => '795', // 駅
		"\x7b\x53" => '796', // 花札
		"\x7b\x54" => '797', // ジョーカー
		"\x7b\x55" => '798', // エビフライ
		"\x7b\x56" => '799', // eメールアイコン
		"\x7b\x57" => '800', // 歩く人
		"\x7b\x58" => '801', // パトカーのランプ
		"\x7b\x59" => '802', // ezmovie
		"\x7b\x5a" => '803', // ドキドキしているハート
		"\x7b\x5b" => '804', // 正面向きのひよこ
		"\x7b\x5c" => '805', // ジーンズ
		"\x7b\x5d" => '806', // ハートつきメール
		"\x7b\x5e" => '807', // 循環矢印
		"\x7b\x5f" => '808', // 左右両方矢印
		"\x7b\x60" => '809', // 上下両方矢印
		"\x7b\x61" => '810', // 荒波
		"\x7b\x62" => '811', // 双葉
		"\x7b\x63" => '812', // かたつむり
		"\x7b\x64" => '813', // うっしっし (ネコ)
		"\x7b\x65" => '814', // うっしっし (顔)
		"\x7b\x66" => '815', // Cメールアイコン
		"\x7b\x67" => '816', // ハーブ
		"\x7b\x68" => '817', // 手 (グー)
		"\x7b\x69" => '818', // 「#」
		"\x7b\x6a" => '819', // 挙手 (キャラクター)
		"\x7b\x6b" => '820', // 万歳 (キャラクター)
		"\x7b\x6c" => '821', // しょんぼり (キャラクター)
		"\x7b\x6d" => '822', // かわいく怒る (キャラクター)
	);

/* ==================================================
 * @param	string   $buffer
 * @param	string   $charset
 * @return	string   $buffer
 */
public function pickup_pics($buffer, $charset) {
	return $this->pickup_iso_pics($buffer, $charset, self::$pics_iso);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Entry_imode_SJIS class
   ================================================== */

class Ktai_Entry_imode_SJIS extends Ktai_Entry_Operator {
	// http://www.nttdocomo.co.jp/service/imode/make/content/pictograph/
	static public $pics_sjis = array(
		"\xf8\x9f" => 'd001', // 晴れ
		"\xf8\xa0" => 'd002', // 曇り
		"\xf8\xa1" => 'd003', // 雨
		"\xf8\xa2" => 'd004', // 雪 
		"\xf8\xa3" => 'd005', // 雷
		"\xf8\xa4" => 'd006', // 台風
		"\xf8\xa5" => 'd007', // 霧
		"\xf8\xa6" => 'd008', // 小雨
		"\xf8\xa7" => 'd009', // 牡羊座
		"\xf8\xa8" => 'd010', // 牡牛座
		"\xf8\xa9" => 'd011', // 双子座
		"\xf8\xaa" => 'd012', // 蟹座
		"\xf8\xab" => 'd013', // 獅子座
		"\xf8\xac" => 'd014', // 乙女座
		"\xf8\xad" => 'd015', // 天秤座
		"\xf8\xae" => 'd016', // 蠍座
		"\xf8\xaf" => 'd017', // 射手座
		"\xf8\xb0" => 'd018', // 山羊座
		"\xf8\xb1" => 'd019', // 水瓶座
		"\xf8\xb2" => 'd020', // 魚座
		"\xf8\xb3" => 'd021', // スポーツ
		"\xf8\xb4" => 'd022', // 野球
		"\xf8\xb5" => 'd023', // ゴルフ
		"\xf8\xb6" => 'd024', // テニス
		"\xf8\xb7" => 'd025', // サッカー
		"\xf8\xb8" => 'd026', // スキー
		"\xf8\xb9" => 'd027', // バスケットボール
		"\xf8\xba" => 'd028', // モータースポーツ (チェッカーフラッグ)
		"\xf8\xbb" => 'd029', // ポケットベル
		"\xf8\xbc" => 'd030', // 電車
		"\xf8\xbd" => 'd031', // 地下鉄
		"\xf8\xbe" => 'd032', // 新幹線
		"\xf8\xbf" => 'd033', // 車 (セダン)
		"\xf8\xc0" => 'd034', // 車 (RV)
		"\xf8\xc1" => 'd035', // バス
		"\xf8\xc2" => 'd036', // 船
		"\xf8\xc3" => 'd037', // 飛行機
		"\xf8\xc4" => 'd038', // 家
		"\xf8\xc5" => 'd039', // ビル
		"\xf8\xc6" => 'd040', // 郵便局
		"\xf8\xc7" => 'd041', // 病院
		"\xf8\xc8" => 'd042', // 銀行
		"\xf8\xc9" => 'd043', // ATM
		"\xf8\xca" => 'd044', // ホテル
		"\xf8\xcb" => 'd045', // コンビニ
		"\xf8\xcc" => 'd046', // ガソリンスタンド
		"\xf8\xcd" => 'd047', // 駐車場
		"\xf8\xce" => 'd048', // 信号
		"\xf8\xcf" => 'd049', // トイレ
		"\xf8\xd0" => 'd050', // レストラン
		"\xf8\xd1" => 'd051', // 喫茶店
		"\xf8\xd2" => 'd052', // バー (マティーニ)
		"\xf8\xd3" => 'd053', // ビール
		"\xf8\xd4" => 'd054', // ファーストフード (ハンバーガー)
		"\xf8\xd5" => 'd055', // ブティック
		"\xf8\xd6" => 'd056', // 美容院 (鋏)
		"\xf8\xd7" => 'd057', // カラオケ
		"\xf8\xd8" => 'd058', // 映画
		"\xf8\xd9" => 'd059', // 右斜め上
		"\xf8\xda" => 'd060', // 遊園地 (木馬)
		"\xf8\xdb" => 'd061', // 音楽 (ヘッドホン)
		"\xf8\xdc" => 'd062', // アート
		"\xf8\xdd" => 'd063', // 演劇
		"\xf8\xde" => 'd064', // イベント (サーカス)
		"\xf8\xdf" => 'd065', // チケット
		"\xf8\xe0" => 'd066', // 喫煙
		"\xf8\xe1" => 'd067', // 禁煙
		"\xf8\xe2" => 'd068', // カメラ
		"\xf8\xe3" => 'd069', // カバン
		"\xf8\xe4" => 'd070', // 本
		"\xf8\xe5" => 'd071', // リボン
		"\xf8\xe6" => 'd072', // プレゼント
		"\xf8\xe7" => 'd073', // バースデー
		"\xf8\xe8" => 'd074', // 電話
		"\xf8\xe9" => 'd075', // 携帯電話
		"\xf8\xea" => 'd076', // メモ
		"\xf8\xeb" => 'd077', // TV
		"\xf8\xec" => 'd078', // ゲーム
		"\xf8\xed" => 'd079', // CD
		"\xf8\xee" => 'd080', // ハート
		"\xf8\xef" => 'd081', // スペード
		"\xf8\xf0" => 'd082', // ダイヤ
		"\xf8\xf1" => 'd083', // クラブ
		"\xf8\xf2" => 'd084', // 目
		"\xf8\xf3" => 'd085', // 耳
		"\xf8\xf4" => 'd086', // 手 (グー)
		"\xf8\xf5" => 'd087', // 手 (チョキ)
		"\xf8\xf6" => 'd088', // 手 (パー)
		"\xf8\xf7" => 'd089', // 右斜め下
		"\xf8\xf8" => 'd090', // 左斜め上
		"\xf8\xf9" => 'd091', // 足
		"\xf8\xfa" => 'd092', // くつ
		"\xf8\xfb" => 'd093', // 眼鏡
		"\xf8\xfc" => 'd094', // 車椅子
		"\xf9\x40" => 'd095', // 新月
		"\xf9\x41" => 'd096', // やや欠け月
		"\xf9\x42" => 'd097', // 半月
		"\xf9\x43" => 'd098', // 三日月
		"\xf9\x44" => 'd099', // 満月
		"\xf9\x45" => 'd100', // 犬
		"\xf9\x46" => 'd101', // 猫
		"\xf9\x47" => 'd102', // リゾート (ヨット)
		"\xf9\x48" => 'd103', // クリスマス
		"\xf9\x49" => 'd104', // 左斜め下
		"\xf9\x72" => 'd105', // phone to
		"\xf9\x73" => 'd106', // mail to
		"\xf9\x74" => 'd107', // fax to
		"\xf9\x75" => 'd108', // iモード
		"\xf9\x76" => 'd109', // iモード (枠付き)
		"\xf9\x77" => 'd110', // メール
		"\xf9\x78" => 'd111', // ドコモ提供
		"\xf9\x79" => 'd112', // ドコモポイント
		"\xf9\x7a" => 'd113', // 有料
		"\xf9\x7b" => 'd114', // 無料
		"\xf9\x7c" => 'd115', // ID
		"\xf9\x7d" => 'd116', // パスワード
		"\xf9\x7e" => 'd117', // 次項有
		"\xf9\x80" => 'd118', // クリア
		"\xf9\x81" => 'd119', // サーチ (調べる)
		"\xf9\x82" => 'd120', // NEW
		"\xf9\x83" => 'd121', // 位置情報
		"\xf9\x84" => 'd122', // フリーダイヤル
		"\xf9\x85" => 'd123', // シャープダイヤル
		"\xf9\x86" => 'd124', // モバQ
		"\xf9\x87" => 'd125', // 1 (one)
		"\xf9\x88" => 'd126', // 2 (two)
		"\xf9\x89" => 'd127', // 3 (three)
		"\xf9\x8a" => 'd128', // 4 (four)
		"\xf9\x8b" => 'd129', // 5 (five)
		"\xf9\x8c" => 'd130', // 6 (six)
		"\xf9\x8d" => 'd131', // 7 (seven)
		"\xf9\x8e" => 'd132', // 8 (eight)
		"\xf9\x8f" => 'd133', // 9 (nine)
		"\xf9\x90" => 'd134', // 0 (zero)
		"\xf9\xb0" => 'd135', // 決定 (OK)
		"\xf9\x91" => 'd136', // 黒ハート
		"\xf9\x92" => 'd137', // 揺れるハート
		"\xf9\x93" => 'd138', // 失恋
		"\xf9\x94" => 'd139', // ハートたち (複数ハート)
		"\xf9\x95" => 'd140', // わーい (嬉しい顔)
		"\xf9\x96" => 'd141', // ちっ (怒った顔)
		"\xf9\x97" => 'd142', // がく〜 (落胆した顔)
		"\xf9\x98" => 'd143', // もうやだ〜 (悲しい顔)
		"\xf9\x99" => 'd144', // ふらふら
		"\xf9\x9a" => 'd145', // グッド (上向き矢印)
		"\xf9\x9b" => 'd146', // るんるん (音符)
		"\xf9\x9c" => 'd147', // いい気分 (温泉)
		"\xf9\x9d" => 'd148', // かわいい
		"\xf9\x9e" => 'd149', // キスマーク
		"\xf9\x9f" => 'd150', // ぴかぴか (新しい)
		"\xf9\xa0" => 'd151', // ひらめき
		"\xf9\xa1" => 'd152', // むかっ (怒り)
		"\xf9\xa2" => 'd153', // パンチ
		"\xf9\xa3" => 'd154', // 爆弾
		"\xf9\xa4" => 'd155', // ムード
		"\xf9\xa5" => 'd156', // バッド (下向き矢印)
		"\xf9\xa6" => 'd157', // 眠い (睡眠)
		"\xf9\xa7" => 'd158', // exclamation
		"\xf9\xa8" => 'd159', // exclamation and question
		"\xf9\xa9" => 'd160', // double exclamation
		"\xf9\xaa" => 'd161', // どんっ (衝撃)
		"\xf9\xab" => 'd162', // あせあせ (飛び散る汗)
		"\xf9\xac" => 'd163', // たらーっ (汗)
		"\xf9\xad" => 'd164', // ダッシュ (走り出すさま)
		"\xf9\xae" => 'd165', // ー (長音記号1)
		"\xf9\xaf" => 'd166', // ー (長音記号2)
		"\xf9\x50" => 'd167', // カチンコ
		"\xf9\x51" => 'd168', // ふくろ
		"\xf9\x52" => 'd169', // ペン
		"\xf9\x55" => 'd170', // 人影
		"\xf9\x56" => 'd171', // いす
		"\xf9\x57" => 'd172', // 夜
		"\xf9\x5b" => 'd173', // soon
		"\xf9\x5c" => 'd174', // on
		"\xf9\x5d" => 'd175', // end
		"\xf9\x5e" => 'd176', // 時計
		"\xf9\xb1" => 'd201', // iアプリ
		"\xf9\xb2" => 'd202', // iアプリ (枠付き)
		"\xf9\xb3" => 'd203', // Tシャツ (ボーダー)
		"\xf9\xb4" => 'd204', // がま口財布
		"\xf9\xb5" => 'd205', // 化粧
		"\xf9\xb6" => 'd206', // ジーンズ
		"\xf9\xb7" => 'd207', // スノボ
		"\xf9\xb8" => 'd208', // チャペル
		"\xf9\xb9" => 'd209', // ドア
		"\xf9\xba" => 'd210', // ドル袋
		"\xf9\xbb" => 'd211', // パソコン
		"\xf9\xbc" => 'd212', // ラブレター
		"\xf9\xbd" => 'd213', // レンチ
		"\xf9\xbe" => 'd214', // 鉛筆
		"\xf9\xbf" => 'd215', // 王冠
		"\xf9\xc0" => 'd216', // 指輪
		"\xf9\xc1" => 'd217', // 砂時計
		"\xf9\xc2" => 'd218', // 自転車
		"\xf9\xc3" => 'd219', // 湯のみ
		"\xf9\xc4" => 'd220', // 腕時計
		"\xf9\xc5" => 'd221', // 考えてる顔
		"\xf9\xc6" => 'd222', // ほっとした顔
		"\xf9\xc7" => 'd223', // 冷や汗 (顔)
		"\xf9\xc8" => 'd224', // 冷や汗2 (顔)
		"\xf9\xc9" => 'd225', // ぷっくっくな顔
		"\xf9\xca" => 'd226', // ボケーっとした顔
		"\xf9\xcb" => 'd227', // 目がハート (顔)
		"\xf9\xcc" => 'd228', // 指でOK
		"\xf9\xcd" => 'd229', // あっかんべー
		"\xf9\xce" => 'd230', // ウィンク
		"\xf9\xcf" => 'd231', // うれしい顔
		"\xf9\xd0" => 'd232', // がまん顔
		"\xf9\xd1" => 'd233', // 猫2
		"\xf9\xd2" => 'd234', // 泣き顔
		"\xf9\xd3" => 'd235', // 涙
		"\xf9\xd4" => 'd236', // NG
		"\xf9\xd5" => 'd237', // クリップ
		"\xf9\xd6" => 'd238', // コピーライト (C)
		"\xf9\xd7" => 'd239', // トレードマーク (TM)
		"\xf9\xd8" => 'd240', // 走る人
		"\xf9\xd9" => 'd241', // マル秘
		"\xf9\xda" => 'd242', // リサイクル
		"\xf9\xdb" => 'd243', // レジスタードトレードマーク (R)
		"\xf9\xdc" => 'd244', // 危険・警告 (!)
		"\xf9\xdd" => 'd245', // 禁止
		"\xf9\xde" => 'd246', // 空室・空席・空車
		"\xf9\xdf" => 'd247', // 合格マーク
		"\xf9\xe0" => 'd248', // 満室・満席・満車
		"\xf9\xe1" => 'd249', // 矢印左右
		"\xf9\xe2" => 'd250', // 矢印上下
		"\xf9\xe3" => 'd251', // 学校
		"\xf9\xe4" => 'd252', // 波
		"\xf9\xe5" => 'd253', // 富士山
		"\xf9\xe6" => 'd254', // クローバー
		"\xf9\xe7" => 'd255', // さくらんぼ
		"\xf9\xe8" => 'd256', // チューリップ
		"\xf9\xe9" => 'd257', // バナナ
		"\xf9\xea" => 'd258', // りんご
		"\xf9\xeb" => 'd259', // 芽
		"\xf9\xec" => 'd260', // もみじ
		"\xf9\xed" => 'd261', // 桜
		"\xf9\xee" => 'd262', // おにぎり
		"\xf9\xef" => 'd263', // ショートケーキ
		"\xf9\xf0" => 'd264', // とっくり (おちょこ付き)
		"\xf9\xf1" => 'd265', // どんぶり
		"\xf9\xf2" => 'd266', // パン
		"\xf9\xf3" => 'd267', // かたつむり
		"\xf9\xf4" => 'd268', // ひよこ
		"\xf9\xf5" => 'd269', // ペンギン
		"\xf9\xf6" => 'd270', // 魚
		"\xf9\xf7" => 'd271', // うまい! (顔)
		"\xf9\xf8" => 'd272', // ウッシッシ (顔)
		"\xf9\xf9" => 'd273', // ウマ
		"\xf9\xfa" => 'd274', // ブタ
		"\xf9\xfb" => 'd275', // ワイングラス
		"\xf9\xfc" => 'd276', // げっそり (顔)
	);

/* ==================================================
 * @param	string   $buffer
 * @param	string   $charset
 * @return	string   $buffer
 */
public function pickup_pics($buffer, $charset) {
	if (strtolower($charset) == 'shift_jis' || strtolower($charset) == 'sjis' || strtolower($charset) == 'cp932') {
		$buffer = $this->pickup_docomo_sjis($buffer, $charset, self::$pics_sjis);
	}
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Entry_WILLCOM class
   ================================================== */

class Ktai_Entry_WILLCOM extends Ktai_Entry_imode_SJIS {
	// http://www.willcom-inc.com/ja/service/contents_service/club_air_edge/for_phone/homepage/pdf/contents_reference.pdf
	static public $pics_willcom = array(
		'<#HEART>'     => 'wf040', // ハート
		'<#CLOCK>'     => 'wf041', // 掛時計
		'<#TELEPHONE>' => 'wf042', // 電話
		'<#CUP>'       => 'wf043', // マグカップ
		'<#STAR>'      => 'wf044', // *
		'<#VSEL>'      => 'wf045', // 上下矢印
		'<#HSEL>'      => 'wf046', // 左右矢印
		'<#DENPA>'     => 'wf047', // (((
		'<#FINE>'      => 'wf048', // 晴れ
		'<#RAIN>'      => 'wf049', // 雨
		'<#CLOUD>'     => 'wf04a', // 曇り
		'<#TEAR>'      => 'wf04b', // 雫
		'<#SMILE>'     => 'wf04c', // 笑顔
		'<#KISS>'      => 'wf04d', // キスマーク
		'<#MELODY>'    => 'wf04e', // 十六分音符
		'<#CAR>'       => 'wf04f', // 車
		'<#TRAIN>'     => 'wf050', // 電車
		'<#PLANE>'     => 'wf051', // 飛行機
		'<#BIKE>'      => 'wf052', // バイク
		'<#HOME>'      => 'wf053', // 家
		'<#BUIL>'      => 'wf054', // ビル
		'<#PEACE>'     => 'wf055', // 手 (チョキ)
		'<#DINNER>'    => 'wf056', // ナイフとフォーク (レストラン)
		'<#GLASS>'     => 'wf057', // マティーニ (カクテル)
		'<#CRY>'       => 'wf058', // 涙顔
		'<#TULIP>'     => 'wf059', // チューリップ
		'<#BASEBALL>'  => 'wf05a', // バット
		'<#BALL>'      => 'wf05b', // 野球ボール
		'<#PUNCH>'     => 'wf05c', // 手 (グー)
		'<#THUNDER>'   => 'wf05d', // 雷
		'<#ANGRY>'     => 'wf05e', // 怒り顔
		'<#BEER>'      => 'wf05f', // ビール
		'<#NOTE>'      => 'wf060', // ノート
		'<#PEN>'       => 'wf061', // 鉛筆
		'<#DOKURO>'    => 'wf062', // ドクロ
		'<#MAIL>'      => 'wf063', // メール
		'<#NOSMOKING>' => 'wf064', // 禁煙
		'<#BELL>'      => 'wf065', // ベル
		'<#FLOWER>'    => 'wf066', // 花
		'<#SPA>'       => 'wf067', // 温泉
		'<#MOON>'      => 'wf068', // 二十六日月
		'<#FLAG>'      => 'wf069', // 旗
		'<#MASK>'      => 'wf06a', // マスク顔
		'<#RECORD>'    => 'wf06b', // 音楽
		'<#MEAT>'      => 'wf06c', // 肉
		'<#DOG>'       => 'wf06d', // 犬
		'<#CAT>'       => 'wf06e', // 猫
		'<#MONKEY>'    => 'wf06f', // 猿
		'<#ELEPHANT>'  => 'wf070', // 象
		'<#TAKO>'      => 'wf071', // 蛸
		'<#NOODLE>'    => 'wf072', // ラーメン
		'<#MIC>'       => 'wf073', // マイク (カラオケ)
		'<#PIKI>'      => 'wf074', // 怒りマーク
		'<#PIYOPIYO>'  => 'wf075', // ひよこ
		'<#SLEEP>'     => 'wf076', // 眠り顔
		'<#COFFEE>'    => 'wf077', // コーヒーカップ
		'<#TABACCO>'   => 'wf078', // 喫煙
		'<#AUAU>'      => 'wf079', // 飛び散る汗
		'<#ONIGIRI>'   => 'wf07a', // おにぎり
		'<#BAG>'       => 'wf07b', // バッグ
		'<#UNCHI>'     => 'wf07c', // ウンチ
		'<#TIE>'       => 'wf07d', // ネクタイ
		'<#SHIRT>'     => 'wf07e', // Tシャツ
		'<#SUIKA>'     => 'wf080', // 西瓜
		'<#ICE>'       => 'wf081', // かき氷
		'<#BIKINI>'    => 'wf082', // 水着
		'<#HASAMI>'    => 'wf083', // 鋏
		'<#CHUSHA>'    => 'wf084', // 注射器
		'<#MARINE>'    => 'wf085', // 錨
		'<#FROG>'      => 'wf086', // 蛙
		'<#BYEBYE>'    => 'wf087', // 手 (パー)
		'<#BHEART>'    => 'wf088', // 失恋
		'<#DIA>'       => 'wf089', // ダイヤモンド (トランプ)
		'<#CLUBS>'     => 'wf08a', // クラブ (トランプ)
		'<#SPADE>'     => 'wf08b', // スペード (トランプ)
		'<#CLIP>'      => 'wf08c', // クリップ
		'<#SNOWMAN>'   => 'wf08d', // 雪だるま
		'<#CAKE>'      => 'wf08e', // バースデーケーキ
		'<#APPLE>'     => 'wf08f', // 林檎
		'<#PRESENT>'   => 'wf090', // プレゼント
		'<#MONEY>'     => 'wf091', // ドル袋
		'<#EXIT>'      => 'wf092', // 非常口 (右向き)
		'<#DOOR>'      => 'wf093', // ドア
		'<#OYAJI>'     => 'wf094', // おやじ
		'<#PHS>'       => 'wf095', // 携帯電話
		'<#HOSHI>'     => 'wf096', // 星
		'<#TICKET>'    => 'wf097', // チケット
		'<#LOVELOVE>'  => 'wf098', // ハート2つ
		'<#HIRAMEKI>'  => 'wf099', // 電球
		'<#PETA>'      => 'wf09a', // 足跡
		'<#NIKONIKO>'  => 'wf09b', // 喜び顔
		'<#TENNIS>'    => 'wf09c', // テニス
		'<#MOVIE>'     => 'wf09d', // 映画カメラ
		'<#SKI>'       => 'wf09e', // スキー
		'<#!!>'        => 'wf09f', // !!
		'<#!?>'        => 'wf0a0', // !?
		'<#?>'         => 'wf0a1', // ?
		'<#DOWN>'      => 'wf0a2', // カーブ下矢印
		'<#UP>'        => 'wf0a3', // カーブ上矢印
		'<#GOOD>'      => 'wf0a4', // 親指 OK サイン
		'<#MORIMORI>'  => 'wf0a5', // 力こぶ
		'<#CHEART>'    => 'wf0a6', // 矢を射止めたハート
		'<#UZUMAKI>'   => 'wf0a7', // 花丸
		'<#TYPHOON>'   => 'wf0a8', // 台風
		'<#SEA>'       => 'wf0a9', // 海
		'<#SURF>'      => 'wf0aa', // サーフィン
		'<#YAMA>'      => 'wf0ab', // 山
		'<#FUJI>'      => 'wf0ac', // 富士山
		'<#CAMP>'      => 'wf0ad', // テント (キャンプ)
		'<#OCHIBA>'    => 'wf0ae', // 落葉
		'<#BUS>'       => 'wf0af', // バス
		'<#SOCCER>'    => 'wf0b0', // サッカー
		'<#BEGINNER>'  => 'wf0b1', // 初心者マーク
		'<#REW>'       => 'wf0b2', // 二重左矢印
		'<#FF>'        => 'wf0b3', // 二重右矢印
		'<#IMPORTANT>' => 'wf0b4', // 重要
		'<#18KIN>'     => 'wf0b5', // 18禁
		'<#CAUTION>'   => 'wf0b6', // !
		'<#RECICLE>'   => 'wf0b7', // リサイクルマーク
		'<#BARI3>'     => 'wf0b8', // アンテナ
		'<#DEMPA>'     => 'wf0b9', // )))
		'<#PEKE>'      => 'wf0ba', // ×
		'<#COPY>'      => 'wf0bb', // 著作権 (C)
		'<#REG>'       => 'wf0bc', // 登録商標 (R)
		'<#777>'       => 'wf0bd', // スロット (777)
		'<#0>'         => 'wf0be', // 0 (zero)
		'<#1>'         => 'wf0bf', // 1 (one)
		'<#2>'         => 'wf0c0', // 2 (two)
		'<#3>'         => 'wf0c1', // 3 (three)
		'<#4>'         => 'wf0c2', // 4 (four)
		'<#5>'         => 'wf0c3', // 5 (five)
		'<#6>'         => 'wf0c4', // 6 (six)
		'<#7>'         => 'wf0c5', // 7 (seven)
		'<#8>'         => 'wf0c6', // 8 (eight)
		'<#9>'         => 'wf0c7', // 9 (nine)
		'<#ARIES>'     => 'wf0c8', // 牡羊座
		'<#TAURUS>'    => 'wf0c9', // 牡牛座
		'<#GEMINI>'    => 'wf0ca', // 双子座
		'<#CANCER>'    => 'wf0cb', // 蟹座
		'<#LEO>'       => 'wf0cc', // 獅子座
		'<#VIRGO>'     => 'wf0cd', // 乙女座
		'<#LIBLA>'     => 'wf0ce', // 天秤座
		'<#SCORPIO>'   => 'wf0cf', // 蠍座
		'<#OPHIUCHUS>' => 'wf0d0', // 蛇遣座
		'<#SAGITTA>'   => 'wf0d1', // 射手座
		'<#CAPRICO>'   => 'wf0d2', // 山羊座
		'<#AQUARIUS>'  => 'wf0d3', // 水瓶座
		'<#PISCES>'    => 'wf0d4', // 魚座
		'<#JIZOU>'     => 'wf0d5', // 地蔵
		'<#MAKUDO>'    => 'wf0d6', // マクドナルド
		'<#MOS>'       => 'wf0d7', // モスバーガー
		'<#LOTTE>'     => 'wf0d9', // ロッテリア
		'<#DOUTOR>'    => 'wf0db', // ドトールコーヒー
		'<#PEACH>'     => 'wf0e0', // バーミヤン
		'<#!DONKEY>'   => 'wf0e3', // びっくりドンキー
		'<#LAWSON>'    => 'wf0e7', // ローソン
		'<#AM/PM>'     => 'wf0e9', // am/pm
		'<#SEIBU>'     => 'wf0f0', // 西武百貨店
		'<#85>'        => 'wf0fc', // ハチ公
		'<#MOYAI>'     => 'wf140', // モヤイ像
		'<#UFJ>'       => 'wf148', // UFJ Bank
		'<#EXIT2>'     => 'wf14d', // 非常口 (左向き)
		'<#TS-CRY>'    => 'wf150', // 泣き顔
	);

/* ==================================================
 * @param	string   $buffer
 * @param	string   $charset
 * @return	string   $buffer
 */
public function pickup_pics($buffer, $charset) {
	$buffer = preg_replace('|(<#[-_0-9A-Z/!]+>)|e', '"<img localsrc=\"" . self::$pics_willcom["$1"] . "\" />"', $buffer);
	$buffer = $this->pickup_docomo_sjis($buffer, $charset, parent::$pics_sjis);
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Entry_EMNet class
   ================================================== */

class Ktai_Entry_EMNet extends Ktai_Entry_imode_SJIS {
}

/* ==================================================
 *   Ktai_Entry_imode_ISO class
   ================================================== */

class Ktai_Entry_imode_ISO extends Ktai_Entry_Operator {
	private $pics;
	static public $pics_iso = array (
		"\x75\x41" => 'd001', // 晴れ
		"\x75\x46" => 'd002', // 曇り
		"\x75\x45" => 'd003', // 雨
		"\x75\x3e" => 'd004', // 雪 
		"\x75\x40" => 'd005', // 雷
		"\x75\x22" => 'd006', // 台風
		"\x78\x37" => 'd007', // 霧
		"\x7a\x3e" => 'd008', // 小雨
		"\x75\x48" => 'd009', // 牡羊座
		"\x75\x49" => 'd010', // 牡牛座
		"\x75\x4a" => 'd011', // 双子座
		"\x75\xab" => 'd012', // 蟹座
		"\x75\x4c" => 'd013', // 獅子座
		"\x75\x4d" => 'd014', // 乙女座
		"\x75\x4e" => 'd015', // 天秤座
		"\x75\x4f" => 'd016', // 蠍座
		"\x75\x50" => 'd017', // 射手座
		"\x75\x51" => 'd018', // 山羊座
		"\x75\x52" => 'd019', // 水瓶座
		"\x75\x53" => 'd020', // 魚座
		"\x7e\x21" => 'd021', // スポーツ
		"\x75\x73" => 'd022', // 野球
		"\x78\x38" => 'd023', // ゴルフ
		"\x75\x70" => 'd024', // テニス
		"\x75\x6f" => 'd025', // サッカー
		"\x79\x60" => 'd026', // スキー
		"\x78\x39" => 'd027', // バスケットボール
		"\x75\x72" => 'd028', // モータースポーツ (チェッカーフラッグ)
		"\x78\x3a" => 'd029', // ポケットベル
		"\x75\x6e" => 'd030', // 電車
		"\x78\x6e" => 'd031', // 地下鉄
		"\x75\x69" => 'd032', // 新幹線
		"\x75\x6a" => 'd033', // 車 (セダン)
		"\x7e\x22" => 'd034', // 車 (RV)
		"\x75\x68" => 'd035', // バス
		"\x79\x36" => 'd036', // 船
		"\x75\x6c" => 'd037', // 飛行機
		"\x75\x64" => 'd038', // 家
		"\x75\x66" => 'd039', // ビル
		"\x79\x32" => 'd040', // 郵便局
		"\x79\x33" => 'd041', // 病院
		"\x75\x63" => 'd042', // 銀行
		"\x75\x5c" => 'd043', // ATM
		"\x79\x35" => 'd044', // ホテル
		"\x75\x5d" => 'd045', // コンビニ
		"\x77\x6e" => 'd046', // ガソリンスタンド
		"\x75\x5f" => 'd047', // 駐車場
		"\x75\x23" => 'd048', // 信号
		"\x75\x5e" => 'd049', // トイレ
		"\x75\x65" => 'd050', // レストラン
		"\x78\x36" => 'd051', // 喫茶店 
		"\x75\x7b" => 'd052', // バー (マティーニ)
		"\x75\x7c" => 'd053', // ビール
		"\x76\x31" => 'd054', // ファーストフード (ハンバーガー)
		"\x76\x75" => 'd055', // ブティック
		"\x76\x71" => 'd056', // 美容院 (鋏)
		"\x76\x5e" => 'd057', // カラオケ
		"\x76\x72" => 'd058', // 映画
		"\x77\x52" => 'd059', // 右斜め上
		"\x7e\x23" => 'd060', // 遊園地 (木馬)
		"\x76\x63" => 'd061', // 音楽 (ヘッドホン)
		"\x78\x3b" => 'd062', // アート
		"\x7a\x4b" => 'd063', // 演劇
		"\x78\x3d" => 'd064', // イベント (サーカス)
		"\x75\x57" => 'd065', // チケット
		"\x75\x36" => 'd066', // 喫煙
		"\x75\x37" => 'd067', // 禁煙
		"\x76\x70" => 'd068', // カメラ
		"\x75\x55" => 'd069', // カバン
		"\x75\x58" => 'd070', // 本
		"\x78\x3e" => 'd071', // リボン
		"\x76\x2a" => 'd072', // プレゼント
		"\x78\x3f" => 'd073', // バースデー
		"\x78\x35" => 'd074', // 電話
		"\x78\x27" => 'd075', // 携帯電話
		"\x79\x46" => 'd076', // メモ
		"\x76\x5d" => 'd077', // TV
		"\x76\x21" => 'd078', // ゲーム
		"\x76\x67" => 'd079', // CD
		"\x79\x59" => 'd080', // ハート
		"\x78\x40" => 'd081', // スペード
		"\x78\x41" => 'd082', // ダイヤ
		"\x78\x42" => 'd083', // クラブ
		"\x78\x43" => 'd084', // 目
		"\x78\x44" => 'd085', // 耳
		"\x7b\x68" => 'd086', // 手 (グー)
		"\x78\x45" => 'd087', // 手 (チョキ)
		"\x78\x46" => 'd088', // 手 (パー)
		"\x77\x4a" => 'd089', // 右斜め下
		"\x77\x49" => 'd090', // 左斜め上
		"\x7a\x6d" => 'd091', // 足
		"\x7a\x6e" => 'd092', // くつ
		"\x76\x59" => 'd093', // 眼鏡
		"\x75\x38" => 'd094', // 車椅子
		"\x78\x47" => 'd095', // 新月
		"\x78\x48" => 'd096', // やや欠け月
		"\x78\x49" => 'd097', // 半月
		"\x75\x3f" => 'd098', // 三日月
		"\x7e\x24" => 'd099', // 満月
		"\x76\x3c" => 'd100', // 犬
		"\x76\x36" => 'd101', // 猫
		"\x75\x6d" => 'd102', // リゾート (ヨット)
		"\x76\x24" => 'd103', // クリスマス
		"\x77\x53" => 'd104', // 左斜め下
		"\x78\x61" => 'd105', // phone to
		"\x7b\x47" => 'd106', // mail to
		"\x76\x7b" => 'd107', // fax to
		"\x7e\x25" => 'd108', // iモード
		"\x7e\x26" => 'd109', // iモード (枠付き)
		"\x76\x7c" => 'd110', // メール
		"\x7e\x27" => 'd111', // ドコモ提供
		"\x7e\x28" => 'd112', // ドコモポイント
		"\x77\x7a" => 'd113', // 有料
		"\x77\x75" => 'd114', // 無料
		"\x79\x3c" => 'd115', // ID
		"\x76\x74" => 'd116', // パスワード
		"\x77\x5a" => 'd117', // 次項有
		"\x78\x4a" => 'd118', // クリア
		"\x76\x73" => 'd119', // サーチ (調べる)
		"\x78\x67" => 'd120', // NEW
		"\x7a\x6f" => 'd121', // 位置情報
		"\x7d\x5d" => 'd122', // フリーダイヤル
		"\x7b\x69" => 'd123', // シャープダイヤル
		"\x77\x29" => 'd124', // モバQ
		"\x76\x7d" => 'd125', // 1 (one)
		"\x76\x7e" => 'd126', // 2 (two)
		"\x77\x21" => 'd127', // 3 (three)
		"\x77\x22" => 'd128', // 4 (four)
		"\x77\x23" => 'd129', // 5 (five)
		"\x77\x24" => 'd130', // 6 (six)
		"\x77\x25" => 'd131', // 7 (seven)
		"\x77\x26" => 'd132', // 8 (eight)
		"\x77\x27" => 'd133', // 9 (nine)
		"\x78\x4b" => 'd134', // 0 (zero)
		"\x78\x4c" => 'd135', // 決定 (OK)
		"\x78\x34" => 'd136', // 黒ハート
		"\x7b\x5a" => 'd137', // 揺れるハート
		"\x75\x30" => 'd138', // 失恋
		"\x75\x31" => 'd139', // ハートたち (複数ハート)
		"\x75\x2a" => 'd140', // わーい (嬉しい顔)
		"\x75\x2b" => 'd141', // ちっ (怒った顔)
		"\x79\x74" => 'd142', // がく〜 (落胆した顔)
		"\x79\x77" => 'd143', // もうやだ〜 (悲しい顔)
		"\x78\x4d" => 'd144', // ふらふら
		"\x7a\x70" => 'd145', // グッド (上向き矢印)
		"\x78\x70" => 'd146', // るんるん (音符)
		"\x75\x75" => 'd147', // いい気分 (温泉)
		"\x7e\x29" => 'd148', // かわいい
		"\x76\x46" => 'd149', // キスマーク
		"\x79\x5f" => 'd150', // ぴかぴか (新しい)
		"\x75\x2f" => 'd151', // ひらめき
		"\x76\x40" => 'd152', // むかっ (怒り)
		"\x76\x4e" => 'd153', // パンチ
		"\x75\x33" => 'd154', // 爆弾
		"\x76\x60" => 'd155', // ムード
		"\x7a\x71" => 'd156', // バッド (下向き矢印)
		"\x75\x2e" => 'd157', // 眠い (睡眠)
		"\x75\x3b" => 'd158', // exclamation
		"\x7a\x72" => 'd159', // exclamation and question
		"\x7a\x73" => 'd160', // double exclamation
		"\x78\x4f" => 'd161', // どんっ (衝撃)
		"\x78\x50" => 'd162', // あせあせ (飛び散る汗)
		"\x76\x41" => 'd163', // たらーっ (汗)
		"\x76\x4f" => 'd164', // ダッシュ (走り出すさま)
		"\x7e\x2a" => 'd165', // ー (長音記号1)
		"\x7a\x74" => 'd166', // ー (長音記号2)
		"\x75\x77" => 'd167', // カチンコ
		"\x7e\x2b" => 'd168', // ふくろ
		"\x78\x5c" => 'd169', // ペン
		"\x7e\x2c" => 'd170', // 人影
		"\x7d\x57" => 'd171', // いす
		"\x7a\x47" => 'd172', // 夜
		"\x7e\x2d" => 'd173', // soon
		"\x7e\x2e" => 'd174', // on
		"\x7e\x2f" => 'd175', // end
		"\x78\x33" => 'd176', // 時計
		"\x7e\x30" => 'd201', // iアプリ
		"\x7e\x31" => 'd202', // iアプリ (枠付き)
		"\x78\x68" => 'd203', // Tシャツ (ボーダー)
		"\x76\x5f" => 'd204', // がま口財布
		"\x76\x64" => 'd205', // 化粧
		"\x7b\x5c" => 'd206', // ジーンズ
		"\x75\x71" => 'd207', // スノボ
		"\x76\x6d" => 'd208', // チャペル
		"\x7e\x32" => 'd209', // ドア
		"\x76\x22" => 'd210', // ドル袋
		"\x78\x6a" => 'd211', // パソコン
		"\x7b\x5d" => 'd212', // ラブレター
		"\x78\x26" => 'd213', // レンチ
		"\x75\x5a" => 'd214', // 鉛筆
		"\x78\x7b" => 'd215', // 王冠
		"\x76\x6f" => 'd216', // 指輪
		"\x75\x35" => 'd217', // 砂時計
		"\x75\x67" => 'd218', // 自転車
		"\x79\x62" => 'd219', // 湯のみ
		"\x77\x77" => 'd220', // 腕時計
		"\x7e\x33" => 'd221', // 考えてる顔
		"\x79\x79" => 'd222', // ほっとした顔
		"\x7e\x34" => 'd223', // 冷や汗 (顔)
		"\x78\x78" => 'd224', // 冷や汗2 (顔)
		"\x7b\x42" => 'd225', // ぷっくっくな顔
		"\x79\x7d" => 'd226', // ボケーっとした顔
		"\x78\x76" => 'd227', // 目がハート (顔)
		"\x76\x54" => 'd228', // 指でOK
		"\x76\x42" => 'd229', // あっかんべー
		"\x78\x75" => 'd230', // ウィンク
		"\x7e\x35" => 'd231', // うれしい顔
		"\x79\x76" => 'd232', // がまん顔
		"\x79\x73" => 'd233', // 猫2
		"\x75\x2c" => 'd234', // 泣き顔
		"\x7b\x4e" => 'd235', // 涙
		"\x7e\x36" => 'd236', // NG
		"\x75\x59" => 'd237', // クリップ
		"\x77\x55" => 'd238', // コピーライト (C)
		"\x77\x4b" => 'd239', // トレードマーク (TM)
		"\x75\x24" => 'd240', // 走る人
		"\x76\x4c" => 'd241', // マル秘
		"\x7b\x5e" => 'd242', // リサイクル
		"\x77\x56" => 'd243', // レジスタードトレードマーク (R)
		"\x75\x3a" => 'd244', // 危険・警告 (!)
		"\x7e\x37" => 'd245', // 禁止
		"\x79\x3e" => 'd246', // 空室・空席・空車
		"\x7e\x38" => 'd247', // 合格マーク
		"\x79\x3d" => 'd248', // 満室・満席・満車
		"\x7b\x5f" => 'd249', // 矢印左右
		"\x7b\x60" => 'd250', // 矢印上下
		"\x79\x34" => 'd251', // 学校
		"\x7b\x61" => 'd252', // 波
		"\x78\x6f" => 'd253', // 富士山
		"\x76\x6e" => 'd254', // クローバー
		"\x76\x2d" => 'd255', // さくらんぼ
		"\x76\x3f" => 'd256', // チューリップ
		"\x7a\x78" => 'd257', // バナナ
		"\x79\x6d" => 'd258', // りんご
		"\x7b\x62" => 'd259', // 芽
		"\x76\x29" => 'd260', // もみじ
		"\x76\x25" => 'd261', // 桜
		"\x76\x30" => 'd262', // おにぎり
		"\x76\x2b" => 'd263', // ショートケーキ
		"\x79\x4b" => 'd264', // とっくり (おちょこ付き)
		"\x78\x53" => 'd265', // どんぶり
		"\x79\x63" => 'd266', // パン
		"\x7b\x63" => 'd267', // かたつむり
		"\x76\x3b" => 'd268', // ひよこ
		"\x76\x37" => 'd269', // ペンギン
		"\x7a\x60" => 'd270', // 魚
		"\x7a\x23" => 'd271', // うまい! (顔)
		"\x7b\x65" => 'd272', // ウッシッシ (顔)
		"\x76\x33" => 'd273', // ウマ
		"\x76\x39" => 'd274', // ブタ
		"\x75\x7a" => 'd275', // ワイングラス
		"\x78\x77" => 'd276', // げっそり (顔)
	);

/* ==================================================
 * @param	string   $buffer
 * @param	string   $charset
 * @return	string   $buffer
 */
public function pickup_pics($buffer, $charset) {
	return $this->pickup_iso_pics($buffer, $charset, self::$pics_iso);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Entry_SoftBank_ISO class
   ================================================== */

class Ktai_Entry_SoftBank_ISO extends Ktai_Entry_Operator {
	private $pics;
	static public $pics_iso = array (
		"\x7d\x37" => 'se001', // 男の子
		"\x7d\x32" => 'se002', // 女の子
		"\x76\x46" => 'se003', // 美容 (キスマーク)
		"\x76\x57" => 'se004', // お父さん
		"\x76\x55" => 'se005', // お母さん
		"\x78\x68" => 'se006', // 洋服
		"\x78\x69" => 'se007', // ブーツ
		"\x76\x70" => 'se008', // カメラ
		"\x78\x35" => 'se009', // 電話
		"\x78\x27" => 'se00a', // 携帯電話
		"\x76\x7b" => 'se00b', // FAX
		"\x78\x6a" => 'se00c', // パソコン
		"\x76\x4e" => 'se00d', // パンチ
		"\x76\x54" => 'se00e', // GOOD!
		"\x76\x51" => 'se00f', // No.1!
		"\x7b\x68" => 'se010', // グー
		"\x78\x45" => 'se011', // チョキ
		"\x78\x46" => 'se012', // パー
		"\x79\x60" => 'se013', // スキー
		"\x78\x38" => 'se014', // ゴルフ
		"\x75\x70" => 'se015', // テニス
		"\x75\x73" => 'se016', // 野球
		"\x7b\x26" => 'se017', // サーフィン
		"\x75\x6f" => 'se018', // サッカー
		"\x75\x53" => 'se019', // 魚
		"\x76\x33" => 'se01a', // うま
		"\x75\x6a" => 'se01b', // 車
		"\x75\x6d" => 'se01c', // ヨット
		"\x75\x6c" => 'se01d', // 飛行機
		"\x75\x6e" => 'se01e', // 電車
		"\x7d\x43" => 'se01f', // 新幹線
		"\x75\x3c" => 'se020', // ハテナ
		"\x75\x3b" => 'se021', // ビックリ
		"\x78\x34" => 'se022', // ハートマーク
		"\x75\x30" => 'se023', // ハートブレイク
		"\x7d\x26" => 'se024', // 1時
		"\x7d\x27" => 'se025', // 2時
		"\x7d\x28" => 'se026', // 時計
		"\x7d\x29" => 'se027', // 4時
		"\x7d\x2a" => 'se028', // 5時
		"\x7d\x2b" => 'se029', // 6時
		"\x7d\x2c" => 'se02a', // 7時
		"\x7d\x2d" => 'se02b', // 8時
		"\x7d\x2e" => 'se02c', // 9時
		"\x7d\x2f" => 'se02d', // 10時
		"\x7d\x30" => 'se02e', // 11時
		"\x7d\x31" => 'se02f', // 12時
		"\x76\x25" => 'se030', // お花見
		"\x7d\x4c" => 'se031', // エンブレム
		"\x78\x6c" => 'se032', // バラ
		"\x76\x24" => 'se033', // クリスマス
		"\x76\x6f" => 'se034', // 指輪
		"\x7d\x35" => 'se035', // 宝石
		"\x75\x64" => 'se036', // 家
		"\x78\x6d" => 'se037', // 教会
		"\x75\x66" => 'se038', // ビル
		"\x7b\x52" => 'se039', // 駅
		"\x77\x6e" => 'se03a', // ガソリンスタンド
		"\x78\x6f" => 'se03b', // 山
		"\x76\x5e" => 'se03c', // マイク
		"\x76\x72" => 'se03d', // 映画
		"\x78\x70" => 'se03e', // 音楽 (音符)
		"\x76\x74" => 'se03f', // カギ
		"\x7d\x55" => 'se040', // サックス
		"\x76\x61" => 'se041', // ギター
		"\x7a\x32" => 'se042', // トランペット
		"\x75\x65" => 'se043', // レストラン
		"\x75\x7b" => 'se044', // カクテル
		"\x78\x36" => 'se045', // コーヒー
		"\x76\x2b" => 'se046', // ケーキ
		"\x75\x7c" => 'se047', // ビール
		"\x75\x3e" => 'se048', // 雪
		"\x75\x46" => 'se049', // 曇り
		"\x75\x41" => 'se04a', // 晴れ (昼)
		"\x75\x45" => 'se04b', // 雨
		"\x75\x3f" => 'se04c', // 晴れ (夜)
		"\x7d\x53" => 'se04d', // 朝
		"\x78\x71" => 'se04e', // 天使
		"\x76\x36" => 'se04f', // ねこ
		"\x78\x72" => 'se050', // とら
		"\x78\x73" => 'se051', // くま
		"\x76\x3c" => 'se052', // いぬ
		"\x78\x74" => 'se053', // ねずみ
		"\x75\x29" => 'se054', // クジラ
		"\x76\x37" => 'se055', // ペンギン
		"\x7a\x23" => 'se056', // 楽 (顔)
		"\x75\x2a" => 'se057', // 喜 (顔)
		"\x79\x77" => 'se058', // 哀 (顔)
		"\x75\x2b" => 'se059', // 怒 (顔)
		"\x76\x50" => 'se05a', // ウンチ
		"\x7d\x3c" => 'se101', // メール受信
		"\x76\x76" => 'se102', // メール送信
		"\x7b\x47" => 'se103', // メール宛先
		"\x78\x61" => 'se104', // 電話連絡先
		"\x76\x42" => 'se105', // アカンベー (顔)
		"\x78\x76" => 'se106', // ラブラブ (顔)
		"\x78\x77" => 'se107', // ガビーン (顔)
		"\x78\x78" => 'se108', // タラー (顔)
		"\x76\x34" => 'se109', // さる
		"\x78\x79" => 'se10a', // タコ
		"\x76\x39" => 'se10b', // ぶた
		"\x7d\x48" => 'se10c', // 宇宙人
		"\x78\x7a" => 'se10d', // ロケット
		"\x78\x7b" => 'se10e', // 王冠
		"\x75\x2f" => 'se10f', // 電球
		"\x76\x6e" => 'se110', // よつば
		"\x78\x7c" => 'se111', // キス
		"\x76\x2a" => 'se112', // バースデー (プレゼント)
		"\x76\x65" => 'se113', // ピストル
		"\x76\x73" => 'se114', // 虫眼鏡
		"\x75\x24" => 'se115', // 陸上
		"\x78\x7d" => 'se116', // オークション
		"\x78\x7e" => 'se117', // 花火
		"\x76\x29" => 'se118', // もみじ
		"\x79\x21" => 'se119', // 落ち葉
		"\x76\x4a" => 'se11a', // 悪魔
		"\x76\x26" => 'se11b', // おばけ
		"\x76\x53" => 'se11c', // ドクロ
		"\x75\x34" => 'se11d', // ファイヤー
		"\x79\x22" => 'se11e', // かばん
		"\x7d\x56" => 'se11f', // 座席
		"\x76\x31" => 'se120', // ハンバーガー
		"\x79\x23" => 'se121', // 公園
		"\x79\x24" => 'se122', // キャンプ場
		"\x75\x75" => 'se123', // 温泉
		"\x75\x26" => 'se124', // 遊園地
		"\x75\x57" => 'se125', // チケット
		"\x76\x67" => 'se126', // CD
		"\x7d\x49" => 'se127', // DVD
		"\x78\x6b" => 'se128', // ラジオ
		"\x77\x7d" => 'se129', // ビデオ
		"\x76\x5d" => 'se12a', // テレビ
		"\x76\x47" => 'se12b', // ゲーム
		"\x7d\x57" => 'se12c', // 歌い出し
		"\x79\x25" => 'se12d', // マージャン
		"\x79\x26" => 'se12e', // 対決
		"\x76\x22" => 'se12f', // 賞金 (ドル袋)
		"\x75\x7e" => 'se130', // 当たり
		"\x79\x27" => 'se131', // トロフィー
		"\x75\x72" => 'se132', // ゴール (チェッカーフラッグ)
		"\x75\x27" => 'se133', // スロット (777)
		"\x7d\x44" => 'se134', // 競馬
		"\x7d\x3f" => 'se135', // 競艇
		"\x75\x67" => 'se136', // 競輪
		"\x79\x2b" => 'se137', // 工事中
		"\x7d\x58" => 'se138', // 男性
		"\x7d\x59" => 'se139', // 女性
		"\x7d\x54" => 'se13a', // 乳幼児
		"\x76\x6b" => 'se13b', // 注射器
		"\x75\x2e" => 'se13c', // 睡眠 (Zzz)
		"\x75\x40" => 'se13d', // 雷
		"\x76\x75" => 'se13e', // ハイヒール
		"\x79\x2c" => 'se13f', // 入浴
		"\x7d\x42" => 'se140', // トイレ
		"\x7d\x23" => 'se141', // 音声
		"\x7d\x24" => 'se142', // お知らせ (メガホン)
		"\x79\x2d" => 'se143', // 祝日
		"\x76\x77" => 'se144', // ロックON
		"\x7d\x3e" => 'se145', // ロックOFF
		"\x79\x2e" => 'se146', // 街
		"\x76\x2c" => 'se147', // 料理 (卵)
		"\x75\x58" => 'se148', // 本
		"\x7d\x5a" => 'se149', // 為替相場
		"\x79\x30" => 'se14a', // 株価
		"\x75\x61" => 'se14b', // ニュース (パラボラアンテナ)
		"\x76\x44" => 'se14c', // 元気 (力こぶ)
		"\x75\x63" => 'se14d', // 銀行
		"\x75\x23" => 'se14e', // 信号
		"\x75\x5f" => 'se14f', // 駐車場
		"\x75\x60" => 'se150', // バス停
		"\x75\x5e" => 'se151', // 公衆トイレ
		"\x79\x31" => 'se152', // 交番
		"\x79\x32" => 'se153', // 郵便局
		"\x75\x5c" => 'se154', // ATM
		"\x79\x33" => 'se155', // 病院
		"\x75\x5d" => 'se156', // コンビニ
		"\x79\x34" => 'se157', // 学校
		"\x79\x35" => 'se158', // ホテル
		"\x75\x68" => 'se159', // バス
		"\x7d\x3a" => 'se15a', // タクシー
		"\x7b\x57" => 'se201', // 徒歩
		"\x79\x36" => 'se202', // 船
		"\x7d\x5b" => 'se203', // 目的地 (ココ)
		"\x7d\x33" => 'se204', // 飾罫1
		"\x75\x32" => 'se205', // 飾罫2
		"\x77\x3b" => 'se206', // 飾罫3
		"\x79\x37" => 'se207', // 18禁
		"\x75\x37" => 'se208', // 禁煙
		"\x75\x39" => 'se209', // 初心者
		"\x75\x38" => 'se20a', // バリアフリー (車椅子マーク)
		"\x79\x38" => 'se20b', // アンテナマーク
		"\x79\x59" => 'se20c', // ハート (トランプ)
		"\x78\x41" => 'se20d', // ダイヤ (トランプ)
		"\x78\x40" => 'se20e', // スペード (トランプ)
		"\x78\x42" => 'se20f', // クラブ (トランプ)
		"\x7b\x69" => 'se210', // シャープダイヤル
		"\x7d\x5c" => 'se211', // フリーダイヤル
		"\x78\x67" => 'se212', // 新着
		"\x76\x6a" => 'se213', // 更新
		"\x79\x39" => 'se214', // おすすめ (COOL)
		"\x7d\x5d" => 'se215', // 有料
		"\x7d\x5e" => 'se216', // 無料
		"\x7d\x5f" => 'se217', // 月額
		"\x7d\x60" => 'se218', // 申し込み
		"\x77\x47" => 'se219', // 見出しボタン1 (オレンジ)
		"\x77\x48" => 'se21a', // 見出しボタン2 (緑)
		"\x7d\x25" => 'se21b', // 見出しボタン4 (紫)
		"\x76\x7d" => 'se21c', // 1 (one)
		"\x76\x7e" => 'se21d', // 2 (two)
		"\x77\x21" => 'se21e', // 3 (three)
		"\x77\x22" => 'se21f', // 4 (four)
		"\x77\x23" => 'se220', // 5 (five)
		"\x77\x24" => 'se221', // 6 (six)
		"\x77\x25" => 'se222', // 7 (seven)
		"\x77\x26" => 'se223', // 8 (eight)
		"\x77\x27" => 'se224', // 9 (nine)
		"\x78\x4b" => 'se225', // 0 (zero)
		"\x76\x52" => 'se226', // お得
		"\x79\x3a" => 'se227', // 割引
		"\x79\x3b" => 'se228', // サービス料
		"\x79\x3c" => 'se229', // ID
		"\x79\x3d" => 'se22a', // 満席
		"\x79\x3e" => 'se22b', // 空席
		"\x79\x3f" => 'se22c', // 指定席
		"\x79\x40" => 'se22d', // 営業時間
		"\x79\x41" => 'se22e', // 上へ (指)
		"\x79\x42" => 'se22f', // 下へ (指)
		"\x76\x5a" => 'se230', // 左へ (指)
		"\x76\x5b" => 'se231', // 右へ (指)
		"\x77\x3c" => 'se232', // 上
		"\x77\x3d" => 'se233', // 下
		"\x77\x4f" => 'se234', // 右
		"\x77\x50" => 'se235', // 左
		"\x77\x52" => 'se236', // 右上
		"\x77\x49" => 'se237', // 左上
		"\x77\x4a" => 'se238', // 右下
		"\x77\x53" => 'se239', // 左下
		"\x77\x2b" => 'se23a', // 次へ
		"\x77\x2a" => 'se23b', // 前へ
		"\x77\x2d" => 'se23c', // 早送り 
		"\x77\x2c" => 'se23d', // 巻き戻し
		"\x79\x43" => 'se23e', // 星座
		"\x7d\x40" => 'se23f', // おひつじ座
		"\x75\x49" => 'se240', // おうし座
		"\x75\x4a" => 'se241', // ふたご座
		"\x75\x4b" => 'se242', // かに座
		"\x75\x4c" => 'se243', // しし座
		"\x75\x4d" => 'se244', // おとめ座
		"\x75\x4e" => 'se245', // てんぴん座
		"\x75\x4f" => 'se246', // さそり座
		"\x75\x50" => 'se247', // いて座
		"\x75\x51" => 'se248', // やぎ座
		"\x75\x52" => 'se249', // みずがめ座
		"\x7d\x41" => 'se24a', // うお座
		"\x75\x54" => 'se24b', // へびつかい座
		"\x7d\x61" => 'se24c', // TOPページ
		"\x78\x4c" => 'se24d', // OKボタン
		"\x77\x55" => 'se24e', // 著作権 (C)
		"\x77\x56" => 'se24f', // 登録商標 (R)
		"\x79\x44" => 'se250', // マナーモード
		"\x79\x45" => 'se251', // 電源切
		"\x75\x3a" => 'se252', // ご注意 (!)
		"\x7d\x62" => 'se253', // ご案内
/*
		"\x7d\x6a" => 'se254', // J-PHONEショップ
		"\x7d\x6b" => 'se255', // スカイウェブ
		"\x7d\x6c" => 'se256', // スカイウォーカー
		"\x7d\x6d" => 'se257', // スカイメロディ
		"\x7d\x6e" => 'se258', // J-PHONE 1
		"\x7d\x6f" => 'se259', // J-PHONE 2
		"\x7d\x70" => 'se25a', // J-PHONE 3
*/
		"\x79\x46" => 'se301', // メモ
		"\x79\x47" => 'se302', // ネクタイ
		"\x79\x48" => 'se303', // ハイビスカス
		"\x76\x3f" => 'se304', // チューリップ
		"\x76\x3e" => 'se305', // ひまわり
		"\x79\x49" => 'se306', // 花束
		"\x76\x3d" => 'se307', // やしの木
		"\x79\x4a" => 'se308', // サボテン
		"\x7d\x63" => 'se309', // トイレ
		"\x76\x63" => 'se30a', // ヘッドホン
		"\x79\x4b" => 'se30b', // 晩酌 (とっくり)
		"\x79\x4c" => 'se30c', // 乾杯 (ビール)
		"\x79\x4d" => 'se30d', // 祝
		"\x75\x36" => 'se30e', // 喫煙
		"\x79\x4e" => 'se30f', // カプセル薬
		"\x79\x4f" => 'se310', // 風船
		"\x75\x33" => 'se311', // 爆弾
		"\x79\x50" => 'se312', // クラッカー
		"\x76\x71" => 'se313', // ハサミ
		"\x78\x3e" => 'se314', // リボン
		"\x76\x4c" => 'se315', // マル秘
		"\x78\x21" => 'se316', // MD
		"\x76\x6c" => 'se317', // メガフォン
		"\x79\x52" => 'se318', // 帽子
		"\x7b\x50" => 'se319', // 可愛いワンピース
		"\x7d\x39" => 'se31a', // ミュール
		"\x79\x53" => 'se31b', // ロングブーツ
		"\x76\x64" => 'se31c', // 口紅
		"\x79\x54" => 'se31d', // マニキュア
		"\x76\x66" => 'se31e', // エステ
		"\x79\x55" => 'se31f', // 美容院
		"\x79\x56" => 'se320', // 理髪店
		"\x79\x57" => 'se321', // 着物
		"\x79\x58" => 'se322', // ビキニ
		"\x75\x55" => 'se323', // ブランドバッグ
		"\x75\x77" => 'se324', // カチンコ
		"\x76\x6d" => 'se325', // すず
		"\x76\x60" => 'se326', // 踊る音符
		"\x79\x5a" => 'se327', // ぴかぴかハート
		"\x7b\x5a" => 'se328', // ドキドキハート
		"\x76\x45" => 'se329', // ハートを射とめて
		"\x79\x5b" => 'se32a', // ハート (青)
		"\x79\x5c" => 'se32b', // ハート (緑)
		"\x79\x5d" => 'se32c', // ハート (黄)
		"\x79\x5e" => 'se32d', // ハート (紫)
		"\x79\x5f" => 'se32e', // NEW (ぴかぴか)
		"\x75\x44" => 'se32f', // ☆
		"\x76\x4f" => 'se330', // ダッシュ
		"\x78\x50" => 'se331', // 飛び散る汗
		"\x79\x61" => 'se332', // ○
		"\x77\x4d" => 'se333', // ×
		"\x76\x40" => 'se334', // 怒り
		"\x7d\x34" => 'se335', // ☆ (点滅)
		"\x7d\x22" => 'se336', // 動く "?"
		"\x7d\x21" => 'se337', // 動く "!"
		"\x79\x62" => 'se338', // お茶
		"\x79\x63" => 'se339', // パン
		"\x79\x64" => 'se33a', // ソフトクリーム
		"\x79\x65" => 'se33b', // フライドポテト
		"\x79\x66" => 'se33c', // 串団子 
		"\x79\x67" => 'se33d', // せんべい
		"\x79\x68" => 'se33e', // ご飯
		"\x79\x69" => 'se33f', // スパゲティ
		"\x78\x53" => 'se340', // ラーメン
		"\x79\x6a" => 'se341', // カレーライス
		"\x76\x30" => 'se342', // おにぎり
		"\x79\x6b" => 'se343', // おでん
		"\x79\x6c" => 'se344', // 寿司
		"\x79\x6d" => 'se345', // りんご
		"\x79\x6e" => 'se346', // みかん
		"\x76\x2f" => 'se347', // いちご
		"\x76\x28" => 'se348', // すいか
		"\x79\x6f" => 'se349', // トマト
		"\x79\x70" => 'se34a', // なす
		"\x78\x3f" => 'se34b', // バースデーケーキ
		"\x79\x71" => 'se34c', // 駅弁
		"\x79\x72" => 'se34d', // ナベ
		"\x7d\x4b" => 'se401', // あせり (顔)
		"\x79\x73" => 'se402', // ほそくんでいる (顔)
		"\x79\x74" => 'se403', // ひたすらごめんなさい (顔)
		"\x79\x75" => 'se404', // えっへん (顔)
		"\x78\x75" => 'se405', // ウィンク (顔)
		"\x79\x76" => 'se406', // わさびがきいた (顔)
		"\x7d\x4f" => 'se407', // 目がぐるぐる (顔)
		"\x79\x78" => 'se408', // 鼻ちょうちん (顔)
		"\x7d\x47" => 'se409', // あっかんべー (顔)
		"\x79\x79" => 'se40a', // 酔っ払い (顔)
		"\x79\x7a" => 'se40b', // ゲロゲロ (顔)
		"\x79\x7b" => 'se40c', // マスクをつけた顔
		"\x79\x7c" => 'se40d', // 顔があかくなる
		"\x79\x7d" => 'se40e', // しらけ顔
		"\x7d\x50" => 'se40f', // 冷や汗 (顔)
		"\x79\x7e" => 'se410', // びっくり (顔)
		"\x75\x2c" => 'se411', // 泣き (顔)
		"\x7b\x49" => 'se412', // 泣いたり笑ったり (顔)
		"\x7b\x4e" => 'se413', // 可愛く泣いてる人
		"\x7d\x51" => 'se414', // にこにこ (顔)
		"\x7d\x46" => 'se415', // あははと笑う (顔)
		"\x7b\x42" => 'se416', // めちゃめちゃ怒っている (顔)
		"\x7a\x24" => 'se417', // KISS:動く口
		"\x7a\x25" => 'se418', // 投げKISS
		"\x78\x43" => 'se419', // 目
		"\x7a\x26" => 'se41a', // 鼻
		"\x78\x44" => 'se41b', // 耳
		"\x7a\x27" => 'se41c', // 口
		"\x7a\x28" => 'se41d', // ごめんなさい (合わせた手)
		"\x7a\x2c" => 'se41e', // バイバイ (手を振る)
		"\x7a\x29" => 'se41f', // 拍手
		"\x7a\x2a" => 'se420', // OK (指で丸サイン)
		"\x7a\x2b" => 'se421', // Booing (親指を下)
		"\x7d\x52" => 'se422', // おっは〜
		"\x7a\x2d" => 'se423', // × (両腕をクロス)
		"\x7a\x2e" => 'se424', // ○ (両腕を頭に)
		"\x7a\x30" => 'se425', // 手をつないでいる
		"\x7a\x2f" => 'se426', // 土下座
		"\x7b\x6b" => 'se427', // バンザイ
		"\x7d\x64" => 'se428', // 人と人が歩いている
		"\x7a\x31" => 'se429', // ラインダンス (バニーガール)
		"\x78\x39" => 'se42a', // バスケットボール
		"\x75\x74" => 'se42b', // フットボール
		"\x7a\x33" => 'se42c', // ビリヤード
		"\x7a\x34" => 'se42d', // 水泳
		"\x7d\x3b" => 'se42e', // RV車
		"\x75\x6b" => 'se42f', // トラック
		"\x7a\x35" => 'se430', // 消防車
		"\x7a\x36" => 'se431', // 救急車
		"\x7a\x37" => 'se432', // パトカー
		"\x7a\x38" => 'se433', // ジェットコースター
		"\x78\x6e" => 'se434', // 地下鉄
		"\x75\x69" => 'se435', // 新幹線(700系)
		"\x7a\x39" => 'se436', // 門松
		"\x7b\x39" => 'se437', // チョコ
		"\x7a\x3a" => 'se438', // お雛様
		"\x7a\x3b" => 'se439', // 卒業式
		"\x7a\x3c" => 'se43a', // ランドセル
		"\x7a\x3d" => 'se43b', // 鯉のぼり
		"\x7a\x3e" => 'se43c', // とじかさ
		"\x7d\x4a" => 'se43d', // 結婚式
		"\x7b\x61" => 'se43e', // 波がザーン
		"\x7a\x40" => 'se43f', // かき氷
		"\x7a\x41" => 'se440', // 線香花火
		"\x7a\x42" => 'se441', // 貝
		"\x7a\x43" => 'se442', // 風鈴
		"\x75\x22" => 'se443', // 台風
		"\x7d\x65" => 'se444', // 稲穂
		"\x7a\x44" => 'se445', // ハロウィン
		"\x7a\x45" => 'se446', // お月見
		"\x7d\x4d" => 'se447', // 風がビュー
		"\x7a\x46" => 'se448', // サンタクロース
		"\x7a\x4a" => 'se449', // 朝日
		"\x7d\x4e" => 'se44a', // 夕日
		"\x7a\x47" => 'se44b', // 流れ星
		"\x7a\x48" => 'se44c', // 虹
		"\x7a\x49" => 'se501', // ラブホテル
		"\x78\x3b" => 'se502', // アート
		"\x7a\x4b" => 'se503', // 演劇
		"\x7a\x4c" => 'se504', // デパート
		"\x7a\x4d" => 'se505', // お城 (和)
		"\x7a\x4e" => 'se506', // お城 (洋)
		"\x7d\x38" => 'se507', // 映画館
		"\x7a\x4f" => 'se508', // 工場
		"\x75\x79" => 'se509', // 東京タワー
		"\x7d\x66" => 'se50a', // 109
		"\x76\x27" => 'se50b', // 日本 (国旗)
		"\x77\x70" => 'se50c', // アメリカ (国旗)
		"\x7a\x50" => 'se50d', // フランス (国旗)
		"\x7a\x51" => 'se50e', // ドイツ (国旗)
		"\x7a\x52" => 'se50f', // イタリア (国旗)
		"\x7a\x53" => 'se510', // イギリス (国旗)
		"\x79\x29" => 'se511', // スペイン (国旗)
		"\x79\x2a" => 'se512', // ロシア (国旗)
		"\x7a\x54" => 'se513', // 中国 (国旗)
		"\x7a\x55" => 'se514', // 韓国 (国旗)
		"\x7a\x56" => 'se515', // 白人
		"\x7a\x57" => 'se516', // 中国人
		"\x7a\x58" => 'se517', // インド人
		"\x7a\x59" => 'se518', // おじいちゃん
		"\x7a\x5a" => 'se519', // おばあちゃん
		"\x7a\x5b" => 'se51a', // あかちゃん
		"\x7a\x5c" => 'se51b', // 安全第一
		"\x7a\x5d" => 'se51c', // お姫さま
		"\x7d\x67" => 'se51d', // 自由の女神
		"\x7d\x68" => 'se51e', // 衛兵
		"\x7a\x5f" => 'se51f', // フラメンコ
		"\x7a\x5e" => 'se520', // イルカ
		"\x7d\x36" => 'se521', // とり
		"\x7a\x60" => 'se522', // 熱帯魚
		"\x76\x3b" => 'se523', // ひよこ
		"\x7d\x69" => 'se524', // ハムスター
		"\x7a\x61" => 'se525', // けむし
		"\x7a\x62" => 'se526', // ぞう
		"\x7a\x63" => 'se527', // コアラ
		"\x7d\x45" => 'se528', // チンパンジー
		"\x75\x48" => 'se529', // ひつじ
		"\x7d\x3d" => 'se52a', // おおかみ
		"\x7a\x64" => 'se52b', // うし
		"\x76\x32" => 'se52c', // うさぎ
		"\x7a\x65" => 'se52d', // へび
		"\x7a\x66" => 'se52e', // にわとり
		"\x7a\x67" => 'se52f', // いのしし
		"\x7a\x68" => 'se530', // らくだ
		"\x76\x35" => 'se531', // かえる
		"\x7a\x69" => 'se532', // A型
		"\x7a\x6a" => 'se533', // B型
		"\x7a\x6b" => 'se534', // AB型
		"\x7a\x6c" => 'se535', // O型
		"\x7a\x6d" => 'se536', // 足あと
		"\x77\x4b" => 'se537', // TM (商標)
/*
		"\x7d\x71" => 'se538', // J-Sky 1
		"\x7d\x71" => 'se539', // J-Sky 2
		"\x7d\x72" => 'se53a', // Vodafone 1
		"\x7d\x73" => 'se53b', // Vodafone 2
		"\x7d\x74" => 'se53c', // Vodafone 3
		"\x7d\x75" => 'se53d', // Vodafone 4
		"\x7d\x76" => 'se53e', // Vodafone 5
*/
	);

/* ==================================================
 * @param	string   $buffer
 * @param	string   $charset
 * @return	string   $buffer
 */
public function pickup_pics($buffer, $charset) {
	return $this->pickup_iso_pics($buffer, $charset, self::$pics_iso);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Entry_SoftBank_SJIS class
   ================================================== */

class Ktai_Entry_SoftBank_SJIS extends Ktai_Entry_Operator {
	static public $pics_sjis = array(
		"\xf9\x41" => 'se001', // 男の子
		"\xf9\x42" => 'se002', // 女の子
		"\xf9\x43" => 'se003', // 美容 (キスマーク)
		"\xf9\x44" => 'se004', // お父さん
		"\xf9\x45" => 'se005', // お母さん
		"\xf9\x46" => 'se006', // 洋服
		"\xf9\x47" => 'se007', // ブーツ
		"\xf9\x48" => 'se008', // カメラ
		"\xf9\x49" => 'se009', // 電話
		"\xf9\x4a" => 'se00a', // 携帯電話
		"\xf9\x4b" => 'se00b', // FAX
		"\xf9\x4c" => 'se00c', // パソコン
		"\xf9\x4d" => 'se00d', // パンチ
		"\xf9\x4e" => 'se00e', // GOOD!
		"\xf9\x4f" => 'se00f', // No.1!
		"\xf9\x50" => 'se010', // グー
		"\xf9\x51" => 'se011', // チョキ
		"\xf9\x52" => 'se012', // パー
		"\xf9\x53" => 'se013', // スキー
		"\xf9\x54" => 'se014', // ゴルフ
		"\xf9\x55" => 'se015', // テニス
		"\xf9\x56" => 'se016', // 野球
		"\xf9\x57" => 'se017', // サーフィン
		"\xf9\x58" => 'se018', // サッカー
		"\xf9\x59" => 'se019', // 魚
		"\xf9\x5a" => 'se01a', // うま
		"\xf9\x5b" => 'se01b', // 車
		"\xf9\x5c" => 'se01c', // ヨット
		"\xf9\x5d" => 'se01d', // 飛行機
		"\xf9\x5e" => 'se01e', // 電車
		"\xf9\x5f" => 'se01f', // 新幹線
		"\xf9\x60" => 'se020', // ハテナ
		"\xf9\x61" => 'se021', // ビックリ
		"\xf9\x62" => 'se022', // ハートマーク
		"\xf9\x63" => 'se023', // ハートブレイク
		"\xf9\x64" => 'se024', // 1時
		"\xf9\x65" => 'se025', // 2時
		"\xf9\x66" => 'se026', // 時計
		"\xf9\x67" => 'se027', // 4時
		"\xf9\x68" => 'se028', // 5時
		"\xf9\x69" => 'se029', // 6時
		"\xf9\x6a" => 'se02a', // 7時
		"\xf9\x6b" => 'se02b', // 8時
		"\xf9\x6c" => 'se02c', // 9時
		"\xf9\x6d" => 'se02d', // 10時
		"\xf9\x6e" => 'se02e', // 11時
		"\xf9\x6f" => 'se02f', // 12時
		"\xf9\x70" => 'se030', // お花見
		"\xf9\x71" => 'se031', // エンブレム
		"\xf9\x72" => 'se032', // バラ
		"\xf9\x73" => 'se033', // クリスマス
		"\xf9\x74" => 'se034', // 指輪
		"\xf9\x75" => 'se035', // 宝石
		"\xf9\x76" => 'se036', // 家
		"\xf9\x77" => 'se037', // 教会
		"\xf9\x78" => 'se038', // ビル
		"\xf9\x79" => 'se039', // 駅
		"\xf9\x7a" => 'se03a', // ガソリンスタンド
		"\xf9\x7b" => 'se03b', // 山
		"\xf9\x7c" => 'se03c', // マイク
		"\xf9\x7d" => 'se03d', // 映画
		"\xf9\x7e" => 'se03e', // 音楽 (音符)
		"\xf9\x80" => 'se03f', // カギ
		"\xf9\x81" => 'se040', // サックス
		"\xf9\x82" => 'se041', // ギター
		"\xf9\x83" => 'se042', // トランペット
		"\xf9\x84" => 'se043', // レストラン
		"\xf9\x85" => 'se044', // カクテル
		"\xf9\x86" => 'se045', // コーヒー
		"\xf9\x87" => 'se046', // ケーキ
		"\xf9\x88" => 'se047', // ビール
		"\xf9\x89" => 'se048', // 雪
		"\xf9\x8a" => 'se049', // 曇り
		"\xf9\x8b" => 'se04a', // 晴れ (昼)
		"\xf9\x8c" => 'se04b', // 雨
		"\xf9\x8d" => 'se04c', // 晴れ (夜)
		"\xf9\x8e" => 'se04d', // 朝
		"\xf9\x8f" => 'se04e', // 天使
		"\xf9\x90" => 'se04f', // ねこ
		"\xf9\x91" => 'se050', // とら
		"\xf9\x92" => 'se051', // くま
		"\xf9\x93" => 'se052', // いぬ
		"\xf9\x94" => 'se053', // ねずみ
		"\xf9\x95" => 'se054', // クジラ
		"\xf9\x96" => 'se055', // ペンギン
		"\xf9\x97" => 'se056', // 楽 (顔)
		"\xf9\x98" => 'se057', // 喜 (顔)
		"\xf9\x99" => 'se058', // 哀 (顔)
		"\xf9\x9a" => 'se059', // 怒 (顔)
		"\xf9\x9b" => 'se05a', // ウンチ
		"\xf7\x41" => 'se101', // メール受信
		"\xf7\x42" => 'se102', // メール送信
		"\xf7\x43" => 'se103', // メール宛先
		"\xf7\x44" => 'se104', // 電話連絡先
		"\xf7\x45" => 'se105', // アカンベー (顔)
		"\xf7\x46" => 'se106', // ラブラブ (顔)
		"\xf7\x47" => 'se107', // ガビーン (顔)
		"\xf7\x48" => 'se108', // タラー (顔)
		"\xf7\x49" => 'se109', // さる
		"\xf7\x4a" => 'se10a', // タコ
		"\xf7\x4b" => 'se10b', // ぶた
		"\xf7\x4c" => 'se10c', // 宇宙人
		"\xf7\x4d" => 'se10d', // ロケット
		"\xf7\x4e" => 'se10e', // 王冠
		"\xf7\x4f" => 'se10f', // 電球
		"\xf7\x50" => 'se110', // よつば
		"\xf7\x51" => 'se111', // キス
		"\xf7\x52" => 'se112', // バースデー (プレゼント)
		"\xf7\x53" => 'se113', // ピストル
		"\xf7\x54" => 'se114', // 虫眼鏡
		"\xf7\x55" => 'se115', // 陸上
		"\xf7\x56" => 'se116', // オークション
		"\xf7\x57" => 'se117', // 花火
		"\xf7\x58" => 'se118', // もみじ
		"\xf7\x59" => 'se119', // 落ち葉
		"\xf7\x5a" => 'se11a', // 悪魔
		"\xf7\x5b" => 'se11b', // おばけ
		"\xf7\x5c" => 'se11c', // ドクロ
		"\xf7\x5d" => 'se11d', // ファイヤー
		"\xf7\x5e" => 'se11e', // かばん
		"\xf7\x5f" => 'se11f', // 座席
		"\xf7\x60" => 'se120', // ハンバーガー
		"\xf7\x61" => 'se121', // 公園
		"\xf7\x62" => 'se122', // キャンプ場
		"\xf7\x63" => 'se123', // 温泉
		"\xf7\x64" => 'se124', // 遊園地
		"\xf7\x65" => 'se125', // チケット
		"\xf7\x66" => 'se126', // CD
		"\xf7\x67" => 'se127', // DVD
		"\xf7\x68" => 'se128', // ラジオ
		"\xf7\x69" => 'se129', // ビデオ
		"\xf7\x6a" => 'se12a', // テレビ
		"\xf7\x6b" => 'se12b', // ゲーム
		"\xf7\x6c" => 'se12c', // 歌い出し
		"\xf7\x6d" => 'se12d', // マージャン
		"\xf7\x6e" => 'se12e', // 対決
		"\xf7\x6f" => 'se12f', // 賞金 (ドル袋)
		"\xf7\x70" => 'se130', // 当たり
		"\xf7\x71" => 'se131', // トロフィー
		"\xf7\x72" => 'se132', // ゴール (チェッカーフラッグ)
		"\xf7\x73" => 'se133', // スロット (777)
		"\xf7\x74" => 'se134', // 競馬
		"\xf7\x75" => 'se135', // 競艇
		"\xf7\x76" => 'se136', // 競輪
		"\xf7\x77" => 'se137', // 工事中
		"\xf7\x78" => 'se138', // 男性
		"\xf7\x79" => 'se139', // 女性
		"\xf7\x7a" => 'se13a', // 乳幼児
		"\xf7\x7b" => 'se13b', // 注射器
		"\xf7\x7c" => 'se13c', // 睡眠 (Zzz)
		"\xf7\x7d" => 'se13d', // 雷
		"\xf7\x7e" => 'se13e', // ハイヒール
		"\xf7\x80" => 'se13f', // 入浴
		"\xf7\x81" => 'se140', // トイレ
		"\xf7\x82" => 'se141', // 音声
		"\xf7\x83" => 'se142', // お知らせ (メガホン)
		"\xf7\x84" => 'se143', // 祝日
		"\xf7\x85" => 'se144', // ロックON
		"\xf7\x86" => 'se145', // ロックOFF
		"\xf7\x87" => 'se146', // 街
		"\xf7\x88" => 'se147', // 料理 (卵)
		"\xf7\x89" => 'se148', // 本
		"\xf7\x8a" => 'se149', // 為替相場
		"\xf7\x8b" => 'se14a', // 株価
		"\xf7\x8c" => 'se14b', // ニュース (パラボラアンテナ)
		"\xf7\x8d" => 'se14c', // 元気 (力こぶ)
		"\xf7\x8e" => 'se14d', // 銀行
		"\xf7\x8f" => 'se14e', // 信号
		"\xf7\x90" => 'se14f', // 駐車場
		"\xf7\x91" => 'se150', // バス停
		"\xf7\x92" => 'se151', // 公衆トイレ
		"\xf7\x93" => 'se152', // 交番
		"\xf7\x94" => 'se153', // 郵便局
		"\xf7\x95" => 'se154', // ATM
		"\xf7\x96" => 'se155', // 病院
		"\xf7\x97" => 'se156', // コンビニ
		"\xf7\x98" => 'se157', // 学校
		"\xf7\x99" => 'se158', // ホテル
		"\xf7\x9a" => 'se159', // バス
		"\xf7\x9b" => 'se15a', // タクシー
		"\xf7\xa1" => 'se201', // 徒歩
		"\xf7\xa2" => 'se202', // 船
		"\xf7\xa3" => 'se203', // 目的地 (ココ)
		"\xf7\xa4" => 'se204', // 飾罫1
		"\xf7\xa5" => 'se205', // 飾罫2
		"\xf7\xa6" => 'se206', // 飾罫3
		"\xf7\xa7" => 'se207', // 18禁
		"\xf7\xa8" => 'se208', // 禁煙
		"\xf7\xa9" => 'se209', // 初心者
		"\xf7\xaa" => 'se20a', // バリアフリー (車椅子マーク)
		"\xf7\xab" => 'se20b', // アンテナマーク
		"\xf7\xac" => 'se20c', // ハート (トランプ)
		"\xf7\xad" => 'se20d', // ダイヤ (トランプ)
		"\xf7\xae" => 'se20e', // スペード (トランプ)
		"\xf7\xaf" => 'se20f', // クラブ (トランプ)
		"\xf7\xb0" => 'se210', // シャープダイヤル
		"\xf7\xb1" => 'se211', // フリーダイヤル
		"\xf7\xb2" => 'se212', // 新着
		"\xf7\xb3" => 'se213', // 更新
		"\xf7\xb4" => 'se214', // おすすめ (COOL)
		"\xf7\xb5" => 'se215', // 有料
		"\xf7\xb6" => 'se216', // 無料
		"\xf7\xb7" => 'se217', // 月額
		"\xf7\xb8" => 'se218', // 申し込み
		"\xf7\xb9" => 'se219', // 見出しボタン1 (オレンジ)
		"\xf7\xba" => 'se21a', // 見出しボタン2 (緑)
		"\xf7\xbb" => 'se21b', // 見出しボタン4 (紫)
		"\xf7\xbc" => 'se21c', // 1 (one)
		"\xf7\xbd" => 'se21d', // 2 (two)
		"\xf7\xbe" => 'se21e', // 3 (three)
		"\xf7\xbf" => 'se21f', // 4 (four)
		"\xf7\xc0" => 'se220', // 5 (five)
		"\xf7\xc1" => 'se221', // 6 (six)
		"\xf7\xc2" => 'se222', // 7 (seven)
		"\xf7\xc3" => 'se223', // 8 (eight)
		"\xf7\xc4" => 'se224', // 9 (nine)
		"\xf7\xc5" => 'se225', // 0 (zero)
		"\xf7\xc6" => 'se226', // お得
		"\xf7\xc7" => 'se227', // 割引
		"\xf7\xc8" => 'se228', // サービス料
		"\xf7\xc9" => 'se229', // ID
		"\xf7\xca" => 'se22a', // 満席
		"\xf7\xcb" => 'se22b', // 空席
		"\xf7\xcc" => 'se22c', // 指定席
		"\xf7\xcd" => 'se22d', // 営業時間
		"\xf7\xce" => 'se22e', // 上へ (指)
		"\xf7\xcf" => 'se22f', // 下へ (指)
		"\xf7\xd0" => 'se230', // 左へ (指)
		"\xf7\xd1" => 'se231', // 右へ (指)
		"\xf7\xd2" => 'se232', // 上
		"\xf7\xd3" => 'se233', // 下
		"\xf7\xd4" => 'se234', // 右
		"\xf7\xd5" => 'se235', // 左
		"\xf7\xd6" => 'se236', // 右上
		"\xf7\xd7" => 'se237', // 左上
		"\xf7\xd8" => 'se238', // 右下
		"\xf7\xd9" => 'se239', // 左下
		"\xf7\xda" => 'se23a', // 次へ
		"\xf7\xdb" => 'se23b', // 前へ
		"\xf7\xdc" => 'se23c', // 早送り 
		"\xf7\xdd" => 'se23d', // 巻き戻し
		"\xf7\xde" => 'se23e', // 星座
		"\xf7\xdf" => 'se23f', // おひつじ座
		"\xf7\xe0" => 'se240', // おうし座
		"\xf7\xe1" => 'se241', // ふたご座
		"\xf7\xe2" => 'se242', // かに座
		"\xf7\xe3" => 'se243', // しし座
		"\xf7\xe4" => 'se244', // おとめ座
		"\xf7\xe5" => 'se245', // てんぴん座
		"\xf7\xe6" => 'se246', // さそり座
		"\xf7\xe7" => 'se247', // いて座
		"\xf7\xe8" => 'se248', // やぎ座
		"\xf7\xe9" => 'se249', // みずがめ座
		"\xf7\xea" => 'se24a', // うお座
		"\xf7\xeb" => 'se24b', // へびつかい座
		"\xf7\xec" => 'se24c', // TOPページ
		"\xf7\xed" => 'se24d', // OKボタン
		"\xf7\xee" => 'se24e', // 著作権 (C)
		"\xf7\xef" => 'se24f', // 登録商標 (R)
		"\xf7\xf0" => 'se250', // マナーモード
		"\xf7\xf1" => 'se251', // 電源切
		"\xf7\xf2" => 'se252', // ご注意 (!)
		"\xf7\xf3" => 'se253', // ご案内
/*
		"\xf7\xf4" => 'se254', // J-PHONEショップ
		"\xf7\xf5" => 'se255', // スカイウェブ
		"\xf7\xf6" => 'se256', // スカイウォーカー
		"\xf7\xf7" => 'se257', // スカイメロディ
		"\xf7\xf8" => 'se258', // J-PHONE 1
		"\xf7\xf9" => 'se259', // J-PHONE 2
		"\xf7\xfa" => 'se25a', // J-PHONE 3
*/
		"\xf9\xa1" => 'se301', // メモ
		"\xf9\xa2" => 'se302', // ネクタイ
		"\xf9\xa3" => 'se303', // ハイビスカス
		"\xf9\xa4" => 'se304', // チューリップ
		"\xf9\xa5" => 'se305', // ひまわり
		"\xf9\xa6" => 'se306', // 花束
		"\xf9\xa7" => 'se307', // やしの木
		"\xf9\xa8" => 'se308', // サボテン
		"\xf9\xa9" => 'se309', // トイレ
		"\xf9\xaa" => 'se30a', // ヘッドホン
		"\xf9\xab" => 'se30b', // 晩酌 (とっくり)
		"\xf9\xac" => 'se30c', // 乾杯 (ビール)
		"\xf9\xad" => 'se30d', // 祝
		"\xf9\xae" => 'se30e', // 喫煙
		"\xf9\xaf" => 'se30f', // カプセル薬
		"\xf9\xb0" => 'se310', // 風船
		"\xf9\xb1" => 'se311', // 爆弾
		"\xf9\xb2" => 'se312', // クラッカー
		"\xf9\xb3" => 'se313', // ハサミ
		"\xf9\xb4" => 'se314', // リボン
		"\xf9\xb5" => 'se315', // マル秘
		"\xf9\xb6" => 'se316', // MD
		"\xf9\xb7" => 'se317', // メガフォン
		"\xf9\xb8" => 'se318', // 帽子
		"\xf9\xb9" => 'se319', // 可愛いワンピース
		"\xf9\xba" => 'se31a', // ミュール
		"\xf9\xbb" => 'se31b', // ロングブーツ
		"\xf9\xbc" => 'se31c', // 口紅
		"\xf9\xbd" => 'se31d', // マニキュア
		"\xf9\xbe" => 'se31e', // エステ
		"\xf9\xbf" => 'se31f', // 美容院
		"\xf9\xc0" => 'se320', // 理髪店
		"\xf9\xc1" => 'se321', // 着物
		"\xf9\xc2" => 'se322', // ビキニ
		"\xf9\xc3" => 'se323', // ブランドバッグ
		"\xf9\xc4" => 'se324', // カチンコ
		"\xf9\xc5" => 'se325', // すず
		"\xf9\xc6" => 'se326', // 踊る音符
		"\xf9\xc7" => 'se327', // ぴかぴかハート
		"\xf9\xc8" => 'se328', // ドキドキハート
		"\xf9\xc9" => 'se329', // ハートを射とめて
		"\xf9\xca" => 'se32a', // ハート (青)
		"\xf9\xcb" => 'se32b', // ハート (緑)
		"\xf9\xcc" => 'se32c', // ハート (黄)
		"\xf9\xcd" => 'se32d', // ハート (紫)
		"\xf9\xce" => 'se32e', // NEW (ぴかぴか)
		"\xf9\xcf" => 'se32f', // ☆
		"\xf9\xd0" => 'se330', // ダッシュ
		"\xf9\xd1" => 'se331', // 飛び散る汗
		"\xf9\xd2" => 'se332', // ○
		"\xf9\xd3" => 'se333', // ×
		"\xf9\xd4" => 'se334', // 怒り
		"\xf9\xd5" => 'se335', // ☆ (点滅)
		"\xf9\xd6" => 'se336', // 動く "?"
		"\xf9\xd7" => 'se337', // 動く "!"
		"\xf9\xd8" => 'se338', // お茶
		"\xf9\xd9" => 'se339', // パン
		"\xf9\xda" => 'se33a', // ソフトクリーム
		"\xf9\xdb" => 'se33b', // フライドポテト
		"\xf9\xdc" => 'se33c', // 串団子 
		"\xf9\xdd" => 'se33d', // せんべい
		"\xf9\xde" => 'se33e', // ご飯
		"\xf9\xdf" => 'se33f', // スパゲティ
		"\xf9\xe0" => 'se340', // ラーメン
		"\xf9\xe1" => 'se341', // カレーライス
		"\xf9\xe2" => 'se342', // おにぎり
		"\xf9\xe3" => 'se343', // おでん
		"\xf9\xe4" => 'se344', // 寿司
		"\xf9\xe5" => 'se345', // りんご
		"\xf9\xe6" => 'se346', // みかん
		"\xf9\xe7" => 'se347', // いちご
		"\xf9\xe8" => 'se348', // すいか
		"\xf9\xe9" => 'se349', // トマト
		"\xf9\xea" => 'se34a', // なす
		"\xf9\xeb" => 'se34b', // バースデーケーキ
		"\xf9\xec" => 'se34c', // 駅弁
		"\xf9\xed" => 'se34d', // ナベ
		"\xfb\x41" => 'se401', // あせり (顔)
		"\xfb\x42" => 'se402', // ほそくんでいる (顔)
		"\xfb\x43" => 'se403', // ひたすらごめんなさい (顔)
		"\xfb\x44" => 'se404', // えっへん (顔)
		"\xfb\x45" => 'se405', // ウィンク (顔)
		"\xfb\x46" => 'se406', // わさびがきいた (顔)
		"\xfb\x47" => 'se407', // 目がぐるぐる (顔)
		"\xfb\x48" => 'se408', // 鼻ちょうちん (顔)
		"\xfb\x49" => 'se409', // あっかんべー (顔)
		"\xfb\x4a" => 'se40a', // 酔っ払い (顔)
		"\xfb\x4b" => 'se40b', // ゲロゲロ (顔)
		"\xfb\x4c" => 'se40c', // マスクをつけた顔
		"\xfb\x4d" => 'se40d', // 顔があかくなる
		"\xfb\x4e" => 'se40e', // しらけ顔
		"\xfb\x4f" => 'se40f', // 冷や汗 (顔)
		"\xfb\x50" => 'se410', // びっくり (顔)
		"\xfb\x51" => 'se411', // 泣き (顔)
		"\xfb\x52" => 'se412', // 泣いたり笑ったり (顔)
		"\xfb\x53" => 'se413', // 可愛く泣いてる人
		"\xfb\x54" => 'se414', // にこにこ (顔)
		"\xfb\x55" => 'se415', // あははと笑う (顔)
		"\xfb\x56" => 'se416', // めちゃめちゃ怒っている (顔)
		"\xfb\x57" => 'se417', // KISS:動く口
		"\xfb\x58" => 'se418', // 投げKISS
		"\xfb\x59" => 'se419', // 目
		"\xfb\x5a" => 'se41a', // 鼻
		"\xfb\x5b" => 'se41b', // 耳
		"\xfb\x5c" => 'se41c', // 口
		"\xfb\x5d" => 'se41d', // ごめんなさい (合わせた手)
		"\xfb\x5e" => 'se41e', // バイバイ (手を振る)
		"\xfb\x5f" => 'se41f', // 拍手
		"\xfb\x60" => 'se420', // OK (指で丸サイン)
		"\xfb\x61" => 'se421', // Booing (親指を下)
		"\xfb\x62" => 'se422', // おっは〜
		"\xfb\x63" => 'se423', // × (両腕をクロス)
		"\xfb\x64" => 'se424', // ○ (両腕を頭に)
		"\xfb\x65" => 'se425', // 手をつないでいる
		"\xfb\x66" => 'se426', // 土下座
		"\xfb\x67" => 'se427', // バンザイ
		"\xfb\x68" => 'se428', // 人と人が歩いている
		"\xfb\x69" => 'se429', // ラインダンス (バニーガール)
		"\xfb\x6a" => 'se42a', // バスケットボール
		"\xfb\x6b" => 'se42b', // フットボール
		"\xfb\x6c" => 'se42c', // ビリヤード
		"\xfb\x6d" => 'se42d', // 水泳
		"\xfb\x6e" => 'se42e', // RV車
		"\xfb\x6f" => 'se42f', // トラック
		"\xfb\x70" => 'se430', // 消防車
		"\xfb\x71" => 'se431', // 救急車
		"\xfb\x72" => 'se432', // パトカー
		"\xfb\x73" => 'se433', // ジェットコースター
		"\xfb\x74" => 'se434', // 地下鉄
		"\xfb\x75" => 'se435', // 新幹線(700系)
		"\xfb\x76" => 'se436', // 門松
		"\xfb\x77" => 'se437', // チョコ
		"\xfb\x78" => 'se438', // お雛様
		"\xfb\x79" => 'se439', // 卒業式
		"\xfb\x7a" => 'se43a', // ランドセル
		"\xfb\x7b" => 'se43b', // 鯉のぼり
		"\xfb\x7c" => 'se43c', // とじかさ
		"\xfb\x7d" => 'se43d', // 結婚式
		"\xfb\x7e" => 'se43e', // 波がザーン
		"\xfb\x80" => 'se43f', // かき氷
		"\xfb\x81" => 'se440', // 線香花火
		"\xfb\x82" => 'se441', // 貝
		"\xfb\x83" => 'se442', // 風鈴
		"\xfb\x84" => 'se443', // 台風
		"\xfb\x85" => 'se444', // 稲穂
		"\xfb\x86" => 'se445', // ハロウィン
		"\xfb\x87" => 'se446', // お月見
		"\xfb\x88" => 'se447', // 風がビュー
		"\xfb\x89" => 'se448', // サンタクロース
		"\xfb\x8a" => 'se449', // 朝日
		"\xfb\x8b" => 'se44a', // 夕日
		"\xfb\x8c" => 'se44b', // 流れ星
		"\xfb\x8d" => 'se44c', // 虹
		"\xfb\xa1" => 'se501', // ラブホテル
		"\xfb\xa2" => 'se502', // アート
		"\xfb\xa3" => 'se503', // 演劇
		"\xfb\xa4" => 'se504', // デパート
		"\xfb\xa5" => 'se505', // お城 (和)
		"\xfb\xa6" => 'se506', // お城 (洋)
		"\xfb\xa7" => 'se507', // 映画館
		"\xfb\xa8" => 'se508', // 工場
		"\xfb\xa9" => 'se509', // 東京タワー
		"\xfb\xaa" => 'se50a', // 109
		"\xfb\xab" => 'se50b', // 日本 (国旗)
		"\xfb\xac" => 'se50c', // アメリカ (国旗)
		"\xfb\xad" => 'se50d', // フランス (国旗)
		"\xfb\xae" => 'se50e', // ドイツ (国旗)
		"\xfb\xaf" => 'se50f', // イタリア (国旗)
		"\xfb\xb0" => 'se510', // イギリス (国旗)
		"\xfb\xb1" => 'se511', // スペイン (国旗)
		"\xfb\xb2" => 'se512', // ロシア (国旗)
		"\xfb\xb3" => 'se513', // 中国 (国旗)
		"\xfb\xb4" => 'se514', // 韓国 (国旗)
		"\xfb\xb5" => 'se515', // 白人
		"\xfb\xb6" => 'se516', // 中国人
		"\xfb\xb7" => 'se517', // インド人
		"\xfb\xb8" => 'se518', // おじいちゃん
		"\xfb\xb9" => 'se519', // おばあちゃん
		"\xfb\xba" => 'se51a', // あかちゃん
		"\xfb\xbb" => 'se51b', // 安全第一
		"\xfb\xbc" => 'se51c', // お姫さま
		"\xfb\xbd" => 'se51d', // 自由の女神
		"\xfb\xbe" => 'se51e', // 衛兵
		"\xfb\xbf" => 'se51f', // フラメンコ
		"\xfb\xc0" => 'se520', // イルカ
		"\xfb\xc1" => 'se521', // とり
		"\xfb\xc2" => 'se522', // 熱帯魚
		"\xfb\xc3" => 'se523', // ひよこ
		"\xfb\xc4" => 'se524', // ハムスター
		"\xfb\xc5" => 'se525', // けむし
		"\xfb\xc6" => 'se526', // ぞう
		"\xfb\xc7" => 'se527', // コアラ
		"\xfb\xc8" => 'se528', // チンパンジー
		"\xfb\xc9" => 'se529', // ひつじ
		"\xfb\xca" => 'se52a', // おおかみ
		"\xfb\xcb" => 'se52b', // うし
		"\xfb\xcc" => 'se52c', // うさぎ
		"\xfb\xcd" => 'se52d', // へび
		"\xfb\xce" => 'se52e', // にわとり
		"\xfb\xcf" => 'se52f', // いのしし
		"\xfb\xd0" => 'se530', // らくだ
		"\xfb\xd1" => 'se531', // かえる
		"\xfb\xd2" => 'se532', // A型
		"\xfb\xd3" => 'se533', // B型
		"\xfb\xd4" => 'se534', // AB型
		"\xfb\xd5" => 'se535', // O型
		"\xfb\xd6" => 'se536', // 足あと
		"\xfb\xd7" => 'se537', // TM (商標)
/*
		"\xfb\xd8" => 'se538', // J-Sky 1
		"\xfb\xd9" => 'se539', // J-Sky 2
		"\xfb\xda" => 'se53a', // Vodafone 1
		"\xfb\xdb" => 'se53b', // Vodafone 2
		"\xfb\xdc" => 'se53c', // Vodafone 3
		"\xfb\xdd" => 'se53d', // Vodafone 4
		"\xfb\xde" => 'se53e', // Vodafone 5
*/
	);
/* ==================================================
 * @param	string   $buffer
 * @param	string   $charset
 * @return	string   $buffer
 */
public function pickup_pics($buffer, $charset) {
	if (strtolower($charset) == 'shift_jis' || strtolower($charset) == 'sjis' || strtolower($charset) == 'cp932') {
		$buffer = $this->pickup_sbm_sjis($buffer, $charset, self::$pics_sjis);
	}
	return $buffer;
}

// ===== End of class ====================
}
?>