<?php 
/* 
Plugin Name: Force Wave Dash
Plugin URI: http://wppluginsj.sourceforge.jp/force-wave-dash/
Version: 1.0.0-beta1
Description: Convert full-width-tild characters to wave dash ones.
Author: IKEDA Yuriko
Author URI: http://www.yuriko.net/cat/wordpress/
Text Domain: force_wave_dash
Domain Path: lang/
*/

/*  Copyright (c) 2007-2009 yuriko

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 Special thanks to
	WOKAMOTO Wataru: patch at http://dl.dropbox.com/u/110305/force_wavedash.diff
 */

if ( get_bloginfo('charset') == 'UTF-8' ) :

/* ==================================================
 *   ForceWavedash class
   ================================================== */

class ForceWavedash {
	var $wp_vers = NULL;
	var $plugin_dir;
	var $textdomain_loaded = false;
	var $bad_chars_pat = array(
		"/\x{ff5e}/u", // U+FF5E FULLWIDTH TILD -> U+301C
/*
		"/\x{203e}/u", // U+203E OVERLINE -> U+FFE3
		"/\x{2014}/u", // U+2014 EM DASH -> U+2015
		"/\x{ff3c}/u", // U+FF3C FULLWIDTH REVERSE SOLIDUS -> U+005C
		"/\x{2225}/u", // U+2225 PARALLEL TO -> U+2016
		"/\x{22ef}/u", // U+22EF MIDLINE HORIZONTAL ELLIPSIS -> U+2026
		"/\x{ff0d}/u", // U+FF0D FULLWIDTH HYPHEN-MINUS -> U+2212
		"/\x{ffe0}/u", // U+FFE0 FULLWIDTH CENT SIGN -> U+00A2
		"/\x{ffe1}/u", // U+FFE1 FULLWIDTH POUND SIGN -> U+00A3
		"/\x{ffe2}/u", // U+FFE2 FULLWIDTH NOT SIGN -> U+00AC
*/
	);
	var $good_chars = array(
		"\xe3\x80\x9c", // U+301C WAVE DASH
/*
		"\xEF\xBF\xA3",	// U+FFE3 OVERLINE
		"\xE2\x80\x95",	// U+2015 HORIZONTAL BAR
		"\x00\x00\x5C",	// U+005C REVERSE SOLIDUS
		"\xE2\x80\x96",	// U+2016 DOUBLE VERTICAL LINE
		"\xE2\x80\xA6",	// U+2026 HORIZONTAL ELLIPSIS
		"\xE2\x88\x92",	// U+2212 MINUS SIGN
		"\x00\xC2\xA2",	// U+00A2 CENT SIGN
		"\x00\xC2\xA3",	// U+00A3 POUND SIGN
		"\x00\xC2\xAC",	// U+00AC NOT SIGN
*/
	);
	var $good_chars_debug = array(
		"\xe3\x80\xb0", // U+3030 WAVY DASH
/*
		"\xEF\xBF\xA3",	// U+FFE3 OVERLINE
		"\xE2\x80\x95",	// U+2015 HORIZONTAL BAR
		"\x00\x00\x5C",	// U+005C REVERSE SOLIDUS
		"\xE2\x80\x96",	// U+2016 DOUBLE VERTICAL LINE
		"\xE2\x80\xA6",	// U+2026 HORIZONTAL ELLIPSIS
		"\xE2\x88\x92",	// U+2212 MINUS SIGN
		"\x00\xC2\xA2",	// U+00A2 CENT SIGN
		"\x00\xC2\xA3",	// U+00A3 POUND SIGN
		"\x00\xC2\xAC",	// U+00AC NOT SIGN
*/
	);

function ForceWavedash() {
	return $this->__construct();
}

function __construct() {
	$this->plugin_dir = basename(dirname(__FILE__));
	add_action('plugins_loaded', array($this, 'load_textdomain'));

	if (isset($_GET['s'])) {
		$_GET['s'] = $this->tild2wave($_GET['s']);
	}
	if ($this->check_wp_version(2.7)) {
		add_filter('wp_title', array($this, 'show_wave'), 90, 3);
	} else {
		add_filter('wp_title', array($this, 'show_wave'), 90, 2);
	}
	add_filter('bloginfo', array($this, 'show_wave'), 90, 2);
	add_filter('the_title', array($this, 'show_wave'), 90);
	add_filter('the_title_rss', array($this, 'show_wave'), 90);
	add_filter('single_post_title', array($this, 'show_wave'), 90);
	add_filter('the_content',array($this, 'show_wave'), 90);
	add_filter('the_excerpt', array($this, 'show_wave'), 90);
	add_filter('the_category', array($this, 'show_wave'), 90, 3);
	add_filter('single_cat_title', array($this, 'show_wave'), 90);
	if (function_exists('the_tags')) {
		add_filter('wp_tag_cloud', array($this,  'show_wave'), 90, 2);
		add_filter('the_tags', array($this, 'show_wave'), 90);
		add_filter('get_the_tags', array($this, 'show_wave_obj_array'), 90);
		add_filter('single_tag_title', array($this, 'show_wave'), 90);
	}
	add_filter('wp_list_bookmarks', array($this,  'show_wave'), 90, 2);
	add_filter('get_archives_link', array($this,  'show_wave'), 90);
	add_filter('get_comment_author', array($this, 'show_wave'), 90);
	add_filter('get_comment_text', array($this, 'show_wave'), 90);
	add_filter('get_comment_excerpt', array($this, 'show_wave'), 90);

	add_filter('pre_comment_author_name', array($this, 'tild2wave'), 90);
	add_filter('pre_comment_content', array($this, 'tild2wave'), 90);
	add_filter('pre_link_name', array($this, 'tild2wave'), 90);
	add_filter('pre_link_description', array($this, 'tild2wave'), 90);
	add_filter('pre_link_notes', array($this, 'tild2wave'), 90);

	if (function_exists('wp_insert_term')) {
		add_filter('pre_term_name', array($this, 'tild2wave'), 90);
		add_filter('pre_term_slug', array($this, 'tild2wave'), 90);
		add_filter('pre_term_description', array($this, 'tild2wave'), 90);
	} else {
		add_filter('pre_category_nicename', array($this, 'tild2wave'), 90);
	}
	if ($this->check_wp_version(2.7)) {
		add_filter('wp_insert_post_data', array($this, 'filter_posts'), 90, 2);
	} elseif (function_exists('wp_transition_post_status')) { // WP 2.6
		add_action('save_post', array($this, 'convert_posts'), 90, 2);
	} else {
		add_action('save_post', array($this, 'convert_posts'), 90);
	}
}

/* ==================================================
 * @param	string   $version
 * @param	string   $operator
 * @return	boolean  $result
 * @since	0.9.0
 */
//public
function check_wp_version($version, $operator = '>=') {
	if (! isset($this->wp_vers)) {
		$this->wp_vers = get_bloginfo('version');
		if (! is_numeric($this->wp_vers)) {
			$this->wp_vers = preg_replace('/[^.0-9]/', '', $this->wp_vers);  // strip 'ME'
		}
	}
	return version_compare($this->wp_vers, $version, $operator);
}

/* ==================================================
 * @param	none
 * @return	none
 * @since	0.9.0
 */
//public 
function load_textdomain() {
	if (! $this->textdomain_loaded) {
		$lang_dir = $this->plugin_dir . '/lang';
		$plugin_path = defined('PLUGINDIR') ? PLUGINDIR . '/' : 'wp-content/plugins/';
		load_plugin_textdomain('force_wave_dash', $plugin_path . $lang_dir, $lang_dir);
		$this->textdomain_loaded = true;
	}
}

/* ==================================================
 * @param	string $text
 * @return	string $text
 * @since	0.7.0
 */
//public 
function tild2wave($text) {
	$text = preg_replace($this->bad_chars_pat, $this->good_chars, $text);
	return $text;
}

/* ==================================================
 * @param	string $text
 * @return	string $text
 * @since	0.9.0
 * Used for debug only
 */
//public 
function tild2wave_debug($text) {
	$text = preg_replace($this->bad_chars_pat, $this->good_chars_debug, $text);
	return $text;
}

/* ==================================================
 * @param	string $text
 * @return	string $text
 * @since	0.9.0
 */
//public 
function show_wave($text) {
	if (is_user_logged_in()) {
		$text = $this->tild2wave_debug($text);
	} else {
		$text = $this->tild2wave($text);
	}
	return $text;
}

/* ==================================================
 * @param	array  $objs
 * @return	array  $objs
 * @since	0.9.0
 */
//public 
function show_wave_obj_array($objs) {
	if (is_array($objs) && count($objs)) {
		foreach ($objs as $k => $o) {
			if (isset($o->name)) {
				$objs[$k]->name = $this->show_wave($o->name);
			}
			if (isset($o->description)) {
				$objs[$k]->description = $this->show_wave($o->description);
			}
		}
	}
	return $objs;
}

/* ==================================================
 * @params	array $data
 * @params	array $postarr
 * @return	array $data
 * @since	0.9.0
 * Used later than and eaqual to WP 2.7
 */
function filter_posts($data, $postarr) {
	$keys = array('post_author', 'post_content', 'post_content_filtered', 'post_title', 'post_excerpt');
	foreach ($keys as $k) {
		if (isset($data[$k]) && ! empty($data[$k])) {
			$data[$k] = $this->tild2wave($data[$k]);
		}
	}
	return $data;
}

/* ==================================================
 * @params	array $postID
 * @params	object $post
 * @return	none
 * @since	0.7.0
 * Used for under and eaqual to WP 2.6
 */
function convert_posts($postID, $post = false) {
	if (! is_numeric($postID) || $postID <= 0) {
		return;
	}
	if (is_object($post)) {
		if ($post->post_type == 'revision') {
			return;
		}
	} else {
		$post = get_post($postID);
		if (! $post || $post->ID != $postID) {
			return;
		}
	}

	$keys = array('post_author', 'post_content', 'post_content_filtered', 'post_title', 'post_excerpt');
	$converted = array();
	foreach ($keys as $k) {
		if (isset($post->$k) && ! empty($post->$k)) {
			$converted[$k] = $post->$k = $this->tild2wave($post->$k);
		}
	}
	if (count($converted) < 1) {
		return;
	}
	global $wpdb;
	$columns = array();
	foreach ($converted as $k => $c) {
		$columns[] = sprintf("%s = '%s'", $wpdb->escape($k), $wpdb->escape($c));
	}
	$id_sql = intval($post->ID);
	$wpdb->query("UPDATE `{$wpdb->posts}` SET " . implode(', ', $columns) . " WHERE ID = $id_sql");
	$posts = array($post);
	update_post_cache($posts);
	return;
}

// ===== End of class ====================
}

$ForceWavedash = new ForceWavedash();
endif;
?>