<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS.

   ***** DO NOT EDIT THIS FILE WITH WORDPRESS ADMIN PANEL *****
*/

/* ==================================================
 *   KtaiService_EZweb class
   ================================================== */

class KtaiService_EZweb extends KtaiServices {
	static public $networks;
	static public $device_IDs;
	static public $pictograms;

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->theme = ks_option('ks_theme_ezweb');
	$this->operator = 'KDDI';
	$this->image_pictograms = false;
	$this->use_redir = true;
	$this->show_plugin_icon = false;
	$this->pcview_enabled = false;
	$this->sub_ID = isset($_SERVER['HTTP_X_UP_SUBNO']) ? $_SERVER['HTTP_X_UP_SUBNO'] : NULL;
	$this->sub_ID_available = true;
	$this->cookie_available = true;
	$this->ext_css_available = false;
	$this->available_js_version = false;
	if (isset($_SERVER['X-UP-DEVCAP-SCREENPIXELS'])) {
		list($this->screen_width, $this->screen_height) = array_map('intval', explode(',', $_SERVER['X-UP-DEVCAP-SCREENPIXELS']));
	}
	$this->charset = 'SJIS-win';
	$this->mime_type = 'text/html';
	$this->preamble = '<?xml version="1.0" encoding="__CHARSET__"?>
<!DOCTYPE html PUBLIC "-//OPENWAVE//DTD XHTML 1.0//EN" "http://www.openwave.com/DTD/xhtml-basic.dtd">'; // <?php /* syntax hilighting fix */
	$this->require_id_msg = "ERROR: Please configure to send you EZ number (subscriber ID).\nGo au one top &gt; au customer support &gt; Apply/Change &gt; EZ number sending preference.";

	// http://www.au.kddi.com/ezfactory/tec/spec/ezsava_ip.html
	// Last Update: 2010-02-05
	self::$networks = array(
		'210.230.128.224/28', 
		'121.111.227.160/27', 
		'61.117.1.0/28', 
		'219.108.158.0/27', 
		'219.215.146.0/28', 
		'61.117.2.32/29', 
		'61.117.2.40/29', 
		'219.108.158.40/29', 
		'219.125.148.0/25', 
		'222.5.63.0/25', 
		'222.5.63.128/25',
		'222.5.62.128/25', 
		'59.135.38.128/25', 
		'219.108.157.0/25', 
		'219.125.145.0/25', 
		'121.111.231.0/25', 
		'121.111.227.0/25', 
		'118.152.214.192/26', 
		'118.159.131.0/25', 
		'118.159.133.0/25', 
		'118.159.132.160/27', 
		'118.86.142.0/26', // Feb, 2010 */
/*		'118.86.141.64/26', // Apr, 2010
		'118.86.141.128/26', // Apr, 2010
		'118.86.141.192/26', // Apr, 2010 */
		);
	// http://www.au.kddi.com/ezfactory/tec/spec/4_4.html
	// Last Update: 2010-02-01
	// array('term_name', 'flat_rate')
	self::$device_IDs = array(
		"KC3W" => array("mamorino", 1),
		"SH3G" => array("SH006", 1),
		"KC3V" => array("lotta[iida]", 1),
		"KC3U" => array("K004", 1),
		"SN3N" => array("URBANO BARONE", 1),
		"SH3F" => array("SH005", 1),
		"SN3L" => array("BRAVIA Phone U1", 1),
		"SH3E" => array("SH004", 1),
		"KC3S" => array("PRISMOID[iida]", 1),
		"TS3R" => array("T003", 1),
		"SH3D" => array("SH003", 1),
		"CA3G" => array("CA004", 1),
		"SN3M" => array("S002", 1),
		"KC3R" => array("SA001", 1),
		"CA3F" => array("CA003", 1),
		"KC3Q" => array("PLY[iida]", 1),
		"HC3P" => array("K003", 1),
		"HI3G" => array("Mobile Hi-Vision CAM Wooo", 1),
		"KC3Q" => array("misora[iida]", 1),
		"TS3O" => array("biblio", 1),
		"TS3P" => array("T002", 1),
		"SH3B" => array("SH002", 1),
		"KC3O" => array("K002", 1),
		"SH3C" => array("Sportio water beat", 1),
		"CA3E" => array("CA002", 1),
		"SN3K" => array("G9[iida]", 1),
		"SN3J" => array("S001", 1),
		"PT35" => array("NS02", 1),
		"MA35" => array("P001", 1),
		"TS3N" => array("T001", 1),
		"HI3F" => array("H001", 1),
		"SH38" => array("SH001", 1),
		"CA3D" => array("CA001", 1),
		"SN3I" => array("Premier3", 1),
		"KC3N" => array("NS01", 1),
		"KC3M" => array("K001", 1),
		"SN3H" => array("Xmini", 1),
		"HI3E" => array("W63H", 1),
		"TS3M" => array("W65T", 1),
		"CA3C" => array("W63CA", 1),
		"SH37" => array("W64SH", 1),
		"KC3I" => array("W63K", 1),
		"SN3G" => array("W64S", 1),
		"MA34" => array("W62P", 1),
		"TS3L" => array("W64T", 1),
		"KC3K" => array("W63K (Camera Less)", 1),
		"SH36" => array("URBANO", 1),
		"PT34" => array("W62PT", 1),
		"SA3F" => array("W64SA", 1),
		"CA3B" => array("W62CA", 1),
		"HI3D" => array("W62H", 1),
		"SH35" => array("W62SH", 1),
		"SN3F" => array("re", 1), 
		"KC3H" => array("W63K", 1), 
		"TS3K" => array("Sportio", 1), 
		"TS3J" => array("W62T", 1), 
		"SA3D" => array("W63SA", 1), 
		"KC3G" => array("W62K", 1), 
		"SN3D" => array("W61S", 1), 
		"SA3C" => array("W61SA", 1), 
		"SN3E" => array("W62S", 1), 
		"TS3I" => array("W61P", 1), 
		"HI3C" => array("W61H", 1), 
		"ST34" => array("W62SA", 1), 
		"PT33" => array("W61PT", 1), 
		"MA33" => array("W61P", 1), 
		"CA3A" => array("W61CA", 1), 
		"KC3D" => array("W61K", 1), 
		"SA3B" => array("W54SA", 1), 
		"SH34" => array("W61SH", 1), 
		"SN3C" => array("W54S", 1), 
		"TS3H" => array("W56T", 1), 
		"TS3G" => array("W55T", 1), 
		"HI3B" => array("W53H", 1), 
		"KC3B" => array("W53K", 1), 
		"ST33" => array("INFOBAR 2", 1), 
		"KC3E" => array("W44K II (Camera Less)", 1), 
		"SN3B" => array("W53S", 1), 
		"CA39" => array("W53CA", 1), 
		"ST32" => array("W53SA", 1), 
		"TS3E" => array("W54T", 1), 
		"SH33" => array("W52SH", 1), 
		"CA38" => array("W52CA", 1), 
		"MA32" => array("W52P", 1), 
		"SN3A" => array("W52S", 1), 
		"TS3D" => array("W53T", 1), 
		"SA3A" => array("W52SA", 1), 
		"HI3A" => array("W52H", 1), 
		"KC3A" => array("MEDIA SKIN", 1), 
		"SH32" => array("W51SH", 1), 
		"SN39" => array("W51S", 1), 
		"TS3C" => array("W52T", 1), 
		"TS3B" => array("W51T", 1), 
		"SA39" => array("W51SA", 1), 
		"HI39" => array("W51H", 1), 
		"CA37" => array("W51CA", 1), 
		"MA31" => array("W51P", 1), 
		"KC39" => array("W51K", 1), 
		"TS39" => array("DRAPE", 1), 
		"TS3A" => array("W47T", 1), 
		"SN38" => array("W44S", 1), 
		"KC38" => array("W44K/K II", 1), 
		"SA38" => array("W43SA", 1), 
		"TS38" => array("W45T", 1), 
		"CA35" => array("W43CA", 1), 
		"HI38" => array("W43H/H II", 1), 
		"SN37" => array("W43S", 1), 
		"KC37" => array("W43K", 1), 
		"ST31" => array("W42SA", 1), 
		"SH31" => array("W41SH", 1), 
		"CA34" => array("W42CA", 1), 
		"HI37" => array("W42H", 1), 
		"TS37" => array("W44T/T II/T III", 1), 
		"TS35" => array("neon", 1), 
		"TS36" => array("W43T", 1), 
		"SN36" => array("W42S", 1), 
		"KC36" => array("W42K", 1), 
		"KC35" => array("W41K", 1), 
		"SA36" => array("W41SA", 1), 
		"TS34" => array("W41T", 1), 
		"HI36" => array("W41H", 1), 
		"CA33" => array("W41CA", 1), 
		"SN34" => array("W41S", 1), 
		"HI34" => array("PENCK", 1), 
		"SA35" => array("W33SA/SA II", 1), 
		"TS33" => array("W32T", 1), 
		"SA34" => array("W32SA", 1), 
		"KC34" => array("W32K", 1), 
		"HI35" => array("W32H", 1), 
		"SN33" => array("W32S", 1), 
		"SN35" => array("W32S", 1), 
		"CA32" => array("W31CA", 1), 
		"TS32" => array("W31T", 1), 
		"SN32" => array("W31S", 1), 
		"KC33" => array("W31K/K II", 1), 
		"SA33" => array("W31SA/SA II", 1), 
		"SA32" => array("W22SA", 1), 
		"HI33" => array("W22H", 1), 
		"CA31" => array("W21CA/CA II", 1), 
		"TS31" => array("W21T", 1), 
		"SA31" => array("W21SA", 1), 
		"SN31" => array("W21S", 1), 
		"KC32" => array("W21K", 1), 
		"HI32" => array("W21H", 1), 
		"KC31" => array("W11K", 1), 
		"HI31" => array("W11H", 1), 
		"TS3T" => array("E08T", 1),
		"KC3T" => array("E07K", 1),
		"SH3A" => array("E06SH", 1),
		"SH39" => array("E05SH", 1), 
		"CA36" => array("E03CA", 1), 
		"SA37" => array("E02SA", 1), 
		"ST2C" => array("Sweets cute", 0), 
		"ST29" => array("Sweets pure", 0), 
		"CA28" => array("G'zOne TYPE-R", 0), 
		"ST26" => array("Sweets", 0), 
		"ST25" => array("talby", 0), 
		"ST22" => array("INFOBAR", 0), 
		"KC2A" => array("A5528K", 0), 
		"SA2A" => array("A5527SA", 0), 
		"KC29" => array("A5526K", 0), 
		"ST2D" => array("A5525SA", 0), 
		"TS2D" => array("A5523T", 0), 
		"SA29" => array("A5522SA", 0), 
		"KC28" => array("A5521K", 0), 
		"ST2A" => array("A5520SA/SA II", 0), 
		"ST28" => array("A5518SA", 0), 
		"TS2C" => array("A5517T", 0), 
		"TS2B" => array("A5516T", 0), 
		"KC27" => array("A5515K", 0), 
		"ST27" => array("A5514SA", 0), 
		"CA27" => array("A5512CA", 0), 
		"TS2A" => array("A5511T", 0), 
		"TS29" => array("A5509T", 0), 
		"ST24" => array("A5507SA", 0), 
		"TS28" => array("A5506T", 0), 
		"SA27" => array("A5505SA", 0), 
		"TS27" => array("A5504T", 0), 
		"SA26" => array("A5503SA", 0), 
		"KC24" => array("A5502K", 0), 
		"KC25" => array("A5502K", 0), 
		"TS26" => array("A5501T", 0), 
		"CA26" => array("A5407CA", 0), 
		"CA25" => array("A5406CA", 0), 
		"ST23" => array("A5405SA", 0), 
		"SN25" => array("A5404S", 0), 
		"CA24" => array("A5403CA", 0), 
		"SN24" => array("A5402S", 0), 
		"CA23" => array("A5401CA II", 0), 
		"CA23" => array("A5401CA", 0), 
		"ST21" => array("A5306ST", 0), 
		"KC22" => array("A5305K", 0), 
		"TS24" => array("A5304T", 0), 
		"HI24" => array("A5303H II", 0), 
		"HI23" => array("A5303H", 0), 
		"CA22" => array("A5302CA", 0), 
		"TS23" => array("A5301T", 0), 
		"SA22" => array("A3015SA", 0), 
		"PT22" => array("A3016PT", 0), 
		"PT21" => array("A1405PT", 0), 
		"SN29" => array("A1404S/S II", 0), 
		"KC26" => array("A1403K/B01K", 0), 
		"SN27" => array("A1402S", 0), 
		"SN28" => array("A1402S II (Camera Less)", 0), 
		"SN26" => array("A1402S", 0), 
		"KC23" => array("A1401K", 0), 
		"SA28" => array("A1305SA", 0), 
		"TS25" => array("A1304T II", 0), 
		"TS25" => array("A1304T II", 0), 
		"TS25" => array("A1304T (Camera Less)", 0), 
		"SA25" => array("A1303SA", 0), 
		"SA24" => array("A1302SA", 0), 
		"SN23" => array("A1301S", 0), 
		"ST14" => array("A1014ST", 0), 
		"KC15" => array("A1013K", 0), 
		"SN21" => array("A3014S", 0), 
		"TS22" => array("A3013T", 0), 
		"CA21" => array("A3012CA", 0), 
		"SA21" => array("A3011SA", 0), 
		"SN22" => array("A1101S", 0), 
		"KC14" => array("A1012K", 0), 
		"ST13" => array("A1011ST", 0), 
		"TS21" => array("C5001T", 0), 
		"MA21" => array("C3003P", 0), 
		"KC21" => array("C3002K", 0), 
		"HI21" => array("C3001H", 0), 
		"SN17" => array("C1002S", 0), 
		"SY15" => array("C1001SA", 0), 
		"CA14" => array("C452CA", 0), 
		"HI14" => array("C451H", 0), 
		"TS14" => array("C415T", 0), 
		"KC13" => array("C414K II", 0), 
		"KC13" => array("C414K", 0), 
		"SN15" => array("C413S", 0), 
		"SN16" => array("C413S", 0), 
		"SY14" => array("C412SA", 0), 
		"ST12" => array("C411ST", 0), 
		"TS13" => array("C410T", 0), 
		"CA13" => array("C409CA", 0), 
		"MA13" => array("C408P", 0), 
		"HI13" => array("C407H", 0), 
		"SN13" => array("C406S", 0), 
		"SY13" => array("C405SA", 0), 
		"SN12" => array("C404S", 0), 
		"SN14" => array("C404S", 0), 
		"ST11" => array("C403ST", 0), 
		"DN11" => array("C402DE", 0), 
		"SY12" => array("C401SA", 0), 
	);
	// http://www.au.kddi.com/ezfactory/tec/spec/3.html
	self::$pictograms = array (
		'1'   => "\xf6\x59", // u!v
		'2'   => "\xf6\x5a", // u!v
		'3'   => "\xf6\x5b", // u?v
		'4'   => "\xf7\x48", // uQv
		'5'   => "\xf7\x49", // Op1
		'6'   => "\xf7\x4a", // EOp1
		'7'   => "\xf7\x4b", // Op2
		'8'   => "\xf7\x4c", // EOp2
		'9'   => "\xf7\x4d", // lp 1
		'10'  => "\xf7\x4e", // lp 2
		'11'  => "\xf7\x4f", // CtH[VV{
		'12'  => "\xf6\x9a", // COX
		'13'  => "\xf6\xea", // Xs[J[
		'14'  => "\xf7\x96", // h}[N
		'15'  => "\xf6\x5e", //  1
		'16'  => "\xf6\x5f", // Ȃ
		'17'  => "\xf7\x50", // lp 1
		'18'  => "\xf7\x51", // lp 2
		'19'  => "\xf7\x52", // H` 1
		'20'  => "\xf7\x53", // H` 2
		'21'  => "\xf7\x54", // lp 1
		'22'  => "\xf7\x55", // lp 2
		'23'  => "\xf7\x56", // H` 1
		'24'  => "\xf7\x57", // H` 2
		'25'  => "\xf7\x97", // rv
		'26'  => "\xf7\x58", // vX
		'27'  => "\xf7\x59", // }CiX
		'28'  => "\xf7\x5a", //  1
		'29'  => "\xf7\x5b", //  1
		'30'  => "\xf7\x5c", //  1
		'31'  => "\xf7\x5d", // ۂɎ΂ߐ
		'32'  => "\xf7\x5e", // Op 1
		'33'  => "\xf7\x5f", // Op 1
		'34'  => "\xf7\x60", // Op 2
		'35'  => "\xf7\x61", // Op 2
		'36'  => "\xf7\x62", // H` 1
		'37'  => "\xf7\x63", // H` 2
		'38'  => "\xf7\x64", // lp 1
		'39'  => "\xf7\x65", // lp 2
		'40'  => "\xf7\x66", //  1
		'41'  => "\xf7\x67", //  2
		'42'  => "\xf7\x68", //  2 ()
		'43'  => "\xf7\x69", //  2 (E)
		'44'  => "\xf6\x60", // z
		'45'  => "\xf6\x93", // 싅{[
		'46'  => "\xf7\xb1", // v
		'47'  => "\xf6\x61", //  2 ()
		'48'  => "\xf6\xeb", // x
		'49'  => "\xf7\x7c", // vbVs (e)
		'50'  => "\xf6\xd3", // 
		'51'  => "\xf7\xb2", // n[g
		'52'  => "\xf6\x9b", // }eB[j (JNeOX)
		'53'  => "\xf6\xec", // lt
		'54'  => "\xf7\x6a", // g[h}[N (TM)
		'55'  => "\xf7\x6b", // 
		'56'  => "\xf7\x7d", //  1
		'57'  => "\xf7\x98", // v 1
		'58'  => "\xf6\x54", // v 2
		'59'  => "\xf7\x7e", // tbs[fBXN 1
		'60'  => "\xf6\x62", // ̌
		'61'  => "\xf7\x6c", // oc 1
		'62'  => "\xf7\x6d", // oc 2
		'63'  => "\xf7\x6e", // E 1
		'64'  => "\xf7\x6f", //  1
		'65'  => "\xf6\x9c", // }OJbv
		'66'  => "\xf7\x70", // 
		'67'  => "\xf7\x80", // J_[
		'68'  => "\xf6\xd4", // X}CtFCX
		'69'  => "\xf6\x63", //  2
		'70'  => "\xf7\x71", // E 2 (E)
		'71'  => "\xf7\x72", //  2 ()
		'72'  => "\xf6\xed", // WG[
		'73'  => "\xf7\x73", // `FbN}[N 1
		'74'  => "\xf6\xb8", //  (v[h)
		'75'  => "\xf6\x40", //  3
		'76'  => "\xf6\x44", // Xp[N
		'77'  => "\xf6\x4e", // d
		'78'  => "\xf6\xb9", // 
		'79'  => "\xf7\xac", // tH_ 1 ()
		'80'  => "\xf6\xd5", //  1
		'81'  => "\xf7\x74", // Rs[Cg}[N (C)
		'82'  => "\xf7\x75", // WX^[h}[N (R)
		'83'  => "\xf6\x74", // u[tP[X (nhobN)
		'84'  => "\xf7\xad", // tH_ 2 (J)
		'85'  => "\xf7\xb3", // db 1 (vbVz)
		'86'  => "\xf6\xd6", // oRg
		'87'  => "\xf7\x99", // NWbgJ[h
		'88'  => "\xf7\x76", // Op 3
		'89'  => "\xf7\x77", // Op 3
		'90'  => "\xf7\x90", // USA ()
		'91'  => "\xf6\x75", // m[g 3
		'92'  => "\xf7\x81", // Nbv{[h
		'93'  => "\xf7\xb4", // Jbv
		'94'  => "\xf6\xee", // J
		'95'  => "\xf6\x64", // J
		'96'  => "\xf6\x94", // tbg{[
		'97'  => "\xf7\x82", // { 1
		'98'  => "\xf6\x5c", // ֎~
		'99'  => "\xf6\x42", // M
		'100' => "\xf7\x83", // { 2
		'101' => "\xf7\x84", // { 3
		'102' => "\xf7\x85", // { 4
		'103' => "\xf7\x86", //  2
		'104' => "\xf6\xef", // ͂
		'105' => "\xf7\x87", // Ђ߂J_[
		'106' => "\xf6\x76", // `PbgELbv
		'107' => "\xf6\x65", // 
		'108' => "\xf6\xfa", // 
		'109' => "\xf7\x9a", // ؎ (CHECK)
		'110' => "\xf6\xf0", // rfIJ
		'111' => "\xf7\x9b", // nfBJ
		'112' => "\xf6\x84", // 
		'113' => "\xf6\xbd", //  (`[bv)
		'114' => "\xf7\x9c", // iCt
		'115' => "\xf7\x9d", // rfIe[v
		'116' => "\xf6\xd7", // ߂
		'117' => "\xf7\x78", //  1
		'118' => "\xf7\x79", //  2
		'119' => "\xf6\xf1", // ނ߂
		'120' => "\xf6\xf2", // 
		'121' => "\xf7\x88", // m[g 1
		'122' => "\xf6\x77", // m[g 2 (J)
		'123' => "\xf7\x9e", // {g & ibg
		'124' => "\xf6\xf3", //  (nCq[)
		'125' => "\xf6\x8a", // 
		'126' => "\xf7\x9f", // tbs[ 2
		'127' => "\xf7\x91", // `[g (_Ot)
		'128' => "\xf7\x92", // Ot 1 (܂Ot)
		'129' => "\xf6\xf4", // [{bNX
		'130' => "\xf7\xa0", // d
		'131' => "\xf7\x89", // Roldex
		'132' => "\xf7\x7a", // `FbN}[N 2
		'133' => "\xf6\xa7", // ͂
		'134' => "\xf6\xba", // 
		'135' => "\xf7\xa1", // dr
		'136' => "\xf7\x7b", // XN[
		'137' => "\xf7\x8a", // т傤
		'138' => "\xf6\xf5", // O
		'139' => "\xf7\xa2", // hD
		'140' => "\xf6\xd8", // wmF
		'141' => "\xf6\xd9", // wmFE
		'142' => "\xf7\x8b", // 䒠
		'143' => "\xf6\x78", // Nbv
		'144' => "\xf6\xa8", // v[g
		'145' => "\xf6\xf6", // D
		'146' => "\xf6\x85", // Sn 1 (iCtƃtH[N)
		'147' => "\xf7\x8c", // {
		'148' => "\xf6\x8b", // gbN
		'149' => "\xf6\x79", // Gsc
		'150' => "\xf7\xa3", // S (PDC)
		'151' => "\xf7\xae", //  2
		'152' => "\xf7\xa4", // `
		'153' => "\xf7\xaf", // M BOX
		'154' => "\xf7\xb0", // M BOX
		'155' => "\xf6\xf7", // db 2 (b)
		'156' => "\xf6\x86", // HE
		'157' => "\xf7\x8d", // K 1 ()
		'158' => "\xf6\x7a", // K 2 (Op)
		'159' => "\xf7\x93", // Ot 2
		'160' => "\xf6\x9d", // H 2 (}K)
		'161' => "\xf7\xa5", // db 3 (g)
		'162' => "\xf7\xa6", // RZg
		'163' => "\xf6\xda", // Ƒ
		'164' => "\xf7\xa7", // N
		'165' => "\xf6\xf8", // pbP[W
		'166' => "\xf6\xf9", // FAX
		'167' => "\xf6\x66", // Ƃǂ܂
		'168' => "\xf6\x8c", // s@
		'169' => "\xf6\x8d", // {[g (D)
		'170' => "\xf6\xa1", // TCR
		'171' => "\xf7\xa8", // V
		'172' => "\xf6\x8e", // d
		'173' => "\xf7\xa9", // SuN
		'174' => "\xf7\xaa", // uN
		'175' => "\xf7\xab", // 41uN
		'176' => "\xf6\x55", // i
		'177' => "\xf6\x56", // ։
		'178' => "\xf6\x57", // Ԉ֎q
		'179' => "\xf6\x58", // t}[N
		'180' => "\xf6\xfb", // lp 1
		'181' => "\xf6\xfc", // lp 2
		'182' => "\xf7\x40", // lp 3
		'183' => "\xf7\x41", // lp 4
		'184' => "\xf7\x42", // lp 5
		'185' => "\xf7\x43", // lp 6
		'186' => "\xf7\x44", // lp 7
		'187' => "\xf7\x45", // lp 8
		'188' => "\xf7\x46", // lp 9
		'189' => "\xf7\x47", // lp 10
		'190' => "\xf6\x41", // 䕗
		'191' => "\xf6\x5d", // 䂫
		'192' => "\xf6\x67", //  (Ђ)
		'193' => "\xf6\x68", //  ()
		'194' => "\xf6\x69", //  (oq)
		'195' => "\xf6\x6a", //  (ɍ)
		'196' => "\xf6\x6b", //  ()
		'197' => "\xf6\x6c", //  (Ƃߍ)
		'198' => "\xf6\x6d", //  (V)
		'199' => "\xf6\x6e", //  ()
		'200' => "\xf6\x6f", //  (č)
		'201' => "\xf6\x70", //  (€)
		'202' => "\xf6\x71", //  (r)
		'203' => "\xf6\x72", //  ()
		'204' => "\xf6\x73", //  (ւт)
		'205' => "\xf6\x7b", // ATM
		'206' => "\xf6\x7c", // 24 HOURS (Rrj)
		'207' => "\xf6\x7d", // gC
		'208' => "\xf6\x7e", // p[LO
		'209' => "\xf6\x80", // oX
		'210' => "\xf6\x81", // Aei (ʒu}[N)
		'211' => "\xf6\x82", // ` (}[N)
		'212' => "\xf6\x83", // s
		'213' => "\xf7\x8e", // KXX^h
		'214' => "\xf7\x8f", // n}
		'215' => "\xf6\x87", // ]
		'216' => "\xf6\x88", // oX
		'217' => "\xf6\x89", // V
		'218' => "\xf6\x43", // }\
		'219' => "\xf6\x8f", // TbJ[
		'220' => "\xf6\x90", // ejX
		'221' => "\xf6\x91", // Xm[{[h
		'222' => "\xf6\x92", // `FbJ[tbO ([^[X|[c)
		'223' => "\xf6\x45", // Vn
		'224' => "\xf6\x95", // 
		'225' => "\xf6\x96", //  (Ԃ傤)
		'226' => "\xf6\x97", // f ()
		'227' => "\xf6\x98", // ̋
		'228' => "\xf6\x99", // ^[
		'229' => "\xf6\x46", // Xbg (777)
		'230' => "\xf6\x47", //  (A^̂)
		'231' => "\xf6\x9e", // I|
		'232' => "\xf6\x9f", // Q[̃Rg[
		'233' => "\xf6\xa0", // ܋
		'234' => "\xf6\xa2", // NX}Xc[
		'235' => "\xf6\xa3", // Ԍ ()
		'236' => "\xf6\xa4", // 
		'237' => "\xf6\xa5", //  (jE̊)
		'238' => "\xf6\xa6", // XCJ
		'239' => "\xf6\xa9", // P[L
		'240' => "\xf6\xaa", // tCp (ڋʏĂ)
		'241' => "\xf6\xab", // 
		'242' => "\xf6\xac", // ӂ
		'243' => "\xf6\xad", // C`S
		'244' => "\xf6\xae", // ɂ
		'245' => "\xf6\xaf", // no[K[ (t@[Xgt[h)
		'246' => "\xf6\x48", // 
		'247' => "\xf6\xb0", // 
		'248' => "\xf6\xb1", // 
		'249' => "\xf6\xb2", // 
		'250' => "\xf6\xb3", // 
		'251' => "\xf6\xb4", // L
		'252' => "\xf6\xb5", // yM
		'253' => "\xf6\xb6", // 
		'254' => "\xf6\xb7", // Ԃ
		'255' => "\xf6\xbb", // ₵̂
		'256' => "\xf6\xbc", // Ђ܂
		'257' => "\xf6\x49", //  1 (ꂵJI)
		'258' => "\xf6\x4a", //  2 (JI)
		'259' => "\xf6\x4b", //  3 (ȂJI)
		'260' => "\xf6\x4c", //  4 (ꂽJI)
		'261' => "\xf6\x4d", //  (ZZZ...)
		'262' => "\xf6\xbe", // { (Jb)
		'263' => "\xf6\xbf", //  (܁E)
		'264' => "\xf6\xc0", // 炩 (ׂ)
		'265' => "\xf6\x4f", // n[g 2 (Ă)
		'266' => "\xf6\x50", // n[g 3 (傫 & )
		'267' => "\xf6\x51", // Xp[N 2 (L}[N)
		'268' => "\xf6\x52", // e
		'269' => "\xf6\x53", // 
		'270' => "\xf6\xc1", // { (SOS)
		'271' => "\xf6\xc2", // ͂
		'272' => "\xf6\xc3", // n[g 5 (Ă)
		'273' => "\xf6\xc4", // LX}[N
		'274' => "\xf6\xc5", // Fl
		'275' => "\xf6\xc6", // Ȃ
		'276' => "\xf6\xc7", //  ()
		'277' => "\xf6\xc8", // 
		'278' => "\xf6\xc9", // Ԋ
		'279' => "\xf6\xca", // ۔
		'280' => "\xf6\xcb", // 100__
		'281' => "\xf6\xcc", // p`
		'282' => "\xf6\xcd", // _bV
		'283' => "\xf6\xce", // E`}[N
		'284' => "\xf6\xcf", // lwTC
		'285' => "\xf6\xd0", // }
		'286' => "\xf6\xd1", // ǂ
		'287' => "\xf6\xd2", // уTC (w)
		'288' => "\xf6\xdb", // er
		'289' => "\xf6\xdc", // }CN
		'290' => "\xf6\xdd", // z
		'291' => "\xf6\xde", // fB
		'292' => "\xf6\xdf", // M^[ (GL)
		'293' => "\xf6\xe0", // oCI (NVbN)
		'294' => "\xf6\xe1", // wbhtH
		'295' => "\xf6\xe2", // g
		'296' => "\xf6\xe3", // ANV (sXg)
		'297' => "\xf6\xe4", // GXe
		'298' => "\xf7\x94", // EZ }[N
		'299' => "\xf7\x95", //  (FREE)
		'300' => "\xf6\xe5", // CD/DVD
		'301' => "\xf6\xe6", // wl
		'302' => "\xf6\xe7", // UFO
		'303' => "\xf6\xe8", // XV (UP!)
		'304' => "\xf6\xe9", // ˊ ()
		'305' => "\xf7\xb5", // 
		'306' => "\xf7\xb6", // St
		'307' => "\xf7\xb7", // oXPbg{[
		'308' => "\xf7\xb8", // |Pbgx
		'309' => "\xf7\xb9", // A[g
		'310' => "\xf7\xba", // 
		'311' => "\xf7\xbb", // Cxg (T[JX)
		'312' => "\xf7\xbc", // {
		'313' => "\xf7\xbd", // o[Xf[
		'314' => "\xf7\xbe", // Xy[h
		'315' => "\xf7\xbf", // _C
		'316' => "\xf7\xc0", // Nu
		'317' => "\xf7\xc1", // 
		'318' => "\xf7\xc2", // 
		'319' => "\xf7\xc3", //  (`L)
		'320' => "\xf7\xc4", //  (p[)
		'321' => "\xf7\xc5", // V
		'322' => "\xf7\xc6", // ⌇
		'323' => "\xf7\xc7", // 
		'324' => "\xf7\xc8", // NA
		'325' => "\xf7\xc9", // lp 0
		'326' => "\xf7\xca", //  (OK)
		'327' => "\xf7\xcb", // ӂӂ ()
		'328' => "\xf7\xcc", // 킢
		'329' => "\xf7\xcd", // ǂ (Ռ)
		'330' => "\xf7\xce", //  (юU銾)
		'331' => "\xf7\xcf", // C[W[vX
		'332' => "\xf7\xd0", // n
		'333' => "\xf7\xd1", // [
		'334' => "\xf7\xe5", // NEW
		'335' => "\xf7\xe6", // am
		'336' => "\xf7\xe7", // amC
		'337' => "\xf7\xe8", // p\R
		'338' => "\xf7\xe9", // WI
		'339' => "\xf7\xea", // o
		'340' => "\xf7\xeb", // `y
		'341' => "\xf7\xec", // nS
		'342' => "\xf7\xed", // xmR
		'343' => "\xf7\xee", // 
		'344' => "\xf7\xef", // Vg
		'345' => "\xf7\xf0", // g
		'346' => "\xf7\xf1", // 
		'347' => "\xf7\xf2", // ˂
		'348' => "\xf7\xf3", // EBN ()
		'349' => "\xf7\xf4", // ڂn[g ()
		'350' => "\xf7\xf5", // VbLO ()
		'351' => "\xf7\xf6", //  ()
		'352' => "\xf7\xf7", // 
		'353' => "\xf7\xf8", // Pbg
		'354' => "\xf7\xf9", // 
		'355' => "\xf7\xfa", // `[ (LXĂ)
		'356' => "\xf7\xfb", // n}[
		'357' => "\xf7\xfc", // łグԉ
		'358' => "\xf3\x40", // ͂t
		'359' => "\xf3\x41", // d΂
		'360' => "\xf3\x42", // 
		'361' => "\xf3\x43", // Lv
		'362' => "\xf3\x44", // 
		'363' => "\xf3\x45", // VS (o[TX)
		'364' => "\xf3\x46", // gtB[
		'365' => "\xf3\x47", // J
		'366' => "\xf3\x48", // XyC
		'367' => "\xf3\x49", // VA
		'368' => "\xf3\x4a", // H
		'369' => "\xf3\x4b", // C
		'370' => "\xf3\x4c", // j}[N
		'371' => "\xf3\x4d", // [X
		'372' => "\xf3\x4e", // 
		'373' => "\xf3\x4f", // 
		'374' => "\xf3\x50", // |X
		'375' => "\xf3\x51", // X֋
		'376' => "\xf3\x52", // a@
		'377' => "\xf3\x53", // wZ
		'378' => "\xf3\x54", // ze
		'379' => "\xf3\x55", // D
		'380' => "\xf3\x56", // 18
		'381' => "\xf3\x57", // 
		'382' => "\xf3\x58", // COOL!
		'383' => "\xf3\x59", // }[N
		'384' => "\xf3\x5a", // UE}[N
		'385' => "\xf3\x5b", // ID}[N
		'386' => "\xf3\x5c", // }[N
		'387' => "\xf3\x5d", // }[N
		'388' => "\xf3\x5e", // w}[N
		'389' => "\xf3\x5f", // cƒ}[N
		'390' => "\xf3\x60", // w
		'391' => "\xf3\x61", // w
		'392' => "\xf3\x62", // 肢 ()
		'393' => "\xf3\x63", // }i[[h
		'394' => "\xf3\x64", // dOFF
		'395' => "\xf3\x65", // 
		'396' => "\xf3\x66", // lN^C
		'397' => "\xf3\x67", // nCrXJX
		'398' => "\xf3\x68", // ԑ
		'399' => "\xf3\x69", // T{e
		'400' => "\xf3\x6a", // q & t
		'401' => "\xf3\x6b", // t (r[)
		'402' => "\xf3\x6c", // j}[N
		'403' => "\xf3\x6d", // ז (JvZ)
		'404' => "\xf3\x6e", // D
		'405' => "\xf3\x6f", // NbJ[
		'406' => "\xf3\x70", // eznavigation
		'407' => "\xf3\x71", // Xq
		'408' => "\xf3\x72", // Ou[c
		'409' => "\xf3\x73", // lC
		'410' => "\xf3\x74", // e@
		'411' => "\xf3\x75", // 
		'412' => "\xf3\x76", // 
		'413' => "\xf3\x77", // rLj
		'414' => "\xf3\x78", // n[g (gv)
		'415' => "\xf3\x79", // n[g
		'416' => "\xf3\x7a", // n[g
		'417' => "\xf3\x7b", // ΃n[g
		'418' => "\xf3\x7c", // n[g
		'419' => "\xf3\x7d", // n[g
		'420' => "\xf3\x7e", // 炫
		'421' => "\xf3\x80", // XL[
		'422' => "\xf3\x81", // 
		'423' => "\xf3\x82", // {
		'424' => "\xf3\x83", // Hp
		'425' => "\xf3\x84", // \tgN[
		'426' => "\xf3\x85", // |eg
		'427' => "\xf3\x86", // 
		'428' => "\xf3\x87", // ׂ
		'429' => "\xf3\x88", // ͂
		'430' => "\xf3\x89", // XpQeB
		'431' => "\xf3\x8a", // J[
		'432' => "\xf3\x8b", // ł
		'433' => "\xf3\x8c", // i
		'434' => "\xf3\x8d", // 
		'435' => "\xf3\x8e", // ݂
		'436' => "\xf3\x8f", // g}g
		'437' => "\xf3\x90", // Ȃ
		'438' => "\xf3\x91", // ٓ
		'439' => "\xf3\x92", // 
		'440' => "\xf3\x93", // ӂ ()
		'441' => "\xf3\x94", // ڂ ()
		'442' => "\xf3\x95", // ւ ()
		'443' => "\xf3\x96", // s ()
		'444' => "\xf3\x97", // 킩
		'445' => "\xf3\x98", // 
		'446' => "\xf3\x99", // ĂĂ ()
		'447' => "\xf3\x9a", //  ()
		'448' => "\xf3\x9b", // ׂЂ
		'449' => "\xf3\x9c", // M ()
		'450' => "\xf3\x9d", //  ()
		'451' => "\xf3\x9e", // т ()
		'452' => "\xf3\x9f", //  ()
		'453' => "\xf3\xa0", // y
		'454' => "\xf3\xa1", // ɂɂ ()
		'455' => "\xf3\xa2", // `[ 2 ()
		'456' => "\xf3\xa3", // `b ()
		'457' => "\xf3\xa4", // @
		'458' => "\xf3\xa5", // 
		'459' => "\xf3\xa6", // S^肢
		'460' => "\xf3\xa7", // 
		'461' => "\xf3\xa8", // OK! (wŊۃTC)
		'462' => "\xf3\xa9", // u[CO (w)
		'463' => "\xf3\xaa", // oCoC
		'464' => "\xf3\xab", // NG (lR)
		'465' => "\xf3\xac", // OK! 2 (lR)
		'466' => "\xf3\xad", // ӂ (lR)
		'467' => "\xf3\xae", // Jbv
		'468' => "\xf3\xaf", // oj[
		'469' => "\xf3\xb0", // gybg
		'470' => "\xf3\xb1", // r[h
		'471' => "\xf3\xb2", // j
		'472' => "\xf3\xb3", // h
		'473' => "\xf3\xb4", // ~}
		'474' => "\xf3\xb5", // pgJ[
		'475' => "\xf3\xb6", // WFbgR[X^[
		'476' => "\xf3\xb7", // 叼
		'477' => "\xf3\xb8", // Ղ
		'478' => "\xf3\xb9", // Ǝ
		'479' => "\xf3\xba", // w
		'480' => "\xf3\xbb", // ̂ڂ
		'481' => "\xf3\xbc", // P
		'482' => "\xf3\xbd", // ԉ
		'483' => "\xf3\xbe", // X
		'484' => "\xf3\xbf", // ԉ
		'485' => "\xf3\xc0", // L
		'486' => "\xf3\xc1", // 
		'487' => "\xf3\xc2", // nEB
		'488' => "\xf3\xc3", // 
		'489' => "\xf3\xc4", // T^
		'490' => "\xf3\xc5", // ^ꐯ
		'491' => "\xf3\xc6", // 
		'492' => "\xf3\xc7", // ze 2
		'493' => "\xf3\xc8", // ̏o
		'494' => "\xf3\xc9", // VNnbg
		'495' => "\xf3\xca", // fp[g
		'496' => "\xf3\xcb", //  ({)
		'497' => "\xf3\xcc", //  ([bp)
		'498' => "\xf3\xcd", // H 2
		'499' => "\xf3\xce", // tX
		'500' => "\xf7\xd2", // I[vEF[u
		'501' => "\xf7\xd3", // bNmF
		'502' => "\xf7\xd4", // 啶
		'503' => "\xf7\xd5", // 
		'504' => "\xf7\xd6", // 
		'505' => "\xf7\xd7", // L
		'506' => "\xf7\xd8", // ANZvg
		'507' => "\xf7\xd9", // `FbN{bNX
		'508' => "\xf7\xda", // GfBbg
		'509' => "\xf7\xdb", // WI{^
		'510' => "\xf7\xdc", //  (ዾ)
		'511' => "\xf7\xdd", // ߂
		'512' => "\xf7\xde", // Cɓ
		'513' => "\xf7\xdf", // I
		'514' => "\xf7\xe0", // z[
		'515' => "\xf7\xe1", // M 1
		'516' => "\xf7\xe2", // }[N
		'517' => "\xf7\xe3", // l ()
		'518' => "\xf7\xe4", // ēǂݍ
		'700' => "\xf3\xcf", // hCc
		'701' => "\xf3\xd0", // C^A
		'702' => "\xf3\xd1", // CMX
		'703' => "\xf3\xd2", // 
		'704' => "\xf3\xd3", // ؍
		'705' => "\xf3\xd4", // l
		'706' => "\xf3\xd5", // l
		'707' => "\xf3\xd6", // Chl
		'708' => "\xf3\xd7", // 
		'709' => "\xf3\xd8", // ΂
		'710' => "\xf3\xd9", // Ԃ
		'711' => "\xf3\xda", // H̐l
		'712' => "\xf3\xdb", // Pl
		'713' => "\xf3\xdc", // CJ
		'714' => "\xf3\xdd", // _X
		'715' => "\xf3\xde", // Mы
		'716' => "\xf3\xdf", // 
		'717' => "\xf3\xe0", // 
		'718' => "\xf3\xe1", // RA
		'719' => "\xf3\xe2", // zX^C
		'720' => "\xf3\xe3", // wr
		'721' => "\xf3\xe4", // {
		'722' => "\xf3\xe5", // ڂ
		'723' => "\xf3\xe6", // ӂԂ炭
		'724' => "\xf3\xe7", // A^
		'725' => "\xf3\xe8", // B^
		'726' => "\xf3\xe9", // O^
		'727' => "\xf3\xea", // AB^
		'728' => "\xf3\xeb", // 
		'729' => "\xf3\xec", // Xj[J[
		'730' => "\xf3\xed", // 
		'731' => "\xf3\xee", // J[u
		'732' => "\xf3\xef", // J[u
		'733' => "\xf3\xf0", // u!?v
		'734' => "\xf3\xf1", // u!!v
		'735' => "\xf3\xf2", // 
		'736' => "\xf3\xf3", // 
		'737' => "\xf3\xf4", // pCibv
		'738' => "\xf3\xf5", // Ԃǂ
		'739' => "\xf3\xf6", // oii
		'740' => "\xf3\xf7", // Ƃ낱
		'741' => "\xf3\xf8", // ̂
		'742' => "\xf3\xf9", // I
		'743' => "\xf3\xfa", // 
		'744' => "\xf3\xfb", // ₫
		'745' => "\xf3\xfc", // sU
		'746' => "\xf4\x40", // ^[L[
		'747' => "\xf4\x41", // [
		'748' => "\xf4\x42", // gsJhN
		'749' => "\xf4\x43", // C
		'750' => "\xf4\x44", // sAm
		'751' => "\xf4\x45", // T[tB
		'752' => "\xf4\x46", // ނ
		'753' => "\xf4\x47", // {EO
		'754' => "\xf4\x48", // Ȃ܂͂
		'755' => "\xf4\x49", // V
		'756' => "\xf4\x4a", // p_
		'757' => "\xf4\x4b", // ׁ[
		'758' => "\xf4\x4c", // Ԃ̕@
		'759' => "\xf4\x4d", // 
		'760' => "\xf4\x4e", // ACXN[
		'761' => "\xf4\x4f", // h[ic
		'762' => "\xf4\x50", // NbL[
		'763' => "\xf4\x51", // `R
		'764' => "\xf4\x52", // LfB ()
		'765' => "\xf4\x53", // LfB (؂؂)
		'766' => "\xf4\x54", //  ()
		'767' => "\xf4\x55", // 킴 ()
		'768' => "\xf4\x56", //  ()
		'769' => "\xf4\x57", // ΎR
		'770' => "\xf4\x58", // {̃n[g
		'771' => "\xf4\x59", // puABCv
		'772' => "\xf4\x5a", // v
		'773' => "\xf4\x5b", // ~co`
		'774' => "\xf4\x5c", // egEV
		'775' => "\xf4\x5d", // I|bg
		'776' => "\xf4\x5e", // 
		'777' => "\xf4\x5f", // Ĥ͂D
		'778' => "\xf4\x60", // ڂ܂鎞̋L
		'779' => "\xf4\x61", // Ձ[ (킢{)
		'780' => "\xf4\x62", // Ձ[ (킢{) (lR)
		'781' => "\xf4\x63", // V̐
		'782' => "\xf4\x64", // `[ (lR)
		'783' => "\xf4\x65", // ɂ (lR)
		'784' => "\xf4\x66", // [
		'785' => "\xf4\x67", // ΂ (lR)
		'786' => "\xf4\x68", // ΂ ()
		'787' => "\xf4\x69", // ڂn[g (lR)
		'788' => "\xf4\x6a", // ق[ (lR)
		'789' => "\xf4\x6b", // ق[ ()
		'790' => "\xf4\x6c", // ܂ۂ (lR)
		'791' => "\xf4\x6d", // ܂ۂ ()
		'792' => "\xf4\x6e", //  (lR)
		'793' => "\xf4\x6f", // hX
		'794' => "\xf4\x70", // C
		'795' => "\xf4\x71", // w
		'796' => "\xf4\x72", // ԎD
		'797' => "\xf4\x73", // W[J[
		'798' => "\xf4\x74", // GrtC
		'799' => "\xf4\x75", // e[ACR
		'800' => "\xf4\x76", // l
		'801' => "\xf4\x77", // pgJ[̃v
		'802' => "\xf4\x78", // ezmovie
		'803' => "\xf4\x79", // hLhLĂn[g
		'804' => "\xf4\x7a", // ʌ̂Ђ悱
		'805' => "\xf4\x7b", // W[Y
		'806' => "\xf4\x7c", // n[g[
		'807' => "\xf4\x7d", // z
		'808' => "\xf4\x7e", // E
		'809' => "\xf4\x80", // ㉺
		'810' => "\xf4\x81", // rg
		'811' => "\xf4\x82", // ot
		'812' => "\xf4\x83", // ނ
		'813' => "\xf4\x84", //  (lR)
		'814' => "\xf4\x85", //  ()
		'815' => "\xf4\x86", // C[ACR
		'816' => "\xf4\x87", // n[u
		'817' => "\xf4\x88", //  (O[)
		'818' => "\xf4\x89", // u#v
		'819' => "\xf4\x8a", //  (LN^[)
		'820' => "\xf4\x8b", //  (LN^[)
		'821' => "\xf4\x8c", // ڂ (LN^[)
		'822' => "\xf4\x8d", // 킢{ (LN^[)
	);
	return;
}

/* ==================================================
 * @param	boolean $allow_search_engine
 * @return	boolean $in_network
 */
public function in_network($allow_search_engine = false) {
	return parent::in_network(self::$networks, $allow_search_engine);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => self::$pictograms['257'],
		'icon_biggrin.gif'   => self::$pictograms['454'], 
		'icon_sad.gif'       => self::$pictograms['259'], 
		'icon_surprised.gif' => self::$pictograms['451'], 
		'icon_eek.gif'       => self::$pictograms['451'], 
		'icon_confused.gif'  => self::$pictograms['444'], 
		'icon_cool.gif'      => self::$pictograms['382'], 
		'icon_mad.gif'       => self::$pictograms['258'], 
		'icon_razz.gif'      => self::$pictograms['264'], 
		'icon_neutral.gif'   => self::$pictograms['440'], 
		'icon_wink.gif'      => self::$pictograms['348'], 
		'icon_lol.gif'       => self::$pictograms['789'], 
		'icon_redface.gif'   => self::$pictograms['446'], // or 349
		'icon_cry.gif'       => self::$pictograms['786'], 
		'icon_evil.gif'      => self::$pictograms['277'],  
		'icon_twisted.gif'   => self::$pictograms['277'], 
		'icon_rolleyes.gif'  => self::$pictograms['444'], 
		'icon_exclaim.gif'   => self::$pictograms['2'], 
		'icon_question.gif'  => self::$pictograms['3'], 
		'icon_idea.gif'      => self::$pictograms['77'], 
		'icon_arrow.gif'     => self::$pictograms['63'], 
		'icon_mrgreen.gif'   => self::$pictograms['814'], 
	);
	$smiles = apply_filters('ktai_smiley_table', $smiles, __CLASS__);
	$smiles = apply_filters('smiley_table/ktai_style.php', $smiles);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function convert_pict($buffer) {
	// http://www.au.kddi.com/email/emoji/taiohyo/
	// http://mb.softbank.jp/mb/service/3G/mail/pictogram/
	// http://www.nttdocomo.co.jp/service/mail/imode_mail/emoji_convert/
	// http://www.willcom-inc.com/ja/service/e_mail/pdf/conversiontable.pdf
	$translated = self::$pictograms + array(
		'se001' => self::$pictograms['80'], // j̎q
		'se002' => self::$pictograms['50'], // ̎q
		'se003' => self::$pictograms['273'], // e (LX}[N)
		'se004' => self::$pictograms['80'], // 
		'se005' => self::$pictograms['50'], // ꂳ
		'se006' => self::$pictograms['335'], // m
		'se007' => self::$pictograms['336'], // u[c
		'se008' => self::$pictograms['94'], // J
		'se009' => self::$pictograms['85'], // db
		'se00a' => self::$pictograms['161'], // gѓdb
		'se00b' => self::$pictograms['166'], // FAX
		'se00c' => self::$pictograms['337'], // p\R
		'se00d' => self::$pictograms['281'], // p`
		'se00e' => self::$pictograms['287'], // GOOD!
		'se00f' => self::$pictograms['284'], // No.1!
		'se010' => self::$pictograms['817'], // O[
		'se011' => self::$pictograms['319'], // `L
		'se012' => self::$pictograms['320'], // p[
		'se013' => self::$pictograms['421'], // XL[
		'se014' => self::$pictograms['306'], // St
		'se015' => self::$pictograms['220'], // ejX
		'se016' => self::$pictograms['45'], // 싅
		'se017' => self::$pictograms['751'], // T[tB
		'se018' => self::$pictograms['219'], // TbJ[
		'se019' => self::$pictograms['203'], // 
		'se01a' => self::$pictograms['248'], // 
		'se01b' => self::$pictograms['125'], // 
		'se01c' => self::$pictograms['169'], // bg
		'se01d' => self::$pictograms['168'], // s@
		'se01e' => self::$pictograms['172'], // d
		'se01f' => self::$pictograms['217'], // V
		'se020' => self::$pictograms['3'], // nei
		'se021' => self::$pictograms['2'], // rbN
		'se022' => self::$pictograms['51'], // n[g}[N
		'se023' => self::$pictograms['265'], // n[guCN
		'se024' => self::$pictograms['46'], // 1
		'se025' => self::$pictograms['46'], // 2
		'se026' => self::$pictograms['46'], // v
		'se027' => self::$pictograms['46'], // 4
		'se028' => self::$pictograms['46'], // 5
		'se029' => self::$pictograms['46'], // 6
		'se02a' => self::$pictograms['46'], // 7
		'se02b' => self::$pictograms['46'], // 8
		'se02c' => self::$pictograms['46'], // 9
		'se02d' => self::$pictograms['46'], // 10
		'se02e' => self::$pictograms['46'], // 11
		'se02f' => self::$pictograms['46'], // 12
		'se030' => self::$pictograms['235'], // Ԍ
		'se031' => self::$pictograms['354'], // Gu
		'se032' => self::$pictograms['339'], // o
		'se033' => self::$pictograms['234'], // NX}X
		'se034' => self::$pictograms['72'], // w
		'se035' => self::$pictograms['72'], // 
		'se036' => self::$pictograms['112'], // 
		'se037' => self::$pictograms['340'], // 
		'se038' => self::$pictograms['156'], // r
		'se039' => self::$pictograms['795'], // w
		'se03a' => self::$pictograms['213'], // K\X^h
		'se03b' => self::$pictograms['342'], // R
		'se03c' => self::$pictograms['289'], // }CN
		'se03d' => self::$pictograms['110'], // f
		'se03e' => self::$pictograms['343'], // y
		'se03f' => self::$pictograms['120'], // JM
		'se040' => '[TbNX]', // TbNX
		'se041' => self::$pictograms['292'], // M^[
		'se042' => self::$pictograms['469'], // gybg
		'se043' => self::$pictograms['146'], // Xg
		'se044' => self::$pictograms['52'], // JNe
		'se045' => self::$pictograms['93'], // R[q[
		'se046' => self::$pictograms['239'], // P[L
		'se047' => self::$pictograms['65'], // r[
		'se048' => self::$pictograms['191'], // 
		'se049' => self::$pictograms['107'], // ܂
		'se04a' => self::$pictograms['44'], //  ()
		'se04b' => self::$pictograms['95'], // J
		'se04c' => self::$pictograms['15'], //  ()
		'se04d' => self::$pictograms['493'], // 
		'se04e' => self::$pictograms['344'], // Vg
		'se04f' => self::$pictograms['251'], // ˂
		'se050' => self::$pictograms['345'], // Ƃ
		'se051' => self::$pictograms['346'], // 
		'se052' => self::$pictograms['134'], // 
		'se053' => self::$pictograms['347'], // ˂
		'se054' => self::$pictograms['246'], // NW
		'se055' => self::$pictograms['252'], // yM
		'se056' => self::$pictograms['454'], // y ()
		'se057' => self::$pictograms['257'], //  ()
		'se058' => self::$pictograms['444'], //  ()
		'se059' => self::$pictograms['258'], // { ()
		'se05a' => self::$pictograms['283'], // E`
		'se101' => self::$pictograms['129'], // [M
		'se102' => self::$pictograms['153'], // [M
		'se103' => self::$pictograms['784'], // [
		'se104' => self::$pictograms['513'], // dbA
		'se105' => self::$pictograms['264'], // AJx[ ()
		'se106' => self::$pictograms['349'], // uu ()
		'se107' => self::$pictograms['350'], // Kr[ ()
		'se108' => self::$pictograms['351'], // ^[ ()
		'se109' => self::$pictograms['249'], // 
		'se10a' => self::$pictograms['352'], // ^R
		'se10b' => self::$pictograms['254'], // Ԃ
		'se10c' => self::$pictograms['274'], // Fl
		'se10d' => self::$pictograms['353'], // Pbg
		'se10e' => self::$pictograms['354'], // 
		'se10f' => self::$pictograms['77'], // d
		'se110' => self::$pictograms['53'], // 
		'se111' => self::$pictograms['355'], // LX
		'se112' => self::$pictograms['144'], // o[Xf[ (v[g)
		'se113' => self::$pictograms['296'], // sXg
		'se114' => self::$pictograms['119'], // ዾ
		'se115' => self::$pictograms['218'], // 
		'se116' => self::$pictograms['356'], // I[NV
		'se117' => self::$pictograms['357'], // ԉ
		'se118' => self::$pictograms['133'], // ݂
		'se119' => self::$pictograms['358'], // t
		'se11a' => self::$pictograms['277'], // 
		'se11b' => self::$pictograms['236'], // ΂
		'se11c' => self::$pictograms['286'], // hN
		'se11d' => self::$pictograms['269'], // t@C[
		'se11e' => self::$pictograms['359'], // ΂
		'se11f' => '[]', // 
		'se120' => self::$pictograms['245'], // no[K[
		'se121' => self::$pictograms['360'], // 
		'se122' => self::$pictograms['361'], // Lv
		'se123' => self::$pictograms['224'], // 
		'se124' => self::$pictograms['223'], // Vn
		'se125' => self::$pictograms['106'], // `Pbg
		'se126' => self::$pictograms['300'], // CD
		'se127' => self::$pictograms['300'], // DVD
		'se128' => self::$pictograms['338'], // WI
		'se129' => self::$pictograms['115'], // rfI
		'se12a' => self::$pictograms['288'], // er
		'se12b' => self::$pictograms['232'], // Q[
		'se12c' => self::$pictograms['343'], // ̂o
		'se12d' => self::$pictograms['362'], // }[W
		'se12e' => self::$pictograms['363'], // Ό
		'se12f' => self::$pictograms['233'], // ܋ (h)
		'se130' => self::$pictograms['231'], // 
		'se131' => self::$pictograms['364'], // gtB[
		'se132' => self::$pictograms['222'], // S[ (`FbJ[tbO)
		'se133' => self::$pictograms['229'], // Xbg (777)
		'se134' => self::$pictograms['248'], // n
		'se135' => self::$pictograms['169'], // 
		'se136' => self::$pictograms['215'], // 
		'se137' => self::$pictograms['368'], // H
		'se138' => '', // j
		'se139' => '', // 
		'se13a' => self::$pictograms['710'], // c
		'se13b' => self::$pictograms['304'], // ˊ
		'se13c' => self::$pictograms['261'], //  (Zzz)
		'se13d' => self::$pictograms['16'], // 
		'se13e' => self::$pictograms['124'], // nCq[
		'se13f' => self::$pictograms['369'], // 
		'se140' => self::$pictograms['207'], // gC
		'se141' => self::$pictograms['13'], // 
		'se142' => self::$pictograms['13'], // m点 (Kz)
		'se143' => self::$pictograms['370'], // j
		'se144' => self::$pictograms['138'], // bNON
		'se145' => self::$pictograms['138'], // bNOFF
		'se146' => self::$pictograms['371'], // X
		'se147' => self::$pictograms['240'], //  ()
		'se148' => self::$pictograms['122'], // {
		'se149' => '[$\\]', // ב֑
		'se14a' => self::$pictograms['373'], // 
		'se14b' => self::$pictograms['210'], // j[X (p{Aei)
		'se14c' => self::$pictograms['271'], // C (͂)
		'se14d' => self::$pictograms['212'], // s
		'se14e' => self::$pictograms['99'], // M
		'se14f' => self::$pictograms['208'], // ԏ
		'se150' => self::$pictograms['209'], // oX
		'se151' => self::$pictograms['207'], // OgC
		'se152' => self::$pictograms['374'], // 
		'se153' => self::$pictograms['375'], // X֋
		'se154' => self::$pictograms['205'], // ATM
		'se155' => self::$pictograms['376'], // a@
		'se156' => self::$pictograms['206'], // Rrj
		'se157' => self::$pictograms['377'], // wZ
		'se158' => self::$pictograms['378'], // ze
		'se159' => self::$pictograms['216'], // oX
		'se15a' => self::$pictograms['125'], // ^NV[
		'se201' => self::$pictograms['800'], // k
		'se202' => self::$pictograms['379'], // D
		'se203' => '[RR]', // ړIn (RR)
		'se204' => self::$pictograms['51'], // r1
		'se205' => self::$pictograms['267'], // r2
		'se206' => self::$pictograms['28'], // r3
		'se207' => self::$pictograms['380'], // 18
		'se208' => self::$pictograms['177'], // ։
		'se209' => self::$pictograms['179'], // S
		'se20a' => self::$pictograms['178'], // oAt[ (Ԉ֎q}[N)
		'se20b' => self::$pictograms['381'], // Aei}[N
		'se20c' => self::$pictograms['414'], // n[g (gv)
		'se20d' => self::$pictograms['315'], // _C (gv)
		'se20e' => self::$pictograms['314'], // Xy[h (gv)
		'se20f' => self::$pictograms['316'], // Nu (gv)
		'se210' => self::$pictograms['818'], // V[v_C
		'se211' => self::$pictograms['299'], // t[_C
		'se212' => self::$pictograms['334'], // V
		'se213' => self::$pictograms['303'], // XV
		'se214' => self::$pictograms['382'], //  (COOL)
		'se215' => self::$pictograms['233'], // L
		'se216' => self::$pictograms['299'], // 
		'se217' => '[]', // z
		'se218' => '[\]', // \
		'se219' => self::$pictograms['40'], // o{^1 (IW)
		'se21a' => self::$pictograms['41'], // o{^2 ()
		'se21b' => self::$pictograms['41'], // o{^4 ()
		'se21c' => self::$pictograms['180'], // 1 (one)
		'se21d' => self::$pictograms['181'], // 2 (two)
		'se21e' => self::$pictograms['182'], // 3 (three)
		'se21f' => self::$pictograms['183'], // 4 (four)
		'se220' => self::$pictograms['184'], // 5 (five)
		'se221' => self::$pictograms['185'], // 6 (six)
		'se222' => self::$pictograms['186'], // 7 (seven)
		'se223' => self::$pictograms['187'], // 8 (eight)
		'se224' => self::$pictograms['188'], // 9 (nine)
		'se225' => self::$pictograms['325'], // 0 (zero)
		'se226' => self::$pictograms['285'], // 
		'se227' => self::$pictograms['383'], // 
		'se228' => self::$pictograms['384'], // T[rX
		'se229' => self::$pictograms['385'], // ID
		'se22a' => self::$pictograms['386'], // 
		'se22b' => self::$pictograms['387'], // 
		'se22c' => self::$pictograms['388'], // w
		'se22d' => self::$pictograms['389'], // cƎ
		'se22e' => self::$pictograms['390'], //  (w)
		'se22f' => self::$pictograms['391'], //  (w)
		'se230' => self::$pictograms['140'], //  (w)
		'se231' => self::$pictograms['141'], // E (w)
		'se232' => self::$pictograms['29'], // 
		'se233' => self::$pictograms['30'], // 
		'se234' => self::$pictograms['63'], // E
		'se235' => self::$pictograms['64'], // 
		'se236' => self::$pictograms['70'], // E
		'se237' => self::$pictograms['42'], // 
		'se238' => self::$pictograms['43'], // E
		'se239' => self::$pictograms['71'], // 
		'se23a' => self::$pictograms['6'], // 
		'se23b' => self::$pictograms['5'], // O
		'se23c' => self::$pictograms['8'], //  
		'se23d' => self::$pictograms['7'], // ߂
		'se23e' => self::$pictograms['392'], // 
		'se23f' => self::$pictograms['192'], // Ђ
		'se240' => self::$pictograms['193'], // 
		'se241' => self::$pictograms['194'], // ӂ
		'se242' => self::$pictograms['195'], // ɍ
		'se243' => self::$pictograms['196'], // 
		'se244' => self::$pictograms['197'], // Ƃߍ
		'se245' => self::$pictograms['198'], // Ă҂
		'se246' => self::$pictograms['199'], // 
		'se247' => self::$pictograms['200'], // č
		'se248' => self::$pictograms['201'], // €
		'se249' => self::$pictograms['202'], // ݂ߍ
		'se24a' => self::$pictograms['203'], // 
		'se24b' => self::$pictograms['204'], // ւт
		'se24c' => '[TOP]', // TOPy[W
		'se24d' => self::$pictograms['326'], // OK{^
		'se24e' => self::$pictograms['81'], // 쌠 (C)
		'se24f' => self::$pictograms['82'], // o^W (R)
		'se250' => self::$pictograms['393'], // }i[[h
		'se251' => self::$pictograms['394'], // d
		'se252' => self::$pictograms['1'], //  (!)
		'se253' => self::$pictograms['50'], // ē
		'se254' => self::$pictograms['156'], // J-PHONEVbv
		'se255' => self::$pictograms['332'], // XJCEFu
		'se256' => self::$pictograms['108'], // XJCEH[J[
		'se257' => self::$pictograms['343'] . self::$pictograms['784'], // XJCfB
		'se258' => 'J-', // J-PHONE 1
		'se259' => 'Pho', // J-PHONE 2
		'se25a' => 'ne', // J-PHONE 3
		'se301' => self::$pictograms['395'], // 
		'se302' => self::$pictograms['396'], // lN^C
		'se303' => self::$pictograms['397'], // nCrXJX
		'se304' => self::$pictograms['113'], // `[bv
		'se305' => self::$pictograms['256'], // Ђ܂
		'se306' => self::$pictograms['398'], // ԑ
		'se307' => self::$pictograms['255'], // ₵̖
		'se308' => self::$pictograms['399'], // T{e
		'se309' => self::$pictograms['207'], // gC
		'se30a' => self::$pictograms['294'], // wbhz
		'se30b' => self::$pictograms['400'], // ӎ (Ƃ)
		'se30c' => self::$pictograms['401'], // t (r[)
		'se30d' => self::$pictograms['402'], // j
		'se30e' => self::$pictograms['176'], // i
		'se30f' => self::$pictograms['403'], // JvZ
		'se310' => self::$pictograms['404'], // D
		'se311' => self::$pictograms['268'], // e
		'se312' => self::$pictograms['405'], // NbJ[
		'se313' => self::$pictograms['104'], // nT~
		'se314' => self::$pictograms['312'], // {
		'se315' => self::$pictograms['279'], // }
		'se316' => self::$pictograms['126'], // MD
		'se317' => self::$pictograms['13'], // KtH
		'se318' => self::$pictograms['407'], // Xq
		'se319' => self::$pictograms['793'], // s[X
		'se31a' => self::$pictograms['124'], // ~[
		'se31b' => self::$pictograms['408'], // Ou[c
		'se31c' => self::$pictograms['295'], // g
		'se31d' => self::$pictograms['409'], // }jLA
		'se31e' => self::$pictograms['297'], // GXe
		'se31f' => self::$pictograms['410'], // e@
		'se320' => self::$pictograms['411'], // X
		'se321' => self::$pictograms['412'], // 
		'se322' => self::$pictograms['413'], // rLj
		'se323' => self::$pictograms['83'], // uhobO
		'se324' => self::$pictograms['226'], // J`R
		'se325' => self::$pictograms['48'], // 
		'se326' => self::$pictograms['291'], // x鉹
		'se327' => self::$pictograms['415'], // ҂҂n[g
		'se328' => self::$pictograms['803'], // hLhLn[g
		'se329' => self::$pictograms['272'], // n[g˂Ƃ߂
		'se32a' => self::$pictograms['416'], // n[g ()
		'se32b' => self::$pictograms['417'], // n[g ()
		'se32c' => self::$pictograms['418'], // n[g ()
		'se32d' => self::$pictograms['419'], // n[g ()
		'se32e' => self::$pictograms['420'], // NEW (҂҂)
		'se32f' => self::$pictograms['69'], // 
		'se330' => self::$pictograms['282'], // _bV
		'se331' => self::$pictograms['330'], // юU銾
		'se332' => self::$pictograms['422'], // 
		'se333' => self::$pictograms['61'], // ~
		'se334' => self::$pictograms['262'], // {
		'se335' => self::$pictograms['69'], //  (_)
		'se336' => self::$pictograms['3'], //  "?"
		'se337' => self::$pictograms['2'], //  "!"
		'se338' => self::$pictograms['423'], // 
		'se339' => self::$pictograms['424'], // p
		'se33a' => self::$pictograms['425'], // \tgN[
		'se33b' => self::$pictograms['426'], // tCh|eg
		'se33c' => self::$pictograms['427'], // cq 
		'se33d' => self::$pictograms['428'], // ׂ
		'se33e' => self::$pictograms['429'], // 
		'se33f' => self::$pictograms['430'], // XpQeB
		'se340' => self::$pictograms['333'], // [
		'se341' => self::$pictograms['431'], // J[CX
		'se342' => self::$pictograms['244'], // ɂ
		'se343' => self::$pictograms['432'], // ł
		'se344' => self::$pictograms['433'], // i
		'se345' => self::$pictograms['434'], // 
		'se346' => self::$pictograms['435'], // ݂
		'se347' => self::$pictograms['243'], // 
		'se348' => self::$pictograms['238'], // 
		'se349' => self::$pictograms['436'], // g}g
		'se34a' => self::$pictograms['437'], // Ȃ
		'se34b' => self::$pictograms['313'], // o[Xf[P[L
		'se34c' => self::$pictograms['438'], // w
		'se34d' => self::$pictograms['439'], // ix
		'se401' => self::$pictograms['351'], //  ()
		'se402' => self::$pictograms['440'], // قł ()
		'se403' => self::$pictograms['441'], // Ђ炲߂Ȃ ()
		'se404' => self::$pictograms['442'], // ւ ()
		'se405' => self::$pictograms['348'], // EBN ()
		'se406' => self::$pictograms['443'], // 킳т ()
		'se407' => self::$pictograms['444'], // ڂ邮 ()
		'se408' => self::$pictograms['445'], // @傤 ()
		'se409' => self::$pictograms['264'], // ׁ[ ()
		'se40a' => self::$pictograms['446'], //  ()
		'se40b' => self::$pictograms['447'], // QQ ()
		'se40c' => self::$pictograms['448'], // }XN
		'se40d' => self::$pictograms['449'], // 炪Ȃ
		'se40e' => self::$pictograms['450'], // 炯
		'se40f' => self::$pictograms['447'], // ⊾ ()
		'se410' => self::$pictograms['451'], // т ()
		'se411' => self::$pictograms['259'], //  ()
		'se412' => self::$pictograms['786'], // ΂ ()
		'se413' => self::$pictograms['791'], // Ăl
		'se414' => self::$pictograms['454'], // ɂɂ ()
		'se415' => self::$pictograms['257'], // ͂͂Ə΂ ()
		'se416' => self::$pictograms['779'], // ߂߂{Ă ()
		'se417' => self::$pictograms['455'], // KISS:
		'se418' => self::$pictograms['456'], // KISS
		'se419' => self::$pictograms['317'], // 
		'se41a' => self::$pictograms['457'], // @
		'se41b' => self::$pictograms['318'], // 
		'se41c' => self::$pictograms['458'], // 
		'se41d' => self::$pictograms['459'], // ߂Ȃ (킹)
		'se41e' => self::$pictograms['463'], // oCoC (U)
		'se41f' => self::$pictograms['460'], // 
		'se420' => self::$pictograms['461'], // OK (wŊۃTC)
		'se421' => self::$pictograms['462'], // Booing (ew)
		'se422' => self::$pictograms['460'], // ́`
		'se423' => self::$pictograms['464'], // ~ (rNX)
		'se424' => self::$pictograms['465'], //  (r𓪂)
		'se425' => self::$pictograms['467'], // Ȃł
		'se426' => self::$pictograms['466'], // y
		'se427' => self::$pictograms['820'], // oUC
		'se428' => self::$pictograms['467'], // lƐlĂ
		'se429' => self::$pictograms['468'], // C_X (oj[K[)
		'se42a' => self::$pictograms['307'], // oXPbg{[
		'se42b' => self::$pictograms['96'], // tbg{[
		'se42c' => self::$pictograms['470'], // r[h
		'se42d' => self::$pictograms['471'], // j
		'se42e' => self::$pictograms['125'], // RV
		'se42f' => self::$pictograms['148'], // gbN
		'se430' => self::$pictograms['472'], // h
		'se431' => self::$pictograms['473'], // ~}
		'se432' => self::$pictograms['474'], // pgJ[
		'se433' => self::$pictograms['475'], // WFbgR[X^[
		'se434' => self::$pictograms['341'], // nS
		'se435' => self::$pictograms['217'], // V(700n)
		'se436' => self::$pictograms['476'], // 叼
		'se437' => self::$pictograms['763'], // `R
		'se438' => self::$pictograms['477'], // l
		'se439' => self::$pictograms['478'], // Ǝ
		'se43a' => self::$pictograms['479'], // hZ
		'se43b' => self::$pictograms['480'], // ̂ڂ
		'se43c' => self::$pictograms['481'], // Ƃ
		'se43d' => self::$pictograms['340'], // 
		'se43e' => self::$pictograms['810'], // gU[
		'se43f' => self::$pictograms['483'], // X
		'se440' => self::$pictograms['484'], // ԉ
		'se441' => self::$pictograms['485'], // L
		'se442' => self::$pictograms['486'], // 
		'se443' => self::$pictograms['190'], // 䕗
		'se444' => '[]', // 
		'se445' => self::$pictograms['487'], // nEB
		'se446' => self::$pictograms['488'], // 
		'se447' => self::$pictograms['358'], // r[
		'se448' => self::$pictograms['489'], // T^N[X
		'se449' => self::$pictograms['493'], // 
		'se44a' => self::$pictograms['371'], // [
		'se44b' => self::$pictograms['490'], // ꐯ
		'se44c' => self::$pictograms['491'], // 
		'se501' => self::$pictograms['492'], // uze
		'se502' => self::$pictograms['309'], // A[g
		'se503' => self::$pictograms['494'], // 
		'se504' => self::$pictograms['495'], // fp[g
		'se505' => self::$pictograms['496'], //  (a)
		'se506' => self::$pictograms['497'], //  (m)
		'se507' => self::$pictograms['110'], // f
		'se508' => self::$pictograms['498'], // H
		'se509' => self::$pictograms['228'], // ^[
		'se50a' => self::$pictograms['495'], // 109
		'se50b' => self::$pictograms['237'], // { ()
		'se50c' => self::$pictograms['90'], // AJ ()
		'se50d' => self::$pictograms['499'], // tX ()
		'se50e' => self::$pictograms['700'], // hCc ()
		'se50f' => self::$pictograms['701'], // C^A ()
		'se510' => self::$pictograms['702'], // CMX ()
		'se511' => self::$pictograms['366'], // XyC ()
		'se512' => self::$pictograms['367'], // VA ()
		'se513' => self::$pictograms['703'], //  ()
		'se514' => self::$pictograms['704'], // ؍ ()
		'se515' => self::$pictograms['705'], // l
		'se516' => self::$pictograms['706'], // l
		'se517' => self::$pictograms['707'], // Chl
		'se518' => self::$pictograms['708'], // 
		'se519' => self::$pictograms['709'], // ΂
		'se51a' => self::$pictograms['710'], // 
		'se51b' => self::$pictograms['711'], // S
		'se51c' => self::$pictograms['712'], // P
		'se51d' => '[Ȑ_]', // Ȑ_
		'se51e' => '[q]', // q
		'se51f' => self::$pictograms['714'], // tR
		'se520' => self::$pictograms['713'], // CJ
		'se521' => self::$pictograms['78'], // Ƃ
		'se522' => self::$pictograms['715'], // Mы
		'se523' => self::$pictograms['78'], // Ђ悱
		'se524' => '[nX^[]', // nX^[
		'se525' => self::$pictograms['716'], // ނ
		'se526' => self::$pictograms['717'], // 
		'se527' => self::$pictograms['718'], // RA
		'se528' => self::$pictograms['249'], // `pW[
		'se529' => self::$pictograms['192'], // Ђ
		'se52a' => self::$pictograms['134'], // 
		'se52b' => self::$pictograms['719'], // 
		'se52c' => self::$pictograms['247'], // 
		'se52d' => self::$pictograms['720'], // ւ
		'se52e' => self::$pictograms['721'], // ɂƂ
		'se52f' => self::$pictograms['722'], // ̂
		'se530' => self::$pictograms['723'], // 炭
		'se531' => self::$pictograms['250'], // 
		'se532' => self::$pictograms['724'], // A^
		'se533' => self::$pictograms['725'], // B^
		'se534' => self::$pictograms['727'], // AB^
		'se535' => self::$pictograms['726'], // O^
		'se536' => self::$pictograms['728'], // 
		'se537' => self::$pictograms['54'], // TM (W)
		'se538' => 'J-', 
		'se539' => 'Sky', 
		'se53a' => 'g', 
		'se53b' => 'h', 
		'se53c' => 'V', 
		'se53d' => 'odaf', 
		'se53e' => 'one', 
		'd001'  => self::$pictograms['44'], // 
		'd002'  => self::$pictograms['107'], // ܂
		'd003'  => self::$pictograms['95'], // J
		'd004'  => self::$pictograms['191'], //  
		'd005'  => self::$pictograms['16'], // 
		'd006'  => self::$pictograms['190'], // 䕗
		'd007'  => self::$pictograms['305'], // 
		'd008'  => self::$pictograms['481'], // J
		'd009'  => self::$pictograms['192'], // r
		'd010'  => self::$pictograms['193'], // 
		'd011'  => self::$pictograms['194'], // oq
		'd012'  => self::$pictograms['195'], // I
		'd013'  => self::$pictograms['196'], // q
		'd014'  => self::$pictograms['197'], // 
		'd015'  => self::$pictograms['198'], // V
		'd016'  => self::$pictograms['199'], // 嶍
		'd017'  => self::$pictograms['200'], // ˎ
		'd018'  => self::$pictograms['201'], // Rr
		'd019'  => self::$pictograms['202'], // r
		'd020'  => self::$pictograms['203'], // 
		'd021'  => self::$pictograms['335'], // X|[c
		'd022'  => self::$pictograms['45'], // 싅
		'd023'  => self::$pictograms['306'], // St
		'd024'  => self::$pictograms['220'], // ejX
		'd025'  => self::$pictograms['219'], // TbJ[
		'd026'  => self::$pictograms['421'], // XL[
		'd027'  => self::$pictograms['307'], // oXPbg{[
		'd028'  => self::$pictograms['222'], // [^[X|[c (`FbJ[tbO)
		'd029'  => self::$pictograms['308'], // |Pbgx
		'd030'  => self::$pictograms['172'], // d
		'd031'  => self::$pictograms['341'], // nS
		'd032'  => self::$pictograms['217'], // V
		'd033'  => self::$pictograms['125'], //  (Z_)
		'd034'  => self::$pictograms['125'], //  (RV)
		'd035'  => self::$pictograms['216'], // oX
		'd036'  => self::$pictograms['379'], // D
		'd037'  => self::$pictograms['168'], // s@
		'd038'  => self::$pictograms['112'], // 
		'd039'  => self::$pictograms['156'], // r
		'd040'  => self::$pictograms['375'], // X֋
		'd041'  => self::$pictograms['376'], // a@
		'd042'  => self::$pictograms['212'], // s
		'd043'  => self::$pictograms['205'], // ATM
		'd044'  => self::$pictograms['378'], // ze
		'd045'  => self::$pictograms['206'], // Rrj
		'd046'  => self::$pictograms['213'], // K\X^h
		'd047'  => self::$pictograms['208'], // ԏ
		'd048'  => self::$pictograms['99'], // M
		'd049'  => self::$pictograms['207'], // gC
		'd050'  => self::$pictograms['146'], // Xg
		'd051'  => self::$pictograms['93'], // iX
		'd052'  => self::$pictograms['52'], // o[ (}eB[j)
		'd053'  => self::$pictograms['401'], // r[
		'd054'  => self::$pictograms['245'], // t@[Xgt[h (no[K[)
		'd055'  => self::$pictograms['124'], // ueBbN
		'd056'  => self::$pictograms['104'], // e@ ()
		'd057'  => self::$pictograms['289'], // JIP
		'd058'  => self::$pictograms['110'], // f
		'd059'  => self::$pictograms['70'], // E΂ߏ
		'd060'  => self::$pictograms['223'], // Vn (ؔn)
		'd061'  => self::$pictograms['294'], // y (wbhz)
		'd062'  => self::$pictograms['309'], // A[g
		'd063'  => self::$pictograms['310'], // 
		'd064'  => self::$pictograms['311'], // Cxg (T[JX)
		'd065'  => self::$pictograms['106'], // `Pbg
		'd066'  => self::$pictograms['176'], // i
		'd067'  => self::$pictograms['177'], // ։
		'd068'  => self::$pictograms['94'], // J
		'd069'  => self::$pictograms['83'], // Jo
		'd070'  => self::$pictograms['97'], // {
		'd071'  => self::$pictograms['312'], // {
		'd072'  => self::$pictograms['144'], // v[g
		'd073'  => self::$pictograms['313'], // o[Xf[
		'd074'  => self::$pictograms['85'], // db
		'd075'  => self::$pictograms['161'], // gѓdb
		'd076'  => self::$pictograms['56'], // 
		'd077'  => self::$pictograms['288'], // TV
		'd078'  => self::$pictograms['232'], // Q[
		'd079'  => self::$pictograms['300'], // CD
		'd080'  => self::$pictograms['414'], // n[g
		'd081'  => self::$pictograms['314'], // Xy[h
		'd082'  => self::$pictograms['315'], // _C
		'd083'  => self::$pictograms['316'], // Nu
		'd084'  => self::$pictograms['317'], // 
		'd085'  => self::$pictograms['318'], // 
		'd086'  => self::$pictograms['817'], //  (O[)
		'd087'  => self::$pictograms['319'], //  (`L)
		'd088'  => self::$pictograms['320'], //  (p[)
		'd089'  => self::$pictograms['43'], // E΂߉
		'd090'  => self::$pictograms['42'], // ΂ߏ
		'd091'  => self::$pictograms['728'], // 
		'd092'  => self::$pictograms['336'], // 
		'd093'  => self::$pictograms['116'], // ዾ
		'd094'  => self::$pictograms['178'], // Ԉ֎q
		'd095'  => self::$pictograms['321'], // V
		'd096'  => self::$pictograms['322'], // ⌇
		'd097'  => self::$pictograms['323'], // 
		'd098'  => self::$pictograms['15'], // O
		'd099'  => self::$pictograms['488'], // 
		'd100'  => self::$pictograms['134'], // 
		'd101'  => self::$pictograms['251'], // L
		'd102'  => self::$pictograms['169'], // ][g (bg)
		'd103'  => self::$pictograms['234'], // NX}X
		'd104'  => self::$pictograms['71'], // ΂߉
		'd105'  => self::$pictograms['161'], // phone to
		'd106'  => self::$pictograms['784'], // mail to
		'd107'  => self::$pictograms['166'], // fax to
		'd108'  => '[i]', // i[h
		'd109'  => '[i]', // i[h (gt)
		'd110'  => self::$pictograms['108'], // [
		'd111'  => '[hR]', // hR
		'd112'  => '[D]', // hR|Cg
		'd113'  => self::$pictograms['109'], // L
		'd114'  => self::$pictograms['299'], // 
		'd115'  => self::$pictograms['385'], // ID
		'd116'  => self::$pictograms['120'], // pX[h
		'd117'  => self::$pictograms['118'], // L
		'd118'  => self::$pictograms['324'], // NA
		'd119'  => self::$pictograms['119'], // T[` (ׂ)
		'd120'  => self::$pictograms['334'], // NEW
		'd121'  => self::$pictograms['210'], // ʒu
		'd122'  => self::$pictograms['299'], // t[_C
		'd123'  => self::$pictograms['818'], // V[v_C
		'd124'  => self::$pictograms['4'], // oQ
		'd125'  => self::$pictograms['180'], // 1 (one)
		'd126'  => self::$pictograms['181'], // 2 (two)
		'd127'  => self::$pictograms['182'], // 3 (three)
		'd128'  => self::$pictograms['183'], // 4 (four)
		'd129'  => self::$pictograms['184'], // 5 (five)
		'd130'  => self::$pictograms['185'], // 6 (six)
		'd131'  => self::$pictograms['186'], // 7 (seven)
		'd132'  => self::$pictograms['187'], // 8 (eight)
		'd133'  => self::$pictograms['188'], // 9 (nine)
		'd134'  => self::$pictograms['325'], // 0 (zero)
		'd135'  => self::$pictograms['326'], //  (OK)
		'd136'  => self::$pictograms['51'], // n[g
		'd137'  => self::$pictograms['803'], // hn[g
		'd138'  => self::$pictograms['265'], // 
		'd139'  => self::$pictograms['266'], // n[g (n[g)
		'd140'  => self::$pictograms['257'], // [ ()
		'd141'  => self::$pictograms['258'], //  ({)
		'd142'  => self::$pictograms['443'], // ` (_)
		'd143'  => self::$pictograms['259'], // ₾` (߂)
		'd144'  => self::$pictograms['260'], // ӂӂ
		'd145'  => self::$pictograms['731'], // Obh ()
		'd146'  => self::$pictograms['343'], //  ()
		'd147'  => self::$pictograms['224'], // C ()
		'd148'  => self::$pictograms['759'], // 킢
		'd149'  => self::$pictograms['273'], // LX}[N
		'd150'  => self::$pictograms['76'], // ҂҂ (V)
		'd151'  => self::$pictograms['77'], // Ђ߂
		'd152'  => self::$pictograms['262'], // ނ ({)
		'd153'  => self::$pictograms['281'], // p`
		'd154'  => self::$pictograms['268'], // e
		'd155'  => self::$pictograms['291'], // [h
		'd156'  => self::$pictograms['732'], // obh ()
		'd157'  => self::$pictograms['261'], //  ()
		'd158'  => self::$pictograms['2'], // exclamation
		'd159'  => self::$pictograms['733'], // exclamation and question
		'd160'  => self::$pictograms['734'], // double exclamation
		'd161'  => self::$pictograms['329'], // ǂ (Ռ)
		'd162'  => self::$pictograms['330'], //  (юU銾)
		'd163'  => self::$pictograms['263'], // [ ()
		'd164'  => self::$pictograms['282'], // _bV (o)
		'd165'  => '``', // [ (L1)
		'd166'  => self::$pictograms['735'], // [ (L2)
		'd167'  => self::$pictograms['226'], // J`R
		'd168'  => self::$pictograms['233'], // ӂ
		'd169'  => self::$pictograms['508'], // y
		'd170'  => self::$pictograms['257'], // le
		'd171'  => '[֎q]', // 
		'd172'  => self::$pictograms['490'], // 
		'd173'  => 'SOON', // soon
		'd174'  => 'ON', // on
		'd175'  => 'END', // end
		'd176'  => self::$pictograms['46'], // v
		'd201'  => '', // iAv
		'd202'  => '[]', // iAv (gt)
		'd203'  => self::$pictograms['335'], // TVc ({[_[)
		'd204'  => self::$pictograms['290'], // ܌z
		'd205'  => self::$pictograms['295'], // 
		'd206'  => self::$pictograms['805'], // W[Y
		'd207'  => self::$pictograms['221'], // Xm{
		'd208'  => self::$pictograms['48'], // `y
		'd209'  => '[hA]', // hA
		'd210'  => self::$pictograms['233'], // h
		'd211'  => self::$pictograms['337'], // p\R
		'd212'  => self::$pictograms['806'], // u^[
		'd213'  => self::$pictograms['152'], // `
		'd214'  => self::$pictograms['149'], // M
		'd215'  => self::$pictograms['354'], // 
		'd216'  => self::$pictograms['72'], // w
		'd217'  => self::$pictograms['57'], // v
		'd218'  => self::$pictograms['215'], // ]
		'd219'  => self::$pictograms['423'], // ̂
		'd220'  => self::$pictograms['25'], // rv
		'd221'  => self::$pictograms['351'], // lĂ
		'd222'  => self::$pictograms['440'], // قƂ
		'd223'  => self::$pictograms['452'], // ⊾ ()
		'd224'  => self::$pictograms['330'], // ⊾2 ()
		'd225'  => self::$pictograms['779'], // ՂȊ
		'd226'  => self::$pictograms['450'], // {P[Ƃ
		'd227'  => self::$pictograms['349'], // ڂn[g ()
		'd228'  => self::$pictograms['287'], // wOK
		'd229'  => self::$pictograms['264'], // ׁ[
		'd230'  => self::$pictograms['348'], // EBN
		'd231'  => self::$pictograms['454'], // ꂵ
		'd232'  => self::$pictograms['327'], // ܂
		'd233'  => self::$pictograms['251'], // L2
		'd234'  => self::$pictograms['786'], // 
		'd235'  => self::$pictograms['791'], // 
		'd236'  => self::$pictograms['98'], // NG
		'd237'  => self::$pictograms['143'], // Nbv
		'd238'  => self::$pictograms['81'], // Rs[Cg (C)
		'd239'  => self::$pictograms['54'], // g[h}[N (TM)
		'd240'  => self::$pictograms['218'], // l
		'd241'  => self::$pictograms['279'], // }
		'd242'  => self::$pictograms['807'], // TCN
		'd243'  => self::$pictograms['82'], // WX^[hg[h}[N (R)
		'd244'  => self::$pictograms['1'], // 댯Ex (!)
		'd245'  => self::$pictograms['98'], // ֎~
		'd246'  => self::$pictograms['387'], // 󎺁EȁE
		'd247'  => '[i]', // i}[N
		'd248'  => self::$pictograms['386'], // EȁE
		'd249'  => self::$pictograms['808'], // 󍶉E
		'd250'  => self::$pictograms['809'], // ㉺
		'd251'  => self::$pictograms['377'], // wZ
		'd252'  => self::$pictograms['810'], // g
		'd253'  => self::$pictograms['342'], // xmR
		'd254'  => self::$pictograms['53'], // N[o[
		'd255'  => self::$pictograms['241'], // 
		'd256'  => self::$pictograms['113'], // `[bv
		'd257'  => self::$pictograms['739'], // oii
		'd258'  => self::$pictograms['434'], // 
		'd259'  => self::$pictograms['811'], // 
		'd260'  => self::$pictograms['133'], // ݂
		'd261'  => self::$pictograms['235'], // 
		'd262'  => self::$pictograms['244'], // ɂ
		'd263'  => self::$pictograms['239'], // V[gP[L
		'd264'  => self::$pictograms['400'], // Ƃ (傱t)
		'd265'  => self::$pictograms['333'], // ǂԂ
		'd266'  => self::$pictograms['424'], // p
		'd267'  => self::$pictograms['812'], // ނ
		'd268'  => self::$pictograms['78'], // Ђ悱
		'd269'  => self::$pictograms['252'], // yM
		'd270'  => self::$pictograms['715'], // 
		'd271'  => self::$pictograms['454'], // ܂! ()
		'd272'  => self::$pictograms['442'], // EbVbV ()
		'd273'  => self::$pictograms['248'], // E}
		'd274'  => self::$pictograms['254'], // u^
		'd275'  => self::$pictograms['12'], // COX
		'd276'  => self::$pictograms['350'], //  ()
		'e253'  => self::$pictograms['284'], // lw
		'e254'  => self::$pictograms['467'], // Jbv
		'e255'  => self::$pictograms['179'], // t}[N
		'e256'  => self::$pictograms['292'], // M^[
		'e257'  => self::$pictograms['373'], // `[g
		'e258'  => self::$pictograms['98'], // 18Έȏ֎~
		'e259'  => self::$pictograms['362'], // v
		'e260'  => self::$pictograms['332'], // R~jeB
		'e261'  => self::$pictograms['420'], // qbg
		'e262'  => self::$pictograms['171'], // V
		'e263'  => self::$pictograms['489'], // T^N[X
		'e264'  => self::$pictograms['163'], // Ƒ
		'e265'  => '@', // [gp]
		'e266'  => self::$pictograms['233'], // RC
		'e267'  => '@', // [gp]
		'e268'  => '@', // [gp]
		'e269'  => 'EM', // EMOBILE S (n)
		'e270'  => 'EM', // EMOBILE S (Ԓn)
		'e271'  => '@', // [gp]
		'e272'  => '@', // [gp]
		'e273'  => '@', // [gp]
		'e274'  => '@', // [gp]
		'e275'  => '@', // [gp]
		'e276'  => '@', // [gp]
		'e277'  => '@', // [gp]
		'e278'  => '@', // [gp]
		'wf040' => self::$pictograms['51'], // n[g
		'wf041' => self::$pictograms['46'], // v
		'wf042' => self::$pictograms['85'], // db
		'wf043' => self::$pictograms['65'], // Jbv
		'wf044' => '*', // *
		'wf045' => self::$pictograms['809'], // ㉺ ()
		'wf046' => self::$pictograms['808'], // E ()
		'wf047' => '(((', // dg ()
		'wf048' => self::$pictograms['44'], // 
		'wf049' => self::$pictograms['95'], // J
		'wf04a' => self::$pictograms['107'], // ܂
		'wf04b' => self::$pictograms['263'], // 
		'wf04c' => self::$pictograms['68'], // Ί
		'wf04d' => self::$pictograms['273'], //  (LX}[N)
		'wf04e' => self::$pictograms['291'], // fB (\Z)
		'wf04f' => self::$pictograms['125'], // 
		'wf050' => self::$pictograms['172'], // d
		'wf051' => self::$pictograms['168'], // s@
		'wf052' => '[oCN]'        , // oCN
		'wf053' => self::$pictograms['112'], // 
		'wf054' => self::$pictograms['156'], // r
		'wf055' => self::$pictograms['319'], // s[X ()
		'wf056' => self::$pictograms['146'], // fBi[ (iCtƃtH[N)
		'wf057' => self::$pictograms['52'], // OX
		'wf058' => self::$pictograms['791'], //  ()
		'wf059' => self::$pictograms['113'], // `[bv
		'wf05a' => self::$pictograms['45'], // 싅 (obg)
		'wf05b' => self::$pictograms['45'], // {[
		'wf05c' => self::$pictograms['817'], // p` ()
		'wf05d' => self::$pictograms['16'], // 
		'wf05e' => self::$pictograms['258'], // {
		'wf05f' => self::$pictograms['401'], // r[
		'wf060' => self::$pictograms['56'], // m[g
		'wf061' => self::$pictograms['149'], // y (M)
		'wf062' => self::$pictograms['286'], // hN
		'wf063' => self::$pictograms['108'], // [
		'wf064' => self::$pictograms['177'], // ։
		'wf065' => self::$pictograms['48'], // x
		'wf066' => self::$pictograms['759'], // 
		'wf067' => self::$pictograms['224'], // 
		'wf068' => self::$pictograms['15'], //  (26)
		'wf069' => self::$pictograms['730'], // 
		'wf06a' => self::$pictograms['448'], // }XN ()
		'wf06b' => self::$pictograms['294'], // R[h
		'wf06c' => self::$pictograms['160'], // 
		'wf06d' => self::$pictograms['134'], // 
		'wf06e' => self::$pictograms['251'], // L
		'wf06f' => self::$pictograms['249'], // 
		'wf070' => self::$pictograms['717'], // 
		'wf071' => self::$pictograms['352'], // 
		'wf072' => self::$pictograms['333'], // k[h
		'wf073' => self::$pictograms['289'], // }CN (JIP)
		'wf074' => self::$pictograms['262'], // ނ ({)
		'wf075' => self::$pictograms['78'], // Ђ悱
		'wf076' => self::$pictograms['445'], // 
		'wf077' => self::$pictograms['93'], // R[q[
		'wf078' => self::$pictograms['176'], // ^oR
		'wf079' => self::$pictograms['330'], // 
		'wf07a' => self::$pictograms['244'], // ɂ
		'wf07b' => self::$pictograms['83'], // Jo
		'wf07c' => self::$pictograms['283'], // 
		'wf07d' => self::$pictograms['396'], // lN^C
		'wf07e' => self::$pictograms['335'], // Vc
		'wf080' => self::$pictograms['238'], // 
		'wf081' => self::$pictograms['483'], // JLX
		'wf082' => self::$pictograms['413'], // rLj
		'wf083' => self::$pictograms['104'], // ͂
		'wf084' => self::$pictograms['304'], // 
		'wf085' => self::$pictograms['211'], // D (d)
		'wf086' => self::$pictograms['250'], // 
		'wf087' => self::$pictograms['320'], // oCoC ()
		'wf088' => self::$pictograms['265'], // 
		'wf089' => self::$pictograms['315'], // _C (gv)
		'wf08a' => self::$pictograms['316'], // N[o[ (gv)
		'wf08b' => self::$pictograms['314'], // Xy[h (gv)
		'wf08c' => self::$pictograms['143'], // Nbv
		'wf08d' => self::$pictograms['191'], // Ⴞ
		'wf08e' => self::$pictograms['313'], // P[L
		'wf08f' => self::$pictograms['434'], // 
		'wf090' => self::$pictograms['144'], // v[g
		'wf091' => self::$pictograms['233'], //  (h)
		'wf092' => '[EXIT]', // o
		'wf093' => '[hA]', // 
		'wf094' => self::$pictograms['80'], // ₶
		'wf095' => self::$pictograms['161'], // PHS
		'wf096' => self::$pictograms['69'], // 
		'wf097' => self::$pictograms['106'], // `Pbg
		'wf098' => self::$pictograms['266'], // n[g
		'wf099' => self::$pictograms['77'], // Ђ߂
		'wf09a' => self::$pictograms['276'], // 
		'wf09b' => self::$pictograms['257'], // Ί
		'wf09c' => self::$pictograms['220'], // ejX
		'wf09d' => self::$pictograms['110'], // f
		'wf09e' => self::$pictograms['421'], // XL[
		'wf09f' => self::$pictograms['734'], // !!
		'wf0a0' => self::$pictograms['733'], // !?
		'wf0a1' => self::$pictograms['3'], // ?
		'wf0a2' => self::$pictograms['732'], // ~ ()
		'wf0a3' => self::$pictograms['731'], // ㏸ ()
		'wf0a4' => self::$pictograms['287'], // Obh (ew)
		'wf0a5' => self::$pictograms['271'], // ͂
		'wf0a6' => self::$pictograms['272'], // L[sbg (n[gƖ)
		'wf0a7' => self::$pictograms['278'], // ܂
		'wf0a8' => self::$pictograms['190'], // 䕗
		'wf0a9' => self::$pictograms['379'], // C
		'wf0aa' => self::$pictograms['751'], // T[tB
		'wf0ab' => self::$pictograms['769'], // R
		'wf0ac' => self::$pictograms['342'], // xmR
		'wf0ad' => self::$pictograms['361'], // Lv
		'wf0ae' => self::$pictograms['358'], // t
		'wf0af' => self::$pictograms['216'], // oX
		'wf0b0' => self::$pictograms['219'], // TbJ[
		'wf0b1' => self::$pictograms['179'], // S
		'wf0b2' => self::$pictograms['7'], // ߂
		'wf0b3' => self::$pictograms['8'], // 
		'wf0b4' => '[dv]', // dv
		'wf0b5' => self::$pictograms['98'], // 18
		'wf0b6' => self::$pictograms['1'], // 
		'wf0b7' => self::$pictograms['807'], // TCN
		'wf0b8' => self::$pictograms['381'], // dEx
		'wf0b9' => ')))', // dg (E)
		'wf0ba' => self::$pictograms['61'], // oc
		'wf0bb' => self::$pictograms['81'], // Rs[Cg
		'wf0bc' => self::$pictograms['82'], // WX^[hg[h}[N
		'wf0bd' => self::$pictograms['229'], // X[Zu
		'wf0be' => self::$pictograms['325'], // 0 (zero)
		'wf0bf' => self::$pictograms['180'], // 1 (one)
		'wf0c0' => self::$pictograms['181'], // 2 (two)
		'wf0c1' => self::$pictograms['182'], // 3 (three)
		'wf0c2' => self::$pictograms['183'], // 4 (four)
		'wf0c3' => self::$pictograms['184'], // 5 (five)
		'wf0c4' => self::$pictograms['185'], // 6 (six)
		'wf0c5' => self::$pictograms['186'], // 7 (seven)
		'wf0c6' => self::$pictograms['187'], // 8 (eight)
		'wf0c7' => self::$pictograms['188'], // 9 (nine)
		'wf0c8' => self::$pictograms['192'], // r
		'wf0c9' => self::$pictograms['193'], // 
		'wf0ca' => self::$pictograms['194'], // oq
		'wf0cb' => self::$pictograms['195'], // I
		'wf0cc' => self::$pictograms['196'], // q
		'wf0cd' => self::$pictograms['197'], // 
		'wf0ce' => self::$pictograms['198'], // V
		'wf0cf' => self::$pictograms['199'], // 嶍
		'wf0d0' => self::$pictograms['204'], // ւт
		'wf0d1' => self::$pictograms['200'], // ˎ
		'wf0d2' => self::$pictograms['201'], // Rr
		'wf0d3' => self::$pictograms['202'], // r
		'wf0d4' => self::$pictograms['203'], // 
		'wf0d5' => self::$pictograms['794'], // n
		'wf0d6' => self::$pictograms['245'], // }Nhih
		'wf0d7' => self::$pictograms['245'], // Xo[K[
		'wf0d8' => '@', // [gp]
		'wf0d9' => self::$pictograms['245'], // beA
		'wf0da' => '@', // [gp]
		'wf0db' => self::$pictograms['93'], // hg[R[q[
		'wf0dc' => '@', // [gp]
		'wf0dd' => '@', // [gp]
		'wf0de' => '@', // [gp]
		'wf0df' => '@', // [gp]
		'wf0e0' => self::$pictograms['743'], //  (o[~?)
		'wf0e1' => '@', // [gp]
		'wf0e2' => '@', // [gp]
		'wf0e3' => self::$pictograms['146'], // тhL[
		'wf0e4' => '@', // [gp]
		'wf0e5' => '@', // [gp]
		'wf0e6' => '@', // [gp]
		'wf0e7' => self::$pictograms['206'], // [\
		'wf0e8' => '@', // [gp]
		'wf0e9' => self::$pictograms['206'], // am/pm
		'wf0ea' => '@', // [gp]
		'wf0eb' => '@', // [gp]
		'wf0ec' => '@', // [gp]
		'wf0ed' => '@', // [gp]
		'wf0ee' => '@', // [gp]
		'wf0ef' => '@', // [gp]
		'wf0f0' => self::$pictograms['495'], // 
		'wf0f1' => '@', // [gp]
		'wf0f2' => '@', // [gp]
		'wf0f3' => '@', // [gp]
		'wf0f4' => '@', // [gp]
		'wf0f5' => '@', // [gp]
		'wf0f6' => '@', // [gp]
		'wf0f7' => '@', // [gp]
		'wf0f8' => '@', // [gp]
		'wf0f9' => '@', // [gp]
		'wf0fa' => '@', // [gp]
		'wf0fb' => '@', // [gp]
		'wf0fc' => self::$pictograms['134'], // n`
		'wf140' => self::$pictograms['794'], // C
		'wf141' => '@', // [gp]
		'wf142' => '@', // [gp]
		'wf143' => '@', // [gp]
		'wf144' => '@', // [gp]
		'wf145' => '@', // [gp]
		'wf146' => '@', // [gp]
		'wf147' => '@', // [gp]
		'wf148' => self::$pictograms['212'], // UFJ
		'wf149' => '@', // [gp]
		'wf14a' => '@', // [gp]
		'wf14b' => '@', // [gp]
		'wf14c' => '@', // [gp]
		'wf14d' => '[EXIT]', // 
		'wf14e' => '@', // [gp]
		'wf14f' => '@', // [gp]
		'wf150' => self::$pictograms['259'], // 
		'wf151' => '@', // [gp]
		'wf152' => '@', // [gp]
		'wf153' => '@', // [gp]
		'wf154' => '@', // [gp]
		'wf155' => '@', // [gp]
		'wf156' => '@', // [gp]
		'wf157' => '@', // [gp]
		'wf158' => '@', // [gp]
		'wf159' => '@', // [gp]
		'wf15a' => '@', // [gp]
		'wf15b' => '@', // [gp]
		'wf15c' => '@', // [gp]
		'wf15d' => '@', // [gp]
		'wf15e' => '@', // [gp]
		'wf15f' => '@', // [gp]
	);
	$translated = apply_filters('ktai_pictogram_table', $translated, __CLASS__, $this->charset);
	$translated = apply_filters('pictogram_table/ktai_style.php', $translated);
	$buffer = preg_replace(
		'!<img localsrc="([^"]+)"( alt="(' . KtaiStyle::DOUBLE_QUOTED_STRING_REGEX . ')")?[^/>]*/?>!se', // <?php /* syntax hilighting fix */
		'isset($translated["$1"]) ? $translated["$1"] : ("$3" ? "$3" : "")', 
		$buffer);
	$entities = array(
		'&spades;' => self::$pictograms['314'],
		'&#9824;'  => self::$pictograms['314'],
		'&#x2660;' => self::$pictograms['314'],
		'&clubs;'  => self::$pictograms['316'],
		'&#9827;'  => self::$pictograms['316'],
		'&#x2663;' => self::$pictograms['316'],
		'&hearts;' => self::$pictograms['414'],
		'&#9829;'  => self::$pictograms['414'],
		'&#x2665;' => self::$pictograms['414'],
		'&#9825;'  => self::$pictograms['51'], // WHITE HEART
		'&#x2661;' => self::$pictograms['51'], // WHITE HEART
		'&diams;'  => self::$pictograms['315'],
		'&#9830;'  => self::$pictograms['315'],
		'&#x2666;' => self::$pictograms['315'],
		'&#12336;' => '``', // WAVY DASH
		'&#x3030;' => '``', // WAVY DASH
	);
	$buffer = str_replace(array_keys($entities), $entities, $buffer);
	return parent::convert_pict($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
	$buffer = preg_replace('!<(b|i|em|strong)>(.*?)</\\1>!s', '$2', $buffer);
	return parent::shrink_pre_split($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function pickup_pics($buffer) {
	$pictograms = array_flip(self::$pictograms);
	if (! $pictograms || ! function_exists('mb_regex_encoding')) {
		return $buffer;
	}
	mb_regex_encoding($this->charset);
	$replaced = mb_ereg_replace(
		"([\xf3\x40-\xf3\x5b]|[\xf3\x5d-\xf3\xfc]|[\xf4\x40-\xf4\x5b]|[\xf4\x5d-\xf4\xfc]|[\xf6\x40-\xf6\x5b]|[\xf6\x5d-\xf6\xfc]|[\xf7\x40-\xf7\x5b]|[\xf7\x5d-\xf7\xfc])", 
		'isset($pictograms["\1"]) ?
		"<img localsrc=\"" . $pictograms["\1"] . "\" />" :
		"<img localsrc=\"ez\" alt=\"" . "[0x" . bin2hex("\1") . "]\" />"', 
		$buffer, 'e');
	if ($replaced) {
		$replaced = mb_ereg_replace("\xf3\x5c", '<img localsrc="' . $pictograms["\xf3\x5c"] . '" />', $replaced);
		$replaced = mb_ereg_replace("\xf4\x5c", '<img localsrc="' . $pictograms["\xf4\x5c"] . '" />', $replaced);
		$replaced = mb_ereg_replace("\xf6\x5c", '<img localsrc="' . $pictograms["\xf6\x5c"] . '" />', $replaced);
		$replaced = mb_ereg_replace("\xf7\x5c", '<img localsrc="' . $pictograms["\xf7\x5c"] . '" />', $replaced);
	}
	return $replaced ? $replaced : $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   KtaiService_EZweb_HDML class
   ================================================== */

class KtaiService_EZweb_HDML extends KtaiService_EZweb {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->type = 'HDML';
	preg_match('!^UP\.Browser/\d\.\d+-([A-Za-z0-9]+) !', $user_agent, $specs);
	$device_ID = $specs[1];
	$this->term_name = isset(parent::$device_IDs[$device_ID][0]) ? parent::$device_IDs[$device_ID][0] : NULL;
	$this->flat_rate = isset(parent::$device_IDs[$device_ID][1]) ? parent::$device_IDs[$device_ID][1] : NULL;
	if ( !$this->term_name ) {
		$this->term_name = "(Unknown au device:$device_ID)";
		$this->flat_rate = false;
	}
	$this->ext_css_available = false;
	$this->textarea_size = 1024;
	$this->page_size  = 7500;
	$this->cache_size = (isset($_SERVER['HTTP_X_UP_DEVCAP_MAX_PDU']) && $_SERVER['HTTP_X_UP_DEVCAP_MAX_PDU'] > 0) ? intval($_SERVER['HTTP_X_UP_DEVCAP_MAX_PDU']) : 49152;
	$this->xhtml_head = '';
	return;
}

// ===== End of class ====================
}

/* ==================================================
 *   KtaiService_EZweb_WAP2 class
   ================================================== */

class KtaiService_EZweb_WAP2 extends KtaiService_EZweb {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->type = 'WAP2.0';
	preg_match('!^KDDI-([A-Za-z0-9]+) !', $user_agent, $specs);
	$device_ID = $specs[1];
	$this->term_name = isset(parent::$device_IDs[$device_ID][0]) ? parent::$device_IDs[$device_ID][0] : NULL;
	$this->flat_rate = isset(parent::$device_IDs[$device_ID][1]) ? parent::$device_IDs[$device_ID][1] : NULL;
	if ( !$this->term_name ) {
		$this->term_name = "(Unknown au device:$device_ID)";
		$this->flat_rate = true;
	}
	$this->ext_css_available = true;
	$this->available_js_version = false;
	$this->textarea_size = 1024;
	$this->cache_size = (isset($_SERVER['HTTP_X_UP_DEVCAP_MAX_PDU']) && $_SERVER['HTTP_X_UP_DEVCAP_MAX_PDU'] > 0) ? intval($_SERVER['HTTP_X_UP_DEVCAP_MAX_PDU'] * 0.96) : 102400;
	$this->page_size  = min(20000, $this->cache_size);
	$this->xhtml_head = '<html xmlns="http://www.w3.org/1999/xhtml">';
	add_action('ktai_wp_head', array($this, 'paragraph_margin') );
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = $this->font_to_big_small($buffer);
	if ($this->mime_type == 'application/xhtml+xml') {
		$buffer = $this->input_to_style($buffer);
	}
	return parent::shrink_post_split($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
protected function font_to_big_small($buffer) {
	$buffer = str_replace(array("\375", "\376"), array('', ''), $buffer);
	$buffer = str_replace(array('<font', '</font>'), array("\375", "\376"), $buffer, $num_replaced);
	$loop = 0;
	while (preg_match('!\\375([^<>]*)>([^\\375\\376]*?)\\376!s', $buffer, $f)) {
		if ($loop++ > $num_replaced) { // infinity loop check
			break;
		}
		$attr       = $f[1];
		$html       = $f[2];
		if (preg_match('/ ?size=([\'"])([-+])1\\1/', $attr, $size)) { //"
			$attr = str_replace($size[0], '', $attr);
			$elem = ($size[2] == '+') ? 'big' : 'small';
			if (preg_match('/^\s*$/', $attr)) {
				$html ="<$elem>" . $html . "</$elem>";
			} else {
				$html = "<$elem><font$attr>" . $html . "</font></$elem>";
			}
		} else {
			$html = str_replace(array("\375", "\376"), array('<font', '</font>'), $f[0]);
		}
		$buffer = preg_replace('!' . preg_quote($f[0], '!') . '!', $html, $buffer, 1);
	}
	$buffer = str_replace(array("\375", "\376"), array('<font', '</font>'), $buffer, $num_replaced); // restore rest font tags
	return $buffer;
}

/* ==================================================
 * @param	none
 * @return	none
 * @since	2.0.0
 */
public function paragraph_margin() {
	echo '<style type="text/css"><![CDATA[ p {margin:0.75em 0;} ]]></style>' . "\n";
}

// ===== End of class ====================
}
?>