/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public class LoadedWrapperListener
implements WrapperListener,
Runnable {
    private String[] m_startMainArgs;
    private boolean m_mainComplete;
    private Integer m_mainExitCode;
    private boolean m_waitTimedOut;

    private LoadedWrapperListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer start(String[] args) {
        if (WrapperManager.isDebugEnabled()) {
            System.out.println("LoadedWrapperListener: start(args)");
        }
        Thread mainThread = new Thread((Runnable)this, "LoadedWrapperListenerMain");
        LoadedWrapperListener loadedWrapperListener = this;
        synchronized (loadedWrapperListener) {
            this.m_startMainArgs = args;
            mainThread.start();
            try {
                this.wait(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.m_waitTimedOut = true;
            if (WrapperManager.isDebugEnabled()) {
                System.out.println("LoadedWrapperListener: start(args) end.  Main Completed=" + this.m_mainComplete + ", exitCode=" + this.m_mainExitCode);
            }
            return this.m_mainExitCode;
        }
    }

    public int stop(int exitCode) {
        if (WrapperManager.isDebugEnabled()) {
            System.out.println("LoadedWrapperListener: stop(" + exitCode + ")");
        }
        return exitCode;
    }

    public void controlEvent(int event) {
        if (WrapperManager.isControlledByNativeWrapper()) {
            if (WrapperManager.isDebugEnabled()) {
                System.out.println("LoadedWrapperListener: controlEvent(" + event + ") Ignored");
            }
        } else {
            if (WrapperManager.isDebugEnabled()) {
                System.out.println("LoadedWrapperListener: controlEvent(" + event + ") Stopping");
            }
            WrapperManager.stop((int)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Throwable t = null;
        try {
            if (WrapperManager.isDebugEnabled()) {
                System.out.println("LoadedWrapperListener: invoking start main method");
            }
            this.appMain(this.m_startMainArgs);
            if (WrapperManager.isDebugEnabled()) {
                System.out.println("LoadedWrapperListener: start main method completed");
            }
            LoadedWrapperListener loadedWrapperListener = this;
            synchronized (loadedWrapperListener) {
                this.m_mainComplete = true;
                this.notifyAll();
            }
            return;
        }
        catch (Throwable e) {
            t = e;
            System.out.println("Encountered an error running start main: " + t);
            t.printStackTrace();
            LoadedWrapperListener loadedWrapperListener = this;
            synchronized (loadedWrapperListener) {
                if (this.m_waitTimedOut) {
                    WrapperManager.stop((int)1);
                    return;
                }
                this.m_mainComplete = true;
                this.m_mainExitCode = new Integer(1);
                this.notifyAll();
                return;
            }
        }
    }

    private void appMain(String[] args) {
        int i;
        System.out.println("App Main Starting.");
        System.out.println();
        for (int i2 = 0; i2 < 500; ++i2) {
            System.out.println(new Date() + "  Pre " + i2 + " of output. " + "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
        }
        Thread diskThrasher = new Thread("LoadedWrapperListener_DiskThrasher"){

            public void run() {
                LoadedWrapperListener.this.performDiskThrashing();
            }
        };
        diskThrasher.start();
        Thread memoryThrasher = new Thread("LoadedWrapperListener_MemoryThrasher"){

            public void run() {
                LoadedWrapperListener.this.performMemoryThrashing();
            }
        };
        memoryThrasher.start();
        for (i = 0; i < 4; ++i) {
            Thread cpuThrasher = new Thread("LoadedWrapperListener_CPUThrasher_" + i){

                public void run() {
                    LoadedWrapperListener.this.performCPUThrashing();
                }
            };
            cpuThrasher.start();
        }
        for (i = 0; i < 5000; ++i) {
            System.out.println(new Date() + "  Row " + i + " of output. " + "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
        }
        System.out.println();
        System.out.println("App Main Complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDiskThrashing() {
        while (!this.m_mainComplete) {
            File file = new File("loadedwrapperlistener.dat");
            try {
                PrintWriter w = new PrintWriter(new FileWriter(file));
                try {
                    for (int i = 0; i < 100; ++i) {
                        w.println(new Date() + "  Row " + i + " of output. " + "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
                    }
                }
                finally {
                    w.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            file.delete();
        }
    }

    private void performMemoryThrashing() {
        while (!this.m_mainComplete) {
            Object garbage = new byte[200][];
            for (int i = 0; i < ((byte[][])garbage).length; ++i) {
                garbage[i] = new byte[0x100000];
            }
            garbage = null;
            Runtime runtime = Runtime.getRuntime();
            long totalMemory = runtime.totalMemory();
            long freeMemory = runtime.freeMemory();
            System.out.println("Total Memory=" + totalMemory + ", " + "Used Memory=" + (totalMemory - freeMemory));
        }
    }

    private void performCPUThrashing() {
        while (!this.m_mainComplete) {
        }
    }

    public static void main(String[] args) {
        System.out.println();
        System.out.println("LoadedWrapperListener.main");
        WrapperManager.start((WrapperListener)new LoadedWrapperListener(), (String[])args);
    }
}

