/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.demo;

import java.awt.AWTError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import javax.swing.JOptionPane;
import org.tanukisoftware.wrapper.WrapperActionServer;
import org.tanukisoftware.wrapper.WrapperJNIError;
import org.tanukisoftware.wrapper.WrapperLicenseError;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcessConfig;
import org.tanukisoftware.wrapper.WrapperResources;
import org.tanukisoftware.wrapper.WrapperSystemPropertyUtil;
import org.tanukisoftware.wrapper.demo.CustomizeDialog;
import org.tanukisoftware.wrapper.demo.DeadLock;
import org.tanukisoftware.wrapper.demo.DemoAppMainFrame;
import org.tanukisoftware.wrapper.demo.LoggerThread;
import org.tanukisoftware.wrapper.demo.MailDialog;

public class DemoApp
implements WrapperListener {
    private WrapperActionServer m_actionServer;
    private static DemoAppMainFrame m_frame;
    private static boolean m_isTestCaseRunning;
    private static Process m_testCase;
    private static PrintStream m_childPrintStream;
    private static WrapperResources m_res;
    private String m_confFile;

    private DemoApp() {
        m_isTestCaseRunning = false;
        this.m_confFile = "../conf/demoapp.conf";
    }

    protected DemoAppMainFrame getFrame() {
        return m_frame;
    }

    protected void setTestCaseRunning(boolean val) {
        m_isTestCaseRunning = val;
    }

    protected boolean isTestCaseRunning() {
        return m_isTestCaseRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WrapperResources getRes() {
        if (m_res == null) {
            Class clazz = DemoApp.class;
            synchronized (clazz) {
                if (m_res == null) {
                    m_res = WrapperManager.loadWrapperResources((String)"wrapperTestApp", (String)WrapperSystemPropertyUtil.getStringProperty((String)"wrapper.lang.folder", (String)"../lang"));
                }
            }
        }
        return m_res;
    }

    public void controlEvent(int event) {
        System.out.println(DemoApp.getRes().getString("TestWrapper: controlEvent({0})", (Object)new Integer(event)));
        if (event == 202) {
            if (WrapperManager.isLaunchedAsService() || WrapperManager.isIgnoreUserLogoffs()) {
                System.out.println(DemoApp.getRes().getString("TestWrapper:   Ignoring logoff event"));
            } else {
                WrapperManager.stop((int)0);
            }
        } else if (event != 200) {
            WrapperManager.stop((int)0);
        }
    }

    public Integer start(String[] args) {
        String command = args.length <= 0 ? "dialog" : args[0];
        if (command.equals("dialog")) {
            System.out.println("Demo: start()");
            System.out.println(DemoApp.getRes().getString("Demo: Showing dialog..."));
            try {
                m_frame = new DemoAppMainFrame(this);
                m_frame.setVisible(true);
                try {
                    m_testCase = this.callAction("start");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (InternalError e) {
                System.out.println(DemoApp.getRes().getString("Demo: "));
                System.out.println(DemoApp.getRes().getString("Demo: ERROR - Unable to display the GUI:"));
                System.out.println("Demo:           " + e.toString());
                System.out.println("Demo: ");
                System.out.println(DemoApp.getRes().getString("Demo: This demo requires a display to show its GUI.  Exiting..."));
                command = "console";
            }
            catch (AWTError e) {
                System.out.println("Demo: ");
                System.out.println(DemoApp.getRes().getString("Demo: ERROR - Unable to display the GUI:"));
                System.out.println("Demo:           " + e.toString());
                System.out.println("Demo: ");
                System.out.println(DemoApp.getRes().getString("Demo: This demo requires a display to show its GUI.  Exiting..."));
                command = "console";
            }
            catch (UnsupportedOperationException e) {
                if (e.getClass().getName().equals("java.awt.HeadlessException")) {
                    System.out.println("Demo: ");
                    System.out.println(DemoApp.getRes().getString("Demo: ERROR - Unable to display the GUI:"));
                    System.out.println("Demo:           " + e.toString());
                    System.out.println("Demo: ");
                    System.out.println(DemoApp.getRes().getString("Demo: This demo requires a display to show its GUI.  Exiting..."));
                    command = "console";
                }
                throw e;
            }
        } else if (command.equals("start")) {
            Thread commandRunner = new Thread("DemoApp-Command-Runner"){

                public void run() {
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    String command = "";
                    System.out.println(DemoApp.getRes().getString("Started and waiting for a command from the Demo Application"));
                    while (command.compareToIgnoreCase("finish") != 0) {
                        try {
                            command = br.readLine();
                            System.out.println(DemoApp.getRes().getString("Read action: {0}", (Object)command));
                            if (command.equals("crash")) {
                                Thread.sleep(5000L);
                                System.out.println(DemoApp.getRes().getString("Going to cause the JVM to crash."));
                                WrapperManager.accessViolationNative();
                                continue;
                            }
                            if (command.equals("frozen")) {
                                WrapperManager.appearHung();
                                System.out.println(DemoApp.getRes().getString("Waiting until wrapper stops this JVM."));
                                while (true) {
                                    // Infinite loop
                                }
                            }
                            if (command.equals("out_of_mem")) {
                                int ii = 2;
                                System.out.println(DemoApp.getRes().getString("Going to cause a Out of Memory Error"));
                                Thread.sleep(5000L);
                                if (5 > ii) {
                                    DemoApp.getOutOfMemError();
                                }
                                System.out.println(DemoApp.getRes().getString("Application should get restarted now..."));
                                try {
                                    Thread.sleep(5000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                continue;
                            }
                            if (command.equals("deadlock")) {
                                if (WrapperManager.isStandardEdition()) {
                                    System.out.println(DemoApp.getRes().getString("Deadlock Tester Running..."));
                                    Object obj1 = new Object();
                                    Object obj2 = new Object();
                                    int exitCode = 1;
                                    DeadLock dl = new DeadLock(1, obj1, obj2);
                                    switch (exitCode) {
                                        case 1: {
                                            System.out.println(DemoApp.getRes().getString("2-object deadlock."));
                                            dl.create2ObjectDeadlock();
                                            break;
                                        }
                                        case 2: {
                                            System.out.println(DemoApp.getRes().getString("Wait then 2-object deadlock."));
                                            try {
                                                Thread.sleep(10000L);
                                            }
                                            catch (InterruptedException e) {
                                                // empty catch block
                                            }
                                            dl.create2ObjectDeadlock();
                                            break;
                                        }
                                        case 3: {
                                            System.out.println(DemoApp.getRes().getString("3-object deadlock."));
                                            dl.create3ObjectDeadlock();
                                            break;
                                        }
                                        default: {
                                            System.out.println(DemoApp.getRes().getString("Done."));
                                        }
                                    }
                                    try {
                                        System.out.println(DemoApp.getRes().getString("Sleeping for 5 sec..."));
                                        Thread.sleep(5000L);
                                    }
                                    catch (InterruptedException e) {
                                        // empty catch block
                                    }
                                    System.out.println(DemoApp.getRes().getString("Main Complete."));
                                    continue;
                                }
                                System.out.println(DemoApp.getRes().getString("Deadlock checks require at least the Standard Edition."));
                                continue;
                            }
                            if (command.indexOf("exec") != 0) continue;
                            try {
                                String input = command.substring(5);
                                System.out.println(DemoApp.getRes().getString("Starting a simple application: ") + input);
                                if (input == null || input.length() <= 0) continue;
                                WrapperManager.exec((String)input, (WrapperProcessConfig)new WrapperProcessConfig().setDetached(false));
                                System.out.println(DemoApp.getRes().getString("Successfully executed!"));
                            }
                            catch (SecurityException e) {
                                e.printStackTrace();
                            }
                            catch (NullPointerException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalArgumentException e) {
                                e.printStackTrace();
                            }
                            catch (UnsatisfiedLinkError e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            catch (WrapperJNIError e) {
                                e.printStackTrace();
                            }
                            catch (WrapperLicenseError e) {
                                e.printStackTrace();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            commandRunner.start();
        }
        return null;
    }

    public int stop(int exitCode) {
        System.out.println("Demo: stop(" + exitCode + ")");
        if (this.m_actionServer != null) {
            try {
                this.m_actionServer.stop();
            }
            catch (Exception e) {
                System.out.println(DemoApp.getRes().getString("Demo: Unable to stop the action server: {0}", (Object)e.getMessage()));
            }
        }
        if (m_frame != null) {
            if (!WrapperManager.hasShutdownHookBeenTriggered()) {
                m_frame.setVisible(false);
                m_frame.dispose();
            }
            m_frame = null;
        }
        return exitCode;
    }

    private Process callAction(String action) throws IOException {
        Process p = null;
        if (action.equals("mail")) {
            MailDialog md = new MailDialog();
            md.setVisible(true);
            if (md.getResult() != 0) {
                this.callAction("finish");
                try {
                    Thread.sleep(3000L);
                    if (m_isTestCaseRunning) {
                        System.out.println(DemoApp.getRes().getString("destroy!"));
                        m_testCase.destroy();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                String wrapperBin = WrapperManager.isWindows() ? "../bin/wrapper.exe" : "../bin/wrapper";
                String arg = wrapperBin + " -c " + this.m_confFile + " wrapper.console.flush=TRUE wrapper.console.format=LPM wrapper.console.direct=FALSE wrapper.app.parameter.1=start " + md.getEvents() + " wrapper.event.default.email.debug=TRUE wrapper.event.default.email.smtp.host=" + md.getServer() + " wrapper.event.default.email.smtp.port=" + md.getPort() + " wrapper.event.default.email.sender=" + md.getSender() + " wrapper.event.default.email.recipient=" + md.getRecipients();
                p = Runtime.getRuntime().exec(arg);
                m_childPrintStream = new PrintStream(p.getOutputStream());
                if (p != null) {
                    DemoApp.m_frame.jTabbedPane2.setSelectedIndex(1);
                    m_isTestCaseRunning = true;
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    LoggerThread setTextRun = new LoggerThread(br, this);
                    Thread t = new Thread(setTextRun);
                    t.start();
                }
            }
        } else if (action.equals("daemon")) {
            System.out.println(DemoApp.getRes().getString("Going to install an application as daemon - this requires root privileges"));
            p = Runtime.getRuntime().exec(" ../bin/testwrapper install");
            if (p != null) {
                DemoApp.m_frame.jTabbedPane2.setSelectedIndex(1);
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                LoggerThread setTextRun = new LoggerThread(br, this, true);
                Thread t = new Thread(setTextRun);
                t.start();
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                p = null;
                p = Runtime.getRuntime().exec("../bin/testwrapper remove");
                if (p != null) {
                    DemoApp.m_frame.jTabbedPane2.setSelectedIndex(1);
                    BufferedReader br2 = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    LoggerThread setTextRun2 = new LoggerThread(br2, this, true);
                    Thread t2 = new Thread(setTextRun2);
                    t2.start();
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            p = null;
        } else if (action.equals("service")) {
            p = Runtime.getRuntime().exec("..\\bin\\wrapper.exe -it " + this.m_confFile + " wrapper.console.flush=TRUE");
            if (p != null) {
                DemoApp.m_frame.jTabbedPane2.setSelectedIndex(1);
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                LoggerThread setTextRun = new LoggerThread(br, this, true);
                Thread t = new Thread(setTextRun);
                t.start();
            }
            p = null;
        } else if (action.equals("customize")) {
            CustomizeDialog cd = new CustomizeDialog();
            cd.setVisible(true);
            if (cd.getResult() == 1) {
                String arg = "\"" + cd.getSelectedSource() + "\"" + " --customize --target \"" + cd.getSelectedDestination() + "\"";
                if (cd.getSelectedIcon() != null && cd.getSelectedIcon().length() > 0) {
                    arg = arg.concat(" --icon \"" + cd.getSelectedIcon() + "\"");
                }
                if (cd.getSelectedSplashScreen() != null && cd.getSelectedSplashScreen().length() > 0) {
                    arg = arg.concat(" --splash \"" + cd.getSelectedSplashScreen() + "\"");
                }
                if ((p = Runtime.getRuntime().exec(arg)) != null) {
                    DemoApp.m_frame.jTabbedPane2.setSelectedIndex(1);
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    LoggerThread setTextRun = new LoggerThread(br, this, true);
                    Thread t = new Thread(setTextRun);
                    t.start();
                }
                p = null;
            }
        } else if (action.equals("start")) {
            String wrapperBin = WrapperManager.isWindows() ? "../bin/wrapper.exe" : "../bin/wrapper";
            String arg = wrapperBin + " -c " + this.m_confFile + " wrapper.console.flush=TRUE wrapper.console.format=LPM wrapper.console.direct=FALSE wrapper.app.parameter.1=" + action;
            if (!m_isTestCaseRunning) {
                p = Runtime.getRuntime().exec(arg);
                m_childPrintStream = new PrintStream(p.getOutputStream());
            }
            if (p != null) {
                DemoApp.m_frame.jTabbedPane2.setSelectedIndex(1);
                m_isTestCaseRunning = true;
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                LoggerThread setTextRun = new LoggerThread(br, this);
                Thread t = new Thread(setTextRun);
                t.start();
            }
        } else if (action.equals("finish")) {
            if (m_isTestCaseRunning) {
                m_childPrintStream.println(action);
                m_childPrintStream.flush();
                m_childPrintStream.close();
            }
        } else if (action.equals("exec")) {
            String input = "";
            input = System.getProperty("os.name").indexOf("Windows") >= 0 ? (String)JOptionPane.showInputDialog(m_frame, DemoApp.getRes().getString("Please enter the Command, you wish to execute:"), DemoApp.getRes().getString("Child Process Execution"), 3, null, null, "notepad") : (String)JOptionPane.showInputDialog(m_frame, DemoApp.getRes().getString("Please enter the Command, you wish to execute:"), DemoApp.getRes().getString("Child Process Execution"), 3, null, null, "xclock");
            if (input != null && input.length() > 0) {
                String wrapperBin = WrapperManager.isWindows() ? "../bin/wrapper.exe" : "../bin/wrapper";
                String arg = wrapperBin + " -c " + this.m_confFile + " wrapper.console.flush=TRUE wrapper.console.format=LPM wrapper.console.direct=FALSE wrapper.app.parameter.1=start";
                if (!m_isTestCaseRunning) {
                    p = Runtime.getRuntime().exec(arg);
                    m_childPrintStream = new PrintStream(p.getOutputStream());
                    m_frame.getJMenuBar().getMenu(0).getItem(0).setEnabled(false);
                    m_frame.getJMenuBar().getMenu(0).getItem(1).setEnabled(true);
                }
                if (p != null) {
                    DemoApp.m_frame.jTabbedPane2.setSelectedIndex(1);
                    m_isTestCaseRunning = true;
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    LoggerThread setTextRun = new LoggerThread(br, this);
                    Thread t = new Thread(setTextRun);
                    t.start();
                }
                m_childPrintStream.println(action + " " + input);
                m_childPrintStream.flush();
            }
        } else {
            String wrapperBin = WrapperManager.isWindows() ? "../bin/wrapper.exe" : "../bin/wrapper";
            String arg = wrapperBin + " -c " + this.m_confFile + " wrapper.console.flush=TRUE wrapper.console.format=LPM wrapper.console.direct=FALSE wrapper.app.parameter.1=start";
            if (!m_isTestCaseRunning) {
                p = Runtime.getRuntime().exec(arg);
                m_childPrintStream = new PrintStream(p.getOutputStream());
                m_frame.getJMenuBar().getMenu(0).getItem(0).setEnabled(false);
                m_frame.getJMenuBar().getMenu(0).getItem(1).setEnabled(true);
            }
            if (p != null) {
                DemoApp.m_frame.jTabbedPane2.setSelectedIndex(1);
                m_isTestCaseRunning = true;
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                LoggerThread setTextRun = new LoggerThread(br, this);
                Thread t = new Thread(setTextRun);
                t.start();
            }
            m_childPrintStream.println(action);
            m_childPrintStream.flush();
        }
        return p == null ? m_testCase : p;
    }

    protected boolean doAction(String action) {
        try {
            m_testCase = this.callAction(action);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    static void getOutOfMemError() {
        try {
            throw new OutOfMemoryError(DemoApp.getRes().getString("BANG"));
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        System.out.println(DemoApp.getRes().getString("DemoApp: Initializing..."));
        WrapperManager.start((WrapperListener)new DemoApp(), (String[])args);
    }
}

