/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.demo.AboutDialog;
import org.tanukisoftware.wrapper.demo.DemoApp;

public class DemoAppMainFrame
extends JFrame
implements ActionListener,
WindowListener {
    private DemoApp m_this;
    private static final long serialVersionUID = -3847376282833547574L;
    JScrollPane m_logPane;
    protected JEditorPane m_logTextArea;
    JScrollPane jScrollPane2;
    JEditorPane jEditorPane2;
    JTabbedPane jTabbedPane2;

    protected JEditorPane getlogTextArea() {
        return this.m_logTextArea;
    }

    protected JEditorPane getDescTextArea() {
        return this.jEditorPane2;
    }

    DemoAppMainFrame(DemoApp m_this) {
        super(DemoApp.getRes().getString("Wrapper Demo Application"));
        this.m_this = m_this;
        this.init();
        this.setLocationRelativeTo(null);
        this.setResizable(true);
    }

    private void init() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("?");
        JMenuItem about = new JMenuItem(DemoApp.getRes().getString("About.."));
        about.setActionCommand("about");
        about.addActionListener(this);
        this.addWindowListener(this);
        JMenu jMenu1 = new JMenu();
        jMenu1.setText(DemoApp.getRes().getString("Test"));
        JMenuItem jMenuItem1 = new JMenuItem();
        jMenuItem1.setText(DemoApp.getRes().getString("Start Test"));
        jMenuItem1.setEnabled(false);
        jMenuItem1.setActionCommand("start");
        jMenuItem1.addActionListener(this);
        jMenu1.add(jMenuItem1);
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setText(DemoApp.getRes().getString("Stop Test"));
        jMenuItem2.setActionCommand("finish");
        jMenuItem2.addActionListener(this);
        jMenu1.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem();
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(115, 512));
        jMenuItem3.setText(DemoApp.getRes().getString("Close"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DemoAppMainFrame.this.m_this.doAction("finish");
                WrapperManager.stopAndReturn((int)0);
            }
        });
        jMenu1.add(jMenuItem3);
        this.setJMenuBar(menuBar);
        menu.add(about);
        menuBar.add(jMenu1);
        menuBar.add(menu);
        this.setDefaultCloseOperation(0);
        GridBagLayout gridBag1 = new GridBagLayout();
        GridBagLayout gridBag2 = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        GridBagConstraints c2 = new GridBagConstraints();
        JPanel panel1 = new JPanel();
        panel1.setLayout(gridBag1);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(DemoApp.getRes().getString("Failure Detections"), panel1);
        tabbedPane.setMnemonicAt(0, 49);
        this.buildCommand(panel1, gridBag1, c1, 1, DemoApp.getRes().getString("Crash"), "crash", DemoApp.getRes().getString("Simulate an Application Crash"));
        this.buildCommand(panel1, gridBag1, c1, 1, DemoApp.getRes().getString("Out of Memory"), "out_of_mem", DemoApp.getRes().getString("Simulate a Out Of Memory Error"));
        this.buildCommand(panel1, gridBag1, c1, 1, DemoApp.getRes().getString("Frozen"), "frozen", DemoApp.getRes().getString("Simulate a Frozen JVM"));
        this.buildCommand(panel1, gridBag1, c1, 2, DemoApp.getRes().getString("Deadlock"), "deadlock", DemoApp.getRes().getString("Simulate a Thread Deadlock"));
        JPanel panel2 = new JPanel();
        panel2.setLayout(gridBag2);
        tabbedPane.addTab(DemoApp.getRes().getString("Feature Demo"), panel2);
        tabbedPane.setMnemonicAt(1, 50);
        this.buildCommand(panel2, gridBag2, c2, 3, DemoApp.getRes().getString("Email"), "mail", DemoApp.getRes().getString("Activates the email functionality"));
        this.buildCommand(panel2, gridBag2, c2, 3, DemoApp.getRes().getString("WrapperExec"), "exec", DemoApp.getRes().getString("Creates a managed Child Process"));
        String os = System.getProperty("os.name");
        if (os.indexOf("Windows") >= 0) {
            this.buildCommand(panel2, gridBag2, c2, 2, DemoApp.getRes().getString("Customization"), "customize", DemoApp.getRes().getString("Creates a customized Binary of the wrapper"));
            this.buildCommand(panel2, gridBag2, c2, 1, DemoApp.getRes().getString("Service"), "service", DemoApp.getRes().getString("Installs and starts this app as Windows Service"));
        } else {
            this.buildCommand(panel2, gridBag2, c2, 1, DemoApp.getRes().getString("Daemon"), "daemon", DemoApp.getRes().getString("Installs and starts this app as Daemon"));
        }
        this.m_logTextArea = new JEditorPane();
        this.jEditorPane2 = new JEditorPane();
        this.m_logTextArea.setContentType("text/html;");
        this.jEditorPane2.setContentType("text/html; charset=UTF-8");
        this.jEditorPane2.setEditable(false);
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: 14pt; }";
        ((HTMLDocument)this.jEditorPane2.getDocument()).getStyleSheet().addRule(bodyRule);
        this.m_logTextArea.setEditable(false);
        this.jTabbedPane2 = new JTabbedPane();
        this.m_logPane = new JScrollPane(this.m_logTextArea);
        this.jScrollPane2 = new JScrollPane(this.jEditorPane2);
        this.jTabbedPane2.setPreferredSize(new Dimension(800, 400));
        this.jTabbedPane2.addTab(DemoApp.getRes().getString("Description"), this.jScrollPane2);
        this.jTabbedPane2.addTab(DemoApp.getRes().getString("Wrapper Output"), this.m_logPane);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tabbedPane, "First");
        this.getContentPane().add((Component)this.jTabbedPane2, "Center");
        this.setVisible(true);
        this.pack();
        tabbedPane.setMaximumSize(new Dimension(tabbedPane.getMaximumSize().width, tabbedPane.getSize().height));
    }

    private void buildCommand(JComponent container, GridBagLayout gridBag, GridBagConstraints c, int level, String label, String command, Object description) {
        JButton button = new JButton(label);
        button.setActionCommand(command);
        c.fill = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.insets = new Insets(10, 10, 10, 10);
        gridBag.setConstraints(button, c);
        container.add(button);
        button.addActionListener(this);
        JButton buttonhelp = new JButton("?");
        buttonhelp.setActionCommand("help" + command);
        c.fill = 0;
        c.gridwidth = 1;
        c.gridx = 1;
        c.insets = new Insets(10, 10, 10, 10);
        gridBag.setConstraints(buttonhelp, c);
        container.add(buttonhelp);
        buttonhelp.addActionListener(this);
        c.fill = 0;
        c.gridwidth = 0;
        JComponent desc = description instanceof String ? new JLabel((String)description) : (description instanceof JComponent ? (JComponent)description : new JLabel(description.toString()));
        c.gridx = 2;
        c.insets = new Insets(10, 10, 10, 10);
        gridBag.setConstraints(desc, c);
        container.add(desc);
        if (level == 2) {
            if (!WrapperManager.isStandardEdition()) {
                button.setEnabled(false);
                button.setToolTipText(DemoApp.getRes().getString("Requires the Standard Edition."));
            }
        } else if (level == 3 && !WrapperManager.isProfessionalEdition()) {
            button.setEnabled(false);
            button.setToolTipText(DemoApp.getRes().getString("Requires the Professional Edition."));
        }
    }

    String getHTMLDescription(String action) {
        try {
            BufferedReader br;
            String rsname = "html/" + action + "_" + Locale.getDefault().getLanguage() + ".html";
            URL url = this.getClass().getResource(rsname);
            try {
                br = new BufferedReader(new InputStreamReader(url.openStream(), "utf8"));
            }
            catch (NullPointerException npe1) {
                try {
                    br = new BufferedReader(new InputStreamReader(this.getClass().getResource("html/" + action + "_en.html").openStream(), "utf8"));
                }
                catch (NullPointerException npe2) {
                    return "<html>" + DemoApp.getRes().getString("No description for {0} found...", (Object)action) + "</html>";
                }
            }
            char[] buffer = new char[4096];
            String t = "";
            while (br.read(buffer) != -1) {
                t = t.concat(new String(buffer));
            }
            ((Reader)br).close();
            return t;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "<html>" + DemoApp.getRes().getString("No description for {0} found...", (Object)action) + "</html>";
        }
    }

    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (!action.startsWith("help")) {
            if (action.equals("start")) {
                this.getJMenuBar().getMenu(0).getItem(0).setEnabled(false);
                this.getJMenuBar().getMenu(0).getItem(1).setEnabled(true);
                this.m_this.doAction(action);
            } else if (action.equals("finish")) {
                this.getJMenuBar().getMenu(0).getItem(0).setEnabled(true);
                this.getJMenuBar().getMenu(0).getItem(1).setEnabled(false);
                this.m_this.doAction(action);
            } else if (action.equals("about")) {
                this.createAboutScreen();
            } else if (action.equals("daemon")) {
                this.jEditorPane2.setText(this.getHTMLDescription(action));
                this.jEditorPane2.setCaretPosition(0);
                this.jTabbedPane2.setSelectedIndex(1);
                this.m_this.doAction(action);
            } else {
                this.jEditorPane2.setText(this.getHTMLDescription(action));
                this.jEditorPane2.setCaretPosition(0);
                this.jTabbedPane2.setSelectedIndex(1);
                this.m_this.doAction(action);
            }
        } else {
            this.jEditorPane2.setText(this.getHTMLDescription(action.substring(4)));
            this.jEditorPane2.setCaretPosition(0);
            this.jTabbedPane2.setSelectedIndex(0);
        }
    }

    private void createAboutScreen() {
        new AboutDialog(this).setVisible(true);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (!this.m_this.isTestCaseRunning() || JOptionPane.showConfirmDialog(this, DemoApp.getRes().getString("A test case is still running.\nDo you really want to exit and stop this one??")) == 0) {
            System.out.println(DemoApp.getRes().getString("Stopping..."));
            this.m_this.doAction("finish");
            WrapperManager.stopAndReturn((int)0);
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

