/* $Id: xbabylon.h,v 1.2 2004/05/16 10:32:01 makigura Exp $ */
#ifndef XBABYLON_H
#define XBABYLON_H
/*
 * xbabylon translator, the translator on X Window System.
 * Copyright (c) 2001 Shigeki Kaneko, all right reserved.
 */
#include <unistd.h>
#include <stdio.h>

#ifdef NDEBUG
# undef DEBUG
#endif

#define ERR			(-1)
#define XBUFSIZ			(8192)
#define MAXWORDLENGTH		(100)	// max length of the word to search

#ifdef DEBUG
# ifndef DEBUG_PRINT
# define DEBUG_PRINT		(1)
# endif
#endif

#ifdef DEBUG_PRINT
# define Dprint(a)		printf a
#else
# define Dprint(a)
#endif

#define PrintUsage(s)	{fprintf(stderr,"Usage: %s [-hv] [-d dictionary_file]\n",(s));}

typedef enum {FALSE = 0, TRUE = 1} Boolean;

#ifndef DICT_FILE
# define DICT_FILE 		("ejdic.euc")
#endif

/* Utility macro to test characters, it is inappropriate and not work
   with JP */
#define IsPrintable(t)	(((t) >> 5) && (t) != 0x7f)
#define IsUpperCase(t)	((t) >= 'A' && (t) <= 'Z')
#define IsLowerCase(t)	((t) >= 'a' && (t) <= 'z')
#define IsSpace(t)	((t) == ' ' || (t) == '\t')
#define IsSeparator(t)	((t) == ':' || (t) == ';' || (t) == '.' || (t) == ',')
#define ToLowerCase(t)	((t) -= 'A' - 'a')
#define ToUpperCase(t)	((t) += 'A' - 'a')

/* ------> offset
 * word   translation.............
 */
typedef struct translation_s Translation;
struct translation_s {
    int   	length;		// whole length of the string in buf
    int   	offset;		// offset to point the start of translation
    char  	*buf;		// translation buffer structured: word  translation
    Translation *next;		// next result;
};

/*
 * Search word list, it it the list of words to try finding.
 */
typedef struct searchword_s Searchword;
struct searchword_s {
    int         length;         // whole length of the word.
    char        *word;          // word to search.
    Boolean     exact_match;    // must be found exact match word.
    Searchword  *next;          // next word.
};

extern Translation * SearchWord (char *, Searchword *);
extern Translation * GetTranslationBuffer (int);
extern Searchword * GetSearchwordBuffer (int);
extern void  FreeSearchwordBuffer(Searchword *);
#endif // XBABYLON_H
