<?php
/*
 * A class for Xml Perse Sample. 
 *
 * PHP 5 >
 *
 * @author     Jun Yamane <jun1969x[at]gmail.com>
 * @license    BSD http://www.opensource.org/licenses/bsd-license.html
 * @version    ver 0.13 (2011-01-24)
 * @link       http://sourceforge.jp/projects/xbrl-php/
 *
 */

$ob_ = new SAMPLE;
$ob_->common();

class SAMPLE {
	const TITLE = "XML for PHP";
	const UPLOAD_SIZE = 100000;
	const URL_BASE = "http://sourceforge.jp/projects/xbrl-php/";
	private $BENCH;
	private $LANGUAGE;
	private $SUB_TITLE;
	private $TMP = "./tmp/";
/**********************************************************
Conf
**********************************************************/
	function __construct() {
// Bench Time Start
		$this->getTime();
// Language Choice
		$this->LANGUAGE = ($_REQUEST["lang"]==="en") ? "en" : "jp";
// Class Require
		$class_ary = array("XML"=>"/xml/XML", "LANG"=>"/lang/".$this->LANGUAGE);
		foreach($class_ary as $class=>$dir) {
			if(!class_exists($class, false)) {
				require(dirname(__FILE__).$dir.".php");  
				$this->$class = new $class;
			}
		}
// Change Class "XML" Properties
		$change_ary = array(
			"ATTR" => "_attr:",
			"NS" => "_name_space",
			"VAL" => "_val:"
		);
		$this->XML->changeProperties($change_ary);
	}
/**********************************************************
Echo
**********************************************************/
	public function common() {
// http://www.php.net/manual/en/features.file-upload.errors.php#53278
		$message = array(
"",
"The uploaded file exceeds the upload_max_filesize directive in php.ini",
"The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form",
"The uploaded file was only partially uploaded",
"No file was uploaded",
"Missing a temporary folder"
		); 
		switch($_REQUEST["id"]) {
		case "source" :
			$this->SUB_TITLE = " - ".LANG::I_03;
			$body = $this->_HtmlBodyHighlightFile();
			break;
		case "xml" :
			$this->SUB_TITLE = " - XML ".LANG::I_00;
			$menu = $this->_HtmlMenu();
			$body = $this->_HtmlBodyXML($message);
			break;
		default :
			$this->SUB_TITLE = "";
			$body = $this->_HtmlBodyIndex();
		}
		echo '<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-8" />
		<meta http-equiv="Content-Style-Type" content="text/css; charset=utf-8" />
		<meta http-equiv="Content-Script-Type" content="text/javascript; charset=utf-8" />
		<link rel="bookmark" title="'.self::TITLE.'" href="'.self::URL_BASE.'" />
		<style>
		<!--
			h1, h2, h3 {margin:0.2em; padding:0.2em;}
			body {font-size:14px;}
			code {background:#ccc; padding:0.3em; display:block;}
			dd {margin:0 0.3em;}
			div {clear:both;}
			dl {float:left; margin-right:1em;}
			dt {font-weight:bold;}
			em {color:#666; font-size:0.9em;}
			h1 {font-size:2em; border-top:3px double #aaa; border-bottom:3px double #aaa;}
			h2 {font-size:1.6em;}
			h3 {font-size:1.4em;}
			p {margin:0.3em 0;}
		-->
		</style>
		<script type="text/javascript" src="./xbrl.js"></script>
		<title>'.self::TITLE.$this->SUB_TITLE.'</title>
	</head>
	<body>
		'.$this->_lang().'
		<h1><a href="'.$this->_url().'" title="Top Page" style="text-decoration:none;">'.self::TITLE.'</a>'.$this->SUB_TITLE.'</h1>
		'.$menu.'
		<div>
			'.$body.'
		</div>';
		echo '		<div>
			<hr />
			<p><a href="'.$this->_url().'">'.self::TITLE.'</a></p>
			'.self::TITLE.' '.LANG::I_10.'<br /><a href="'.self::URL_BASE.'">'.self::URL_BASE.'</a><br />
			*'.LANG::I_11a.'"'.self::TITLE.'"'.LANG::I_11b.' ! &nbsp; &nbsp;'.$this->getTime("end").'
		</div>
	</body>
</html>';
	}
/**********************************************************
Benchmark Time
**********************************************************/
	public function getTime($id="") {
		list($usec, $sec) = explode(" ", microtime()); 
		$time = ((float)$sec + (float)$usec)*10000; 
		if(!$this->BENCH) {
			$this->BENCH = $time; 
		}else {
			$ptime = intval($time - $this->BENCH)/10000;
			if($id=="end") {
				return " (".number_format($ptime, 3)." sec)";
			}else {
				$info = debug_backtrace();
				echo '<p>@</p><p><strong style="background:yellow;">'.$ptime.' sec. ['.$info[0]["file"].':'.$info[0]["line"].']</strong></p>';
				if($id==1) {
					exit;
				}
			}
		}
	}
/**********************************************************
HTML Body Index
**********************************************************/
	private function _HtmlBodyIndex() {
		$m_title = (self::TITLE==="XBRL for PHP") ? LANG::I_F01 : LANG::I_F01a;
		$body = $this->_HtmlParts("start")."
<h2><a href=\"./manual/".$this->LANGUAGE."/\">* ".self::TITLE." ".LANG::I_01."</a></h2>
<ul>
<li>".$m_title."</li>
</ul>
<h2><a href=\"".$this->_url("?id=xml")."\">* XML ".LANG::I_00." ".LANG::I_02."</a></h2>
".$this->_HtmlParts("xml", 1)."
<h2>* ".LANG::I_F02."</h2>
".$this->_HtmlParts("source", 1);
		return $body;
	}
/**********************************************************
HTML Body Highlight File
**********************************************************/
	private function _HtmlBodyHighlightFile() {
		$file = $this->XML->h(urldecode($_REQUEST["file"]));
		$body = (file_exists($file)) ? highlight_file($file, true) : "<pre><code>No file</code></pre>";
		return "<h2>".$file."</h2>".$body."<hr />".$this->_HtmlParts("source");
	}
/**********************************************************
HTML Body XML
**********************************************************/
	private function _HtmlBodyXML($message="") {
		if($em = $_GET["sample"]) {
			$body = $this->_xmlFile($em);
		}else if($_FILES["upfile"]) {
			$body = $this->_xmlUpload($em, $message);
		}else if($em = $_POST["geturl"]) {
			$body = $this->_xmlGeturl($em);
		}else {
			$body = $this->_HtmlParts("xml");
		}
		return "<hr />".$body;
	}
/**********************************************************
HTML Menu
**********************************************************/
	private function _HtmlMenu($id="") {
		$z = ($id=="xbrl") ? array("XBRL", "Only", "xbrl") : array("XML", "OK!", "xml", "<dd>&nbsp;tdnet-acedjpsm-32480.xml</dd>");
		$zip_show = (self::TITLE==="XBRL for PHP") ? " (*Zip ".$z[1].")" : "";
		$zip_sample = (self::TITLE==="XBRL for PHP") ? "<dd>&nbsp;XBRL_20101125_111441.zip</dd>" : "";
		$menu1 = '<dl>
			<dt>'.LANG::I_02.' '.$z[0].'</dt>
'.$this->_xmlFileAry($id).'			<dd>&nbsp;</dd>
		</dl>
		<dl>
			<dt>'.$z[0].' '.LANG::I_04.$zip_show.'</dt>
			<dd>
				<form action="./" method="post" enctype="multipart/form-data">
					<div>
						<input type="hidden" name="max_file_size" value="'.self::UPLOAD_SIZE.'" />
						'.LANG::I_08.'：<input type="file" name="upfile" size="30" />
						<p><input type="submit" value="'.LANG::I_05.'" /> (*'.LANG::I_06.' '.intval(self::UPLOAD_SIZE/1000).'kb)</p>
						<input type="hidden" name="id" value="'.$z[2].'" />
					</div>
				</form>
			</dd>
			<dd>('.LANG::I_07.')</dd>
			'.$z[3].'
			'.$zip_sample.'
		</dl>';
		$menu2 = '		<dl>
			<dt>'.LANG::I_09.' (*XML)</dt>
			<dd>
				<form action="./" method="post">
					<div>
						Url：<input type="text" name="geturl" size="30" />
						<p><input type="submit" value="Push" /></p>
						<input type="hidden" name="id" value="xml" />
					</div>
				</form>
			</dd>
			<dd>('.LANG::I_07.')</dd>
			<dd>&nbsp;http://bit.ly/hqO6aC</dd>
			<dd>&nbsp;http://bit.ly/gj8DcD</dd>
		</dl>';
		return ($id=="xbrl") ? $menu1 : $menu1.$menu2;
	}
/**********************************************************
HTML Parts
**********************************************************/
	private function _HtmlParts($id="", $jd="") {
		switch($id) {
		case "source" :
			$body = "	<li>/xbrlphp
	<ul>
		<li>/xml
		<ul>
			<li><a href=\"".$this->_url("?id=source&file=".urlencode("./xml/XML.php"))."\">XML.php</a>：<em>XML".LANG::I_F03." Class \"XML\"</em></li>
		</ul>
		</li>
		<li>/lang : <em>\"".self::TITLE."\" ".LANG::I_F07."</em>
		<ul>
			<li><a href=\"".$this->_url("?id=source&file=".urlencode("./lang/".$this->LANGUAGE.".php"))."\">".$this->LANGUAGE.".php</a></li>
			<li>...</li>
		</ul>
		</li>
		<li>/manual : <em>\"".self::TITLE."\" ".LANG::I_F08."</em>
		<ul>
			<li>/".$this->LANGUAGE."</li>
			<li>...</li>
		</ul>
		</li>
		<li>/sample : <em>\"".self::TITLE."\" ".LANG::I_F09."</em>
		<ul>
			<li>sample1.xml</li>
			<li>...</li>
		</ul>
		</li>
		<li>/tmp : <em>".LANG::I_F10."</em></li>
		<li><a href=\"".$this->_url("?id=source&file=".urlencode("./index.php"))."\">index.php</a> : <em>\"".self::TITLE."\" ".LANG::I_F11." (*PHP)</em></li>
		<li><a href=\"".$this->_url("?id=source&file=".urlencode("./history.txt"))."\">history.txt</a> : <em>\"".self::TITLE."\" ".LANG::I_F12." (*Japanese only)</em></li>
	</ul>
	</li>";
			break;
		case "start" :
			$add = (self::TITLE==="XBRL for PHP") ? "<li>".LANG::I_B03."</li>" : "";
			$body = "<li>".LANG::I_B01."</li>
<li>".LANG::I_B02."</li>
".$add;
			break;
		case "xml" :
			$add = (self::TITLE==="XBRL for PHP") ? "<li>".LANG::I_A04."</li>" : "";
			$body = "<li>".LANG::I_A01."</li>
<li>".LANG::I_A02."</li>
<li>".LANG::I_A03."</li>
".$add."
<li>".LANG::I_A05."</li>
<li>".LANG::I_A06."</li>";
			break;
		case "xbrl" :
			$body = "<li>".LANG::I_C01."</li>
<li>".LANG::I_C02."</li>
";
			$lists = "<h3>".LANG::I_D01."</h3>
<ul>
<li>".LANG::I_D02."</li>
<li>".LANG::I_D03."</li>
<li>".LANG::I_D04."</li>
<li>".LANG::I_D05."</li>
</ul>";
			break;
		}
		return ($jd) ? "<ul>".$body."</ul>" : "<h2>".$this->SUB_TITLE."</h2>
<ul>
".$body."
</ul>"
.$lists;
	}
/**********************************************************
Lang
**********************************************************/
	private function _lang() {
		$url = "http://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
		if($_REQUEST["lang"]!=="en") {
			$jd = ($_SERVER["QUERY_STRING"]) ? "&" : "?";
			return "<strong>".LANG::I_12."</strong> | <a href=\"".$url.$jd."lang=en\">English</a>";
		}else {
			$url = preg_replace("/[&\?]lang=en/", "", $url);
			return "<a href=\"".$url."\">".LANG::I_12."</a> | <strong>English</strong>";
		}
	}
/**********************************************************
Url
**********************************************************/
	private function _url($url="") {
		if($_REQUEST["lang"]==="en") {
			$p = parse_url($url);
			$add = ($p["query"]) ? "&" : "?";
			$url .= $add."lang=".$_REQUEST["lang"];
		}
		return $this->XML->h("./".$url);
	}
/**********************************************************
Print Perse
**********************************************************/
	private function _xmlPrintPerse($array="", $num="") {
		switch($_GET["echo"]) {
		case "json" :
			$pre[0] = "<br />&nbsp;";
			$array = json_encode($array);
			break;
		case "serialize" :
			$pre[0] = "<br />&nbsp;";
			$array = serialize($array);
			break;
		default :
			$pre = array("<pre>", "</pre>");
			$_GET["echo"] = "array";
		}
		if($num) {
			foreach(array("array", "json", "serialize") as $val) {
        $flag = ($_GET["echo"]!=$val) ? "" : " style=\"background:yellow;\"";
				$ch[] = "<a href=\"".$this->_url("?id=xml&sample=".$num."&echo=".$val)."\"".$flag.">".$val."</a>";
			}
			$change = " [ ".implode(" | ", $ch)." ]";
		}
		return $change.$pre[0]."
<code>
".$this->XML->h(print_r($array, true))."
</code>
".$pre[1];
	}
/**********************************************************
Sample File
**********************************************************/
	private function _xmlFile($em="") {
		$file = "sample".$em.".".$this->_xmlFileAry($em);
		$dir = "./sample/".$file;
		$file = "<a href=\"".$dir."\" target=\"_blank\">".$file."</a>";
		$body = $this->_xmlPrintPerse($this->XML->perseXml($dir), $em);
		return "<h2>XML ".LANG::I_00."</h2>"
.$file.$body;
	}
/**********************************************************
Sample File Array
**********************************************************/
	private function _xmlFileAry($id="") {
		$ary = array(
1 => "xml",
2 => "xml",
3 => "xsd",
4 => "xbrl",
5 => "xhtml",
6 => "rdf"
		);
		if(!$id) {
			foreach($ary as $key=>$val) {
        $flag = ($_GET["sample"]!=$key) ? "" : " style=\"background:yellow;\"";
				$data .= "			<dd><a href=\"".$this->_url("?id=xml&sample=".$key)."\"".$flag.">sample".$key.".".$val."</a></dd>\n";
			}
			return $data;
		}else if($id=="xbrl") {
			return "			<dd><a href=\"".$this->_url("?id=xbrl&sample=7")."\">sample7.zip</a></dd>\n";
		}else {
			return $ary[$id];
		}
	}
/**********************************************************
Sample Upload
**********************************************************/
	private function _xmlUpload($em="", $message="") {
		$file = $this->TMP.$_FILES["upfile"]["name"];
		$fname = $file;
		if(is_uploaded_file($em = $_FILES["upfile"]["tmp_name"])) {
			$file = $em;
			$body = $this->_xmlPrintPerse($this->XML->perseXml($file));
		}else if($id = $_FILES["upfile"]["error"]) {
			$body = "<pre><code>".print_r(array("error", $message[$id]), true)."</code></pre>";
		}
		return "<h2>XML ".LANG::I_00."</h2>"
.$fname.$body;
	}
/**********************************************************
Sample Geturl
**********************************************************/
	private function _xmlGeturl($file="") {
		$data = $this->_xmlPrintPerse($this->XML->perseXml($file));
		return "<h2>XML ".LANG::I_00."</h2>
<a href=\"".$file."\" target=\"_blank\">".$file."</a>"
.$data;
	}
}
?>