<?php
/**
 * @file
 * @package xdbase
 * @version $Id: DataListAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractListAction.class.php';

class Xdbase_DataListAction extends Xdbase_AbstractListAction
{
	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data');
		return $handler;
	}

	/**
	 * @protected
	 */
	function &_getFilterForm()
	{
		$filter =& $this->mController->create('filter', 'data');
		$filter->prepare($this->_getPageNavi(), $this->_getHandler());
		return $filter;
	}

	/**
	 * @protected
	 */
	function _getBaseUrl()
	{
		return './index.php?action=DataList';
	}

	/**
	 * @public
	 */
	function executeViewIndex()
	{
		$handler =& $this->_getHandler();

		$GLOBALS['xoopsOption']['template_main'] = $this->mController->mDirname.'_'._MD_XDBASE_CONST_LIST_TPT;

		$this->mTpl->assign('objects', $this->mObjects);
		$this->mTpl->assign('pageNavi', $this->mFilter->mNavi);
		$this->mTpl->assign('filter', $this->mFilter);
		$this->mTpl->assign('handler', $handler);

		// categories options
		$catHandler =& $this->mController->load('handler', 'cat');
		$catHandler->setTree($catHandler->getCriteria());
		$this->mTpl->assign('catHandler', $catHandler);
		$cid = $this->mFilter->getCid();
		if ($cid != 0)
		{
			$selectedCatObject =& $catHandler->get($cid);
			$this->mTpl->assign('selectedCatObject', $selectedCatObject);
		}

		// for bbs style post form
		if (_MD_XDBASE_CONST_LIST_TPT == 'data_list_bbs_style.html')
		{
			$this->mActionForm =& $this->mController->create('form', 'edit_data');
			$this->mActionForm->prepare();
			$this->mTpl->assign('actionForm', $this->mActionForm);
		}

		$pageTitle = trim($catHandler->getCatTitle($cid));
		if ($pageTitle != '')
		{
			$this->mTpl->assign('xoops_pagetitle', $this->mTpl->get_template_vars('xoops_pagetitle').' - '.$pageTitle);
		}

	}

}

?>
