<?php
/**
 * @file
 * @package xdbase
 * @version $Id: DataListAjaxAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/AbstractListAction.class.php';

class Xdbase_DataListAjaxAction extends Xdbase_AbstractListAction
{
	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data');
		return $handler;
	}

	/**
	 * @protected
	 */
	function &_getFilterForm()
	{
		$filter =& $this->mController->create('filter', 'data');
		$filter->prepare($this->_getPageNavi(), $this->_getHandler());
		return $filter;
	}

	/**
	 * @protected
	 */
	function _getBaseUrl()
	{
		return './index.php?action=DataList';
	}


	/**
	 * @public
	 */
	
	// for ajax style
	function executeViewIndex()
	{

		$getTotal = xdbaseGetRequest('getTotal');
		$getCriteria = xdbaseGetRequest('getCriteria');

		if ($getCriteria)
		{
			$this->getDataCriteria();
		}

		if ($getTotal)
		{
			$this->getDataTotal();
		}
		else
		{
			$this->getJsonData();
		}
	}

	function getDataCriteria()
	{
		$criteria =& $this->mFilter->getCriteria();
//		echo $criteria->render();
		echo intval(xdbaseGetRequest('start'));
		exit();
	}

	function getDataTotal()
	{
		if (!xoops_refcheck())
		{
			$this->mController->executeRedirect('./index.php', 1, _MD_XDBASE_ERROR_CONTENT_IS_NOT_FOUND);
		}

		$handler =& $this->mController->load('handler', 'data');
		$criteria =& $this->mFilter->getCriteria();
		$dataTotal = intval($handler->getCount($criteria));

		echo $dataTotal;
		exit();
	}

	function getJsonData()
	{
		if (!xoops_refcheck())
		{
			$this->mController->executeRedirect('./index.php', 1, _MD_XDBASE_ERROR_CONTENT_IS_NOT_FOUND);
		}

		// ϡʸɤUTF-8
//		mb_http_output('EUC_JP');
//		mb_internal_encoding('EUC_JP');

		$handler =& $this->mController->load('handler', 'data');
		$start = intval(xdbaseGetRequest('start'));
		$perpage = intval(xdbaseGetRequest('perpage'));
		if ($perpage > 10) $perpage = 10;
//		$start = null;
//		$perpage = 0;
		$criteria =& $this->mFilter->getCriteria($start, $perpage);
//		$criteria =& $this->mFilter->getCriteria();
		$dataObjects =& $handler->getObjects($criteria);
		$keyArray = $handler->getShowListKeyArray();

		$retArray = array();
		$i = 0;
		foreach ($dataObjects as $object)
		{
			foreach ($keyArray as $key)
			{
				$retArray['item'][$i][$key] = mb_convert_encoding($object->getShow($key), 'UTF-8', 'EUC_JP');
			}
			$i++;
		}
		$result = json_encode($retArray);

		echo $result;
		exit();
	}


}

?>
