<?php
/**
 * @file
 * @package xdbase
 * @version $Id: CatListAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractListAction.class.php';

class Xdbase_Admin_CatListAction extends Xdbase_AbstractListAction
{
	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'cat');
		return $handler;
	}

	/**
	 * @protected
	 */
	function &_getFilterForm()
	{
		$filter =& $this->mController->create('filter', 'admin.cat');
		$filter->prepare($this->_getPageNavi(), $this->_getHandler());
		return $filter;
	}

	/**
	 * @protected
	 */
	function _getBaseUrl()
	{
		return './index.php?action=CatList';
	}

	/**
	 * @public
	 */
	function executeViewIndex()
	{
		$this->setParentTitle();

		$this->mTpl->assign('objects', $this->mObjects);
		$this->mTpl->assign('pageNavi', $this->mFilter->mNavi);
		$this->mTpl->assign('pageNaviHtml', $this->mFilter->mNavi->renderNaviHtml());

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/cat_list.html');
	}

	function setParentTitle()
	{
		$handler =& $this->mController->load('handler', 'cat');

		if (count($this->mObjects) > 0)
		{
			foreach ($this->mObjects as $object)
			{
				$catObject =& $handler->get($object->get('pid'));
				if (is_object($catObject))
				{
					$object->initVar('ptitle', XOBJ_DTYPE_STRING, '', false, 255);
					$object->assignVar('ptitle', $catObject->getShow('title'));
				}
			}
		}
	}
}

?>
