<?php
/**
 * @file
 * @package xdbase
 * @version $Id: GroupPermAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractEditAction.class.php';

class Xdbase_Admin_GroupPermAction extends Xdbase_AbstractEditAction
{
	var $itemIdArray = array(_MD_XDBASE_GPERM_INSERTABLE, _MD_XDBASE_GPERM_SUPERINSERT, _MD_XDBASE_GPERM_EDITABLE, _MD_XDBASE_GPERM_SUPEREDIT, _MD_XDBASE_GPERM_SUPERDELETE, _MD_XDBASE_GPERM_CANUPLOAD);

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& xoops_gethandler('groupperm');
		return $handler;
	}

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
		$this->mActionForm =& $this->mController->create('form', 'admin.edit_groupPerm');
		$this->mActionForm->prepare();
	}


	function _doExecute()
	{
		$this->mObjectHandler =& $this->_getHandler();
		$mid = $this->mController->mXoopsModule->getVar('mid');
		$groupHandler =& xoops_gethandler('group');
		$groupsArray =& $groupHandler->getObjects(null, true);

		foreach ($groupsArray as $gid => $group)
		{
			foreach ($this->itemIdArray as $itemId)
			{
				$criteria =& new CriteriaCompo();
				$criteria->add(new Criteria('gperm_groupid', $gid));
				$criteria->add(new Criteria('gperm_modid', $mid));
				$criteria->add(new Criteria('gperm_itemid', $itemId));
				$criteria->add(new Criteria('gperm_name', 'xdbase_global'));
				$gpermObjectArray =& $this->mObjectHandler->getObjects($criteria);
				$count = count($gpermObjectArray);
				$gperm = $this->mActionForm->get('gperm_itemid'.$itemId, $gid);
				if ($count == 1)
				{
					if ($gperm == 1)
					{
					}
					else
					{
						if (!$this->mObjectHandler->delete($gpermObjectArray[0]))
						{
							return XDBASE_FRAME_VIEW_ERROR;
						}
					}
				}
				else
				{
					if ($gperm == 1)
					{
						$gpermObject =& $this->mObjectHandler->create();
						$gpermObject->setVar('gperm_groupid', $gid);
						$gpermObject->setVar('gperm_modid', $mid);
						$gpermObject->setVar('gperm_itemid', $itemId);
						$gpermObject->setVar('gperm_name', 'xdbase_global');
						if (!$this->mObjectHandler->insert($gpermObject))
						{
							return XDBASE_FRAME_VIEW_ERROR;
						}
					}
					else
					{
					}
				}
				unset($criteria);
			}
		}
		return XDBASE_FRAME_VIEW_SUCCESS;
	}


	function execute()
	{
		if (xdbaseGetRequest('_form_control_cancel') != null)
		{
			return XDBASE_FRAME_VIEW_CANCEL;
		}

		$this->mActionForm->fetch();
		$this->mActionForm->validate();

		if ($this->mActionForm->hasError())
		{
			return XDBASE_FRAME_VIEW_INPUT;
		}
		else
		{
			return $this->_doExecute();
		}
	}

	/**
	 * @public
	 */
	function executeViewInput()
	{
		$this->mTpl->assign('actionForm', $this->mActionForm);

		$this->mObjectHandler =& $this->_getHandler();
		$mid = $this->mController->mXoopsModule->getVar('mid');
		$gpermArray = array();

		$groupHandler =& xoops_gethandler('group');
		$groupsArray =& $groupHandler->getObjects(null, true);
		foreach ($groupsArray as $gid => $group)
		{
			$gpermArray[$gid]['name'] = $group->getVar('name');
			foreach ($this->itemIdArray as $itemId)
			{
				$criteria =& new CriteriaCompo();
				$criteria->add(new Criteria('gperm_groupid', $gid));
				$criteria->add(new Criteria('gperm_modid', $mid));
				$criteria->add(new Criteria('gperm_itemid', $itemId));
				$criteria->add(new Criteria('gperm_name', 'xdbase_global'));
				$count = $this->mObjectHandler->getCount($criteria);
				if ($count == 1)
				{
					$gpermArray[$gid][$itemId] = 1;
				}
				else
				{
					$gpermArray[$gid][$itemId] = 0;
				}
				unset($criteria);
			}
		}

		$this->mTpl->assign('gpermArray', $gpermArray);

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/group_perm.html');
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->mController->executeRedirect('./index.php?action=GroupPerm', 3, _MD_XDBASE_GPERM_UPDATED);
//		$this->mController->executeForward('./index.php?action=GroupPerm');
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
//		$this->mController->executeRedirect('./index.php?action=GroupPerm', 1, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
		$this->mController->executeForward('./index.php?action=GroupPerm');
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php');
	}

}

?>
