<?php
/**
 * @file
 * @package xdbase
 * @version $Id: CatFilterForm.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractFilterForm.class.php';

define('XDBASE_CAT_SORT_KEY_CID', 1);
define('XDBASE_CAT_SORT_KEY_PID', 2);
define('XDBASE_CAT_SORT_KEY_TITLE', 3);
define('XDBASE_CAT_SORT_KEY_DESCRIPTION', 4);
define('XDBASE_CAT_SORT_KEY_IMG', 5);
define('XDBASE_CAT_SORT_KEY_WEIGHT', 6);
define('XDBASE_CAT_SORT_KEY_STATUS', 7);
define('XDBASE_CAT_SORT_KEY_ACCESS', 8);
define('XDBASE_CAT_SORT_KEY_GROUPS', 9);
define('XDBASE_CAT_SORT_KEY_CREATED_DATE', 10);
define('XDBASE_CAT_SORT_KEY_UPDATED_DATE', 11);
define('XDBASE_CAT_SORT_KEY_SHOW_MAP', 12);
define('XDBASE_CAT_SORT_KEY_LATITUDE', 13);
define('XDBASE_CAT_SORT_KEY_LONGITUDE', 14);
define('XDBASE_CAT_SORT_KEY_ZOOM', 15);
define('XDBASE_CAT_SORT_KEY_ICON', 16);
define('XDBASE_CAT_SORT_KEY_INT01', 17);
define('XDBASE_CAT_SORT_KEY_INT02', 18);
define('XDBASE_CAT_SORT_KEY_INT03', 19);

define('XDBASE_CAT_SORT_KEY_DEFAULT', XDBASE_CAT_SORT_KEY_CID);

class Xdbase_Admin_CatFilterForm extends Xdbase_AbstractFilterForm
{
	var $mSortKeys = array(
		XDBASE_CAT_SORT_KEY_CID => 'cid',
		XDBASE_CAT_SORT_KEY_PID => 'pid',
		XDBASE_CAT_SORT_KEY_TITLE => 'title',
		XDBASE_CAT_SORT_KEY_DESCRIPTION => 'description',
		XDBASE_CAT_SORT_KEY_IMG => 'img',
		XDBASE_CAT_SORT_KEY_WEIGHT => 'weight',
		XDBASE_CAT_SORT_KEY_STATUS => 'status',
		XDBASE_CAT_SORT_KEY_ACCESS => 'access',
		XDBASE_CAT_SORT_KEY_GROUPS => 'groups',
		XDBASE_CAT_SORT_KEY_CREATED_DATE => 'created_date',
		XDBASE_CAT_SORT_KEY_UPDATED_DATE => 'updated_date',
		XDBASE_CAT_SORT_KEY_SHOW_MAP => 'show_map',
		XDBASE_CAT_SORT_KEY_LATITUDE => 'latitude',
		XDBASE_CAT_SORT_KEY_LONGITUDE => 'longitude',
		XDBASE_CAT_SORT_KEY_ZOOM => 'zoom',
		XDBASE_CAT_SORT_KEY_ICON => 'icon',
		XDBASE_CAT_SORT_KEY_INT01 => 'int01',
		XDBASE_CAT_SORT_KEY_INT02 => 'int02',
		XDBASE_CAT_SORT_KEY_INT03 => 'int03'
	);

	/**
	 * @public
	 */
	function getDefaultSortKey()
	{
		return XDBASE_CAT_SORT_KEY_DEFAULT;
	}

	/**
	 * @public
	 */
	function fetch()
	{
		parent::fetch();

		if (($value = xdbaseGetRequest('cid')) !== null) {
			$this->mNavi->addExtra('cid', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('cid', $value));
		}
	
		if (($value = xdbaseGetRequest('pid')) !== null) {
			$this->mNavi->addExtra('pid', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('pid', $value));
		}
	
		if (($value = xdbaseGetRequest('title')) !== null) {
			$this->mNavi->addExtra('title', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('title', $value));
		}
	
		if (($value = xdbaseGetRequest('img')) !== null) {
			$this->mNavi->addExtra('img', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('img', $value));
		}
	
		if (($value = xdbaseGetRequest('weight')) !== null) {
			$this->mNavi->addExtra('weight', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('weight', $value));
		}
	
		if (($value = xdbaseGetRequest('status')) !== null) {
			$this->mNavi->addExtra('status', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('status', $value));
		}
	
		if (($value = xdbaseGetRequest('access')) !== null) {
			$this->mNavi->addExtra('access', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('access', $value));
		}
	
		if (($value = xdbaseGetRequest('groups')) !== null) {
			$this->mNavi->addExtra('groups', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('groups', $value));
		}
	
		if (($value = xdbaseGetRequest('created_date')) !== null) {
			$this->mNavi->addExtra('created_date', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('created_date', $value));
		}
	
		if (($value = xdbaseGetRequest('updated_date')) !== null) {
			$this->mNavi->addExtra('updated_date', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('updated_date', $value));
		}

		if (($value = xdbaseGetRequest('show_map')) !== null) {
			$this->mNavi->addExtra('show_map', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('show_map', $value));
		}
	
		if (($value = xdbaseGetRequest('latitude')) !== null) {
			$this->mNavi->addExtra('latitude', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('latitude', $value));
		}
	
		if (($value = xdbaseGetRequest('longitude')) !== null) {
			$this->mNavi->addExtra('longitude', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('longitude', $value));
		}
	
		if (($value = xdbaseGetRequest('zoom')) !== null) {
			$this->mNavi->addExtra('zoom', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('zoom', $value));
		}

		if (($value = xdbaseGetRequest('icon')) !== null) {
			$this->mNavi->addExtra('icon', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('icon', $value));
		}

		if (($value = xdbaseGetRequest('int01')) !== null) {
			$this->mNavi->addExtra('int01', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('int01', $value));
		}

		if (($value = xdbaseGetRequest('int02')) !== null) {
			$this->mNavi->addExtra('int02', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('int02', $value));
		}

		if (($value = xdbaseGetRequest('int03')) !== null) {
			$this->mNavi->addExtra('int03', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('int03', $value));
		}
	
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
