<?php
/**
 * @file
 * @package xdbase
 * @version $Id: xdbase.php
 */

	// a plugin for xdbase

	if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit ;

	/*
		$db : db instance
		$myts : MyTextSanitizer instance
		$this->year : year
		$this->month : month
		$this->user_TZ : user's timezone (+1.5 etc)
		$this->server_TZ : server's timezone (-2.5 etc)
		$tzoffset_s2u : the offset from server to user
		$now : the result of time()
		$plugin = array('dirname'=>'dirname','name'=>'name','dotgif'=>'*.gif')
		$just1gif : 0 or 1
		
		$plugin_returns[ DATE ][]
	*/

	// set range (added 86400 second margin "begin" & "end")
	$range_start_s = mktime(0,0,0,$this->month,0,$this->year) ;
	$range_end_s = mktime(0,0,0,$this->month+1,1,$this->year) ;

	// options
	$options = explode( '|' , $plugin['options'] ) ;
	// options[0] : category extract
	if( ! empty( $options[0] ) ) {
		$col_date = $options[0] ;
	} else {
		$col_date = 'created_date' ;
	}

	include_once XOOPS_TRUST_PATH.'/modules/xdbase/include/function.php';
	include_once XOOPS_TRUST_PATH.'/modules/xdbase/class/handler/Data.class.php';
	$data_handler =& xdbaseGetModuleHandler('data', $plugin['dirname']);
	$criteria =& $data_handler->getCriteria();

	$whr_str = $criteria->render();

	// query (added 86400 second margin "begin" & "end")
	$sql = "SELECT title,did,".$col_date." FROM ".$db->prefix( $plugin['dirname'] )."_data WHERE ".$col_date." >= $range_start_s AND ".$col_date." < $range_end_s" ;

if ($whr_str != '')
{
	$sql .= " AND ".$whr_str;
}
//exit(var_dump($sql));

	$result = $db->query($sql) ;

	while( list( $title , $id , $server_time ) = $db->fetchRow( $result ) ) {
		$user_time = $server_time + $tzoffset_s2u ;
		if( date( 'n' , $user_time ) != $this->month ) continue ;
		$target_date = date('j',$user_time) ;
		$tmp_array = array(
			'dotgif' => $plugin['dotgif'] ,
			'dirname' => $plugin['dirname'] ,
			'link' => XOOPS_URL."/modules/{$plugin['dirname']}/index.php?action=DataView&amp;did=$id" ,
			'id' => $id ,
			'server_time' => $server_time ,
			'user_time' => $user_time ,
			'name' => 'did' ,
			'title' => $myts->makeTboxData4Show( $title )
		) ;
		if( $just1gif ) {
			// just 1 gif per a plugin & per a day
			$plugin_returns[ $target_date ][ $plugin['dirname'] ] = $tmp_array ;
		} else {
			// multiple gifs allowed per a plugin & per a day
			$plugin_returns[ $target_date ][] = $tmp_array ;
		}
	}

?>