<?php
/**
 * Smarty plugin
 * @package xdbase
 * @version $Id: modifier.xdbase_formattimestamp.php,v 1.3 2010/03/01 06:44:26 bluemelon Exp $
 */

function smarty_modifier_xdbase_formattimestamp($time, $format='l')
{
	if ($time && is_numeric($time))
	{
		if (preg_match('/jl/', $format))
		{
			$week_day = xdbase_get_week(formatTimestamp($time,'w'), 1);
			$format = preg_replace('/jl/', $week_day, $format);
		}
		elseif (preg_match('/jD/', $format))
		{
			$week_day = xdbase_get_week(formatTimestamp($time,'w'), 2);
			$format = preg_replace('/jD/', $week_day, $format);
		}

		$date = formatTimestamp($time, $format);

		return $date;
	}
	return;
}

function xdbase_get_week($week_no, $fmt)
{
	static $week_array = array(_MD_XDBASE_LANG_SUN, _MD_XDBASE_LANG_MON, _MD_XDBASE_LANG_TUE, _MD_XDBASE_LANG_WED, _MD_XDBASE_LANG_THU, _MD_XDBASE_LANG_FRI, _MD_XDBASE_LANG_SAT);
	$week_day = $week_array[$week_no];
	switch ($fmt)
	{
		case 1:
			return $week_day._MD_XDBASE_LANG_WEEK;
		case 2:
			return '('.$week_day.')';
		default:
			return $week_day;
		break;
	}
}


?>
