<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_attributeDeleteAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/AbstractDeleteAction.class.php';

class Xdbase_Data_attributeDeleteAction extends Xdbase_AbstractDeleteAction
{
	/**
	 * @protected
	 */
	function &_getId()
	{
		$ret =& xdbaseGetRequest('aid');
		return $ret;
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data_attribute');
		return $handler;
	}

	/**
	 * @protected
	 */
//	function &_setupActionForm()
	function _setupActionForm()
	{
		// $this->mActionForm =& new Xdbase_DataDeleteForm();
		$this->mActionForm =& $this->mController->create('form', 'delete_data_attribute');
		$this->mActionForm->prepare();
	}

	/**
	 * @public
	 */
	function executeViewInput()
	{
		$this->checkPerm();

		global $xoopsTpl;
		$handler =& $this->mController->load('handler', 'data_attribute');

		$xoopsTpl->fetch('db:'.$this->mController->mDirname.'_data_attribute_delete.html', null, null, false);
		$xoopsTpl->assign('actionForm', $this->mActionForm);
		$xoopsTpl->assign('objects', $this->mObjects);
		$xoopsTpl->assign('handler', $handler);
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->mController->executeForward('./index.php?action=Data_attributeList&did='.$this->mObject->getShow('did').'&type='.$this->mObject->getShow('type'));
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mController->executeRedirect('./index.php?action=Data_attributeList&did='.$this->mObject->getShow('did').'&type='.$this->mObject->getShow('type'), 1, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php?action=Data_attributeList&did='.$this->mObject->getShow('did').'&type='.$this->mObject->getShow('type'));
	}


	/**
	 * @protected
	 */
	function _doExecute()
	{
		if ($this->mController->mUser->isInRole('Module.'.$this->mController->mDirname.'.Admin'))
		{
			if ($this->mObjectHandler->delete($this->mObject)) {
				return XDBASE_FRAME_VIEW_SUCCESS;
			}
		}
		else
		{
			$this->checkPerm();
//			$this->mObject->set('status', 0);
//			if ($this->mObjectHandler->insert($this->mObject)) {
			if ($this->mObjectHandler->delete($this->mObject)) {
				return XDBASE_FRAME_VIEW_SUCCESS;
			}
		}

		return XDBASE_FRAME_VIEW_ERROR;
	}

	function checkPerm()
	{
		$did = $this->mObject->getShow('did');
		$dataHandler =& $this->mController->load('handler', 'data');
		$dataObject =& $dataHandler->get($did);
		$reservation = false;
		if (!is_object($this->mController->mXoopsUser))
		{
			$uid = 0;
		}
		else
		{
			$uid = $this->mController->mXoopsUser->get('uid');
		}

		if (is_object($dataObject))
		{
			$reservation = $dataObject->getShow('reservation');
		}
		if ($reservation)
		{
			if ($dataHandler->getReservationCount($did, $uid) == 0)
			{
				$this->mController->executeRedirect('./index.php?action=DataView&did='.$this->mObject->getShow('did'), 3, _NOPERM);
			}
		}
		else
		{
			$this->mController->executeRedirect('./index.php?action=DataView&did='.$this->mObject->getShow('did'), 3, _NOPERM);
		}
	}


}

?>
