<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_attributeViewAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractViewAction.class.php';

class Xdbase_Data_attributeViewAction extends Xdbase_AbstractViewAction
{
	/**
	 * @public
	 */
	function _getId()
	{
		return xdbaseGetRequest('aid');
	}

	/**
	 * @public
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data_attribute');
		return $handler;
	}


	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->checkAccessPerm();

		$GLOBALS['xoopsOption']['template_main'] = $this->mController->mDirname.'_data_attribute_view.html';

		$this->mTpl->assign('object', $this->mObject);

		$handler =& $this->mController->load('handler', 'data_attribute');
		$this->mTpl->assign('handler', $handler);

		$dataHandler =& $this->mController->load('handler', 'data');
		$this->mTpl->assign('dataHandler', $dataHandler);
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mController->executeRedirect('./index.php?action=DataView&did='.$this->mObject->getShow('did'), 1, _MD_XDBASE_ERROR_CONTENT_IS_NOT_FOUND);
	}


	function checkAccessPerm()
	{
		if (!xdbaseIsAdmin())
		{
			$uid = xdbaseGetUid();
			$handler =& $this->_getHandler();
			$criteria =& new Xdbase_CriteriaCompo();
			$criteria->add(new Xdbase_Criteria('aid', $this->_getId()));
			$criteria->add(new Xdbase_Criteria('uid', $uid));

			$count = $handler->getCount($criteria);
			if ($count != 1)
			{
				$this->mController->executeRedirect('./index.php?action=DataView&did='.$this->mObject->getShow('did'), 3, _NOPERM);
			}
		}
	}

}

?>
