<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_attributeDeleteAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/AbstractDeleteAction.class.php';

class Xdbase_Admin_Data_attributeDeleteAction extends Xdbase_AbstractDeleteAction
{
	/**
	 * @protected
	 */
	function &_getId()
	{
		$ret =& xdbaseGetRequest('aid');
		return $ret;
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data_attribute');
		return $handler;
	}

	/**
	 * @protected
	 */
//	function &_setupActionForm()
	function _setupActionForm()
	{
		// $this->mActionForm =& new Xdbase_DataDeleteForm();
		$this->mActionForm =& $this->mController->create('form', 'admin.delete_data_attribute');
		$this->mActionForm->prepare();
	}

	/**
	 * @public
	 */
	function executeViewInput()
	{
		global $xoopsTpl;
		$render->setTemplateName('data_attribute_delete.html');
		$xoopsTpl->assign('actionForm', $this->mActionForm);
		$xoopsTpl->assign('object', $this->mObject);
		$xoopsTpl->assign('handler', $this->mObjectHandler);
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->mController->executeForward('./index.php?action=Data_attributeList');
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mController->executeRedirect('./index.php?action=Data_attributeList', 1, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php?action=Data_attributeList');
	}

	/**
	 * @protected
	 */
	function _doExecute()
	{
		if ($this->mObjectHandler->delete($this->mObject)) {
			return XDBASE_FRAME_VIEW_SUCCESS;
		}
	
		return XDBASE_FRAME_VIEW_ERROR;
	}

}

?>
