<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Xdbase_Image.class.php,v 1.4 2010/02/23 02:38:27 bluemelon Exp $
 */

class Xdbase_Image
{
	var $width = 0;
	var $height = 0;
	var $type = 0;
	var $quality = 80;// 0100

///////////////////////////////////////////////////////////////////////////////////////////////////////
	function Xdbase_Image()
	{
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////
	function __construct()
	{
		$this->Xdbase_Image();
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////
	function calcImageSize($maxSize, $width, $height)
	{
		if ($maxSize > 1200)
		{
			$maxSize = 1200;
		}

		if ($width <= $maxSize && $height <= $maxSize)
		{
			$ret = array($width, $height);
		}
		else
		{
			if ($width >= $height)
			{
				$aspectratio = $width / $maxSize;
				$width = $maxSize;
				$height = round($height / $aspectratio, 0);
			}
			else
			{
				$aspectratio = $height / $maxSize;
				$width = round($width / $aspectratio, 0);
				$height = $maxSize;
			}
			$ret = array($width, $height);
		}
		return $ret;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////
	function checkFile($filePath)
	{
		if (!file_exists($filePath))
		{
			$err = 'Error: file '.$filePath.' is not exists.';
			return $err;
		}

		list($this->width, $this->height, $this->type, $attr) = getimagesize($filePath);

//var_dump(gd_info());

		switch ($this->type)
		{
			case IMAGETYPE_GIF:
				if (!imagetypes() & IMG_GIF)
				{
					$err = 'Error: GIF Support is disabled';
					return $err;
				}
				break;
			
			case IMAGETYPE_JPEG:
				if (!imagetypes() & IMG_JPG)
				{
					$err = 'Error: JPEG Support is disabled';
					return $err;
				}
				break;
			
			case IMAGETYPE_PNG:
				if (!imagetypes() & IMG_PNG)
				{
					$err = 'Error: PNG Support is disabled';
					return $err;
				}
				break;
			
			default:
				$err = 'Error: Invalid file type '.$this->type;
				return $err;
		}

		return false;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////
	function saveResizedImage($tmpFilePath, $newFilePath, $maxSize)
	{
		if ($err = $this->checkFile($tmpFilePath))
		{
			return $err;
		}

		list($width, $height) = $this->calcImageSize($maxSize, $this->width, $this->height);

		$imagecreate = function_exists('imagecreatetruecolor') ? 'imagecreatetruecolor' : 'imagecreate';
		$imageresize = function_exists('imagecopyresampled') ? 'imagecopyresampled' : 'imagecopyresized';

		switch($this->type)
		{
			case IMAGETYPE_GIF:
				$tmpImage = ImageCreateFromGif($tmpFilePath);
				$type = 'imagegif';
				break;
			case IMAGETYPE_JPEG:
				$tmpImage = ImageCreateFromJpeg($tmpFilePath);
				$type = 'imagejpeg';
				break;
			case IMAGETYPE_PNG:
				$tmpImage = ImageCreateFromPng($tmpFilePath);
				$type = 'imagepng';
				break;
		}

		$resizedImage = @$imagecreate($width, $height);
		@$imageresize($resizedImage, $tmpImage, 0, 0, 0, 0, $width, $height, $this->width, $this->height);

		if ($this->type == IMAGETYPE_JPEG)
		{
			@$type($resizedImage, $newFilePath, $this->quality);
		}
		else
		{
			@$type($resizedImage, $newFilePath);
		}

		@imagedestroy($tmpImage);
		@imagedestroy($resizedImage);

		return false;
	}


}

?>
