<?php
/**
 * @file
 * @package xdbase
 * @version $Id: DataEditForm.class.php,v 1.13 2010/06/16 10:27:10 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_ActionForm.class.php';

class Xdbase_DataEditForm extends Xdbase_ActionForm
{
	var $mOldImageName1 = null;
	var $mOldImageName2 = null;
	var $mOldFileName1 = null;
	var $mIsNew = false;
	var $mOldStatus = null;
	var $mFormImage1 = null;
	var $mFormImage2 = null;
	var $mFormFile1 = null;
	var $dataConfigHandler = null;
	var $mHasTag = false;

	/**
	 * @public
	 */
	function getTokenName()
	{
		return 'module.xdbase.DataEditForm.TOKEN';
	}

	/**
	 * @public
	 */
	function prepare()
	{
		$this->dataConfigHandler =& $this->mController->load('handler', 'data_config');

		//
		// Set form properties
		//
		$this->mFormProperties['did'] =& new Xdbase_IntProperty('did');
		$this->mFormProperties['cid'] =& new Xdbase_IntProperty('cid');
		$this->mFormProperties['title'] =& new Xdbase_StringProperty('title');
		$this->mFormProperties['tag'] =& new Xdbase_StringArrayProperty('tag');
		$this->mFormProperties['pid'] =& new Xdbase_IntProperty('pid');
		$this->mFormProperties['uid'] =& new Xdbase_IntProperty('uid');
		$this->mFormProperties['name'] =& new Xdbase_StringProperty('name');
		$this->mFormProperties['poster_ip'] =& new Xdbase_StringProperty('poster_ip');
		$this->mFormProperties['created_date'] =& new Xdbase_IntProperty('created_date');
		$this->mFormProperties['updated_date'] =& new Xdbase_IntProperty('updated_date');
		$this->mFormProperties['published_date'] =& new Xdbase_IntProperty('published_date');
		$this->mFormProperties['expired_date'] =& new Xdbase_IntProperty('expired_date');
		$this->mFormProperties['s_date'] =& new Xdbase_IntProperty('s_date');
		$this->mFormProperties['e_date'] =& new Xdbase_IntProperty('e_date');
		$this->mFormProperties['password'] =& new Xdbase_StringProperty('password');
		$this->mFormProperties['url'] =& new Xdbase_StringProperty('url');
		$this->mFormProperties['email'] =& new Xdbase_StringProperty('email');
		$this->mFormProperties['zip'] =& new Xdbase_StringProperty('zip');
		$this->mFormProperties['state'] =& new Xdbase_StringProperty('state');
		$this->mFormProperties['city'] =& new Xdbase_StringProperty('city');
		$this->mFormProperties['street'] =& new Xdbase_StringProperty('street');
		$this->mFormProperties['phone'] =& new Xdbase_StringProperty('phone');
		$this->mFormProperties['mobile_phone'] =& new Xdbase_StringProperty('mobile_phone');
		$this->mFormProperties['fax'] =& new Xdbase_StringProperty('fax');
		$this->mFormProperties['img01'] =& new Xdbase_ImageFileProperty('img01');
		$this->mFormProperties['img01_height'] =& new Xdbase_IntProperty('img01_height');
		$this->mFormProperties['img01_width'] =& new Xdbase_IntProperty('img01_width');
		$this->mFormProperties['img02'] =& new Xdbase_ImageFileProperty('img02');
		$this->mFormProperties['img02_height'] =& new Xdbase_IntProperty('img02_height');
		$this->mFormProperties['img02_width'] =& new Xdbase_IntProperty('img02_width');
		$this->mFormProperties['file01'] =& new Xdbase_FileProperty('file01');
		$this->mFormProperties['file01name'] =& new Xdbase_StringProperty('file01name');
		$this->mFormProperties['file01ext'] =& new Xdbase_StringProperty('file01ext');
		$this->mFormProperties['file01size'] =& new Xdbase_FloatProperty('file01size');
		$this->mFormProperties['downloads'] =& new Xdbase_IntProperty('downloads');
		$this->mFormProperties['body'] =& new Xdbase_TextProperty('body');
		$this->mFormProperties['int01'] =& new Xdbase_IntProperty('int01');
		$this->mFormProperties['int02'] =& new Xdbase_IntProperty('int02');
		$this->mFormProperties['int03'] =& new Xdbase_IntProperty('int03');
		$this->mFormProperties['int04'] =& new Xdbase_IntProperty('int04');
		$this->mFormProperties['int05'] =& new Xdbase_IntProperty('int05');
		$this->mFormProperties['int06'] =& new Xdbase_IntProperty('int06');
		$this->mFormProperties['int07'] =& new Xdbase_IntProperty('int07');
		$this->mFormProperties['int08'] =& new Xdbase_IntProperty('int08');
		$this->mFormProperties['int09'] =& new Xdbase_IntProperty('int09');
		$this->mFormProperties['int10'] =& new Xdbase_IntProperty('int10');
		$this->mFormProperties['float01'] =& new Xdbase_FloatProperty('float01');
		$this->mFormProperties['float02'] =& new Xdbase_FloatProperty('float02');
		$this->mFormProperties['varchar01'] =& new Xdbase_StringProperty('varchar01');
		$this->mFormProperties['varchar02'] =& new Xdbase_StringProperty('varchar02');
		$this->mFormProperties['varchar03'] =& new Xdbase_StringProperty('varchar03');
		$this->mFormProperties['varchar04'] =& new Xdbase_StringProperty('varchar04');
		$this->mFormProperties['varchar05'] =& new Xdbase_StringProperty('varchar05');
		$this->mFormProperties['varchar06'] =& new Xdbase_StringProperty('varchar06');
		$this->mFormProperties['varchar07'] =& new Xdbase_StringProperty('varchar07');
		$this->mFormProperties['varchar08'] =& new Xdbase_StringProperty('varchar08');
		$this->mFormProperties['varchar09'] =& new Xdbase_StringProperty('varchar09');
		$this->mFormProperties['varchar10'] =& new Xdbase_StringProperty('varchar10');
		$this->mFormProperties['trackbacks'] =& new Xdbase_IntProperty('trackbacks');
		$this->mFormProperties['pipe_id'] =& new Xdbase_IntProperty('pipe_id');
		$this->mFormProperties['show_map'] =& new Xdbase_BoolProperty('show_map');
		$this->mFormProperties['latitude'] =& new Xdbase_FloatProperty('latitude');
		$this->mFormProperties['longitude'] =& new Xdbase_FloatProperty('longitude');
		$this->mFormProperties['zoom'] =& new Xdbase_IntProperty('zoom');
		$this->mFormProperties['text01'] =& new Xdbase_TextProperty('text01');
		$this->mFormProperties['text02'] =& new Xdbase_TextProperty('text02');
		$this->mFormProperties['reservation'] =& new Xdbase_BoolProperty('reservation');
//		$this->mFormProperties['option_value'] =& new Xdbase_TextProperty('option_value');
		$this->mFormProperties['weight'] =& new Xdbase_IntProperty('weight');
		$this->mFormProperties['status'] =& new Xdbase_BoolProperty('status');
		$this->mFormProperties['access'] =& new Xdbase_IntProperty('access');
		$this->mFormProperties['groups'] =& new Xdbase_IntArrayProperty('groups');
		$this->mFormProperties['hits'] =& new Xdbase_IntProperty('hits');
		$this->mFormProperties['comments'] =& new Xdbase_IntProperty('comments');
		$this->mFormProperties['rating'] =& new Xdbase_FloatProperty('rating');
		$this->mFormProperties['votes'] =& new Xdbase_IntProperty('votes');
		$this->mFormProperties['dohtml'] =& new Xdbase_BoolProperty('dohtml');
		$this->mFormProperties['doxcode'] =& new Xdbase_BoolProperty('doxcode');
		$this->mFormProperties['dosmiley'] =& new Xdbase_BoolProperty('dosmiley');
		$this->mFormProperties['doimage'] =& new Xdbase_BoolProperty('doimage');
		$this->mFormProperties['dobr'] =& new Xdbase_BoolProperty('dobr');

		$this->mFormProperties['published_date_array'] =& new Xdbase_IntArrayProperty('published_date_array');
		$this->mFormProperties['expired_date_array'] =& new Xdbase_IntArrayProperty('expired_date_array');
		$this->mFormProperties['s_date_array'] =& new Xdbase_IntArrayProperty('s_date_array');
		$this->mFormProperties['e_date_array'] =& new Xdbase_IntArrayProperty('e_date_array');

		$this->mFormProperties['option_label'] =& new Xdbase_TextArrayProperty('option_label');
		$this->mFormProperties['option_required'] =& new Xdbase_IntArrayProperty('option_required');
		$this->mFormProperties['option_type'] =& new Xdbase_TextArrayProperty('option_type');
		$this->mFormProperties['option_value'] =& new Xdbase_TextArrayProperty('option_value');
		$this->mFormProperties['option_default'] =& new Xdbase_TextArrayProperty('option_default');

		$this->mFormProperties['tag_add'] =& new Xdbase_StringProperty('tag_add');
		$this->mFormProperties['delete_img01'] =& new Xdbase_BoolProperty('delete_img01');
		$this->mFormProperties['delete_img02'] =& new Xdbase_BoolProperty('delete_img02');

		//
		// Set field properties
		//
		$this->mFieldProperties['did'] =& new Xdbase_FieldProperty($this);
		$this->mFieldProperties['did']->setDependsByArray(array('required'));
		$this->mFieldProperties['did']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_DID);
	
		if ($this->dataConfigHandler->getRequired('cid'))
		{
			$this->mFieldProperties['cid'] =& new Xdbase_FieldProperty($this);
			$this->mFieldProperties['cid']->setDependsByArray(array('required'));
			$this->mFieldProperties['cid']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_CID);
		}

		$this->mFieldProperties['title'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('title'))
		{
			$this->mFieldProperties['title']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['title']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_TITLE);
		}
		else
		{
			$this->mFieldProperties['title']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['title']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_TITLE, '255');
		$this->mFieldProperties['title']->addVar('maxlength', '255');

		$this->mFieldProperties['tag'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('tag'))
		{
			$this->mFieldProperties['tag']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['tag']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_TAG);
		}
		else
		{
			$this->mFieldProperties['tag']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['tag']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_TAG, '255');
		$this->mFieldProperties['tag']->addVar('maxlength', '255');

		$this->mFieldProperties['name'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('name'))
		{
			$this->mFieldProperties['name']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['name']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_NANE);
		}
		else
		{
			$this->mFieldProperties['name']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['name']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_NAME, '100');
		$this->mFieldProperties['name']->addVar('maxlength', '100');

		if ($this->dataConfigHandler->getRequired('s_date'))
		{
			$this->mFieldProperties['s_date'] =& new Xdbase_FieldProperty($this);
			$this->mFieldProperties['s_date']->setDependsByArray(array('required'));
			$this->mFieldProperties['s_date']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_S_DATE);
		}

		if ($this->dataConfigHandler->getRequired('e_date'))
		{
			$this->mFieldProperties['e_date'] =& new Xdbase_FieldProperty($this);
			$this->mFieldProperties['e_date']->setDependsByArray(array('required'));
			$this->mFieldProperties['e_date']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_E_DATE);
		}

		$this->mFieldProperties['password'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('password'))
		{
			$this->mFieldProperties['password']->setDependsByArray(array('required'));
			$this->mFieldProperties['password']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_PASSWORD);
		}
		else
		{
			$this->mFieldProperties['password']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['password']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_PASSWORD, '34');
		$this->mFieldProperties['password']->addVar('maxlength', '34');

		$this->mFieldProperties['url'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('url'))
		{
			$this->mFieldProperties['url']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['url']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_URL, '255');
		}
		else
		{
			$this->mFieldProperties['url']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['url']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_URL, '255');
		$this->mFieldProperties['url']->addVar('maxlength', '255');

		$this->mFieldProperties['email'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('email'))
		{
			$this->mFieldProperties['email']->setDependsByArray(array('required','email'));
			$this->mFieldProperties['email']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_EMAIL);
		}
		$this->mFieldProperties['email']->setDependsByArray(array('email'));
		$this->mFieldProperties['email']->addMessage('email', _MD_XDBASE_ERROR_EMAIL, _MD_XDBASE_LANG_EMAIL);

		$this->mFieldProperties['zip'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('zip'))
		{
			$this->mFieldProperties['zip']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['zip']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_ZIP);
		}
		else
		{
			$this->mFieldProperties['zip']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['zip']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_ZIP, '20');
		$this->mFieldProperties['zip']->addVar('maxlength', '20');

		$this->mFieldProperties['state'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('state'))
		{
			$this->mFieldProperties['state']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['state']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_STATE);
		}
		else
		{
			$this->mFieldProperties['state']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['state']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_STATE, '255');
		$this->mFieldProperties['state']->addVar('maxlength', '255');

		$this->mFieldProperties['city'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('city'))
		{
			$this->mFieldProperties['city']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['city']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_CITY);
		}
		else
		{
			$this->mFieldProperties['city']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['city']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_CITY, '255');
		$this->mFieldProperties['city']->addVar('maxlength', '255');

		$this->mFieldProperties['street'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('street'))
		{
			$this->mFieldProperties['street']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['street']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_STREET);
		}
		else
		{
			$this->mFieldProperties['street']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['street']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_STREET, '255');
		$this->mFieldProperties['street']->addVar('maxlength', '255');

		$this->mFieldProperties['phone'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('phone'))
		{
			$this->mFieldProperties['phone']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['phone']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_PHONE);
		}
		else
		{
			$this->mFieldProperties['phone']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['phone']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_PHONE, '30');
		$this->mFieldProperties['phone']->addVar('maxlength', '30');

		$this->mFieldProperties['mobile_phone'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('mobile_phone'))
		{
			$this->mFieldProperties['mobile_phone']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['mobile_phone']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_MOBILE_PHONE);
		}
		else
		{
			$this->mFieldProperties['mobile_phone']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['mobile_phone']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_MOBILE_PHONE, '30');
		$this->mFieldProperties['mobile_phone']->addVar('maxlength', '30');

		$this->mFieldProperties['fax'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('fax'))
		{
			$this->mFieldProperties['fax']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['fax']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_FAX);
		}
		else
		{
			$this->mFieldProperties['fax']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['fax']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_FAX, '30');
		$this->mFieldProperties['fax']->addVar('maxlength', '30');

		$this->mFieldProperties['img01'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('img01'))
		{
			$this->mFieldProperties['img01']->setDependsByArray(array('required','maxlength','extension','maxfilesize'));
			$this->mFieldProperties['img01']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_IMG01);
		}
		else
		{
			$this->mFieldProperties['img01']->setDependsByArray(array('maxlength','extension','maxfilesize'));
		}
		$this->mFieldProperties['img01']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_IMG01, '255');
		$this->mFieldProperties['img01']->addVar('maxlength', '255');
		$this->mFieldProperties['img01']->addMessage('extension', _MD_XDBASE_ERROR_EXTENSION, 'gif,png,jpg');
		$this->mFieldProperties['img01']->addVar('extension', 'gif,png,jpg');
		$this->mFieldProperties['img01']->addMessage('maxfilesize', _MD_XDBASE_ERROR_MAXFILESIZE, _MD_XDBASE_CONST_MAXFILESIZE);
		$this->mFieldProperties['img01']->addVar('maxfilesize', _MD_XDBASE_CONST_MAXFILESIZE * 1024);

		$this->mFieldProperties['img02'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('img02'))
		{
			$this->mFieldProperties['img02']->setDependsByArray(array('required','maxlength','extension','maxfilesize'));
			$this->mFieldProperties['img02']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_IMG02);
		}
		else
		{
			$this->mFieldProperties['img02']->setDependsByArray(array('maxlength','extension','maxfilesize'));
		}
		$this->mFieldProperties['img02']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_IMG02, '255');
		$this->mFieldProperties['img02']->addVar('maxlength', '255');
		$this->mFieldProperties['img02']->addMessage('extension', _MD_XDBASE_ERROR_EXTENSION, 'gif,png,jpg');
		$this->mFieldProperties['img02']->addVar('extension', 'gif,png,jpg');
		$this->mFieldProperties['img02']->addMessage('maxfilesize', _MD_XDBASE_ERROR_MAXFILESIZE, _MD_XDBASE_CONST_MAXFILESIZE);
		$this->mFieldProperties['img02']->addVar('maxfilesize', _MD_XDBASE_CONST_MAXFILESIZE * 1024);

		$this->mFieldProperties['file01'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('file01'))
		{
			$this->mFieldProperties['file01']->setDependsByArray(array('required','maxlength','extension','maxfilesize'));
			$this->mFieldProperties['file01']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_FILE01);
		}
		else
		{
			$this->mFieldProperties['file01']->setDependsByArray(array('maxlength','extension','maxfilesize'));
		}
		$this->mFieldProperties['file01']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_FILE01, '255');
		$this->mFieldProperties['file01']->addVar('maxlength', '255');
		$this->mFieldProperties['file01']->addMessage('extension', _MD_XDBASE_ERROR_EXTENSION, _MD_XDBASE_CONST_ALLOWEDEXTS);
		$this->mFieldProperties['file01']->addVar('extension', _MD_XDBASE_CONST_ALLOWEDEXTS);
		$this->mFieldProperties['file01']->addMessage('maxfilesize', _MD_XDBASE_ERROR_MAXFILESIZE, _MD_XDBASE_CONST_MAXFILESIZE);
		$this->mFieldProperties['file01']->addVar('maxfilesize', _MD_XDBASE_CONST_MAXFILESIZE * 1024);

		if ($this->dataConfigHandler->getRequired('int01'))
		{
			$this->mFieldProperties['int01'] =& new Xdbase_FieldProperty($this);
			$this->mFieldProperties['int01']->setDependsByArray(array('required'));
			$this->mFieldProperties['int01']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_INT01);
		}
	
		if ($this->dataConfigHandler->getRequired('int02'))
		{
			$this->mFieldProperties['int02'] =& new Xdbase_FieldProperty($this);
			$this->mFieldProperties['int02']->setDependsByArray(array('required'));
			$this->mFieldProperties['int02']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_INT02);
		}
	
		if ($this->dataConfigHandler->getRequired('int03'))
		{
			$this->mFieldProperties['int03'] =& new Xdbase_FieldProperty($this);
			$this->mFieldProperties['int03']->setDependsByArray(array('required'));
			$this->mFieldProperties['int03']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_INT03);
		}
	
		if ($this->dataConfigHandler->getRequired('int04'))
		{
			$this->mFieldProperties['int04'] =& new Xdbase_FieldProperty($this);
			$this->mFieldProperties['int04']->setDependsByArray(array('required'));
			$this->mFieldProperties['int04']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_INT04);
		}
	
		if ($this->dataConfigHandler->getRequired('int05'))
		{
			$this->mFieldProperties['int05'] =& new Xdbase_FieldProperty($this);
			$this->mFieldProperties['int05']->setDependsByArray(array('required'));
			$this->mFieldProperties['int05']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_INT05);
		}
	
		if ($this->dataConfigHandler->getRequired('int06'))
		{
			$this->mFieldProperties['int06'] =& new Xdbase_FieldProperty($this);
			$this->mFieldProperties['int06']->setDependsByArray(array('required'));
			$this->mFieldProperties['int06']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_INT06);
		}
	
		if ($this->dataConfigHandler->getRequired('int07'))
		{
			$this->mFieldProperties['int07'] =& new Xdbase_FieldProperty($this);
			$this->mFieldProperties['int07']->setDependsByArray(array('required'));
			$this->mFieldProperties['int07']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_INT07);
		}
	
		if ($this->dataConfigHandler->getRequired('int08'))
		{
			$this->mFieldProperties['int08'] =& new Xdbase_FieldProperty($this);
			$this->mFieldProperties['int08']->setDependsByArray(array('required'));
			$this->mFieldProperties['int08']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_INT08);
		}
	
	
		if ($this->dataConfigHandler->getRequired('int09'))
		{
			$this->mFieldProperties['int09'] =& new Xdbase_FieldProperty($this);
			$this->mFieldProperties['int09']->setDependsByArray(array('required'));
			$this->mFieldProperties['int09']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_INT09);
		}
	
		if ($this->dataConfigHandler->getRequired('int10'))
		{
			$this->mFieldProperties['int10'] =& new Xdbase_FieldProperty($this);
			$this->mFieldProperties['int10']->setDependsByArray(array('required'));
			$this->mFieldProperties['int10']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_INT10);
		}

		if ($this->dataConfigHandler->getRequired('float01'))
		{
			$this->mFieldProperties['float01'] =& new Xdbase_FieldProperty($this);
			$this->mFieldProperties['float01']->setDependsByArray(array('required'));
			$this->mFieldProperties['float01']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_FLOAT01);
		}
	
		if ($this->dataConfigHandler->getRequired('float02'))
		{
			$this->mFieldProperties['float02'] =& new Xdbase_FieldProperty($this);
			$this->mFieldProperties['float02']->setDependsByArray(array('required'));
			$this->mFieldProperties['float02']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_FLOAT02);
		}
	
		$this->mFieldProperties['varchar01'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('varchar01'))
		{
			$this->mFieldProperties['varchar01']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['varchar01']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_VARCHAR01);
		}
		else
		{
			$this->mFieldProperties['varchar01']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['varchar01']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_VARCHAR01, '255');
		$this->mFieldProperties['varchar01']->addVar('maxlength', '255');
	
		$this->mFieldProperties['varchar02'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('varchar02'))
		{
			$this->mFieldProperties['varchar02']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['varchar02']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_VARCHAR02);
		}
		else
		{
			$this->mFieldProperties['varchar02']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['varchar02']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_VARCHAR02, '255');
		$this->mFieldProperties['varchar02']->addVar('maxlength', '255');
	
		$this->mFieldProperties['varchar03'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('varchar03'))
		{
			$this->mFieldProperties['varchar03']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['varchar03']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_VARCHAR03);
		}
		else
		{
			$this->mFieldProperties['varchar03']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['varchar03']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_VARCHAR03, '255');
		$this->mFieldProperties['varchar03']->addVar('maxlength', '255');
	
		$this->mFieldProperties['varchar04'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('varchar04'))
		{
			$this->mFieldProperties['varchar04']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['varchar04']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_VARCHAR04);
		}
		else
		{
			$this->mFieldProperties['varchar04']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['varchar04']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_VARCHAR04, '255');
		$this->mFieldProperties['varchar04']->addVar('maxlength', '255');
	
		$this->mFieldProperties['varchar05'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('varchar05'))
		{
			$this->mFieldProperties['varchar05']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['varchar05']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_VARCHAR05);
		}
		else
		{
			$this->mFieldProperties['varchar05']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['varchar05']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_VARCHAR05, '255');
		$this->mFieldProperties['varchar05']->addVar('maxlength', '255');
	
		$this->mFieldProperties['varchar06'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('varchar06'))
		{
			$this->mFieldProperties['varchar06']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['varchar06']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_VARCHAR06);
		}
		else
		{
			$this->mFieldProperties['varchar06']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['varchar06']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_VARCHAR06, '255');
		$this->mFieldProperties['varchar06']->addVar('maxlength', '255');
	
		$this->mFieldProperties['varchar07'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('varchar07'))
		{
			$this->mFieldProperties['varchar07']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['varchar07']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_VARCHAR07);
		}
		else
		{
			$this->mFieldProperties['varchar07']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['varchar07']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_VARCHAR07, '255');
		$this->mFieldProperties['varchar07']->addVar('maxlength', '255');
	
		$this->mFieldProperties['varchar08'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('varchar08'))
		{
			$this->mFieldProperties['varchar08']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['varchar08']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_VARCHAR08);
		}
		else
		{
			$this->mFieldProperties['varchar08']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['varchar08']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_VARCHAR08, '255');
		$this->mFieldProperties['varchar08']->addVar('maxlength', '255');
	
		$this->mFieldProperties['varchar09'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('varchar09'))
		{
			$this->mFieldProperties['varchar09']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['varchar09']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_VARCHAR09);
		}
		else
		{
			$this->mFieldProperties['varchar09']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['varchar09']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_VARCHAR09, '255');
		$this->mFieldProperties['varchar09']->addVar('maxlength', '255');

		$this->mFieldProperties['varchar10'] =& new Xdbase_FieldProperty($this);
		if ($this->dataConfigHandler->getRequired('varchar10'))
		{
			$this->mFieldProperties['varchar10']->setDependsByArray(array('required','maxlength'));
			$this->mFieldProperties['varchar10']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_VARCHAR10);
		}
		else
		{
			$this->mFieldProperties['varchar10']->setDependsByArray(array('maxlength'));
		}
		$this->mFieldProperties['varchar10']->addMessage('maxlength', _MD_XDBASE_ERROR_MAXLENGTH, _MD_XDBASE_LANG_VARCHAR10, '255');
		$this->mFieldProperties['varchar10']->addVar('maxlength', '255');
	}

/*
	function validateGroups()
	{
		$groupHandler =& xoops_gethandler('group');
		if (is_array($this->get('groups')))
		{
			foreach ($this->get('groups') as $gid)
			{
				$group =& $groupHandler->get($gid);
				if (!is_object($group))
				{
					$this->addErrorMessage(_MD_XDBASE_ERROR_GROUP_VALUE);
				}
			}
		}
	}
*/
	function validateUrl()
	{
		$t_url = $this->get('url');
		if (strlen($t_url) > 0)
		{
			if (!preg_match('/^https?(:\/\/[-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)$/', $t_url))
			{
				$this->addErrorMessage(xdbaseFormatString(_MD_XDBASE_ERROR_INTRANGE, _MD_XDBASE_LANG_URL));
			}
		}
	}
/*
	function validatePassword()
	{
		$dataHandler =& $this->mController->load('handler', 'data');
		$dataObject =& $dataHandler->get($this->get('did'));
		if (is_object($dataObject))
		{
			$password = $dataObject->get('password');
			if (strlen($password))
			{
				if ($password != md5($this->get('password')))
				{
					$this->addErrorMessage(xdbaseFormatString(_MD_XDBASE_ERROR_INTRANGE, _MD_XDBASE_LANG_PASSWORD));
				}
			}
		}
	}
*/

	/**
	 * @public
	 */
	function load(&$obj)
	{
		$this->set('did', $obj->get('did'));
		$this->set('cid', $obj->get('cid'));
		$this->set('title', $obj->get('title'));
//		$this->set('tag', $obj->get('tag'));
		$this->set('pid', $obj->get('pid'));
		$this->set('uid', $obj->get('uid'));
		$this->set('name', $obj->get('name'));
		$this->set('poster_ip', $obj->get('poster_ip'));
		$this->set('created_date', $obj->get('created_date'));
		$this->set('updated_date', $obj->get('updated_date'));
		$this->set('published_date', $obj->get('published_date'));
		$this->set('expired_date', $obj->get('expired_date'));
		$this->set('s_date', $obj->get('s_date'));
		$this->set('e_date', $obj->get('e_date'));
		$this->set('password', $obj->get('password'));
		$this->set('url', $obj->get('url'));
		$this->set('email', $obj->get('email'));
		$this->set('zip', $obj->get('zip'));
		$this->set('state', $obj->get('state'));
		$this->set('city', $obj->get('city'));
		$this->set('street', $obj->get('street'));
		$this->set('phone', $obj->get('phone'));
		$this->set('mobile_phone', $obj->get('mobile_phone'));
		$this->set('fax', $obj->get('fax'));
//		$this->set('img01', $obj->get('img01'));
		$this->set('img01_height', $obj->get('img01_height'));
		$this->set('img01_width', $obj->get('img01_width'));
//		$this->set('img02', $obj->get('img02'));
		$this->set('img02_height', $obj->get('img02_height'));
		$this->set('img02_width', $obj->get('img02_width'));
		$this->set('file01name', $obj->get('file01name'));
		$this->set('file01ext', $obj->get('file01ext'));
		$this->set('file01size', $obj->get('file01size'));
		$this->set('downloads', $obj->get('downloads'));
		$this->set('body', $obj->get('body'));
		$this->set('int01', $obj->get('int01'));
		$this->set('int02', $obj->get('int02'));
		$this->set('int03', $obj->get('int03'));
		$this->set('int04', $obj->get('int04'));
		$this->set('int05', $obj->get('int05'));
		$this->set('int06', $obj->get('int06'));
		$this->set('int07', $obj->get('int07'));
		$this->set('int08', $obj->get('int08'));
		$this->set('int09', $obj->get('int09'));
		$this->set('int10', $obj->get('int10'));
		$this->set('float01', $obj->get('float01'));
		$this->set('float02', $obj->get('float02'));
		$this->set('varchar01', $obj->get('varchar01'));
		$this->set('varchar02', $obj->get('varchar02'));
		$this->set('varchar03', $obj->get('varchar03'));
		$this->set('varchar04', $obj->get('varchar04'));
		$this->set('varchar05', $obj->get('varchar05'));
		$this->set('varchar06', $obj->get('varchar06'));
		$this->set('varchar07', $obj->get('varchar07'));
		$this->set('varchar08', $obj->get('varchar08'));
		$this->set('varchar09', $obj->get('varchar09'));
		$this->set('varchar10', $obj->get('varchar10'));
		$this->set('trackbacks', $obj->get('trackbacks'));
		$this->set('pipe_id', $obj->get('pipe_id'));
		$this->set('show_map', $obj->get('show_map'));
		$this->set('latitude', $obj->get('latitude'));
		$this->set('longitude', $obj->get('longitude'));
		$this->set('zoom', $obj->get('zoom'));
		$this->set('text01', $obj->get('text01'));
		$this->set('text02', $obj->get('text02'));
		$this->set('reservation', $obj->get('reservation'));
//		$this->set('option_value', $obj->get('option_value'));
		$this->set('weight', $obj->get('weight'));
		$this->set('status', $obj->get('status'));
		$this->set('access', $obj->get('access'));
		$this->set('hits', $obj->get('hits'));
		$this->set('comments', $obj->get('comments'));
		$this->set('rating', $obj->get('rating'));
		$this->set('votes', $obj->get('votes'));
		$this->set('dohtml', $obj->get('dohtml'));
		$this->set('doxcode', $obj->get('doxcode'));
		$this->set('dosmiley', $obj->get('dosmiley'));
		$this->set('doimage', $obj->get('doimage'));
		$this->set('dobr', $obj->get('dobr'));

		$this->set('option_value', $obj->getOptionValueArray());

		$this->mOldStatus = $obj->get('status');
		$this->mOldImageName1 = $obj->get('img01');
		$this->mOldImageName2 = $obj->get('img02');
		$this->mOldFileName1 = $obj->get('file01');
		$this->mIsNew = $obj->isNew();

		$offset = xdbaseGetTimeOffset();

		if ($obj->isNew())
		{
			// set default value
			foreach ($this->mFormProperties as $key => $formProperty)
			{
				switch ($key)
				{
					case 'cid':
						$cid = xdbaseGetRequest('cid');
						if (is_null($cid))
						{
							$this->set($key, $this->dataConfigHandler->getDefaultValue($key));
						}
						else
						{
							$this->set($key, intval($cid));
						}
						break;
					case 'expired_date':
						$expired_date_default = intval($this->dataConfigHandler->getDefaultValue($key));
						$this->set($key, $this->dataConfigHandler->getDefaultValue($key));
						if (preg_match("/^[+|-][0-9]+/", $this->dataConfigHandler->getDefaultValue($key)))
						{
							$this->set($key, time() - $offset + $expired_date_default);
						}
						else
						{
							$this->set($key, $expired_date_default);
						}
						break;
					case 's_date':
						// for calendar style get year, month, day
						$date = xdbaseGetDateUnixTime();
						$this->set($key, $date);
						break;
					case 'e_date':
						$date = xdbaseGetDateUnixTime();
						$e_date_default = intval($this->dataConfigHandler->getDefaultValue($key));
						if (preg_match("/^[+|-]([0-9]+)/", $this->dataConfigHandler->getDefaultValue($key)))
						{
							$this->set($key, $date - $offset + $e_date_default);
						}
						else
						{
							$this->set($key, $e_date_default);
						}
						break;
					case 'latitude':
						$this->set($key, _MD_XDBASE_CONST_GMAPLATI);
						break;
					case 'longitude':
						$this->set($key, _MD_XDBASE_CONST_GMAPLONGI);
						break;
					case 'zoom':
						$this->set($key, _MD_XDBASE_CONST_GMAPZOOM);
						break;
					case 'img01':
						break;
					case 'img02':
						break;
					case 'file01':
						break;
					default;
						$this->set($key, $this->dataConfigHandler->getDefaultValue($key));
						break;
				}
			}

			// set access groups
			$groupHandler =& xoops_gethandler('group');
			$groups =& $groupHandler->getObjects(null, true);
			$i = 0;
			foreach ($groups as $gid => $group)
			{
				$this->set('groups', $i++, $gid);
			}

			if (_MD_XDBASE_CONST_LIST_TPT == 'data_list_bbs_style.html')
			{
				// for bbs style post form set pid
				if ($pid = xdbaseGetRequest('pid'))
				{
					$this->set('pid', $pid);
				}
			}
/*
			elseif (_MD_XDBASE_CONST_LIST_TPT == 'data_list_calendar_style.html')
			{
				// for calendar style get year, month, day
				$date = xdbaseGetDateUnixTime();
				$this->set('s_date', $date);
//				$this->set('e_date', $date + _MD_XDBASE_CONST_EDATE_AFILL);
			}
*/
		}
		else
		{
			$groupsArray = explode(',', $obj->get('groups'));
			if (is_array($groupsArray))
			{
				$i = 0;
				foreach ($groupsArray as $gid)
				{
					$this->set('groups', $i++, intval($gid));
				}
			}
		}

		// set tag
		$tags = preg_replace('/^\|([\W|\w]+)\|$/', '$1', $obj->get('tag'));
		$tags = explode('|', $tags);
		$i = 0;
		foreach ($tags as $tag)
		{
			$this->set('tag', $i++, $tag);
		}
	}

	/**
	 * @public
	 */
	function update(&$obj)
	{
		foreach ($this->mFormProperties as $key => $formProperty)
		{
			if (is_null($this->get($key)) && ($key != 'img01' && $key != 'img02' && $key != 'file01'))
			{
				$this->set($key, $obj->get($key));
			}
		}

		$obj->set('did', $this->get('did'));
		$obj->set('cid', $this->get('cid'));
		$obj->set('title', $this->get('title'));
		$obj->set('pid', $this->get('pid'));
		$obj->set('name', $this->get('name'));
		$obj->set('poster_ip', $_SERVER['REMOTE_ADDR']);
		$obj->set('password', $this->get('password'));
		$obj->set('url', $this->get('url'));
		$obj->set('email', $this->get('email'));
		$obj->set('zip', $this->get('zip'));
		$obj->set('state', $this->get('state'));
		$obj->set('city', $this->get('city'));
		$obj->set('street', $this->get('street'));
		$obj->set('phone', $this->get('phone'));
		$obj->set('mobile_phone', $this->get('mobile_phone'));
		$obj->set('fax', $this->get('fax'));
		$obj->set('downloads', $this->get('downloads'));
		$obj->set('body', $this->get('body'));
		$obj->set('int01', $this->get('int01'));
		$obj->set('int02', $this->get('int02'));
		$obj->set('int03', $this->get('int03'));
		$obj->set('int04', $this->get('int04'));
		$obj->set('int05', $this->get('int05'));
		$obj->set('int06', $this->get('int06'));
		$obj->set('int07', $this->get('int07'));
		$obj->set('int08', $this->get('int08'));
		$obj->set('int09', $this->get('int09'));
		$obj->set('int10', $this->get('int10'));
		$obj->set('float01', $this->get('float01'));
		$obj->set('float02', $this->get('float02'));
		$obj->set('varchar01', $this->get('varchar01'));
		$obj->set('varchar02', $this->get('varchar02'));
		$obj->set('varchar03', $this->get('varchar03'));
		$obj->set('varchar04', $this->get('varchar04'));
		$obj->set('varchar05', $this->get('varchar05'));
		$obj->set('varchar06', $this->get('varchar06'));
		$obj->set('varchar07', $this->get('varchar07'));
		$obj->set('varchar08', $this->get('varchar08'));
		$obj->set('varchar09', $this->get('varchar09'));
		$obj->set('varchar10', $this->get('varchar10'));
		$obj->set('trackbacks', $this->get('trackbacks'));
		$obj->set('pipe_id', $this->get('pipe_id'));
		$obj->set('show_map', $this->get('show_map'));
		$obj->set('latitude', $this->get('latitude'));
		$obj->set('longitude', $this->get('longitude'));
		$obj->set('zoom', $this->get('zoom'));
		$obj->set('text01', $this->get('text01'));
		$obj->set('text02', $this->get('text02'));
		$obj->set('reservation', $this->get('reservation'));
		$obj->set('option_value', $this->getOptionValue());
		$obj->set('weight', $this->get('weight'));
		$obj->set('status', $this->get('status'));
		$obj->set('access', $this->get('access'));
		$obj->set('hits', $this->get('hits'));
		$obj->set('comments', $this->get('comments'));
		$obj->set('rating', $this->get('rating'));
		$obj->set('votes', $this->get('votes'));
		$obj->set('dohtml', $this->get('dohtml'));
		$obj->set('doxcode', $this->get('doxcode'));
		$obj->set('dosmiley', $this->get('dosmiley'));
		$obj->set('doimage', $this->get('doimage'));
		$obj->set('dobr', $this->get('dobr'));

		// tag
		$tag = '';
		$tagOptionArray = $this->get('tag');
		if (count($tagOptionArray) > 0)
		{
			foreach ($tagOptionArray as $tagOption)
			{
				if ($tagOption != '')
				{
					$tag .= '|'.$tagOption;
					$this->mHasTag = true;
				}
			}
		}
		$tagAddArray = explode(',', $this->get('tag_add'));
		if (count($tagAddArray) > 0)
		{
			foreach ($tagAddArray as $tagAdd)
			{
				if (strlen($tagAdd) && !in_array($tagAdd, $tagOptionArray))
				{
					$tag .= '|'.$tagAdd;
					$this->mHasTag = true;
				}
			}
		}
		if ($this->mHasTag)
		{
			$tag .= '|';
		}
		$obj->set('tag', $tag);

		if (strlen($this->get('password')))
		{
			$obj->set('password', md5($this->get('password')));
		}

		$uid = xdbaseGetUid();
		$offset = xdbaseGetTimeOffset();

		$this->mIsNew = $obj->isNew();
		$status = 0;
		if ($obj->isNew())
		{
			$obj->set('uid', $uid);
			$obj->set('created_date', time() - $offset);
			if (_MD_XDBASE_CONST_SUPERINSERT)
			{
				$status = 1;
			}
			elseif ($this->dataConfigHandler->getActive('status') == false)
			{
				$status = 1;
			}
		}
		else
		{
			$obj->set('created_date', $obj->get('created_date'));
			if (_MD_XDBASE_CONST_SUPEREDIT)
			{
				$status = 1;
			}
		}
		$obj->set('status', $status);

		$obj->set('updated_date', time() - $offset);

		$published_date_array = $this->get('published_date_array');
		if (is_array($published_date_array))
		{
			if (count($published_date_array) > 0)
			{
				$published_date = mktime(intval($published_date_array['Time_Hour']), intval($published_date_array['Time_Minute']), 0, intval($published_date_array['Date_Month']), intval($published_date_array['Date_Day']), intval($published_date_array['Date_Year']));
				$published_date = $published_date - $offset;
				$obj->set('published_date', $published_date);
			}
		}

		$expired_date_array = $this->get('expired_date_array');
		if (is_array($expired_date_array))
		{
			if (count($expired_date_array) > 0)
			{
				$expired_date = mktime(intval($expired_date_array['Time_Hour']), intval($expired_date_array['Time_Minute']), 0, intval($expired_date_array['Date_Month']), intval($expired_date_array['Date_Day']), intval($expired_date_array['Date_Year']));
				$expired_date = $expired_date - $offset;
				$obj->set('expired_date', $expired_date);
			}
		}

		$s_date_array = $this->get('s_date_array');
		if (is_array($s_date_array))
		{
			if (count($s_date_array) > 0)
			{
				$s_date = mktime(intval($s_date_array['Time_Hour']), intval($s_date_array['Time_Minute']), 0, intval($s_date_array['Date_Month']), intval($s_date_array['Date_Day']), intval($s_date_array['Date_Year']));
				$s_date = $s_date - $offset;
				$obj->set('s_date', $s_date);
			}
		}

		$e_date_array = $this->get('e_date_array');
		if (is_array($e_date_array))
		{
			if (count($e_date_array) > 0)
			{
				$e_date = mktime(intval($e_date_array['Time_Hour']), intval($e_date_array['Time_Minute']), 0, intval($e_date_array['Date_Month']), intval($e_date_array['Date_Day']), intval($e_date_array['Date_Year']));
				$e_date = $e_date - $offset;
				$obj->set('e_date', $e_date);
			}
		}
		elseif (is_array($s_date_array))
		{
			if (count($s_date_array) > 0)
			{
				$s_date = mktime(intval($s_date_array['Time_Hour']), intval($s_date_array['Time_Minute']), 0, intval($s_date_array['Date_Month']), intval($s_date_array['Date_Day']), intval($s_date_array['Date_Year']));
				$e_date = $s_date - $offset + intval($this->dataConfigHandler->getDefaultValue('e_date'));

				$obj->set('e_date', $e_date);
			}
		}

		// for bbs style
		if (_MD_XDBASE_CONST_LIST_TPT == 'data_list_bbs_style.html')
		{
			$dataHandler =& $this->mController->load('handler', 'data');
			if ($dataHandler->getActive('pid') && $this->get('pid'))
			{
				$parentObject =& $dataHandler->get($this->get('pid'));
				if (is_object($parentObject))
				{
					$parentObject->set('updated_date', time() - $offset);
					$dataHandler->insert($parentObject);
				}
			}
		}

		// groups
		$groupsArray = $this->get('groups');
		$groups = '';
		if (count($groupsArray) > 0)
		{
			$groups = implode(',', $this->get('groups'));
		}
		$obj->set('groups', $groups);

		// image upload
		$this->mFormImage1 = $this->get('img01');
		if ($this->mFormImage1 != null && is_object($this->mFormImage1))
		{
			$this->mFormImage1->setRandomToBodyName('xdbase');
			$imageName1 = $this->mFormImage1->getBodyName();
			$this->mFormImage1->setBodyName(substr($imageName1, 0, 24));
			$obj->set('img01', $this->mFormImage1->getFileName());
			$obj->set('img01_height', $this->mFormImage1->getHeight());
			$obj->set('img01_width', $this->mFormImage1->getWidth());
			$this->deleteImage($this->mOldImageName1);
		}
		else
		{
			if ($this->get('delete_img01') == true)
			{
				$obj->set('img01', '');
				$obj->set('img01_height', 0);
				$obj->set('img01_width', 0);
				$this->deleteImage($this->mOldImageName1);
			}
		}

		$this->mFormImage2 = $this->get('img02');
		if ($this->mFormImage2 != null && is_object($this->mFormImage2))
		{
			$this->mFormImage2->setRandomToBodyName('xdbase');
			$imageName2 = $this->mFormImage2->getBodyName();
			$this->mFormImage2->setBodyName(substr($imageName2, 0, 24));
			$obj->set('img02', $this->mFormImage2->getFileName());
			$obj->set('img02_height', $this->mFormImage2->getHeight());
			$obj->set('img02_width', $this->mFormImage2->getWidth());
			$this->deleteImage($this->mOldImageName2);
		}
		else
		{
			if ($this->get('delete_img02') == true)
			{
				$obj->set('img02', '');
				$obj->set('img02_height', 0);
				$obj->set('img02_width', 0);
				$this->deleteImage($this->mOldImageName2);
			}
		}

		// file upload
		$this->mFormFile1 = $this->get('file01');
		if ($this->mFormFile1 != null && is_object($this->mFormFile1))
		{
			$obj->set('file01', $this->mFormFile1->getFileName());
			$obj->set('file01ext', $this->mFormFile1->getExtension());
			$obj->set('file01size', $this->mFormFile1->getFileSize() / 1024);
			$this->mFormFile1->setRandomToFilename('xdbase');
			$fileName1 = $this->mFormFile1->getFileName();
			$this->mFormFile1->setBodyName(substr($fileName1, 0, 24));
			$obj->set('file01name', xdbaseEncodName($this->mFormFile1->getFileName()));
		}
		else
		{
			if ($this->get('delete_file01') == true)
			{
				$obj->set('file01', '');
				$obj->set('file01ext', '');
				$obj->set('file01size', 0);
				$obj->set('file01name', '');
				$this->deleteFile($this->mOldFileName1);
			}
		}

	}

	function deleteImage($imageName)
	{
		if ($imageName != '')
		{
			if (file_exists(_MD_XDBASE_CONST_PHOTOS_PATH.'/'.$imageName))
			{
				@unlink(_MD_XDBASE_CONST_PHOTOS_PATH.'/'.$imageName);
			}
			if (file_exists(_MD_XDBASE_CONST_THUMBS_PATH.'/'.$imageName))
			{
				@unlink(_MD_XDBASE_CONST_THUMBS_PATH.'/'.$imageName);
			}
		}
	}

	function deleteFile($fileName)
	{
		if ($fileName != '')
		{
			if (file_exists(_MD_XDBASE_CONST_FILES_PATH.'/'.$fileName))
			{
				@unlink(_MD_XDBASE_CONST_FILES_PATH.'/'.$fileName);
			}
		}
	}

	function getRequiredKeyCount()
	{
		return count($this->dataConfigHandler->getRequiredKeyArray());
	}

	function getRequiredKeyArray()
	{
		$requiredKeyArray = $this->dataConfigHandler->getRequiredKeyArray();
		$required = array();
		foreach ($requiredKeyArray as $key=>$requiredKey)
		{
			$eltcaption = trim($this->dataConfigHandler->getKeyConst($requiredKey));
			$eltmsg = sprintf(_FORM_ENTER, $eltcaption);
			$eltmsg = str_replace('"', '\"', stripslashes($eltmsg));
			$required[$key]['key'] = $requiredKey;
			$required[$key]['message'] = $eltmsg;
		}
		return $required;
	}


	function getOptionValue()
	{
		if (!is_array($this->get('option_label'))) return '';

		$optionValueArray = array();
		$max = count($this->get('option_label'));
		for ($i = 0; $i < $max; $i++)
		{
			$option_label = $this->get('option_label', $i);
			$option_required = intval($this->get('option_required', $i));
			$option_type = $this->get('option_type', $i);
			$option_value = $this->get('option_value', $i);
			$option_default = $this->get('option_default', $i);
			if ($option_label !== '')
			{
				$optionValueArray[$i]['label'] = $option_label;
				$optionValueArray[$i]['required'] = $option_required;
				$optionValueArray[$i]['type'] = $option_type;
				$optionValueArray[$i]['value'] = $option_value;
				$optionValueArray[$i]['default'] = $option_default;
			}
		}
		if (count($optionValueArray) > 0)
		{
			$optionValue = serialize($optionValueArray);
		}
		else
		{
			$optionValue = '';
		}
		return $optionValue;
	}


}

?>
