
CREATE TABLE cat (
  cid int(5) unsigned NOT NULL auto_increment,
  pid int(5) unsigned NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  description text NOT NULL,
  img varchar(64) NOT NULL default '',
  img_height int(4) NOT NULL default '0',
  img_width int(4) NOT NULL default '0',
  weight int(5) unsigned NOT NULL default '0',
  status tinyint(1) NOT NULL default '1',
  access tinyint(1) NOT NULL default '0',
  groups varchar(255) NOT NULL default '',
  created_date int(10) NOT NULL default '0',
  updated_date int(10) NOT NULL default '0',
  show_map tinyint(1) NOT NULL default '0',
  latitude double(10,8) NOT NULL default '0',
  longitude double(11,8) NOT NULL default '0',
  zoom tinyint(2) NOT NULL default '0',
  icon varchar(100) NOT NULL default '',
  icon_width int(10) unsigned NOT NULL default '0',
  icon_height int(10) unsigned NOT NULL default '0',
  int01 int(11) NOT NULL default '0',
  int02 int(11) NOT NULL default '0',
  int03 int(11) NOT NULL default '0',
  PRIMARY KEY (cid),
  KEY (pid)
) TYPE=MyISAM;


CREATE TABLE data (
  did int(11) unsigned NOT NULL auto_increment,
  cid int(5) unsigned NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  tag varchar(255) NOT NULL default '',
  pid int(11) unsigned NOT NULL default '0',
  uid int(8) unsigned NOT NULL default '0',
  name varchar(100) NOT NULL default '',
  poster_ip varchar(15) NOT NULL default '',
  created_date int(10) NOT NULL default '0',
  updated_date int(10) NOT NULL default '0',
  published_date int(10) NOT NULL default '0',
  expired_date int(10) NOT NULL default '0',
  s_date int(10) NOT NULL default '0',
  e_date int(10) NOT NULL default '0',
  password varchar(34) NOT NULL default '',
  url varchar(255) NOT NULL default '',
  email varchar(64) NOT NULL default '',
  zip varchar(20) NOT NULL default '',
  state varchar(255) NOT NULL default '',
  city varchar(255) NOT NULL default '',
  street varchar(255) NOT NULL default '',
  phone varchar(30) NOT NULL default '',
  mobile_phone varchar(30) NOT NULL default '',
  fax varchar(30) NOT NULL default '',
  show_map tinyint(1) NOT NULL default '0',
  latitude double(10,8) NOT NULL default '0',
  longitude double(11,8) NOT NULL default '0',
  zoom tinyint(2) NOT NULL default '0',
  img01 varchar(64) NOT NULL default '',
  img01_height int(4) NOT NULL default '0',
  img01_width int(4) NOT NULL default '0',
  img02 varchar(64) NOT NULL default '',
  img02_height int(4) NOT NULL default '0',
  img02_width int(4) NOT NULL default '0',
  file01 varchar(64) NOT NULL default '',
  file01name varchar(64) NOT NULL default '',
  file01ext varchar(10) NOT NULL default '',
  file01size double(8,2) NOT NULL default '0.00',
  body text NOT NULL,
  int01 int(11) NOT NULL default '0',
  int02 int(11) NOT NULL default '0',
  int03 int(11) NOT NULL default '0',
  int04 int(11) NOT NULL default '0',
  int05 int(11) NOT NULL default '0',
  int06 int(11) NOT NULL default '0',
  int07 int(11) NOT NULL default '0',
  int08 int(11) NOT NULL default '0',
  int09 int(11) NOT NULL default '0',
  int10 int(11) NOT NULL default '0',
  float01 double(6,4) NOT NULL default '0.0000',
  float02 double(6,4) NOT NULL default '0.0000',
  varchar01 varchar(255) NOT NULL default '',
  varchar02 varchar(255) NOT NULL default '',
  varchar03 varchar(255) NOT NULL default '',
  varchar04 varchar(255) NOT NULL default '',
  varchar05 varchar(255) NOT NULL default '',
  varchar06 varchar(255) NOT NULL default '',
  varchar07 varchar(255) NOT NULL default '',
  varchar08 varchar(255) NOT NULL default '',
  varchar09 varchar(255) NOT NULL default '',
  varchar10 varchar(255) NOT NULL default '',
  text01 text NOT NULL,
  text02 text NOT NULL,
  reservation tinyint(1) unsigned NOT NULL default '0',
  option_value text NOT NULL,
  weight int(5) unsigned NOT NULL default '0',
  status tinyint(1) NOT NULL default '1',
  access tinyint(1) NOT NULL default '0',
  groups varchar(255) NOT NULL default '',
  hits int(11) unsigned NOT NULL default '0',
  comments int(11) unsigned NOT NULL default '0',
  rating double(6,4) NOT NULL default '0.0000',
  votes int(11) unsigned NOT NULL default '0',
  downloads int(11) unsigned NOT NULL default '0',
  trackbacks int(11) unsigned NOT NULL default '0',
  pipe_id int(11) unsigned NOT NULL default '0',
  dohtml tinyint(1) NOT NULL default '0',
  doxcode tinyint(1) NOT NULL default '1',
  dosmiley tinyint(1) NOT NULL default '1',
  doimage tinyint(1) NOT NULL default '1',
  dobr tinyint(1) NOT NULL default '1',
  PRIMARY KEY (did),
  KEY (cid),
  KEY (pid),
  KEY (uid),
  KEY (tag)
) TYPE=MyISAM;


CREATE TABLE data_config (
  configid int(5) unsigned NOT NULL default '0',
  col varchar(30) NOT NULL default '',
  name varchar(100) NOT NULL default '',
  active tinyint(1) NOT NULL default '0',
  search tinyint(1) NOT NULL default '0',
  show_list tinyint(1) NOT NULL default '0',
  show_article tinyint(1) NOT NULL default '0',
  input_type tinyint(1) NOT NULL default '0',
  option_value text NOT NULL,
  default_value text NOT NULL,
  PRIMARY KEY (col),
  KEY (configid)
) TYPE=MyISAM;


CREATE TABLE data_attribute (
  aid int(11) unsigned NOT NULL auto_increment,
  did int(11) unsigned NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  uid int(8) unsigned NOT NULL default '0',
  email varchar(64) NOT NULL default '',
  status tinyint(1) NOT NULL default '0',
  poster_ip varchar(15) NOT NULL default '',
  timestamp int(10) NOT NULL default '0',
  int01 int(11) NOT NULL default '0',
  int02 int(11) NOT NULL default '0',
  int03 int(11) NOT NULL default '0',
  int04 int(11) NOT NULL default '0',
  int05 int(11) NOT NULL default '0',
  option_value text NOT NULL,
  PRIMARY KEY (aid),
  KEY (did)
) TYPE=MyISAM;
