<?php
/**
 * Smarty plugin
 * @package xdbase
 * @version $Id: function.xdbase_textarea.php,v 1.4 2010/03/01 06:44:26 bluemelon Exp $
 */

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * Type:     function
 * Name:     xoops_textarea
 * Version:  1.0
 * Date:     Nov 2, 2005
 * Author:   minahito
 * Purpose:  textarea tag with sanitize.
 * Input:    name = form 'name'.
 *           value = preset value. Set raw value without htmlspecialchars().
 *           class = form 'class'.
 *           id = form 'id'. If it's empty, ID is defined automatically by prefix & name.
 *           cols = amount of cols. (default 50)
 *           rows = amount of rows. (default 7)
 *           readonly = if it's true, textarea becomes readonly.
 * 
 * Examples: {xoops_textarea name=message cols=40 rows=6 value=$message}
 * -------------------------------------------------------------
 */

define ("XOOPS_TEXTAREA_DEFID_PREFIX", "legacy_xoopsform_");
define ("XOOPS_TEXTAREA_DEFAULT_COLS", "50");
define ("XOOPS_TEXTAREA_DEFAULT_ROWS", "7");

function smarty_function_xdbase_textarea($params, &$smarty)
{
	if (isset($params['name'])) {
		//
		// Fetch major elements from $params.
		//
		$name = trim($params['name']);
		$class = isset($params['class']) ? trim($params['class']) : null;
        $style = isset($params['style']) ? trim($params['style']) : null;
		$cols = isset($params['cols']) ? intval($params['cols']) : XOOPS_TEXTAREA_DEFAULT_COLS;
		$rows = isset($params['rows']) ? intval($params['rows']) : XOOPS_TEXTAREA_DEFAULT_ROWS;
		$value = isset($params['value']) ? htmlspecialchars($params['value'], ENT_QUOTES) : null;
		$id = isset($params['id']) ? trim($params['id']) : XOOPS_TEXTAREA_DEFID_PREFIX . $name;
		$readonly = isset($params['readonly']) ? (bool)(trim($params['readonly'])) : false;

		//
		// Build string.
		//
		$string = "<textarea name=\"${name}\" cols=\"${cols}\" rows=\"${rows}\"";
		
		if ($class) {
			$string .= " class=\"${class}\"";
		}

        if ($style) {
            $string .= " style=\"${style}\"";
        }

		$string .= " id=\"$id\"";
		
		if($readonly) {
			$string .= " readonly=\"readonly\"";
		}

		$string .= ">" . $value . "</textarea>";

		//
		// Output.
		//
		print $string;
	}
}

?>
