<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_attributeEditAction.class.php,v 1.6 2011/10/10 07:45:13 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractEditAction.class.php';

class Xdbase_Data_attributeEditAction extends Xdbase_AbstractEditAction
{
	var $mAttributeActionForm = null;

	/**
	 * @protected
	 */
	function _getId()
	{
		return xdbaseGetRequest('aid');
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data_attribute');
		return $handler;
	}

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
		$this->mActionForm =& $this->mController->create('form', 'edit_data_attribute');
		$this->mActionForm->prepare();
	}

	/**
	 * @public
	 */
	function executeViewInput()
	{
		$this->checkPerm();


		$GLOBALS['xoopsOption']['template_main'] = $this->mController->mDirname.'_data_attribute_edit.html';
		$this->mTpl->assign('actionForm', $this->mActionForm);
		$this->mTpl->assign('object', $this->mObject);

		$handler =& $this->mController->load('handler', 'data_attribute');
		$this->mTpl->assign('handler', $handler);

		$dataHandler =& $this->mController->load('handler', 'data');
		$this->mTpl->assign('dataHandler', $dataHandler);
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->mController->executeForward('./index.php?action=Data_attributeView&aid='.$this->mObject->getShow('aid').'&type='.$this->mObject->getShow('type'));
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mController->executeRedirect('./index.php?action=Data_attributeList&did='.$this->mObject->getShow('did').'&type='.$this->mObject->getShow('type'), 1, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php?action=Data_attributeList&did='.$this->mObject->getShow('did').'&type='.$this->mObject->getShow('type'));
	}


	function _doExecute()
	{
		$this->checkPerm();
		if ($this->mObjectHandler->insert($this->mObject))
		{
			return XDBASE_FRAME_VIEW_SUCCESS;
		}
		return XDBASE_FRAME_VIEW_ERROR;
	}

	function checkPerm()
	{
		$did = $this->mObject->getShow('did');
		$dataHandler =& $this->mController->load('handler', 'data');
		$dataObject =& $dataHandler->get($did);
		$reservation = false;
		if (is_object($dataObject))
		{
			$reservation = $dataObject->getShow('reservation');
		}
		if ($reservation)
		{
			if (!$this->mActionForm->mIsNew)
			{
				if (!$dataHandler->checkData($did))
				{
					$this->mController->executeRedirect('./index.php?action=DataView&did='.$this->mObject->getShow('did'), 3, _NOPERM);
				}
				if (_MD_XDBASE_CONST_EDITABLE == false)
				{
					$this->mController->executeRedirect('./index.php?action=DataView&did='.$this->mObject->getShow('did'), 3, _NOPERM);
				}
			}
		}
		else
		{
			$this->mController->executeRedirect('./index.php?action=DataView&did='.$this->mObject->getShow('did'), 3, _NOPERM);
		}
	}


}

?>
