<?php
/**
 * @file
 * @package xdbase
 * @version $Id: ImportAction.class.php,v 1.11 2011/10/10 07:45:13 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/class/ConvertDataAction.class.php';

class Xdbase_Admin_ImportAction extends Xdbase_Admin_ConvertDataAction
{

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
		$this->mActionForm =& $this->mController->create('form', 'admin.edit_Import');
		$this->mActionForm->prepare();
	}

	/**
	 * @protected
	 * added by hiro
	 */
	function _setupTemplateName()
	{
		$this->templateName = 'import.html';
	}

	function _setupTableName()
	{
		$this->catTableFrom = xdbaseGetRequest('cat_table');
		$this->dataTableFrom = xdbaseGetRequest('data_table');
		$this->catTableTo = _MD_XDBASE_CONST_MODULEDIRNAME.'_cat';
		$this->dataTableTo = _MD_XDBASE_CONST_MODULEDIRNAME.'_data';
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function execute()
	{
		if (xdbaseGetRequest('_form_control_cancel') != null)
		{
			return XDBASE_FRAME_VIEW_CANCEL;
		}

		if ($this->progress < 3)
		{
			return XDBASE_FRAME_VIEW_INPUT;
		}

		$this->mActionForm->fetch();
		$this->mActionForm->validate();

		if ($this->mActionForm->hasError())
		{
			return XDBASE_FRAME_VIEW_INPUT;
		}
		else
		{
			return $this->_doExecute();
		}
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function _doExecute()
	{
		$ret = $this->truncateTable();

		switch ($this->datatype)
		{
			case 1: // MySQL
				$ret = $this->executeMySqlImport();
				break;
			case 2: // CSV
				$ret = $this->executeCsvImport();
				break;
			case 3: // VCard
				$ret = $this->executeVCardImport();
				break;
			case 4: // ContactXML
				$ret = $this->executeContactXMLImport();
				break;
			default:
				$ret = false;
				break;
		}

		if ($ret)
		{
			return XDBASE_FRAME_VIEW_SUCCESS;
		}
		return XDBASE_FRAME_VIEW_ERROR;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mTpl->assign('actionForm', $this->mActionForm);
		$retMessage = 'Import Failed<br />'.$this->getMessage();
		$this->mTpl->assign('retMessage', $retMessage);
		$this->mTpl->assign('progress', 5);

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/import.html');
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getTempFileName($extension = '')
	{
		$tmpFileName = false;

		if (isset($_FILES['file']))
		{
			$fileName = $_FILES['file']['name'];
			if (preg_match("/\.([a-z\.]+)$/", $fileName, $match))
			{
				$tmpFileExtension = $match[1];
				if ($tmpFileExtension == $extension)
				{
					$tmpFileName = $_FILES['file']['tmp_name'];
				}
			}
		}

		return $tmpFileName;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function executeMySqlImport()
	{
		$updateCat = intval(xdbaseGetRequest('update_cat'));
		$updateData = intval(xdbaseGetRequest('update_data'));

		if ($this->catTableFrom != '')
		{
			if ($updateCat)
			{
				list($ret, $messageArray) = $this->mySqlHandler->updateDataFromTable($this->catTableFrom, $this->catTableTo, 'cat', 'cid');
				$this->setMessage($messageArray);
				if ($ret == false) return false;
			}
			else
			{
				list($ret, $messageArray) = $this->mySqlHandler->importDataFromTable($this->catTableFrom, $this->catTableTo, 'cat');
				$this->setMessage($messageArray);
				if ($ret == false) return false;
			}
		}

		if ($this->dataTableFrom != '')
		{
			if ($updateData)
			{
				list($ret, $messageArray) = $this->mySqlHandler->updateDataFromTable($this->dataTableFrom, $this->dataTableTo, 'data', 'did');
				$this->setMessage($messageArray);
				if ($ret == false) return false;
			}
			else
			{
				list($ret, $messageArray) = $this->mySqlHandler->importDataFromTable($this->dataTableFrom, $this->dataTableTo, 'data');
				$this->setMessage($messageArray);
				if ($ret == false) return false;
			}
		}
		return true;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function executeContactXMLImport()
	{
		require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/class/ContactXMLHandler.php';
		$contactXMLHandler =& new ContactXMLHandler();

		$tmpFileName = $this->getTempFileName('contact');

		$xmlArray = $contactXMLHandler->getContactXMLArray($tmpFileName);
		if (!is_array($xmlArray)) return false;

		list($ret, $messageArray) = $this->mySqlHandler->importDataFromArray($this->dataTableTo, $xmlArray);
		$this->setMessage($messageArray);
		if ($ret == false) return false;
		return true;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function executeVCardImport()
	{
		require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/class/VcardHandler.php';
		$vcardHandler =& new VCardHandler();

		$tmpFileName = $this->getTempFileName('vcf');

		$vcardArray = $vcardHandler->getVcardArray($tmpFileName);

		if (!is_array($vcardArray)) return false;

		list($ret, $messageArray) = $this->mySqlHandler->importDataFromArray($this->dataTableTo, $vcardArray);
		$this->setMessage($messageArray);
		if ($ret == false) return false;
		return true;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function executeCsvImport()
	{
		require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/class/CsvHandler.php';
		$csvHandler =& new CsvHandler();

		$tmpFile = $this->getTempFileName('csv');
		if ($err = xdbaseCheckDir(_MD_XDBASE_CONST_FILES_PATH))
		{
			$this->setMessage($err);
			return false;
		}
		$csvFile = _MD_XDBASE_CONST_FILES_PATH.'/'._MD_XDBASE_CONST_MODULEDIRNAME.'_import_'.date('Ymd_Hi').'.csv';

		if (!$ret = move_uploaded_file($tmpFile, $csvFile))
		{
			return XDBASE_FRAME_VIEW_ERROR;
		}
		@chmod($csvFile, XDBASE_FORMFILE_CHMOD);

		$fp = fopen($csvFile, 'r');

//		$memory_limit = (ini_get('memory_limit') * 1024 * 1024);
		$csvArray = array();
		$columnArray = fgetcsv($fp);
		$columnKeyArray = $this->mySqlHandler->getColumnKeyArray();

		if (count($columnArray) == 0)
		{
			return false;
		}

		foreach ($columnArray as $column)
		{
			if (!in_array($column, $columnKeyArray))
			{
				$str = 'Invalid column : '.$column;
				$this->setMessage($str);
				return false;
			}
		}

		$i = 0;
//		while (($csvArray = fgetcsv($fp)) !== false)
		while (($csvArray = fgetcsv($fp, 0, ',' , '"')) !== false)
		{
			if (count($csvArray) != 0)
			{
				if ($ret = $this->mySqlHandler->importCsvDataFromArray($this->dataTableTo, $csvArray, $columnArray))
				{
					$this->setMessage($ret);
					return false;
				}
			}
			$i++;
		}

		fclose($fp);
		unlink($csvFile);

		$str = $i.' records were inserted from DataArray to '.$this->dataTableTo;
		$this->setMessage($str);

		return true;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php?action=Import');
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

}

?>
