<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_configFilterForm.class.php,v 1.10 2011/10/10 07:45:13 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractFilterForm.class.php';

define('XDBASE_DATA_CONFIG_SORT_KEY_CONFIGID', 1);
define('XDBASE_DATA_CONFIG_SORT_KEY_COL', 2);
define('XDBASE_DATA_CONFIG_SORT_KEY_NAME', 3);
define('XDBASE_DATA_CONFIG_SORT_KEY_ACTIVE', 4);
define('XDBASE_DATA_CONFIG_SORT_KEY_SEARCH', 5);
define('XDBASE_DATA_CONFIG_SORT_KEY_SHOW_LIST', 6);
define('XDBASE_DATA_CONFIG_SORT_KEY_SHOW_ARTICLE', 7);
define('XDBASE_DATA_CONFIG_SORT_KEY_INPUT_TYPE', 8);
define('XDBASE_DATA_CONFIG_SORT_KEY_OPTION_VALUE', 9);
define('XDBASE_DATA_CONFIG_SORT_KEY_DEFAULT_VALUE', 10);
define('XDBASE_DATA_CONFIG_SORT_KEY_DEFAULT', XDBASE_DATA_CONFIG_SORT_KEY_CONFIGID);

class Xdbase_Admin_Data_configFilterForm extends Xdbase_AbstractFilterForm
{
	var $mSortKeys = array(
		XDBASE_DATA_CONFIG_SORT_KEY_CONFIGID => 'configid',
		XDBASE_DATA_CONFIG_SORT_KEY_COL => 'col',
		XDBASE_DATA_CONFIG_SORT_KEY_NAME => 'name',
		XDBASE_DATA_CONFIG_SORT_KEY_ACTIVE => 'active',
		XDBASE_DATA_CONFIG_SORT_KEY_SEARCH => 'search',
		XDBASE_DATA_CONFIG_SORT_KEY_SHOW_LIST => 'show_list',
		XDBASE_DATA_CONFIG_SORT_KEY_SHOW_ARTICLE => 'show_article',
		XDBASE_DATA_CONFIG_SORT_KEY_INPUT_TYPE => 'input_type',
		XDBASE_DATA_CONFIG_SORT_KEY_OPTION_VALUE => 'option_value',
		XDBASE_DATA_CONFIG_SORT_KEY_DEFAULT_VALUE => 'default_value'
	);

	/**
	 * @public
	 */
	function getDefaultSortKey()
	{
		return XDBASE_DATA_CONFIG_SORT_KEY_DEFAULT;
	}

	/**
	 * @public
	 */
	function fetch()
	{
		parent::fetch();
	
		if (($value = xdbaseGetRequest('configid')) !== null) {
			$this->mNavi->addExtra('configid', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('configid', $value));
		}
	
		if (($value = xdbaseGetRequest('col')) !== null) {
			$this->mNavi->addExtra('col', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('col', $value));
		}
	
		if (($value = xdbaseGetRequest('name')) !== null) {
			$this->mNavi->addExtra('name', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('name', $value));
		}

		if (($value = xdbaseGetRequest('active')) !== null) {
			$this->mNavi->addExtra('active', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('active', $value));
		}
	
		if (($value = xdbaseGetRequest('search')) !== null) {
			$this->mNavi->addExtra('search', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('search', $value));
		}
	
		if (($value = xdbaseGetRequest('show_list')) !== null) {
			$this->mNavi->addExtra('show_list', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('show_list', $value));
		}
	
		if (($value = xdbaseGetRequest('show_article')) !== null) {
			$this->mNavi->addExtra('show_article', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('show_article', $value));
		}
	
		if (($value = xdbaseGetRequest('input_type')) !== null) {
			$this->mNavi->addExtra('input_type', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('input_type', $value));
		}
	
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());

		$this->mNavi->setPerpage(100);

	}
}

?>
