<?php
/**
 *
 * @package XCube
 * @version $Id: Xdbase_FormFile.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 * @copyright Copyright 2005-2007 XOOPS Cube Project  <http://xoopscube.sourceforge.net/>
 * @license http://xoopscube.sourceforge.net/bsd_licenses.txt Modified BSD license
 *
 */

//define("XDBASE_FORMFILE_PREVMASK", "0022");
define("XDBASE_FORMFILE_CHMOD", 0644);

/**
 * WARNING:
 * This class is simple wrapper class for proccessing the file uploaded.
 * However, we have to examine the position of this class. We aims to simple file tree.
 * This class is only helper. We think that Cube system shouldn't offer misc helper.
 *
 * We put this class in root/class for the progress of this project. But, we will move
 * this to other directory in the future.
 */
class Xdbase_FormFile
{
	var $mName=null;
	
	var $mKey = null;
	
	var $mContentType=null;
	
	var $mFileName=null;
	var $mFileSize=0;
	
	var $_mTmpFileName=null;
	
	var $mUploadFileFlag=false;
	
	function Xdbase_FormFile($name = null, $key = null)
	{
		$this->mName = $name;
		$this->mKey = $key;
	}
	
	/**
	 * Fetch necessary information from $_FILES by $mName
	 */
	function fetch()
	{
		if($this->mName && isset($_FILES[$this->mName])) {
			if ($this->mKey != null) {
				$this->setFileName($_FILES[$this->mName]['name'][$this->mKey]);
				$this->setContentType($_FILES[$this->mName]['type'][$this->mKey]);
				$this->setFileSize($_FILES[$this->mName]['size'][$this->mKey]);
				$this->_mTmpFileName = $_FILES[$this->mName]['tmp_name'][$this->mKey];
			}
			else {
				$this->setFileName($_FILES[$this->mName]['name']);
				$this->setContentType($_FILES[$this->mName]['type']);
				$this->setFileSize($_FILES[$this->mName]['size']);
				$this->_mTmpFileName = $_FILES[$this->mName]['tmp_name'];
			}
			
			if($this->getFileSize()>0)
				$this->mUploadFileFlag=true;
		}
	}
	
	function hasUploadFile()
	{
		return $this->mUploadFileFlag;
	}
	
	/**
	 * Return content type
	 * @return string
	*/
	function getContentType()
	{
		return $this->mContentType;
	}
	
	function getFileData()
	{
		// Now, implemeting.
	}
	
	/**
	 * Return file name.
	 * @return string
	*/
	function getFileName()
	{
		return $this->mFileName;
	}
	
	/**
	 * Return file size.
	 * @return int
	 */
	function getFileSize()
	{
		return $this->mFileSize;
	}
	
	/**
	 * Return extension from file name.
	 * @return string
	 */
	function getExtension()
	{
		$ret = null;
		$filename = $this->getFileName();
		if (preg_match("/\.([a-z\.]+)$/", $filename, $match)) {
			$ret = $match[1];
		}
		
		return $ret;
	}
	
	/**
	 * Set extension.
	 * @return string
	 */
	function setExtension($ext)
	{
		$filename = $this->getFileName();
		if(preg_match("/(.+)\.\w+$/",$filename,$match))
			$this->setFileName($match[1].".${ext}");
	}
	
	/**
	 * Set content type
	 * @param $contenttype string
	*/
	function setContentType($contenttype)
	{
		$this->mContentType = $contenttype;
	}
	
	/**
	 * Set file name
	 * @param $filename string
	 */
	function setFileName($filename)
	{
		$this->mFileName = $filename;
	}
	
	/**
	 * Set file size
	 * @param $filesize int
	 */
	function setFileSize($filesize)
	{
		$this->mFileSize = $filesize;
	}
	
	/**
	 * Set file body name. The extension is never changed.
	 * @param $bodyname string
	 */
	function setBodyName($bodyname)
	{
		$this->setFileName($bodyname.".".$this->getExtension());
	}
	
	/**
	 * Get file body name.
	 * @return string
	 */
	function getBodyName()
	{
		if(preg_match("/(.+)\.\w+$/",$this->getFileName(),$match)) {
			return $match[1];
		}
		
		return null;
	}
	
	/**
	 * Set random string to file body name. The extension is never changed.
	 * @param $prefix string Prefix for random string.
	 * @param $salt string Salt for generating token.
	 */
	function setRandomToBodyName($prefix,$salt='')
	{
		$filename = $prefix . $this->_getRandomString($salt) . "." . $this->getExtension();
		$this->setFileName($filename);
	}
	
	/**
	 * Set random string to file body name. The extension is changed.
	 * @param $prefix string Prefix for random string.
	 * @param $salt string Salt for generating token.
	 */
	function setRandomToFilename($prefix,$salt='')
	{
		$filename = $prefix . $this->_getRandomString($salt);
		$this->setFileName($filename);
	}
	
	/**
	@brief Generate random string.
	@param $salt string Salt for generating token.
	@return string
	*/
	function _getRandomString($salt='')
	{
		if (empty($salt)) {
			$salt = substr(md5(XOOPS_DB_PREFIX . XOOPS_DB_USER . XOOPS_ROOT_PATH), 5, 8);
		}
		srand(microtime() *1000000);
		return md5($salt.rand());
	}
	
	/**
	 * Name this, and store it. If the name is specified as complete file name, store it as the same name.
	 * If the name is specified as directory name, store it as the own name to the directory specified.
	 *
	 * @param $file Directory path or file path.
	 * @return bool
	 */
	function saveAs($file)
	{
		$destFile = "";
		if(preg_match("#\/$#",$file)) {
			$destFile = $file . $this->getFileName();
		}
		elseif(is_dir($file)) {
			$destFile = $file . "/" . $this->getFileName();
		}
		else {
			$destFile = $file;
		}
		
		$ret = move_uploaded_file($this->_mTmpFileName, $destFile);

//		$prevMask = @umask(XDBASE_FORMFILE_PREVMASK);
//		@umask($prevMask);
		@chmod($destFile, XDBASE_FORMFILE_CHMOD);
		
		return $ret;
	}
	
	/**
	 * Set random string to file body name, and store it. The extension is never changed.
	 * @see saveAs()
	 * @see setRandomToBodyName()
	 * @param $dir Directory for store.
	 * @param $prefix string Prefix for random string.
	 * @param $salt string Salt for generating token.
	 * @return bool
	 */
	function saveAsRandBody($dir,$prefix='',$salt='')
	{
		$this->setRandomToBodyName($prefix,$salt);
		return $this->saveAs($dir);
	}
	
	/**
	 * Set random string to file name, and store it. The extension is never changed.
	 * @see saveAs()
	 * @see setRandomToFileName()
	 * @param $dir Directory for store.
	 * @param $prefix string Prefix for random string.
	 * @param $salt string Salt for generating token.
	 * @return bool
	 */
	function saveAsRand($dir,$prefix='',$salt='')
	{
		$this->setRandomToFileName($prefix,$salt);
		return $this->saveAs($dir);
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////
	function checkParentDir($path)
	{
		$err = false;

		$strPath = str_replace('/', '\/', XOOPS_UPLOAD_PATH.'/'._MD_XDBASE_CONST_MODULEDIRNAME);
		$matchStr = "/^(".$strPath.")\/\w+/";
		if (preg_match($matchStr, $path, $match))
		{
			$parentPath = $match[1];

			if (!is_dir($parentPath))
			{
				$safeModeFlag = ini_get('safe_mode');
				if ($safeModeFlag)
				{
					$err = "Error: ".$parentPath." You first have to create and chmod 777 directory by ftp or shell.";
				}
				else
				{
					if (!$rs = mkdir($parentPath, 0777))
					{
						$err = "Error: ".$parentPath." This is not a directory.";
					}
				}
			}

			if (!is_writable($parentPath) || !is_readable($parentPath))
			{
				$err = "Error: ".$parentPath." This directory is not writable nor readable. You should change the permission of the directory to 777.";
			}
		}

		return $err;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////
	function checkDir($path)
	{
		$err = false;

		if (substr($path, -1) == '/')
		{
			$err = "Error: ".$path." The last charactor should not be '/'";
		}

		if (!is_dir($path))
		{
			if ($err = $this->checkParentDir($path))
			{
				return $err;
			}

			$safeModeFlag = ini_get('safe_mode');
			if ($safeModeFlag)
			{
				$err = "Error: ".$path." You first have to create and chmod 777 directory by ftp or shell.";
			}
			else
			{
				if (!$rs = mkdir($path, 0777))
				{
					$err = "Error: ".$path." This is not a directory.";
				}
			}
		}

		if (!is_writable($path) || !is_readable($path))
		{
			$err = "Error: ".$path." This directory is not writable nor readable. You should change the permission of the directory to 777.";
		}
		return $err;
	}

}



/**
 * The sub-class of Xdbase_FormFile to handle image upload file easily.
 */
class Xdbase_FormImageFile extends Xdbase_FormFile
{
	var $width = 0;
	var $height = 0;
	var $type = 0;

///////////////////////////////////////////////////////////////////////////////////////////////////////
	function fetch()
	{
		parent::fetch();

		if ($this->hasUploadFile())
		{
			$this->_checkFormat();
/*
			if (!$this->_checkFormat())
			{
				$this->mUploadFileFlag = false;
			}
*/
		}
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Gets a value indicating whether a format of the uploaded file is allowed.
	 * @access private
	 * @return bool
	 */
	function _checkFormat()
	{
		list($this->width, $this->height, $this->type, $attr) = getimagesize($this->_mTmpFileName);

		switch ($this->type)
		{
			case IMAGETYPE_GIF:
				$this->setExtension("gif");
				break;
			
			case IMAGETYPE_JPEG:
				$this->setExtension("jpg");
				break;
			
			case IMAGETYPE_PNG:
				$this->setExtension("png");
				break;
			
			default:
				$this->setExtension("other");
//				return false;
		}
		
		return true;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Gets a height of the uploaded file.
	 * @return int
	 */
	function getWidth()
	{
		return $this->width;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////
	function getHeight()
	{
		return $this->height;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////
	function saveImage($dir)
	{
		if ($err = $this->checkDir($dir))
		{
			return $err;
		}

		$filePath = $dir.'/'.$this->getFileName();

		if (!$this->saveAs($filePath))
		{
			$err = "Error: image couldn't save";
			return $err;
		}

		return false;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////
	function saveResizedImage($dir, $maxSize)
	{
		if ($err = $this->checkDir($dir))
		{
			return $err;
		}

		$filePath = $dir.'/'.$this->getFileName();

		require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_Image.class.php';
		$imageHandler =& new Xdbase_Image();

		if ($err = $imageHandler->saveResizedImage($this->_mTmpFileName, $filePath, $maxSize))
		{
			return $err;
		}

		return false;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////


}

?>
