#include "xtext.h"

#include <dirent.h>
#include <pwd.h>


static int _offt_data_free(offset_data_t **head,offset_data_t **tail)
{
	offset_data_t *ot,*ott;

	for(ot = *head;ot != NULL;ot = ott){
		ott = ot->next;
		free(ot);
	}

	*head = NULL;
	*tail = NULL;

	return 0;
}
static int _offt_data_add(offset_data_t **head,offset_data_t **tail,offset_data_t *im)
{
        if(*tail){
                im->next = NULL;
                im->prev = *tail;

                (*tail)->next = im;
                *tail = im;
        }else{
                im->next = NULL;
                im->prev = NULL;

                *tail = im;
                *head = im;
        }

	return 0;
}
static offset_data_t *_offt_data_alloc()
{
	offset_data_t *ot;

	ot = (offset_data_t *)malloc(sizeof(offset_data_t));

	ot->font[0] = '\0';
	ot->c1 = 0;
	ot->c2 = 0;
	ot->x_off = 0;
	ot->y_off = 0;
	ot->anti = 0;

	return ot;
}
static int _offt_data_insert(offset_data_t **head,offset_data_t **tail,char *font,char *c1_s,char *c2_s,char *xoff,char *yoff,char *anti)
{
	offset_data_t *ot;


	ot = (offset_data_t *)_offt_data_alloc();

	strcpy(ot->font,font);
	ot->x_off = (int)atoi(xoff);
	ot->y_off = (int)atoi(yoff);
	ot->anti = (int)atoi(anti);

	if((ot->c1 = (unsigned int)xstring2uint(c1_s)) < 0) ot->c1 = 0;
	if((ot->c2 = (unsigned int)xstring2uint(c2_s)) < 0) ot->c2 = 0;

	_offt_data_add(head,tail,ot);

	return 0;
}
static int _parse_data(char *data,char *font,char *c1_s,char *c2_s,char *xoff,char *yoff,char *anti)
{
	char *p,temp[BUFSIZ];
	int flag = 0;
	int i = 0;

	for(p=data;*p;p++){
		if(*p == '\"'){
			flag++;

			if(flag == 2){temp[i] = '\0';strcpy(font,temp);i=0;}

			if(flag == 4){temp[i] = '\0';strncpy(c1_s,temp,4); i = 0;}
			if(flag == 6){temp[i] = '\0';strncpy(c2_s,temp,4);i = 0;}
			if(flag == 8){temp[i] = '\0';strncpy(xoff,temp,2); i = 0;}
			if(flag == 10){temp[i] = '\0';strncpy(yoff,temp,2);i = 0;}
			if(flag == 12){temp[i] = '\0';strncpy(anti,temp,1);i = 0;}

			continue;
		}

		if(flag == 1 || flag == 3 || flag == 5 || flag == 7 || flag == 9 || flag == 11)
			temp[i++] = *p;
	}

	if(flag < 12 ) return -1;

	return 0;
}	
int xtext_offt_data(offset_data_t **head,offset_data_t **tail)
{
	FILE *fp;
	char buf[BUFSIZ];
	char offset_file[256];
	char off_data[256];
	struct passwd *pwd;
	int flag = 0;

	char font[128],c1_s[5],c2_s[5],xoff[4],yoff[4],anti[2];


	 pwd = getpwuid(getuid());
         sprintf(offset_file,"%s/%s/%s",pwd->pw_dir,CONF_DIR_NAME,OFFSET_FILE_NAME);

	 if((fp = fopen(offset_file,"r")) == NULL) return -1;

	 memset(off_data,0,256);
	 while(fgets(buf,BUFSIZ,fp) != NULL){

		 if(buf[0] == '#' || buf[0] == '\n') continue;

		 if(flag == 0 && strstr(buf,"{") != NULL){
			 flag = 1;
			 memset(off_data,0,256);
		 }
		 if(flag && strstr(buf,"}") != NULL){
			 flag = 0;
			 sprintf(off_data,"%s%s",off_data,buf);
			 _parse_data(off_data,font,c1_s,c2_s,xoff,yoff,anti);
			 _offt_data_insert(head,tail,font,c1_s,c2_s,xoff,yoff,anti);
		 }

		 if(flag) sprintf(off_data,"%s%s",off_data,buf);
	 }
	 fclose(fp);


	 return 0;
}
int xtext_offt_set(offset_data_t *head,offset_data_t *tail,xtext_conf_t xconf,offset_data_t **o_head,offset_data_t **o_tail)
{
	offset_data_t *ot,*pt;
	char *font;
	int anti;

	if(head == NULL) return -1;
	if(*o_head != NULL) _offt_data_free(o_head,o_tail); 

	if((font = xconf.main_font_j) == NULL) return -1;
	anti = xconf.anti;

	for(ot=head;ot!=NULL;ot=ot->next){

		if((strcmp(ot->font,font) == 0) && (ot->anti == anti)){
			pt = (offset_data_t*)_offt_data_alloc();
			strcpy(pt->font,ot->font);
			pt->c1 = ot->c1;
			pt->c2 = ot->c2;
			pt->x_off = ot->x_off;
			pt->y_off = ot->y_off;
			pt->anti = ot->anti;
			_offt_data_add(o_head,o_tail,pt);
		}
	}

	return 0;
}
static int xtext_clear_offset(IBUF_T *head)
{
	IBUF_T *ib;
	ITEXT_T *it;

	if(head == NULL) return -1;

	for(ib=head;ib!=NULL;ib=ib->next){
		for(it=ib->i_head;it!=NULL;it=it->next){
			it->x_off = 0;
			it->y_off = 0;
		}
	}

	return 0;
}
int xtext_set_offset(IBUF_T *head,IBUF_T *tail,offset_data_t *o_head)
{
	IBUF_T *ib;
	ITEXT_T *it;
	offset_data_t *ot;

	if(head == NULL) return -1;
	if(o_head == NULL) return -1;

	xtext_clear_offset(head);

	for(ib=head;ib!=NULL;ib=ib->next){
		for(it=ib->i_head;it!=NULL;it=it->next){

			for(ot=o_head;ot!=NULL;ot=ot->next){
				if((it->c1 == ot->c1) && (it->c2 == ot->c2)){
					it->x_off = ot->x_off;
					it->y_off = ot->y_off;
					break;
				}
			}

		}
	}

	return 0;
}




		

