#include "xtext.h"

static chu_data_t *chead = NULL, *ctail = NULL;

static chu_data_t * _chumessage_data_alloc()
{
	chu_data_t *ct;

	ct = (chu_data_t *)malloc(sizeof(chu_data_t));
	ct->message[0] = '\0';

	return ct;
}
static void _chumessage_data_free(chu_data_t **head,chu_data_t **tail)
{
	chu_data_t *ct,*ctt;

	for(ct = *head;ct != NULL;ct = ctt){
		ctt = ct->next;
		free(ct);
	}
	*head = NULL;
	*tail = NULL;
}
static void _chumessage_data_add(chu_data_t **head,chu_data_t **tail,chu_data_t *im)
{
        if(*tail){
                im->next = NULL;
                im->prev = *tail;

                (*tail)->next = im;
                *tail = im;
        }else{
                im->next = NULL;
                im->prev = NULL;

                *tail = im;
                *head = im;
        }

}
int xtextClearChuWindow(Display *disp,my_window_t *win)
{
	if(win == NULL) return -1;

	XClearWindow(disp,win->mwin);

	if(chead == NULL) return 0;

	_chumessage_data_free(&chead,&ctail);

	return 0;
}
int xtextDrawChuMessage(Display *disp,my_window_t *win,char_data_t *cd)
{
	chu_data_t *ct;
	int x=0,y=0;

	XClearWindow(disp,win->mwin);

	if(chead == NULL) return -1;

	x = 1;
	for(ct=chead;ct!=NULL;ct=ct->next){
		y = y + cd->charSize_s + 2;
		XmbDrawString(disp,win->mwin,win->fs_s,win->gc,x,y,ct->message,strlen(ct->message));
	}

	return 0;
}
int xtextChuMessage(Display *disp,my_window_t *win,char_data_t *cd,char *message)
{
	chu_data_t *ct;

	ct = (chu_data_t *)_chumessage_data_alloc();
	strcpy(ct->message,message);
	_chumessage_data_add(&chead,&ctail,ct);

	xtextDrawChuMessage(disp,win,cd);

	return 0;
}
