/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class BinaryTree
extends AbstractMap {
    private Node[] _root = new Node[]{null, null};
    private int _size = 0;
    private int _modifications = 0;
    private Set[] _key_set = new Set[]{null, null};
    private Set[] _entry_set = new Set[]{null, null};
    private Collection[] _value_collection = new Collection[]{null, null};
    private static final int _KEY = 0;
    private static final int _VALUE = 1;
    private static final int _INDEX_SUM = 1;
    private static final int _MINIMUM_INDEX = 0;
    private static final int _INDEX_COUNT = 2;
    private static final String[] _data_name = new String[]{"key", "value"};

    public BinaryTree() {
    }

    public BinaryTree(Map map) throws ClassCastException, NullPointerException, IllegalArgumentException {
        this.putAll(map);
    }

    public Object getKeyForValue(Object value) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)value, 1);
    }

    public Object removeValue(Object value) {
        return this.doRemove((Comparable)value, 1);
    }

    public Set entrySetByValue() {
        if (this._entry_set[1] == null) {
            this._entry_set[1] = new AbstractSet(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(this, 1){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        protected Object doGetNext() {
                            return this._last_returned_node;
                        }
                    };
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getValue(), 1);
                    return node != null && node.getData(0).equals(key);
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getValue(), 1);
                    if (node != null && node.getData(0).equals(key)) {
                        BinaryTree.this.doRedBlackDelete(node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public void clear() {
                    BinaryTree.this.clear();
                }

                static /* synthetic */ BinaryTree access$000(1 x0) {
                    return x0.BinaryTree.this;
                }
            };
        }
        return this._entry_set[1];
    }

    public Set keySetByValue() {
        if (this._key_set[1] == null) {
            this._key_set[1] = new AbstractSet(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(this, 1){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this._last_returned_node, 0);
                        }
                    };
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public boolean contains(Object o) {
                    return BinaryTree.this.containsKey(o);
                }

                public boolean remove(Object o) {
                    int old_size = BinaryTree.this._size;
                    BinaryTree.this.remove(o);
                    return BinaryTree.this._size != old_size;
                }

                public void clear() {
                    BinaryTree.this.clear();
                }

                static /* synthetic */ BinaryTree access$400(3 x0) {
                    return x0.BinaryTree.this;
                }
            };
        }
        return this._key_set[1];
    }

    public Collection valuesByValue() {
        if (this._value_collection[1] == null) {
            this._value_collection[1] = new AbstractCollection(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(this, 1){
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this._last_returned_node, 1);
                        }
                    };
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public boolean contains(Object o) {
                    return BinaryTree.this.containsValue(o);
                }

                public boolean remove(Object o) {
                    int old_size = BinaryTree.this._size;
                    BinaryTree.this.removeValue(o);
                    return BinaryTree.this._size != old_size;
                }

                public boolean removeAll(Collection c) {
                    boolean modified = false;
                    Iterator iter = c.iterator();
                    while (iter.hasNext()) {
                        if (BinaryTree.this.removeValue(iter.next()) == null) continue;
                        modified = true;
                    }
                    return modified;
                }

                public void clear() {
                    BinaryTree.this.clear();
                }

                static /* synthetic */ BinaryTree access$600(5 x0) {
                    return x0.BinaryTree.this;
                }
            };
        }
        return this._value_collection[1];
    }

    private Object doRemove(Comparable o, int index) {
        Node node = this.lookup(o, index);
        Comparable rval = null;
        if (node != null) {
            rval = node.getData(this.oppositeIndex(index));
            this.doRedBlackDelete(node);
        }
        return rval;
    }

    private Object doGet(Comparable o, int index) {
        BinaryTree.checkNonNullComparable(o, index);
        Node node = this.lookup(o, index);
        return node == null ? null : node.getData(this.oppositeIndex(index));
    }

    private int oppositeIndex(int index) {
        return 1 - index;
    }

    private Node lookup(Comparable data, int index) {
        Node rval = null;
        Node node = this._root[index];
        while (node != null) {
            int cmp = BinaryTree.compare(data, node.getData(index));
            if (cmp == 0) {
                rval = node;
                break;
            }
            Node node2 = node = cmp < 0 ? node.getLeft(index) : node.getRight(index);
        }
        return rval;
    }

    private static int compare(Comparable o1, Comparable o2) {
        return o1.compareTo(o2);
    }

    private static Node leastNode(Node node, int index) {
        Node rval = node;
        if (rval != null) {
            while (rval.getLeft(index) != null) {
                rval = rval.getLeft(index);
            }
        }
        return rval;
    }

    private Node nextGreater(Node node, int index) {
        Node rval = null;
        if (node == null) {
            rval = null;
        } else if (node.getRight(index) != null) {
            rval = BinaryTree.leastNode(node.getRight(index), index);
        } else {
            Node parent = node.getParent(index);
            Node child = node;
            while (parent != null && child == parent.getRight(index)) {
                child = parent;
                parent = parent.getParent(index);
            }
            rval = parent;
        }
        return rval;
    }

    private static void copyColor(Node from, Node to, int index) {
        if (to != null) {
            if (from == null) {
                to.setBlack(index);
            } else {
                to.copyColor(from, index);
            }
        }
    }

    private static boolean isRed(Node node, int index) {
        return node == null ? false : node.isRed(index);
    }

    private static boolean isBlack(Node node, int index) {
        return node == null ? true : node.isBlack(index);
    }

    private static void makeRed(Node node, int index) {
        if (node != null) {
            node.setRed(index);
        }
    }

    private static void makeBlack(Node node, int index) {
        if (node != null) {
            node.setBlack(index);
        }
    }

    private static Node getGrandParent(Node node, int index) {
        return BinaryTree.getParent(BinaryTree.getParent(node, index), index);
    }

    private static Node getParent(Node node, int index) {
        return node == null ? null : node.getParent(index);
    }

    private static Node getRightChild(Node node, int index) {
        return node == null ? null : node.getRight(index);
    }

    private static Node getLeftChild(Node node, int index) {
        return node == null ? null : node.getLeft(index);
    }

    private static boolean isLeftChild(Node node, int index) {
        return node == null ? true : (node.getParent(index) == null ? false : node == node.getParent(index).getLeft(index));
    }

    private static boolean isRightChild(Node node, int index) {
        return node == null ? true : (node.getParent(index) == null ? false : node == node.getParent(index).getRight(index));
    }

    private void rotateLeft(Node node, int index) {
        Node right_child = node.getRight(index);
        node.setRight(right_child.getLeft(index), index);
        if (right_child.getLeft(index) != null) {
            right_child.getLeft(index).setParent(node, index);
        }
        right_child.setParent(node.getParent(index), index);
        if (node.getParent(index) == null) {
            this._root[index] = right_child;
        } else if (node.getParent(index).getLeft(index) == node) {
            node.getParent(index).setLeft(right_child, index);
        } else {
            node.getParent(index).setRight(right_child, index);
        }
        right_child.setLeft(node, index);
        node.setParent(right_child, index);
    }

    private void rotateRight(Node node, int index) {
        Node left_child = node.getLeft(index);
        node.setLeft(left_child.getRight(index), index);
        if (left_child.getRight(index) != null) {
            left_child.getRight(index).setParent(node, index);
        }
        left_child.setParent(node.getParent(index), index);
        if (node.getParent(index) == null) {
            this._root[index] = left_child;
        } else if (node.getParent(index).getRight(index) == node) {
            node.getParent(index).setRight(left_child, index);
        } else {
            node.getParent(index).setLeft(left_child, index);
        }
        left_child.setRight(node, index);
        node.setParent(left_child, index);
    }

    private void doRedBlackInsert(Node inserted_node, int index) {
        Node current_node = inserted_node;
        BinaryTree.makeRed(current_node, index);
        while (current_node != null && current_node != this._root[index] && BinaryTree.isRed(current_node.getParent(index), index)) {
            Node y;
            if (BinaryTree.isLeftChild(BinaryTree.getParent(current_node, index), index)) {
                y = BinaryTree.getRightChild(BinaryTree.getGrandParent(current_node, index), index);
                if (BinaryTree.isRed(y, index)) {
                    BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
                    BinaryTree.makeBlack(y, index);
                    BinaryTree.makeRed(BinaryTree.getGrandParent(current_node, index), index);
                    current_node = BinaryTree.getGrandParent(current_node, index);
                    continue;
                }
                if (BinaryTree.isRightChild(current_node, index)) {
                    current_node = BinaryTree.getParent(current_node, index);
                    this.rotateLeft(current_node, index);
                }
                BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
                BinaryTree.makeRed(BinaryTree.getGrandParent(current_node, index), index);
                if (BinaryTree.getGrandParent(current_node, index) == null) continue;
                this.rotateRight(BinaryTree.getGrandParent(current_node, index), index);
                continue;
            }
            y = BinaryTree.getLeftChild(BinaryTree.getGrandParent(current_node, index), index);
            if (BinaryTree.isRed(y, index)) {
                BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
                BinaryTree.makeBlack(y, index);
                BinaryTree.makeRed(BinaryTree.getGrandParent(current_node, index), index);
                current_node = BinaryTree.getGrandParent(current_node, index);
                continue;
            }
            if (BinaryTree.isLeftChild(current_node, index)) {
                current_node = BinaryTree.getParent(current_node, index);
                this.rotateRight(current_node, index);
            }
            BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
            BinaryTree.makeRed(BinaryTree.getGrandParent(current_node, index), index);
            if (BinaryTree.getGrandParent(current_node, index) == null) continue;
            this.rotateLeft(BinaryTree.getGrandParent(current_node, index), index);
        }
        BinaryTree.makeBlack(this._root[index], index);
    }

    private void doRedBlackDelete(Node deleted_node) {
        int index = 0;
        while (index < 2) {
            Node replacement;
            if (deleted_node.getLeft(index) != null && deleted_node.getRight(index) != null) {
                this.swapPosition(this.nextGreater(deleted_node, index), deleted_node, index);
            }
            Node node = replacement = deleted_node.getLeft(index) != null ? deleted_node.getLeft(index) : deleted_node.getRight(index);
            if (replacement != null) {
                replacement.setParent(deleted_node.getParent(index), index);
                if (deleted_node.getParent(index) == null) {
                    this._root[index] = replacement;
                } else if (deleted_node == deleted_node.getParent(index).getLeft(index)) {
                    deleted_node.getParent(index).setLeft(replacement, index);
                } else {
                    deleted_node.getParent(index).setRight(replacement, index);
                }
                deleted_node.setLeft(null, index);
                deleted_node.setRight(null, index);
                deleted_node.setParent(null, index);
                if (BinaryTree.isBlack(deleted_node, index)) {
                    this.doRedBlackDeleteFixup(replacement, index);
                }
            } else if (deleted_node.getParent(index) == null) {
                this._root[index] = null;
            } else {
                if (BinaryTree.isBlack(deleted_node, index)) {
                    this.doRedBlackDeleteFixup(deleted_node, index);
                }
                if (deleted_node.getParent(index) != null) {
                    if (deleted_node == deleted_node.getParent(index).getLeft(index)) {
                        deleted_node.getParent(index).setLeft(null, index);
                    } else {
                        deleted_node.getParent(index).setRight(null, index);
                    }
                    deleted_node.setParent(null, index);
                }
            }
            ++index;
        }
        this.shrink();
    }

    private void doRedBlackDeleteFixup(Node replacement_node, int index) {
        Node current_node = replacement_node;
        while (current_node != this._root[index] && BinaryTree.isBlack(current_node, index)) {
            Node sibling_node;
            if (BinaryTree.isLeftChild(current_node, index)) {
                sibling_node = BinaryTree.getRightChild(BinaryTree.getParent(current_node, index), index);
                if (BinaryTree.isRed(sibling_node, index)) {
                    BinaryTree.makeBlack(sibling_node, index);
                    BinaryTree.makeRed(BinaryTree.getParent(current_node, index), index);
                    this.rotateLeft(BinaryTree.getParent(current_node, index), index);
                    sibling_node = BinaryTree.getRightChild(BinaryTree.getParent(current_node, index), index);
                }
                if (BinaryTree.isBlack(BinaryTree.getLeftChild(sibling_node, index), index) && BinaryTree.isBlack(BinaryTree.getRightChild(sibling_node, index), index)) {
                    BinaryTree.makeRed(sibling_node, index);
                    current_node = BinaryTree.getParent(current_node, index);
                    continue;
                }
                if (BinaryTree.isBlack(BinaryTree.getRightChild(sibling_node, index), index)) {
                    BinaryTree.makeBlack(BinaryTree.getLeftChild(sibling_node, index), index);
                    BinaryTree.makeRed(sibling_node, index);
                    this.rotateRight(sibling_node, index);
                    sibling_node = BinaryTree.getRightChild(BinaryTree.getParent(current_node, index), index);
                }
                BinaryTree.copyColor(BinaryTree.getParent(current_node, index), sibling_node, index);
                BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
                BinaryTree.makeBlack(BinaryTree.getRightChild(sibling_node, index), index);
                this.rotateLeft(BinaryTree.getParent(current_node, index), index);
                current_node = this._root[index];
                continue;
            }
            sibling_node = BinaryTree.getLeftChild(BinaryTree.getParent(current_node, index), index);
            if (BinaryTree.isRed(sibling_node, index)) {
                BinaryTree.makeBlack(sibling_node, index);
                BinaryTree.makeRed(BinaryTree.getParent(current_node, index), index);
                this.rotateRight(BinaryTree.getParent(current_node, index), index);
                sibling_node = BinaryTree.getLeftChild(BinaryTree.getParent(current_node, index), index);
            }
            if (BinaryTree.isBlack(BinaryTree.getRightChild(sibling_node, index), index) && BinaryTree.isBlack(BinaryTree.getLeftChild(sibling_node, index), index)) {
                BinaryTree.makeRed(sibling_node, index);
                current_node = BinaryTree.getParent(current_node, index);
                continue;
            }
            if (BinaryTree.isBlack(BinaryTree.getLeftChild(sibling_node, index), index)) {
                BinaryTree.makeBlack(BinaryTree.getRightChild(sibling_node, index), index);
                BinaryTree.makeRed(sibling_node, index);
                this.rotateLeft(sibling_node, index);
                sibling_node = BinaryTree.getLeftChild(BinaryTree.getParent(current_node, index), index);
            }
            BinaryTree.copyColor(BinaryTree.getParent(current_node, index), sibling_node, index);
            BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
            BinaryTree.makeBlack(BinaryTree.getLeftChild(sibling_node, index), index);
            this.rotateRight(BinaryTree.getParent(current_node, index), index);
            current_node = this._root[index];
        }
        BinaryTree.makeBlack(current_node, index);
    }

    private void swapPosition(Node x, Node y, int index) {
        boolean y_was_left_child;
        Node x_old_parent = x.getParent(index);
        Node x_old_left_child = x.getLeft(index);
        Node x_old_right_child = x.getRight(index);
        Node y_old_parent = y.getParent(index);
        Node y_old_left_child = y.getLeft(index);
        Node y_old_right_child = y.getRight(index);
        boolean x_was_left_child = x.getParent(index) != null && x == x.getParent(index).getLeft(index);
        boolean bl = y_was_left_child = y.getParent(index) != null && y == y.getParent(index).getLeft(index);
        if (x == y_old_parent) {
            x.setParent(y, index);
            if (y_was_left_child) {
                y.setLeft(x, index);
                y.setRight(x_old_right_child, index);
            } else {
                y.setRight(x, index);
                y.setLeft(x_old_left_child, index);
            }
        } else {
            x.setParent(y_old_parent, index);
            if (y_old_parent != null) {
                if (y_was_left_child) {
                    y_old_parent.setLeft(x, index);
                } else {
                    y_old_parent.setRight(x, index);
                }
            }
            y.setLeft(x_old_left_child, index);
            y.setRight(x_old_right_child, index);
        }
        if (y == x_old_parent) {
            y.setParent(x, index);
            if (x_was_left_child) {
                x.setLeft(y, index);
                x.setRight(y_old_right_child, index);
            } else {
                x.setRight(y, index);
                x.setLeft(y_old_left_child, index);
            }
        } else {
            y.setParent(x_old_parent, index);
            if (x_old_parent != null) {
                if (x_was_left_child) {
                    x_old_parent.setLeft(y, index);
                } else {
                    x_old_parent.setRight(y, index);
                }
            }
            x.setLeft(y_old_left_child, index);
            x.setRight(y_old_right_child, index);
        }
        if (x.getLeft(index) != null) {
            x.getLeft(index).setParent(x, index);
        }
        if (x.getRight(index) != null) {
            x.getRight(index).setParent(x, index);
        }
        if (y.getLeft(index) != null) {
            y.getLeft(index).setParent(y, index);
        }
        if (y.getRight(index) != null) {
            y.getRight(index).setParent(y, index);
        }
        x.swapColors(y, index);
        if (this._root[index] == x) {
            this._root[index] = y;
        } else if (this._root[index] == y) {
            this._root[index] = x;
        }
    }

    private static void checkNonNullComparable(Object o, int index) {
        if (o == null) {
            throw new NullPointerException(_data_name[index] + " cannot be null");
        }
        if (!(o instanceof Comparable)) {
            throw new ClassCastException(_data_name[index] + " must be Comparable");
        }
    }

    private static void checkKey(Object key) {
        BinaryTree.checkNonNullComparable(key, 0);
    }

    private static void checkValue(Object value) {
        BinaryTree.checkNonNullComparable(value, 1);
    }

    private static void checkKeyAndValue(Object key, Object value) {
        BinaryTree.checkKey(key);
        BinaryTree.checkValue(value);
    }

    private void modify() {
        ++this._modifications;
    }

    private void grow() {
        this.modify();
        ++this._size;
    }

    private void shrink() {
        this.modify();
        --this._size;
    }

    private void insertValue(Node newNode) throws IllegalArgumentException {
        block4: {
            Node node = this._root[1];
            while (true) {
                int cmp;
                if ((cmp = BinaryTree.compare(newNode.getData(1), node.getData(1))) == 0) {
                    throw new IllegalArgumentException("Cannot store a duplicate value (\"" + newNode.getData(1) + "\") in this Map");
                }
                if (cmp < 0) {
                    if (node.getLeft(1) != null) {
                        node = node.getLeft(1);
                        continue;
                    }
                    node.setLeft(newNode, 1);
                    newNode.setParent(node, 1);
                    this.doRedBlackInsert(newNode, 1);
                    break block4;
                }
                if (node.getRight(1) == null) break;
                node = node.getRight(1);
            }
            node.setRight(newNode, 1);
            newNode.setParent(node, 1);
            this.doRedBlackInsert(newNode, 1);
        }
    }

    public int size() {
        return this._size;
    }

    public boolean containsKey(Object key) throws ClassCastException, NullPointerException {
        BinaryTree.checkKey(key);
        return this.lookup((Comparable)key, 0) != null;
    }

    public boolean containsValue(Object value) {
        BinaryTree.checkValue(value);
        return this.lookup((Comparable)value, 1) != null;
    }

    public Object get(Object key) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)key, 0);
    }

    public Object put(Object key, Object value) throws ClassCastException, NullPointerException, IllegalArgumentException {
        block6: {
            BinaryTree.checkKeyAndValue(key, value);
            Node node = this._root[0];
            if (node == null) {
                Node root;
                this._root[0] = root = new Node((Comparable)key, (Comparable)value);
                this._root[1] = root;
                this.grow();
            } else {
                while (true) {
                    int cmp;
                    if ((cmp = BinaryTree.compare((Comparable)key, node.getData(0))) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + key + "\") in this Map");
                    }
                    if (cmp < 0) {
                        if (node.getLeft(0) != null) {
                            node = node.getLeft(0);
                            continue;
                        }
                        Node newNode = new Node((Comparable)key, (Comparable)value);
                        this.insertValue(newNode);
                        node.setLeft(newNode, 0);
                        newNode.setParent(node, 0);
                        this.doRedBlackInsert(newNode, 0);
                        this.grow();
                        break block6;
                    }
                    if (node.getRight(0) == null) break;
                    node = node.getRight(0);
                }
                Node newNode = new Node((Comparable)key, (Comparable)value);
                this.insertValue(newNode);
                node.setRight(newNode, 0);
                newNode.setParent(node, 0);
                this.doRedBlackInsert(newNode, 0);
                this.grow();
            }
        }
        return null;
    }

    public Object remove(Object key) {
        return this.doRemove((Comparable)key, 0);
    }

    public void clear() {
        this.modify();
        this._size = 0;
        this._root[0] = null;
        this._root[1] = null;
    }

    public Set keySet() {
        if (this._key_set[0] == null) {
            this._key_set[0] = new AbstractSet(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(this, 0){
                        private final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this._last_returned_node, 0);
                        }
                    };
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public boolean contains(Object o) {
                    return BinaryTree.this.containsKey(o);
                }

                public boolean remove(Object o) {
                    int old_size = BinaryTree.this._size;
                    BinaryTree.this.remove(o);
                    return BinaryTree.this._size != old_size;
                }

                public void clear() {
                    BinaryTree.this.clear();
                }

                static /* synthetic */ BinaryTree access$1900(7 x0) {
                    return x0.BinaryTree.this;
                }
            };
        }
        return this._key_set[0];
    }

    public Collection values() {
        if (this._value_collection[0] == null) {
            this._value_collection[0] = new AbstractCollection(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(this, 0){
                        private final /* synthetic */ 9 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this._last_returned_node, 1);
                        }
                    };
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public boolean contains(Object o) {
                    return BinaryTree.this.containsValue(o);
                }

                public boolean remove(Object o) {
                    int old_size = BinaryTree.this._size;
                    BinaryTree.this.removeValue(o);
                    return BinaryTree.this._size != old_size;
                }

                public boolean removeAll(Collection c) {
                    boolean modified = false;
                    Iterator iter = c.iterator();
                    while (iter.hasNext()) {
                        if (BinaryTree.this.removeValue(iter.next()) == null) continue;
                        modified = true;
                    }
                    return modified;
                }

                public void clear() {
                    BinaryTree.this.clear();
                }

                static /* synthetic */ BinaryTree access$2000(9 x0) {
                    return x0.BinaryTree.this;
                }
            };
        }
        return this._value_collection[0];
    }

    public Set entrySet() {
        if (this._entry_set[0] == null) {
            this._entry_set[0] = new AbstractSet(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(this, 0){
                        private final /* synthetic */ 11 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        protected Object doGetNext() {
                            return this._last_returned_node;
                        }
                    };
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object value = entry.getValue();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getKey(), 0);
                    return node != null && node.getData(1).equals(value);
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object value = entry.getValue();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getKey(), 0);
                    if (node != null && node.getData(1).equals(value)) {
                        BinaryTree.this.doRedBlackDelete(node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public void clear() {
                    BinaryTree.this.clear();
                }

                static /* synthetic */ BinaryTree access$2100(11 x0) {
                    return x0.BinaryTree.this;
                }
            };
        }
        return this._entry_set[0];
    }

    private static final class Node
    implements Map.Entry {
        private Comparable[] _data;
        private Node[] _left;
        private Node[] _right;
        private Node[] _parent;
        private boolean[] _black;
        private int _hashcode;
        private boolean _calculated_hashcode;

        Node(Comparable key, Comparable value) {
            this._data = new Comparable[]{key, value};
            this._left = new Node[]{null, null};
            this._right = new Node[]{null, null};
            this._parent = new Node[]{null, null};
            this._black = new boolean[]{true, true};
            this._calculated_hashcode = false;
        }

        private Comparable getData(int index) {
            return this._data[index];
        }

        private void setLeft(Node node, int index) {
            this._left[index] = node;
        }

        private Node getLeft(int index) {
            return this._left[index];
        }

        private void setRight(Node node, int index) {
            this._right[index] = node;
        }

        private Node getRight(int index) {
            return this._right[index];
        }

        private void setParent(Node node, int index) {
            this._parent[index] = node;
        }

        private Node getParent(int index) {
            return this._parent[index];
        }

        private void swapColors(Node node, int index) {
            int n = index;
            this._black[n] = this._black[n] ^ node._black[index];
            int n2 = index;
            node._black[n2] = node._black[n2] ^ this._black[index];
            int n3 = index;
            this._black[n3] = this._black[n3] ^ node._black[index];
        }

        private boolean isBlack(int index) {
            return this._black[index];
        }

        private boolean isRed(int index) {
            return !this._black[index];
        }

        private void setBlack(int index) {
            this._black[index] = true;
        }

        private void setRed(int index) {
            this._black[index] = false;
        }

        private void copyColor(Node node, int index) {
            this._black[index] = node._black[index];
        }

        public Object getKey() {
            return this._data[0];
        }

        public Object getValue() {
            return this._data[1];
        }

        public Object setValue(Object ignored) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Map.Entry.setValue is not supported");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this._data[0].equals(e.getKey()) && this._data[1].equals(e.getValue());
        }

        public int hashCode() {
            if (!this._calculated_hashcode) {
                this._hashcode = this._data[0].hashCode() ^ this._data[1].hashCode();
                this._calculated_hashcode = true;
            }
            return this._hashcode;
        }
    }

    private abstract class BinaryTreeIterator
    implements Iterator {
        private int _expected_modifications;
        protected Node _last_returned_node;
        private Node _next_node;
        private int _type;

        BinaryTreeIterator(int type) {
            this._type = type;
            this._expected_modifications = BinaryTree.this._modifications;
            this._last_returned_node = null;
            this._next_node = BinaryTree.leastNode(BinaryTree.this._root[this._type], this._type);
        }

        protected abstract Object doGetNext();

        public final boolean hasNext() {
            return this._next_node != null;
        }

        public final Object next() throws NoSuchElementException, ConcurrentModificationException {
            if (this._next_node == null) {
                throw new NoSuchElementException();
            }
            if (BinaryTree.this._modifications != this._expected_modifications) {
                throw new ConcurrentModificationException();
            }
            this._last_returned_node = this._next_node;
            this._next_node = BinaryTree.this.nextGreater(this._next_node, this._type);
            return this.doGetNext();
        }

        public final void remove() throws IllegalStateException, ConcurrentModificationException {
            if (this._last_returned_node == null) {
                throw new IllegalStateException();
            }
            if (BinaryTree.this._modifications != this._expected_modifications) {
                throw new ConcurrentModificationException();
            }
            BinaryTree.this.doRedBlackDelete(this._last_returned_node);
            ++this._expected_modifications;
            this._last_returned_node = null;
        }
    }
}

