/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventmodel;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.eventmodel.HSSFRequest;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;

public class HSSFEventFactory {
    public void processWorkbookEvents(HSSFRequest req, POIFSFileSystem fs) throws IOException {
        DocumentInputStream in = fs.createDocumentInputStream("Workbook");
        this.processEvents(req, in);
    }

    public void processEvents(HSSFRequest req, InputStream in) throws IOException {
        try {
            byte[] sidbytes = new byte[2];
            int bytesread = in.read(sidbytes);
            Record rec = null;
            while (bytesread > 0) {
                byte[] data;
                short size;
                short sid = 0;
                sid = LittleEndian.getShort(sidbytes);
                if (rec != null && sid != 60) {
                    req.processRecord(rec);
                }
                if (sid != 60) {
                    Record[] recs;
                    size = LittleEndian.readShort(in);
                    data = new byte[size];
                    if (data.length > 0) {
                        in.read(data);
                    }
                    if ((recs = RecordFactory.createRecord(sid, size, data)).length > 1) {
                        int k = 0;
                        while (k < recs.length - 1) {
                            req.processRecord(recs[k]);
                            ++k;
                        }
                    }
                    rec = recs[recs.length - 1];
                } else {
                    size = LittleEndian.readShort(in);
                    data = new byte[size];
                    if (data.length > 0) {
                        in.read(data);
                    }
                    rec.processContinueRecord(data);
                }
                bytesread = in.read(sidbytes);
            }
            if (rec != null) {
                req.processRecord(rec);
            }
        }
        catch (IOException e) {
            throw new RecordFormatException("Error reading bytes");
        }
    }
}

